/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#ifndef POLYXEDIT_SEQEDITORCTXT_H
#define POLYXEDIT_SEQEDITORCTXT_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "polyxedit-globals.h"
#include "polyxedit-monicon.h"



typedef struct _PxmSeqEditorCtxt PxmSeqEditorCtxt;


struct _PxmSeqEditorCtxt
{
  /* The sequence editor main window.
   */
  GtkWidget *sequence_editor_wnd;
  
  /* The monomer completions' window.
   */
  GtkWidget *monomer_completions_wnd;
  
  /* The gnome-canvas in which all the graphics rendering takes place.
   */
  GtkWidget *sequence_canvas;
    
  /* The scrolled window in which the canvas is packed.
   */
  GtkWidget *canvas_scroll_wnd;
  
  /* Two holder variable (never allocated) to store the values of the
   * scrolled window adjustments.
   */
  GtkAdjustment *canvas_scroll_wnd_adjust_v;
  GtkAdjustment *canvas_scroll_wnd_adjust_h;
    
  /* The canvas in which the sequence editing takes place sits into 
   * a scrolled window. The size of the scroll window is crucial for
   * a number of computations, and we need to ALWAYS know exactly
   * what is the size of this scrolled window.
   */
  gint canvas_scroll_wnd_width;
  gint canvas_scroll_wnd_height;
    
  /* The main canvas group under which all the monicon->canvas_item
   * elements of a single polymer sequence are set.
   */
  GnomeCanvasGroup *main_canvas_group;

  /* The points describing the selection polygon.
   */ 
  GnomeCanvasPoints *canvas_selection_points;
    
  /* The selection polygon that is drawn when user drags the mouse
   * on the polymer sequence.
   */
  GnomeCanvasItem *canvas_selection_polygon; 
    
  /* The label in which the position of the current monomer is
   * displayed.
   */
  GtkWidget *monomer_pos_label;

  /* The labels on the left of the sequence must have some place for them.
   * This is what the left margin is for.
   */
  gint left_margin;
  
  /* The canvas has to know real time what x and y offset it has. The
   * y offset is particularly important to compute the position of the
   * scroll bars. The y offset is the number of pixels that are hidden
   * because of their coming out of the upper border of the scroll
   * window that contains the canvas.
   */
  gint x_offset;
  gint y_offset;

  /* The cursor is created for each polymer editing context.
   */
  PxmMonicon *cursor;
    
  /* Selection rectangle. This rectangle is where (x1,y1) and (x2,y2)
     points are stored so that it is each time possible to recompute
     the index of the currently selected border monomers. This
     rectangle has its values updated each time the cursor changes
     location, either during a selection process (only the second pair
     changes (x2,y2) to indicate that the selection moves), or without
     selection, in which case (x1,y1) is set to current values of
     mouse position and (x2,y2) is set to the same values that (x1,y1)
     so that it is clear that no selection is going on.

     What should be understood is that x1,y1 and x2,y2 are not used to
     compute the acutal selection polygon geometry. They are only
     values from which the index of the first monomer being in the
     selection and the index of the last monomer in that selection are
     being computed. Once the indexes are known the precise geometry
     of the selection polygon is computed by the
     polyxedit_seqed_wnd_update_sel_polygon () function.

     Finally, (x1,y1) and (x2,y2) pairs are either set to mouse cursor
     coordinates if the pointing on the sequence is performed by using
     the mouse, or these pairs' values are set by calculating the x,y
     position coordinates using a monomer index.
   */
  PxmRect selection_rect;
  
  /* We always need to know if there is a selection, what are
   * the two monomers that "border" the selection, this because
   * when the window is moved, resized, we have to be able to redraw
   * the full polymer sequence and restore the selection whose geometry
   * might have changed upon window size modification.
   */
  gint sel_mnm_idx1;
  gint sel_mnm_idx2;

  /* And we need these two rectangles to draw the selection polygon.
   */
  PxmRect mnm1rect;
  PxmRect mnm2rect;

  /* Number of monicons that can stand on a line of the sequence
   * editor window.
   */
  gint monicons_per_line;

  /* The last pointed monomer is the one on which the cursor was
   * clicked/unclicked. Variant _1_ is for button 1 of the mouse
   * (left).
   */
  gint last_point_1_idx;

  /* The last pointed monomer is the one on which the cursor was
   * clicked/unclicked. Variant _2_ is for button 2 of the mouse
   * (middle).
   */
  gint last_point_2_idx;
  
  /* The last pointed monomer is the one on which the cursor was
   * clicked/unclicked. Variant _3_ is for button 3 of the mouse
   * (right).
   */
  gint last_point_3_idx;
  
  /* The last moused monomer is the one on which the cursor was 
   * passed over.
   */
  gint last_mouse_idx;
  
  /* GPtrArray* of the monicons that are created upon displaying of
  * a polymer sequence.
  */
  GPtrArray *moniconGPA;

  /* GPtrArray* of the labels that indicate the position in the
   * sequence, in the left margin.
   */
  GPtrArray *labelGPA;

  /* The size of the side of the square in which the monomer icon is
   * to be rendered (unit: pixel).
   */
  gint monicon_size;

  /* Currently elaborating monomer code string.
   */
  gchar *elab_code;

  /* Already completed code ready for evaluation.
   */
  gchar *eval_code;

  /* Holds how many characters already have been typed during the code
   * elaborating process (in the elab_code string holder)
   */
  gint kb_typed_chars;

  /* GtkEntry widget in the sequence editor context, where the elaborating 
   * monomer code is to be displayed.
   */
  GtkWidget *elab_code_entry;

  /* GtkEntry widget in the sequence editor context, where the non
   * abortive editing error messages are displayed, only in the
   * context of sequence editing.
   */
  GtkWidget *error_code_entry;

  /* GtkEntry widget in the sequence editor context, where all the
   * general messages (error or non-error) are are displayed.
   */
  GtkWidget *messages_entry;

  /* Contains all the prop instances describing how to render a number
   * of visual effects.
   */
  GPtrArray *visualGPA;

  /* The conventional system of prop array.
   */
  GPtrArray *propGPA;
};




/* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
 */
PxmSeqEditorCtxt *
polyxedit_seqeditorctxt_new (void);

gboolean
polyxedit_seqeditorctxt_new_eval_code (PxmSeqEditorCtxt *seqeditorctxt, 
				       gint codelen);

gboolean
polyxedit_seqeditorctxt_new_elab_code (PxmSeqEditorCtxt *seqeditorctxt, 
				       gint codelen);




/* FREE'ING FUNCTIONS
 */
gboolean
polyxedit_seqeditorctxt_free (PxmSeqEditorCtxt *seqeditorctxt);




/* GPtrArray-RELATED FUNCTIONS
 */












#endif /*POLYXEDIT_SEQEDITORCTXT_H*/
