/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef POLYXEDIT_MONOMER_MODIF_H
#define POLYXEDIT_MONOMER_MODIF_H


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "polyxedit-globals.h"
#include "polyxedit-editctxt.h"


/* PxmModifRes holds results pertaining to the modification of
   monomer. Since such a modification is a two-step process, first
   being the chemical modification of the monomer, and second being
   the graphical rendering of such modification, we have to describe
   the results pertaining to these two processes. Y = success, N =
   failure.
*/
typedef enum
{
  MODIF_CHEM_Y_RENDER_Y,
  MODIF_CHEM_Y_RENDER_N,
  MODIF_CHEM_N_RENDER_Y,
  MODIF_CHEM_N_RENDER_N,
} PxmModifRes;


PxmModifRes
polyxedit_monomer_modif_modify_monomer (PxmMonomer *mnm,
					gint idx,
					gchar *modif,
					PxmEditCtxt *editctxt);
void
polyxedit_monomer_modif_modify_monomer_GA (GArray *GA,
					   gchar *modif,
					   PxmEditCtxt *editctxt,
					   gchar **errors,
					   gint *full_success,
					   gint *full_failure,
					   gint *chem_failure,
					   gint *render_failure);


PxmModifRes
polyxedit_monomer_modif_un_modify_monomer (PxmMonomer *mnm,
					   gint idx,
					   gchar *modif,
					   PxmEditCtxt *editctxt);

void
polyxedit_monomer_modif_un_modify_monomer_GA (GArray *GA,
					      gchar *modif,
					      PxmEditCtxt *editctxt,
					      gchar **errors,
					      gint *full_success,
					      gint *full_failure,
					      gint *chem_failure,
					      gint *render_failure);









#endif /* POLYXEDIT_MONOMER_MODIF_H */
