/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef POLYXEDIT_GLOBALS_H
#define POLYXEDIT_GLOBALS_H


#include "polyxmass-globals.h"

typedef struct _PxmRect PxmRect;


struct _PxmRect
{
  gdouble x1;
  gdouble y1;
  
  gdouble x2;
  gdouble y2;
};



/*
the positions caracterizing a monomer bitmap are x 
and y for the following :

NW-----CN-----NE
|             | 
|             | 
|             | 
CW            CE
|             | 
|             | 
|             | 
SW-----CS-----SE

*/

typedef enum
{
  COORDSYS_NW,
  COORDSYS_NE,
  COORDSYS_SW,
  COORDSYS_SE,
  COORDSYS_C,
  COORDSYS_CE,
  COORDSYS_CS,
  COORDSYS_CN,
  COORDSYS_CW
} PxmCoordsys ;


/* Used when displaying modifications' name and actform 
   in a GtkTreeView (or List).
*/
enum
  {
    COLUMN_MDF_NAME,
    COLUMN_MDF_ACTFORM,
    COLUMN_MDF_EDITABLE,
    COLUMN_MDF_COL_COUNT
  };

/* Used when displaying monomers' name, code and formula 
   in a GtkTreeView (or List).
*/
enum
  {
    COLUMN_MNM_NAME,
    COLUMN_MNM_CODE,
    COLUMN_MNM_FORMULA,
    COLUMN_MNM_EDITABLE,
    COLUMN_MNM_COL_COUNT
  };

/* When editing notes, it may be for polymer notes or 
   monomer notes.
*/
enum
  {
    NOTE_TARGET_POLYMER,
    NOTE_TARGET_MONOMER_RANGE,
    NOTE_TARGET_MONOMER_SINGLE
  };

gboolean kbd_alt_down ;
gboolean kbd_control_down;
gboolean kbd_meta_down;
gboolean kbd_shift_down;
	 
gboolean kbd_selecting;


gboolean mouse_dragging;

gchar *polyxedit_tolerance_units_amu ;
gchar *polyxedit_tolerance_units_pct ;
gchar *polyxedit_tolerance_units_ppm ;


/* A number of generally available data.
 */
GPtrArray *polyxedit_editctxtGPA;

gboolean polyxedit_uninitialized;

gpointer *polyxedit_last_editctxt;


/* The window where the masses for all the editctxt's are shown...
 */
GtkWidget *polyxedit_masses_display_wnd;













#endif /* ifndef POLYXEDIT_GLOBALS_H */
