/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#ifndef POLYXCALC_UI_MAIN_H
#define POLYXCALC_UI_MAIN_H

#include "polyxcalc-globals.h"
#include "polyxcalc-calcctxt.h"


GtkWidget *
polyxcalc_ui_calculator_wnd_setup_window (PxmCalcCtxt *calcctxt);




/* COMBO FILLING FUNCTION FOR ATOMS, MONOMERS AND MODIFS
 */
gint
polyxcalc_ui_calculator_wnd_fill_atoms_combobox (PxmCalcCtxt *calcctxt);

gint
polyxcalc_ui_calculator_wnd_fill_monomers_combobox (PxmCalcCtxt *calcctxt);

gint
polyxcalc_ui_calculator_wnd_fill_modifs_combobox (PxmCalcCtxt *calcctxt);



/* OPERATIONS BUTTONS' HANDLERS.
 */
void 
polyxcalc_ui_calculator_wnd_apply_button (GtkWidget *button,
			     gpointer data);

void
polyxcalc_ui_calculator_wnd_clear_all_chemistry_button (GtkWidget *button,
				      gpointer data);

void 
polyxcalc_ui_calculator_wnd_mz_ratio_calculator_button (GtkWidget *button,
							gpointer data);

void 
polyxcalc_ui_calculator_wnd_toggle_chempad_window_button (GtkWidget *button,
					gpointer data);

void 
polyxcalc_ui_calculator_wnd_toggle_recorder_window_button (GtkWidget *button,
							   gpointer data);



/* Mass-related functions.
*/

/* Initial masses
 */
void 
polyxcalc_ui_calculator_wnd_init_masses_add_to_res_button (GtkWidget *button,
					 gpointer data);

void 
polyxcalc_ui_calculator_wnd_init_masses_rem_from_res_button (GtkWidget *button,
					   gpointer data);

void 
polyxcalc_ui_calculator_wnd_init_masses_send_to_res_button (GtkWidget *button,
					  gpointer data);

void 
polyxcalc_ui_calculator_wnd_init_masses_clear_button (GtkWidget *button,
				    gpointer data);

/* Results masses
 */
void 
polyxcalc_ui_calculator_wnd_res_masses_add_to_init_button (GtkWidget *button,
					 gpointer data);

void 
polyxcalc_ui_calculator_wnd_res_masses_rem_from_init_button (GtkWidget *button,
					   gpointer data);

void 
polyxcalc_ui_calculator_wnd_res_masses_send_to_init_button (GtkWidget *button,
					  gpointer data);
void 
polyxcalc_ui_calculator_wnd_res_masses_clear_button (GtkWidget *button,
				   gpointer data);




/* Show/Hide widget checkbuttons.
 */
void 
polyxcalc_ui_calculator_wnd_univ_chem_elem_checkbutton (GtkWidget *widget,
							gpointer data);

void 
polyxcalc_ui_calculator_wnd_atoms_checkbutton (GtkWidget *widget,
			     gpointer data);

void 
polyxcalc_ui_calculator_wnd_formula_actform_checkbutton (GtkWidget *widget,
				       gpointer data);

void 
polyxcalc_ui_calculator_wnd_polchemdefspec_elem_checkbutton (GtkWidget *widget,
					    gpointer data);

void 
polyxcalc_ui_calculator_wnd_monomers_checkbutton (GtkWidget *widget,
				gpointer data);

void 
polyxcalc_ui_calculator_wnd_modifications_checkbutton (GtkWidget *widget,
				     gpointer data);

void 
polyxcalc_ui_calculator_wnd_polymer_sequence_checkbutton (GtkWidget *widget,
					gpointer data);




/* WINDOW LIFE CYCLE-RELATED FUNCTIONS
 */
gboolean
polyxcalc_ui_calculator_wnd_delete_event (GtkWidget *widget,
				  GdkEvent *event,
				  gpointer data);

gboolean
polyxcalc_ui_calculator_wnd_destroy_event (GtkWidget *widget,
				  GdkEvent *event,
				  gpointer data);








#endif /* ifndef POLYXCALC_UI_MAIN_H */
