/*
FUNCTION
<<tmpfile>>---create a temporary file

INDEX
	tmpfile
INDEX
	_tmpfile_r

ANSI_SYNOPSIS
	#include <stdio.h>
	FILE *tmpfile(void);

	FILE *_tmpfile_r(void *<[reent]>);

TRAD_SYNOPSIS
	#include <stdio.h>
	FILE *tmpfile();

	FILE *_tmpfile_r(<[reent]>)
	char *<[reent]>;

DESCRIPTION
Create a temporary file (a file which will be deleted automatically),
using a name generated by <<tmpnam>>.  The temporary file is opened with
the mode <<"wb+">>, permitting you to read and write anywhere in it
as a binary file (without any data transformations the host system may
perform for text files).

The alternate function <<_tmpfile_r>> is a reentrant version.  The
argument <[reent]> is a pointer to a reentrancy structure.

RETURNS
<<tmpfile>> normally returns a pointer to the temporary file.  If no
temporary file could be created, the result is NULL, and <<errno>>
records the reason for failure.

PORTABILITY
Both ANSI C and the System V Interface Definition (Issue 2) require
<<tmpfile>>.

Supporting OS subroutines required: <<close>>, <<fstat>>, <<getpid>>,
<<isatty>>, <<lseek>>, <<open>>, <<read>>, <<sbrk>>, <<write>>.

<<tmpfile>> also requires the global pointer <<environ>>.
*/

#include <stdio.h>
#include <errno.h>

FILE *
_DEFUN (_tmpfile_r, (ptr),
	struct _reent *ptr)
{
  FILE *fp;
  int e;
  char *f;
  char buf[L_tmpnam];

  if ((f = _tmpnam_r (ptr, buf)) == NULL)
    return NULL;
  fp = fopen (f, "wb+");
  e = ptr->_errno;
  _CAST_VOID remove (f);
  ptr->_errno = e;
  return fp;
}

#ifndef _REENT_ONLY

FILE *
_DEFUN_VOID (tmpfile)
{
  return _tmpfile_r (_REENT);
}

#endif
