/*	test_Percent_Bar

CVS ID: test_Percent_Bar.java,v 1.3 2012/04/16 06:23:00 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import PIRL.Viewers.Percent_Bar;

import	javax.swing.JFrame;
import	javax.swing.JPanel;
import	javax.swing.JSlider;
import	javax.swing.event.ChangeListener;
import	javax.swing.event.ChangeEvent;
import	java.awt.GridBagLayout;
import	java.awt.GridBagConstraints;
import	java.awt.Insets;
import	java.awt.Dimension;
import	java.awt.Color;


public class test_Percent_Bar
{
static private Percent_Bar
	Bar;

static private JSlider
	Slider		= new JSlider ();


public static void main
	(
	String[]	arguments
	)
{
System.out.println (Percent_Bar.ID);

JFrame
	frame = new JFrame ("Percent_Bar Test");
frame.setDefaultCloseOperation (JFrame.EXIT_ON_CLOSE);
JPanel
	panel = new JPanel (new GridBagLayout ());
GridBagConstraints
	location = new GridBagConstraints ();

//	Bar:
Bar = new Percent_Bar ();
Bar.setPreferredSize (new Dimension (50, 15));
Bar.setForeground (Color.GREEN);
location.fill = GridBagConstraints.HORIZONTAL;
location.weightx = 1.0;
location.gridwidth	= GridBagConstraints.REMAINDER;
location.insets = new Insets (10, 10, 5, 10);
panel.add (Bar, location);

//	Slider:
Slider = new JSlider ();
Slider.addChangeListener (new ChangeListener ()
	{public void stateChanged (ChangeEvent event)
	{Percent_Changed (((JSlider)event.getSource ()).getValue ());}});
location.insets = new Insets (0, 0, 10, 0);
panel.add (Slider, location);

Bar.Percent ((double)Slider.getValue ());

frame.setContentPane (panel);
frame.pack ();
frame.setVisible (true);
}


private static void Percent_Changed
	(
	int		value
	)
{
System.out.println ("Percent: " + value);
Bar.Percent ((double)value);}

}
