/*
 * Menu stuff for PIMPPA's browser
 *
 */

#include <stdio.h>
#include "proto.h"

GtkWidget *statusBar;

static void 
quit_cb(GtkWidget *widget, gpointer data)
{
	save_yourself();
	gtk_main_quit();
}

static void 
about_cb(GtkWidget *widget, gpointer data) 
{
	GtkWidget *about;
	const gchar *authors[] = {"Igor Wronsky <iwronsky@users.sourceforge.net>", NULL};
  
	about = gnome_about_new ("bowser", VERSION, "(C) RRR Sorority Division. Released under GNU General Public License.",
	authors,"\nPIMPPA homepage: http://pimppa.sourceforge.net/\n", NULL);
	gnome_dialog_set_parent(GNOME_DIALOG (about),GTK_WINDOW(Bowser));
	gtk_widget_show (about);
}


GnomeUIInfo file_menu[] = {
//	GNOMEUIINFO_MENU_SELECT_ALL_ITEM(select_all, NULL),
//	GNOMEUIINFO_ITEM_NONE("_Unselect All","Unselect All Files",unselect_all),
//	GNOMEUIINFO_SEPARATOR,
//	GNOMEUIINFO_ITEM_NONE("_edit","Edit selected",edit_file),
//	GNOMEUIINFO_ITEM_NONE("delete","Delete selected",delete_file),
//	GNOMEUIINFO_ITEM_NONE("_move","Move selected",move_file),
//	GNOMEUIINFO_ITEM_NONE("_view","View selected",view_file),
	GNOMEUIINFO_ITEM_NONE("Leech _All","Download all newsgroups", leech_all),
	GNOMEUIINFO_ITEM_NONE("_Leech selected","Choose & download newsgroups", leech_win),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_ITEM_DATA("Ad_opt files","Adopt files to database (calls 'padopt -v')", externcmd, "padopt -v", NULL),
	GNOMEUIINFO_ITEM_DATA("_Test files","Test untested files (calls 'ptest -v')", externcmd, "ptest -v", NULL),
	GNOMEUIINFO_ITEM_DATA("T_ransform files","Process untransformed files (calls 'ptrans -v')", externcmd, "ptrans -v", NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_EXIT_ITEM(quit_cb,NULL),
	GNOMEUIINFO_END
};

GnomeUIInfo settings_menu[] = {
	GNOMEUIINFO_MENU_PREFERENCES_ITEM(preferences, NULL),
	GNOMEUIINFO_END
};

GnomeUIInfo extra_menu[] = {
	GNOMEUIINFO_ITEM_NONE("View _since", "Calls shell script 'pv_since'", view_since),
	GNOMEUIINFO_ITEM_DATA("View since _last","Calls shell script 'pv_last'", externcmd, "pv_last", NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_ITEM_DATA("_Mark offline files","Marks offline files (calls 'pmarkoff')", externcmd, "pmarkoff", NULL),
	GNOMEUIINFO_ITEM_DATA("Delete broken files","Deletes broken files (calls 'pclean -v -f')", externcmd, "pclean -v -f", NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_ITEM_DATA("Recreate assign patterns","Creates assign patterns (calls 'passign -r')", externcmd, "passign -r", NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_ITEM_DATA("Recreate MD5 checksums","Calculates MD5 checksums for online files (calls 'pmd5sum -v -c')", externcmd, "pmd5sum -v -c", NULL),
	GNOMEUIINFO_ITEM_DATA("_Look for MD5 collisions","Displays MD5-colliding files (calls 'pmd5sum -v -s')", externcmd, "pmd5sum -v -s", NULL),
	GNOMEUIINFO_ITEM_DATA("Delete MD5 colliding files","Deletes MD5-colliding files, preserves oldest (calls 'pmd5sum -v -w')", externcmd, "pmd5sum -v -w", NULL),
	GNOMEUIINFO_END
};

GnomeUIInfo help_menu[] = {
	GNOMEUIINFO_ITEM_DATA("Show _Info Window","Open the info window", createinfowindow, (void *)1, NULL),
	GNOMEUIINFO_ITEM_NONE("_Stats","Show PIMPPA db statistics", show_stats),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_ABOUT_ITEM(about_cb, NULL),
	GNOMEUIINFO_END
};	  

GnomeUIInfo menubar[] = {
	GNOMEUIINFO_MENU_FILE_TREE(file_menu),
	GNOMEUIINFO_MENU_SETTINGS_TREE(settings_menu),
	GNOMEUIINFO_SUBTREE("_Extras", extra_menu),
//	GNOMEUIINFO_SUBTREE("_File", file_menu),
//	GNOMEUIINFO_SUBTREE("_Areas",area_menu),
//	GNOMEUIINFO_SUBTREE("_Tools",tool_menu),
	GNOMEUIINFO_MENU_HELP_TREE(help_menu),
	GNOMEUIINFO_END
};

#define HELPMENU_NUMBER		1

/***************** Code begins ****************************/

void newbox(gchar *boxname, GtkWidget *vbox, gchar *initstring, GtkWidget **entry, gint boxlen)
{
	GtkWidget *label, *table;

	table = gtk_table_new( 1, 1, FALSE );

	label = gtk_label_new(boxname);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment( GTK_MISC( label ), 1.0, 0.5 );
//	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
    gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1, 
						GTK_FILL, 0, 5, 5 );
	
	*entry=gtk_entry_new_with_max_length(boxlen);
    gtk_entry_set_text(GTK_ENTRY (*entry), initstring);
 //   gtk_container_add(GTK_CONTAINER(vbox), *entry);
	gtk_table_attach( GTK_TABLE( table ), *entry, 1, 2, 0, 1, GTK_FILL|GTK_EXPAND, 0, 5, 5 );
	
	gtk_box_pack_start(GTK_BOX(vbox),table,TRUE,TRUE,0);
		
	gtk_widget_show(label);
    gtk_widget_show(*entry);
	gtk_widget_show(table);

	return;
}

void create_menus(void)
{
	gnome_app_create_menus (GNOME_APP (Bowser), menubar);
//	gtk_menu_item_right_justify (GTK_MENU_ITEM (menubar[HELPMENU_NUMBER].widget));

	statusBar=gnome_appbar_new(TRUE, TRUE, GNOME_PREFERENCES_USER);
	gnome_app_set_statusbar(GNOME_APP(Bowser), statusBar);

	gnome_app_install_menu_hints(GNOME_APP(Bowser), menubar);
	
}
