#include "iso2022.h"

extern UNICHAR map_ANSI_X3_110_1983[];
extern UNICHAR map_T_61_8bit[];
extern UNICHAR map_T_101_G2[];
extern UNICHAR map_iso_ir_90[];
extern UNICHAR map_videotex_suppl[];

UNICHAR map_ISO_646_irv_1983[] = {
  0x0021, 0x0022, 0x0023, 0x00a4, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x0040,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 0x0060,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, };
UNICHAR map_BS_4730[] = {
  0x0021, 0x0022, 0x00a3, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x0040,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 0x0060,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, };
UNICHAR map_ANSI_X3_4_1968[] = {
  0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x0040,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 0x0060,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, };
UNICHAR map_NATS_SEFI[] = {
  0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0xe002,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x00c4, 0x00d6, 0x00c5, 0x25a0, 0x005f, 0xe003,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0x00e4, 0x00f6, 0x00e5, 0x2013, };
UNICHAR map_NATS_SEFI_ADD[] = {
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0x00c0, 0xfffd, 0xfffd, 0x0110, 0x00c9, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x00de,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x00dc, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x00c6, 0x00d8, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0x00e0, 0xfffd, 0xfffd, 0x0111, 0x00e9, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x00fe,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x00fc, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x00e6, 0x00f8, 0xfffd, 0xfffd, };
UNICHAR map_NATS_DANO[] = {
  0x0021, 0x00ab, 0x00bb, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0xe002,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x00c6, 0x00d8, 0x00c5, 0x25a0, 0x005f, 0xe003,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0x00e6, 0x00f8, 0x00e5, 0x2013, };
UNICHAR map_NATS_DANO_ADD[] = {
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0x00c0, 0xfffd, 0xfffd, 0x0110, 0x00c9, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x00de,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x00dc, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x00c4, 0x00d6, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0x00e0, 0xfffd, 0xfffd, 0x0111, 0x00e9, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x00fe,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x00fc, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x00e4, 0x00f6, 0xfffd, 0xfffd, };
UNICHAR map_SEN_850200_B[] = {
  0x0021, 0x0022, 0x0023, 0x00a4, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x0040,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x00c4, 0x00d6, 0x00c5, 0x005e, 0x005f, 0x0060,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0x00e4, 0x00f6, 0x00e5, 0x007e, };
UNICHAR map_SEN_850200_C[] = {
  0x0021, 0x0022, 0x0023, 0x00a4, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x00c9,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x00c4, 0x00d6, 0x00c5, 0x00dc, 0x005f, 0x00e9,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0x00e4, 0x00f6, 0x00e5, 0x00fc, };
UNICHAR map_JIS_C6220_1969_jp[] = {
  0x3002, 0x300c, 0x300d, 0x3001, 0x30fb, 0x30f2, 0x30a1, 0x30a3,
  0x30a5, 0x30a7, 0x30a9, 0x30e3, 0x30e5, 0x30e7, 0x30c3, 0x30fc,
  0x30a2, 0x30a4, 0x30a6, 0x30a8, 0x30aa, 0x30ab, 0x30ad, 0x30af,
  0x30b1, 0x30b3, 0x30b5, 0x30b7, 0x30b9, 0x30bb, 0x30bd, 0x30bf,
  0x30c1, 0x30c4, 0x30c6, 0x30c8, 0x30ca, 0x30cb, 0x30cc, 0x30cd,
  0x30ce, 0x30cf, 0x30d2, 0x30d5, 0x30d8, 0x30db, 0x30de, 0x30df,
  0x30e0, 0x30e1, 0x30e2, 0x30e4, 0x30e6, 0x30e8, 0x30e9, 0x30ea,
  0x30eb, 0x30ec, 0x30ed, 0x30ef, 0x30f3, 0x309b, 0x309c, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, };
UNICHAR map_JIS_C6220_1969_ro[] = {
  0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x0040,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x005b, 0x00a5, 0x005d, 0x005e, 0x005f, 0x0060,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, };
UNICHAR map_DIN_66003[] = {
  0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x00a7,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x00c4, 0x00d6, 0x00dc, 0x005e, 0x005f, 0x0060,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0x00e4, 0x00f6, 0x00fc, 0x00df, };
UNICHAR map_PT[] = {
  0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x00a7,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x00c3, 0x00c7, 0x00d5, 0x005e, 0x005f, 0x0060,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0x00e3, 0x00e7, 0x00f5, 0x00b0, };
UNICHAR map_ISO_5427[] = {
  0x0021, 0x0022, 0x0023, 0x00a4, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x044e,
  0x0430, 0x0431, 0x0446, 0x0434, 0x0435, 0x0444, 0x0433, 0x0445,
  0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e, 0x043f,
  0x044f, 0x0440, 0x0441, 0x0442, 0x0443, 0x0436, 0x0432, 0x044c,
  0x044b, 0x0437, 0x0448, 0x044d, 0x0449, 0x0447, 0x044a, 0x042e,
  0x0410, 0x0411, 0x0426, 0x0414, 0x0415, 0x0424, 0x0413, 0x0425,
  0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e, 0x041f,
  0x042f, 0x0420, 0x0421, 0x0422, 0x0423, 0x0416, 0x0412, 0x042c,
  0x042b, 0x0417, 0x0428, 0x042d, 0x0429, 0x0427, };
UNICHAR map_ISO_5427_1981[] = {
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x0491,
  0x0452, 0x0453, 0x0454, 0x0451, 0x0455, 0x0456, 0x0457, 0x0458,
  0x0459, 0x045a, 0x045b, 0x045c, 0x045e, 0x045f, 0xfffd, 0x0463,
  0x0473, 0x0475, 0x046b, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x005b, 0xfffd, 0x005d, 0xfffd, 0x005f, 0x0490,
  0x0402, 0x0403, 0x0404, 0x0401, 0x0405, 0x0406, 0x0407, 0x0408,
  0x0409, 0x040a, 0x040b, 0x040c, 0x040e, 0x040f, 0x042a, 0x0462,
  0x0472, 0x0474, 0x046a, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, };
UNICHAR map_NF_Z_62_010_1973[] = {
  0x0021, 0x0022, 0x00a3, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x00e0,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x00b0, 0x00e7, 0x00a7, 0x005e, 0x005f, 0x0060,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0x00e9, 0x00f9, 0x00e8, 0x00a8, };
UNICHAR map_ISO_5428_1980[] = {
  0xe006, 0xe007, 0xe00d, 0xe009, 0xe018, 0xe017, 0xe016, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x00ab,
  0x00bb, 0x201d, 0x201c, 0x03d8, 0x03d9, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x00b7, 0xfffd, 0xfffd, 0xfffd, 0x003b, 0xfffd,
  0x0391, 0x0392, 0xfffd, 0x0393, 0x0394, 0x0395, 0x03da, 0x03dc,
  0x0396, 0x0397, 0x0398, 0x0399, 0x039a, 0x039b, 0x039c, 0x039d,
  0x039e, 0x039f, 0x03a0, 0x03de, 0x03a1, 0x03a3, 0xfffd, 0x03a4,
  0x03a5, 0x03a6, 0x03a7, 0x03a8, 0x03a9, 0x03e0, 0xfffd, 0xfffd,
  0x03b1, 0x03b2, 0xe01b, 0x03b3, 0x03b4, 0x03b5, 0x03db, 0x03dd,
  0x03b6, 0x03b7, 0x03b8, 0x03b9, 0x03ba, 0x03bb, 0x03bc, 0x03bd,
  0x03be, 0x03bf, 0x03c0, 0x03df, 0x03c1, 0x03c3, 0x03c2, 0x03c4,
  0x03c5, 0x03c6, 0x03c7, 0x03c8, 0x03c9, 0x03e1, };
UNICHAR map_GB_1988_80[] = {
  0x0021, 0x0022, 0x0023, 0x00a5, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x0040,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 0x0060,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, };
UNICHAR map_Latin_greek_1[] = {
  0x039e, 0x0022, 0x0393, 0x00a4, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x03a8, 0x003b, 0x003c, 0x003d, 0x003e, 0x03a0, 0x0394,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x03a9, 0x0398, 0x03a6, 0x039b, 0x03a3, 0x0060,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, };
UNICHAR map_BS_viewdata[] = {
  0x0021, 0x0022, 0x00a3, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x0040,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x2190, 0x00bd, 0x2192, 0x2191, 0x25a1, 0x0060,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0x00bc, 0x2225, 0x00be, 0x00f7, };
UNICHAR map_INIS[] = {
  0xfffd, 0xfffd, 0xfffd, 0x0024, 0x0025, 0xfffd, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0xfffd, 0xfffd,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x005b, 0xfffd, 0x005d, 0xfffd, 0xfffd, 0xfffd,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0xfffd, 0x007c, 0xfffd, 0xfffd, };
UNICHAR map_IT[] = {
  0x0021, 0x0022, 0x00a3, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x00a7,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x00b0, 0x00e7, 0x00e9, 0x005e, 0x005f, 0x00f9,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0x00e0, 0x00f2, 0x00e8, 0x00ec, };
UNICHAR map_ES[] = {
  0x0021, 0x0022, 0x00a3, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x00a7,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x00a1, 0x00d1, 0x00bf, 0x005e, 0x005f, 0x0060,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0x00b0, 0x00f1, 0x00e7, 0x007e, };
UNICHAR map_greek7_old[] = {
  0x0021, 0x0022, 0x00a3, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x00b4,
  0x03b1, 0x03b2, 0x03c8, 0x03b4, 0x03b5, 0x03c6, 0x03b3, 0x03b7,
  0x03b9, 0x03be, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03bf, 0x03c0,
  0x03f5, 0x03c1, 0x03c3, 0x03c4, 0x03b8, 0x03c9, 0x03c2, 0x03c7,
  0x03c5, 0x03b6, 0x1f05, 0xe01a, 0x1f01, 0x007e, 0x005f, 0x0060,
  0x0391, 0x0392, 0x03a8, 0x0394, 0x0395, 0x03a6, 0x0393, 0x0397,
  0x0399, 0x039e, 0x039a, 0x039b, 0x039c, 0x039d, 0x039f, 0x03a0,
  0xfffd, 0x03a1, 0x03a3, 0x03a4, 0x0398, 0x03a9, 0x00b7, 0x03a7,
  0x03a5, 0x0396, 0x1f04, 0xe019, 0x1f00, 0x00a8, };
UNICHAR map_latin_greek[] = {
  0x0021, 0x0022, 0x00a3, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x0040,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 0x0060,
  0x0391, 0x0392, 0x03a8, 0x0394, 0x0395, 0x03a6, 0x0393, 0x0397,
  0x0399, 0x039e, 0x039a, 0x039b, 0x039c, 0x039d, 0x039f, 0x03a0,
  0xfffd, 0x03a1, 0x03a3, 0x03a4, 0x0398, 0x03a9, 0x00b7, 0x03a7,
  0x03a5, 0x0396, 0x007b, 0x007c, 0x007d, 0x00a8, };
UNICHAR map_INIS_8[] = {
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0x03b1, 0x03b2, 0x03b3, 0x03b4, 0x039e, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x2192, 0x222b, 0x2070,
  0x00b9, 0x00b2, 0x00b3, 0x2074, 0x2075, 0x2076, 0x2077, 0x2078,
  0x2079, 0x207a, 0x207b, 0x30eb, 0x0394, 0x039b, 0x03a9, 0x2080,
  0x2081, 0x2082, 0x2083, 0x2084, 0x2085, 0x2086, 0x2087, 0x2088,
  0x2089, 0x03a3, 0x03bc, 0x03bd, 0x03c9, 0x03c0, };
UNICHAR map_INIS_cyrillic[] = {
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0x221a, 0xfffd, 0x2192, 0x222b, 0x03b1,
  0x03b2, 0x03b3, 0x03b4, 0x03a3, 0x03bc, 0x03bd, 0x03c9, 0x03c0,
  0x039e, 0x0394, 0x039b, 0x03a9, 0x042a, 0x207b, 0x207a, 0x044e,
  0x0430, 0x0431, 0x0446, 0x0434, 0x0435, 0x0444, 0x0433, 0x0445,
  0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e, 0x043f,
  0x044f, 0x0440, 0x0441, 0x0442, 0x0443, 0x0436, 0x0432, 0x044c,
  0x044b, 0x0437, 0x0448, 0x044d, 0x0449, 0x0447, 0x044a, 0x042e,
  0x0410, 0x0411, 0x0426, 0x0414, 0x0415, 0x0424, 0x0413, 0x0425,
  0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e, 0x041f,
  0x042f, 0x0420, 0x0421, 0x0422, 0x0423, 0x0416, 0x0412, 0x042c,
  0x042b, 0x0417, 0x0428, 0x042d, 0x0429, 0x0427, };
UNICHAR map_NS_4551_1[] = {
  0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x0040,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x00c6, 0x00d8, 0x00c5, 0x005e, 0x005f, 0x0060,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0x00e6, 0x00f8, 0x00e5, 0x007e, };
UNICHAR map_NS_4551_2[] = {
  0x0021, 0x0022, 0x00b6, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x0040,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x00c6, 0x00d8, 0x00c5, 0x005e, 0x005f, 0x0060,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0x00e6, 0x00f8, 0x00e5, 0x007c, };
UNICHAR map_NF_Z_62_010[] = {
  0x0021, 0x0022, 0x00a3, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x00e0,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x00b0, 0x00e7, 0x00a7, 0x005e, 0x005f, 0x00b5,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0x00e9, 0x00f9, 0x00e8, 0x00a8, };
UNICHAR map_PT2[] = {
  0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x00b4,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x00c3, 0x00c7, 0x00d5, 0x005e, 0x005f, 0x0060,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0x00e3, 0x00e7, 0x00f5, 0x007e, };
UNICHAR map_ES2[] = {
  0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x2219,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x00a1, 0x00d1, 0x00c7, 0x00bf, 0x005f, 0x0060,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0x00b4, 0x00f1, 0x00e7, 0x00a8, };
UNICHAR map_MSZ_7795_3[] = {
  0x0021, 0x0022, 0x0023, 0x00a4, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x00c1,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x00c9, 0x00d6, 0x00dc, 0x005e, 0x005f, 0x00e1,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0x00e9, 0x00f6, 0x00fc, 0x02dd, };
UNICHAR map_greek7[] = {
  0x0021, 0x0022, 0x0023, 0x00a4, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x0040,
  0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 0x0398,
  0x0399, 0xfffd, 0x039a, 0x039b, 0x039c, 0x039d, 0x039e, 0x039f,
  0x03a0, 0x03a1, 0x03a3, 0x03a4, 0x03a5, 0x03a6, 0xfffd, 0x03a7,
  0x03a8, 0x03a9, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 0x0060,
  0x03b1, 0x03b2, 0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7, 0x03b8,
  0x03b9, 0xfffd, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf,
  0x03c0, 0x03c1, 0x03c3, 0x03c4, 0x03c5, 0x03c6, 0x03c2, 0x03c7,
  0x03c8, 0x03c9, 0x007b, 0x007c, 0x007d, 0x007e, };
UNICHAR map_ASMO_449[] = {
  0x0021, 0x0022, 0x0023, 0x00a4, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x060c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x061b, 0x003c, 0x003d, 0x003e, 0x061f, 0x0040,
  0x0621, 0x0622, 0x0623, 0x0624, 0x0625, 0x0626, 0x0627, 0x0628,
  0x0629, 0x062a, 0x062b, 0x062c, 0x062d, 0x062e, 0x062f, 0x0630,
  0x0631, 0x0632, 0x0633, 0x0634, 0x0635, 0x0636, 0x0637, 0x0638,
  0x0639, 0x063a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 0x0640,
  0x0641, 0x0642, 0x0643, 0x0644, 0x0645, 0x0646, 0x0647, 0x0648,
  0x0649, 0x064a, 0x064b, 0x064c, 0x064d, 0x064e, 0x064f, 0x0650,
  0x0651, 0x0652, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x007b, 0x007c, 0x007d, 0x007e, };
UNICHAR map_JIS_C6229_1984_a[] = {
  0xfffd, 0x0022, 0x00a3, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x2440, 0x003d, 0x2441, 0x003f, 0xfffd,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0xfffd, 0x00a5, 0x2442, 0x005e, 0x005f, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0x2443, 0xfffd, 0xfffd, };
UNICHAR map_JIS_C6229_1984_b[] = {
  0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x0040,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x2329, 0x00a5, 0x232a, 0x005e, 0x005f, 0xfffd,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0xfffd, };
UNICHAR map_JIS_C6229_1984_b_add[] = {
  0xfffd, 0xfffd, 0x00a3, 0x00a4, 0x005c, 0xfffd, 0x00a7, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, };
UNICHAR map_JIS_C6229_1984_hand[] = {
  0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x0040,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x2329, 0x00a5, 0x232a, 0x005e, 0x005f, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0x007c, 0xfffd, 0xfffd, };
UNICHAR map_JIS_C6229_1984_hand_add[] = {
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x005c, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, };
UNICHAR map_JIS_C6229_1984_kana[] = {
  0xfffd, 0x300c, 0x300d, 0xfffd, 0xfffd, 0x30f2, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x30fc,
  0x30a2, 0x30a4, 0x30a6, 0x30a8, 0x30aa, 0x30ab, 0x30ad, 0x30af,
  0x30b1, 0x30b3, 0x30b5, 0x30b7, 0x30b9, 0x30bb, 0x30bd, 0x30bf,
  0x30c1, 0x30c4, 0x30c6, 0x30c8, 0x30ca, 0x30cb, 0x30cc, 0x30cd,
  0x30ce, 0x30cf, 0x30d2, 0x30d5, 0x30d8, 0x30db, 0x30de, 0x30df,
  0x30e0, 0x30e1, 0x30e2, 0x30e4, 0x30e6, 0x30e8, 0x30e9, 0x30ea,
  0x30eb, 0x30ec, 0x30ed, 0x30ef, 0x30f3, 0x309b, 0x309c, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, };
UNICHAR map_ISO_2033_1983[] = {
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x2446, 0x2447, 0x2448, 0x2449, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, };
UNICHAR map_T_61_7bit[] = {
  0x0021, 0x0022, 0x0023, 0x00a4, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x0040,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x005b, 0xfffd, 0x005d, 0xfffd, 0x005f, 0xfffd,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0xfffd, 0x007c, 0xfffd, 0xfffd, };
UNICHAR map_CSA_Z243_4_1985_1[] = {
  0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x00e0,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x00e2, 0x00e7, 0x00ea, 0x00ee, 0x005f, 0x00f4,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0x00e9, 0x00f9, 0x00e8, 0x00fb, };
UNICHAR map_CSA_Z243_4_1985_2[] = {
  0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x00e0,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x00e2, 0x00e7, 0x00ea, 0x00c9, 0x005f, 0x00f4,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0x00e9, 0x00f9, 0x00e8, 0x00fb, };
UNICHAR map_JUS_I_B1_002[] = {
  0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x017d,
  0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
  0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
  0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
  0x0059, 0x005a, 0x0160, 0x0110, 0x0106, 0x010c, 0x005f, 0x017e,
  0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
  0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
  0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
  0x0079, 0x007a, 0x0161, 0x0111, 0x0107, 0x010d, };
UNICHAR map_JUS_I_B1_003_serb[] = {
  0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x0416,
  0x0410, 0x0411, 0x0426, 0x0414, 0x0415, 0x0424, 0x0413, 0x0425,
  0x0418, 0x0408, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e, 0x041f,
  0x0409, 0x0420, 0x0421, 0x0422, 0x0423, 0x0412, 0x040a, 0x040f,
  0x0405, 0x0417, 0x0428, 0x0402, 0x040b, 0x0427, 0x005f, 0x0436,
  0x0430, 0x0431, 0x0446, 0x0434, 0x0435, 0x0444, 0x0433, 0x0445,
  0x0438, 0x0458, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e, 0x043f,
  0x0459, 0x0440, 0x0441, 0x0442, 0x0443, 0x0432, 0x045a, 0x045f,
  0x0455, 0x0437, 0x0448, 0x0452, 0x045b, 0x0447, };
UNICHAR map_JUS_I_B1_003_mac[] = {
  0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
  0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
  0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
  0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x0416,
  0x0410, 0x0411, 0x0426, 0x0414, 0x0415, 0x0424, 0x0413, 0x0425,
  0x0418, 0x0408, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e, 0x041f,
  0x0409, 0x0420, 0x0421, 0x0422, 0x0423, 0x0412, 0x040a, 0x040f,
  0x0405, 0x0417, 0x0428, 0x0403, 0x040c, 0x0427, 0x005f, 0x0436,
  0x0430, 0x0431, 0x0446, 0x0434, 0x0435, 0x0444, 0x0433, 0x0445,
  0x0438, 0x0458, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e, 0x043f,
  0x0459, 0x0440, 0x0441, 0x0442, 0x0443, 0x0432, 0x045a, 0x045f,
  0x0455, 0x0437, 0x0448, 0x0453, 0x045c, 0x0447, };
UNICHAR map_ECMA_cyrillic[] = {
  0x00a0, 0x0401, 0x0402, 0x0403, 0x0404, 0x0405, 0x0406, 0x0407,
  0x0408, 0x0409, 0x040a, 0x040b, 0x040c, 0x00ad, 0x040e, 0x040f,
  0x2116, 0x0451, 0x0452, 0x0453, 0x0454, 0x0455, 0x0456, 0x0457,
  0x0458, 0x0459, 0x045a, 0x045b, 0x045c, 0x00a4, 0x045e, 0x045f,
  0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417,
  0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e, 0x041f,
  0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427,
  0x0428, 0x0429, 0x042a, 0x042b, 0x042c, 0x042d, 0x042e, 0x042f,
  0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437,
  0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e, 0x043f,
  0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447,
  0x0448, 0x0449, 0x044a, 0x044b, 0x044c, 0x044d, 0x044e, 0x044f, };
UNICHAR map_ISO_8859_1_1987[] = {
  0x00a0, 0x00a1, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7,
  0x00a8, 0x00a9, 0x00aa, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x00af,
  0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7,
  0x00b8, 0x00b9, 0x00ba, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00bf,
  0x00c0, 0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x00c7,
  0x00c8, 0x00c9, 0x00ca, 0x00cb, 0x00cc, 0x00cd, 0x00ce, 0x00cf,
  0x00d0, 0x00d1, 0x00d2, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x00d7,
  0x00d8, 0x00d9, 0x00da, 0x00db, 0x00dc, 0x00dd, 0x00de, 0x00df,
  0x00e0, 0x00e1, 0x00e2, 0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x00e7,
  0x00e8, 0x00e9, 0x00ea, 0x00eb, 0x00ec, 0x00ed, 0x00ee, 0x00ef,
  0x00f0, 0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x00f7,
  0x00f8, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x00fd, 0x00fe, 0x00ff, };
UNICHAR map_ISO_8859_2_1987[] = {
  0x00a0, 0x0104, 0x02d8, 0x0141, 0x00a4, 0x013d, 0x015a, 0x00a7,
  0x00a8, 0x0160, 0x015e, 0x0164, 0x0179, 0x00ad, 0x017d, 0x017b,
  0x00b0, 0x0105, 0x02db, 0x0142, 0x00b4, 0x013e, 0x015b, 0x02c7,
  0x00b8, 0x0161, 0x015f, 0x0165, 0x017a, 0x02dd, 0x017e, 0x017c,
  0x0154, 0x00c1, 0x00c2, 0x0102, 0x00c4, 0x0139, 0x0106, 0x00c7,
  0x010c, 0x00c9, 0x0118, 0x00cb, 0x011a, 0x00cd, 0x00ce, 0x010e,
  0x0110, 0x0143, 0x0147, 0x00d3, 0x00d4, 0x0150, 0x00d6, 0x00d7,
  0x0158, 0x016e, 0x00da, 0x0170, 0x00dc, 0x00dd, 0x0162, 0x00df,
  0x0155, 0x00e1, 0x00e2, 0x0103, 0x00e4, 0x013a, 0x0107, 0x00e7,
  0x010d, 0x00e9, 0x0119, 0x00eb, 0x011b, 0x00ed, 0x00ee, 0x010f,
  0x0111, 0x0144, 0x0148, 0x00f3, 0x00f4, 0x0151, 0x00f6, 0x00f7,
  0x0159, 0x016f, 0x00fa, 0x0171, 0x00fc, 0x00fd, 0x0163, 0x02d9, };
UNICHAR map_ISO_8859_3_1988[] = {
  0x00a0, 0x0126, 0x02d8, 0x00a3, 0x00a4, 0xfffd, 0x0124, 0x00a7,
  0x00a8, 0x0130, 0x015e, 0x011e, 0x0134, 0x00ad, 0xfffd, 0x017b,
  0x00b0, 0x0127, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x0125, 0x00b7,
  0x00b8, 0x0131, 0x015f, 0x011f, 0x0135, 0x00bd, 0xfffd, 0x017c,
  0x00c0, 0x00c1, 0x00c2, 0xfffd, 0x00c4, 0x010a, 0x0108, 0x00c7,
  0x00c8, 0x00c9, 0x00ca, 0x00cb, 0x00cc, 0x00cd, 0x00ce, 0x00cf,
  0xfffd, 0x00d1, 0x00d2, 0x00d3, 0x00d4, 0x0120, 0x00d6, 0x00d7,
  0x011c, 0x00d9, 0x00da, 0x00db, 0x00dc, 0x016c, 0x015c, 0x00df,
  0x00e0, 0x00e1, 0x00e2, 0xfffd, 0x00e4, 0x010b, 0x0109, 0x00e7,
  0x00e8, 0x00e9, 0x00ea, 0x00eb, 0x00ec, 0x00ed, 0x00ee, 0x00ef,
  0xfffd, 0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x0121, 0x00f6, 0x00f7,
  0x011d, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x016d, 0x015d, 0x02d9, };
UNICHAR map_ISO_8859_4_1988[] = {
  0x00a0, 0x0104, 0x0138, 0x0156, 0x00a4, 0x0128, 0x013b, 0x00a7,
  0x00a8, 0x0160, 0x0112, 0x0122, 0x0166, 0x00ad, 0x017d, 0x203e,
  0x00b0, 0x0105, 0x02db, 0x0157, 0x00b4, 0x0129, 0x013c, 0x02c7,
  0x00b8, 0x0161, 0x0113, 0x0123, 0x0167, 0x014a, 0x017e, 0x014b,
  0x0100, 0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x012e,
  0x010c, 0x00c9, 0x0118, 0x00cb, 0x0116, 0x00cd, 0x00ce, 0x012a,
  0x0110, 0x0145, 0x014c, 0x0136, 0x00d4, 0x00d5, 0x00d6, 0x00d7,
  0x00d8, 0x0172, 0x00da, 0x00db, 0x00dc, 0x0168, 0x016a, 0x00df,
  0x0101, 0x00e1, 0x00e2, 0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x012f,
  0x010d, 0x00e9, 0x0119, 0x00eb, 0x0117, 0x00ed, 0x00ee, 0x012b,
  0x0111, 0x0146, 0x014d, 0x0137, 0x00f4, 0x00f5, 0x00f6, 0x00f7,
  0x00f8, 0x0173, 0x00fa, 0x00fb, 0x00fc, 0x0169, 0x016b, 0x02d9, };
UNICHAR map_CSA_Z243_4_1985_gr[] = {
  0x00a0, 0x00a1, 0x00a8, 0x00a3, 0x00a2, 0x00a5, 0x00b1, 0x00b4,
  0x207d, 0x207e, 0x00bd, 0x207a, 0x00b8, 0x00ad, 0x00b7, 0x207b,
  0x2070, 0x00b9, 0x00b2, 0x00b3, 0x2074, 0x2075, 0x2076, 0x2077,
  0x2078, 0x2079, 0x00bc, 0x00be, 0x21d0, 0x2260, 0x2265, 0x00bf,
  0x00c0, 0x00c1, 0x00c2, 0x00c7, 0x00c8, 0x00c9, 0x00ca, 0x00cb,
  0x00cd, 0x00ce, 0x00cf, 0x00d1, 0x00d3, 0x00d4, 0x00d9, 0x00da,
  0x00db, 0x00dc, 0x00ae, 0x00a7, 0x00b6, 0x03bc, 0x00aa, 0x00ba,
  0x2018, 0x2019, 0x201c, 0x201d, 0x00ab, 0x00bb, 0x00b0, 0x00a6,
  0x00e0, 0x00e1, 0x00e2, 0x00e7, 0x00e8, 0x00e9, 0x00ea, 0x00eb,
  0x00ed, 0x00ee, 0x00ef, 0x00f1, 0x00f3, 0x00f4, 0x00f9, 0x00fa,
  0x00fb, 0x00fc, 0x00a9, 0x2500, 0x2502, 0x2514, 0x2518, 0x2510,
  0x250c, 0x251c, 0x2534, 0x2524, 0x252c, 0x253c, 0x00ac, 0x2588, };
UNICHAR map_ISO_8859_7_1987[] = {
  0x00a0, 0x201b, 0x2019, 0x00a3, 0xfffd, 0xfffd, 0x00a6, 0x00a7,
  0x00a8, 0x00a9, 0xfffd, 0x00ab, 0x00ac, 0x00ad, 0xfffd, 0x2014,
  0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x03f4, 0x0386, 0x00b7,
  0x0388, 0x0389, 0x038a, 0x00bb, 0x038c, 0x00bd, 0x038e, 0x038f,
  0x0390, 0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397,
  0x0398, 0x0399, 0x039a, 0x039b, 0x039c, 0x039d, 0x039e, 0x039f,
  0x03a0, 0x03a1, 0xfffd, 0x03a3, 0x03a4, 0x03a5, 0x03a6, 0x03a7,
  0x03a8, 0x03a9, 0x03aa, 0x03ab, 0x03ac, 0x03ad, 0x03ae, 0x03af,
  0x03b0, 0x03b1, 0x03b2, 0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7,
  0x03b8, 0x03b9, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf,
  0x03c0, 0x03c1, 0x03c2, 0x03c3, 0x03c4, 0x03c5, 0x03c6, 0x03c7,
  0x03c8, 0x03c9, 0x03ca, 0x03cb, 0x03cc, 0x03cd, 0x03ce, 0xfffd, };
UNICHAR map_ISO_8859_6_1987[] = {
  0x00a0, 0xfffd, 0xfffd, 0xfffd, 0x00a4, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x060c, 0x00ad, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0x061b, 0xfffd, 0xfffd, 0xfffd, 0x061f,
  0xfffd, 0x0621, 0x0622, 0x0623, 0x0624, 0x0625, 0x0626, 0x0627,
  0x0628, 0x0629, 0x062a, 0x062b, 0x062c, 0x062d, 0x062e, 0x062f,
  0x0630, 0x0631, 0x0632, 0x0633, 0x0634, 0x0635, 0x0636, 0x0637,
  0x0638, 0x0639, 0x063a, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0x0640, 0x0641, 0x0642, 0x0643, 0x0644, 0x0645, 0x0646, 0x0647,
  0x0648, 0x0649, 0x064a, 0x064b, 0x064c, 0x064d, 0x064e, 0x064f,
  0x0650, 0x0651, 0x0652, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, };
UNICHAR map_ISO_8859_8_1988[] = {
  0x00a0, 0xfffd, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7,
  0x00a8, 0x00a9, 0x00d7, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x203e,
  0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7,
  0x00b8, 0x00b9, 0x00f7, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x2017,
  0x05d0, 0x05d1, 0x05d2, 0x05d3, 0x05d4, 0x05d5, 0x05d6, 0x05d7,
  0x05d8, 0x05d9, 0x05da, 0x05db, 0x05dc, 0x05dd, 0x05de, 0x05df,
  0x05e0, 0x05e1, 0x05e2, 0x05e3, 0x05e4, 0x05e5, 0x05e6, 0x05e7,
  0x05e8, 0x05e9, 0x05ea, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, };
UNICHAR map_CSN_369103[] = {
  0x00a0, 0x0104, 0x02d8, 0x0141, 0x0024, 0x013d, 0x015a, 0x00a7,
  0x00a8, 0x0160, 0x015e, 0x0164, 0x0179, 0x00ad, 0x017d, 0x017b,
  0x00b0, 0x0105, 0x02db, 0x0142, 0x00b4, 0x013e, 0x015b, 0x02c7,
  0x00b8, 0x0161, 0x015f, 0x0165, 0x017a, 0x02dd, 0x017e, 0x017c,
  0x0154, 0x00c1, 0x00c2, 0x0102, 0x00c4, 0x0139, 0x0106, 0x00c7,
  0x010c, 0x00c9, 0x0118, 0x00cb, 0x011a, 0x00cd, 0x00ce, 0x010e,
  0x0110, 0x0143, 0x0147, 0x00d3, 0x00d4, 0x0150, 0x00d6, 0x00d7,
  0x0158, 0x016e, 0x00da, 0x0170, 0x00dc, 0x00dd, 0x0162, 0x00df,
  0x0155, 0x00e1, 0x00e2, 0x0103, 0x00e4, 0x013a, 0x0107, 0x00e7,
  0x010d, 0x00e9, 0x0119, 0x00eb, 0x011b, 0x00ed, 0x00ee, 0x010f,
  0x0111, 0x0144, 0x0148, 0x00f3, 0x00f4, 0x0151, 0x00f6, 0x00f7,
  0x0159, 0x016f, 0x00fa, 0x0171, 0x00fc, 0x00fd, 0x0163, 0x02d9, };
UNICHAR map_ISO_6937_2_add[] = {
  0x00a0, 0x00a1, 0x00a2, 0x00a3, 0x0024, 0x00a5, 0xfffd, 0x00a7,
  0xfffd, 0x2018, 0x201c, 0x00ab, 0x2190, 0x2191, 0x2192, 0x2193,
  0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x00d7, 0x00b5, 0x00b6, 0x00b7,
  0x00f7, 0x2019, 0x201d, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00bf,
  0xfffd, 0xe006, 0xe007, 0xe008, 0xe009, 0xe00a, 0xe00b, 0xe00c,
  0xe00d, 0xfffd, 0xe00e, 0xe011, 0xe013, 0xe00f, 0xe012, 0xe010,
  0x2014, 0x00b9, 0x00ae, 0x00a9, 0x2122, 0x2669, 0x00ac, 0x00a6,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x215b, 0x215c, 0x215d, 0x215e,
  0x2126, 0x00c6, 0x00d0, 0x00aa, 0x0126, 0xfffd, 0x0132, 0x013f,
  0x0141, 0x00d8, 0x0152, 0x00ba, 0x00de, 0x0166, 0x014a, 0x0149,
  0x0138, 0x00e6, 0x0111, 0x00f0, 0x0127, 0x0131, 0x0133, 0x0140,
  0x0142, 0x00f8, 0x0153, 0x00df, 0x00fe, 0x0167, 0x014b, 0x00ad, };
UNICHAR map_IEC_P27_1[] = {
  0x02c7, 0x2261, 0x2227, 0x2228, 0x2229, 0x222a, 0x2282, 0x2283,
  0x21d0, 0x21d2, 0x2234, 0x2235, 0x2208, 0x220b, 0x2286, 0x2287,
  0x222b, 0x222e, 0x221e, 0x2207, 0x2202, 0x223c, 0x2248, 0x2243,
  0x2245, 0x2264, 0x2260, 0x2265, 0x2194, 0x00ac, 0x2200, 0x2203,
  0x05d0, 0x25a1, 0x2225, 0x0393, 0x0394, 0x22a5, 0x2220, 0x221f,
  0x0398, 0x2329, 0x232a, 0x039b, 0x2032, 0x2033, 0x039e, 0x2213,
  0x03a0, 0x00b2, 0x03a3, 0x00d7, 0x00b3, 0x03a5, 0x03a6, 0x00b7,
  0x03a8, 0x03a9, 0x2205, 0xe025, 0x221a, 0xe01d, 0x221d, 0x00b1,
  0x00b0, 0x03b1, 0x03b2, 0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7,
  0x03b8, 0x03b9, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03be, 0x2030,
  0x03c0, 0x03c1, 0x03c3, 0x00f7, 0x03c4, 0x03c5, 0x03c6, 0x03c7,
  0x03c8, 0x03c9, 0x2020, 0x2190, 0x2191, 0x2192, 0x2193, 0x203e, };
UNICHAR map_ISO_8859_5_1988[] = {
  0x00a0, 0x0401, 0x0402, 0x0403, 0x0404, 0x0405, 0x0406, 0x0407,
  0x0408, 0x0409, 0x040a, 0x040b, 0x040c, 0x00ad, 0x040e, 0x040f,
  0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417,
  0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e, 0x041f,
  0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427,
  0x0428, 0x0429, 0x042a, 0x042b, 0x042c, 0x042d, 0x042e, 0x042f,
  0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437,
  0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e, 0x043f,
  0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447,
  0x0448, 0x0449, 0x044a, 0x044b, 0x044c, 0x044d, 0x044e, 0x044f,
  0x2116, 0x0451, 0x0452, 0x0453, 0x0454, 0x0455, 0x0456, 0x0457,
  0x0458, 0x0459, 0x045a, 0x045b, 0x045c, 0x00a7, 0x045e, 0x045f, };
UNICHAR map_ISO_8859_9_1989[] = {
  0x00a0, 0x00a1, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7,
  0x00a8, 0x00a9, 0x00aa, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x203e,
  0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7,
  0x00b8, 0x00b9, 0x00ba, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00bf,
  0x00c0, 0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x00c7,
  0x00c8, 0x00c9, 0x00ca, 0x00cb, 0x00cc, 0x00cd, 0x00ce, 0x00cf,
  0x011e, 0x00d1, 0x00d2, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x00d7,
  0x00d8, 0x00d9, 0x00da, 0x00db, 0x00dc, 0x0130, 0x015e, 0x00df,
  0x00e0, 0x00e1, 0x00e2, 0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x00e7,
  0x00e8, 0x00e9, 0x0119, 0x00eb, 0x0117, 0x00ed, 0x00ee, 0x012b,
  0x011f, 0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x00f7,
  0x00f8, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x0131, 0x015f, 0x00ff, };
UNICHAR map_ISO_6937_2_25[] = {
  0x00a0, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x201c, 0xfffd, 0x2190, 0x2191, 0x2192, 0x2193,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x201d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x2122, 0x2669, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x215b, 0x215c, 0x215d, 0x215e,
  0x2126, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x0132, 0x013f,
  0xfffd, 0xfffd, 0x0152, 0xfffd, 0x0174, 0x0176, 0x0178, 0x0149,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x0133, 0x0140,
  0xfffd, 0xfffd, 0x0153, 0xfffd, 0x0175, 0x0177, 0xfffd, 0xfffd, };
UNICHAR map_GOST_19768_74[] = {
  0x00a0, 0x0401, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x00ad, 0xfffd, 0xfffd,
  0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417,
  0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e, 0x041f,
  0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427,
  0x0428, 0x0429, 0x042a, 0x042b, 0x042c, 0x042d, 0x042e, 0x042f,
  0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437,
  0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e, 0x043f,
  0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447,
  0x0448, 0x0449, 0x044a, 0x044b, 0x044c, 0x044d, 0x044e, 0x044f,
  0xfffd, 0x0451, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, };
UNICHAR map_ISO_8859_supp[] = {
  0xfffd, 0xfffd, 0x0100, 0x0108, 0x010a, 0xfffd, 0x0116, 0x0112,
  0x011c, 0x2018, 0x201c, 0x2122, 0x2190, 0x2191, 0x2192, 0x2193,
  0xfffd, 0xfffd, 0x0101, 0x0109, 0x010b, 0x00f0, 0x0117, 0x0113,
  0x011d, 0x2019, 0x201d, 0x2669, 0x215b, 0x215c, 0x215d, 0x215e,
  0xfffd, 0x011e, 0x0120, 0x0122, 0x0124, 0x0126, 0x0128, 0x0130,
  0x012a, 0x012e, 0x0132, 0x0134, 0x0136, 0x013b, 0x013f, 0x0145,
  0x2014, 0x014a, 0x014c, 0x0152, 0x0156, 0x015c, 0x0166, 0x00de,
  0x0168, 0x016c, 0x016a, 0x0172, 0x0174, 0x00dd, 0x0176, 0x0178,
  0x2126, 0x011f, 0x0121, 0x0123, 0x0125, 0x0127, 0x0129, 0x0131,
  0x012b, 0x012f, 0x0133, 0x0135, 0x0137, 0x013c, 0x0140, 0x0146,
  0x0138, 0x014b, 0x014d, 0x0153, 0x0157, 0x015d, 0x0167, 0x00fe,
  0x0169, 0x016d, 0x016b, 0x0173, 0x0175, 0x00fd, 0x0177, 0x0149, };
UNICHAR map_ISO_10367_box[] = {
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0x2503, 0x2501, 0x250f, 0x2513, 0x2517, 0x251b, 0x2523, 0x252b,
  0x2533, 0x253b, 0x254b, 0xe003, 0x2584, 0x2588, 0x25aa, 0xfffd,
  0x2502, 0x2500, 0x250c, 0x2510, 0x2514, 0x2518, 0x251c, 0x2524,
  0x252c, 0x2534, 0x253c, 0x2591, 0x2592, 0x2593, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, };
UNICHAR map_JIS_C6226_1978[] = {
  0x0020, 0x3001, 0x3002, 0x002c, 0x002e, 0x30fb, 0x003a, 0x003b,
  0x0021, 0x309b, 0x309c, 0x00b4, 0x0060, 0x00a8, 0x005e, 0x203e,
  0x005f, 0x30fd, 0x30fe, 0x309d, 0x309e, 0x3003, 0x3004, 0x3005,
  0x3006, 0x3007, 0x30fc, 0x301c, 0x2013, 0xfffd, 0x2571, 0x2572,
  0x223c, 0x2225, 0x007c, 0x22ef, 0x2025, 0x2018, 0x2019, 0x201c,
  0x201d, 0x0028, 0x0029, 0x3014, 0x3015, 0x005b, 0x005d, 0x007b,
  0x007d, 0x2039, 0x203a, 0x2329, 0x232a, 0x300c, 0x300d, 0x300e,
  0x300f, 0x3010, 0x3011, 0x002b, 0x002d, 0x00b1, 0x00d7, 0x00f7,
  0x003d, 0x2260, 0x003c, 0x003e, 0x2264, 0x2265, 0x221e, 0x2234,
  0x2642, 0x2640, 0x00b0, 0x2032, 0x2033, 0x2103, 0x00a5, 0x0024,
  0x00a2, 0x00a3, 0x0025, 0x0023, 0x0026, 0x002a, 0x0040, 0x00a7,
  0x2606, 0x2605, 0x25cb, 0x25cf, 0x25ce, 0x25ca, 0x25c6, 0x25a1,
  0x25a0, 0x25b3, 0x25b2, 0x25bd, 0x007f, 0x203b, 0x3012, 0x2192,
  0x2190, 0x2191, 0x2193, 0x3013, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0x0030, 0x0031, 0x0032, 0x0033, 0x0034,
  0x0035, 0x0036, 0x0037, 0x0038, 0x0039, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x0041, 0x0042, 0x0043, 0x0044,
  0x0045, 0x0046, 0x0047, 0x0048, 0x0049, 0x004a, 0x004b, 0x004c,
  0x004d, 0x004e, 0x004f, 0x0050, 0x0051, 0x0052, 0x0053, 0x0054,
  0x0055, 0x0056, 0x0057, 0x0058, 0x0059, 0x005a, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x0061, 0x0062, 0x0063, 0x0064,
  0x0065, 0x0066, 0x0067, 0x0068, 0x0069, 0x006a, 0x006b, 0x006c,
  0x006d, 0x006e, 0x006f, 0x0070, 0x0071, 0x0072, 0x0073, 0x0074,
  0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007a, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x3041, 0x3042, 0x3043, 0x3044, 0x3045, 0x3046,
  0x3047, 0x3048, 0x3049, 0x304a, 0x304b, 0x304c, 0x304d, 0x304e,
  0x304f, 0x3050, 0x3051, 0x3052, 0x3053, 0x3054, 0x3055, 0x3056,
  0x3057, 0x3058, 0x3059, 0x305a, 0x305b, 0x305c, 0x305d, 0x305e,
  0x305f, 0x3060, 0x3061, 0x3062, 0x3063, 0x3064, 0x3065, 0x3066,
  0x3067, 0x3068, 0x3069, 0x306a, 0x306b, 0x306c, 0x306d, 0x306e,
  0x306f, 0x3070, 0x3071, 0x3072, 0x3073, 0x3074, 0x3075, 0x3076,
  0x3077, 0x3078, 0x3079, 0x307a, 0x307b, 0x307c, 0x307d, 0x307e,
  0x307f, 0x3080, 0x3081, 0x3082, 0x3083, 0x3084, 0x3085, 0x3086,
  0x3087, 0x3088, 0x3089, 0x308a, 0x308b, 0x308c, 0x308d, 0x308e,
  0x308f, 0x3090, 0x3091, 0x3092, 0x3093, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0x30a1, 0x30a2, 0x30a3, 0x30a4, 0x30a5, 0x30a6, 0x30a7, 0x30a8,
  0x30a9, 0x30aa, 0x30ab, 0x30ac, 0x30ad, 0x30ae, 0x30af, 0x30b0,
  0x30b1, 0x30b2, 0x30b3, 0x30b4, 0x30b5, 0x30b6, 0x30b7, 0x30b8,
  0x30b9, 0x30ba, 0x30bb, 0x30bc, 0x30bd, 0x30be, 0x30bf, 0x30c0,
  0x30c1, 0x30c2, 0x30c3, 0x30c4, 0x30c5, 0x30c6, 0x30c7, 0x30c8,
  0x30c9, 0x30ca, 0x30cb, 0x30cc, 0x30cd, 0x30ce, 0x30cf, 0x30d0,
  0x30d1, 0x30d2, 0x30d3, 0x30d4, 0x30d5, 0x30d6, 0x30d7, 0x30d8,
  0x30d9, 0x30da, 0x30db, 0x30dc, 0x30dd, 0x30de, 0x30df, 0x30e0,
  0x30e1, 0x30e2, 0x30e3, 0x30e4, 0x30e5, 0x30e6, 0x30e7, 0x30e8,
  0x30e9, 0x30ea, 0x30eb, 0x30ec, 0x30ed, 0x30ee, 0x30ef, 0x30f0,
  0x30f1, 0x30f2, 0x30f3, 0x30f8, 0x30f5, 0x30f6, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x0391, 0x0392,
  0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 0x0398, 0x0399, 0x039a,
  0x039b, 0x039c, 0x039d, 0x039e, 0x039f, 0x03a0, 0x03a1, 0x03a3,
  0x03a4, 0x03a5, 0x03a6, 0x03a7, 0x03a8, 0x03a9, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x03b1, 0x03b2,
  0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7, 0x03b8, 0x03b9, 0x03ba,
  0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf, 0x03c0, 0x03c1, 0x03c3,
  0x03c4, 0x03c5, 0x03c6, 0x03c7, 0x03c8, 0x03c9, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x0410, 0x0411, 0x0412, 0x0413,
  0x0414, 0x0415, 0x0401, 0x0416, 0x0417, 0x0418, 0x0419, 0x041a,
  0x041b, 0x041c, 0x041d, 0x041e, 0x041f, 0x0420, 0x0421, 0x0422,
  0x0423, 0x0424, 0x0425, 0x0426, 0x0427, 0x0428, 0x0429, 0x042a,
  0x042b, 0x042c, 0x042d, 0x042e, 0x042f, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x0430, 0x0431, 0x0432, 0x0433,
  0x0434, 0x0435, 0x0451, 0x0436, 0x0437, 0x0438, 0x0439, 0x043a,
  0x043b, 0x043c, 0x043d, 0x043e, 0x043f, 0x0440, 0x0441, 0x0442,
  0x0443, 0x0444, 0x0445, 0x0446, 0x0447, 0x0448, 0x0449, 0x044a,
  0x044b, 0x044c, 0x044d, 0x044e, 0x044f, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, };
UNICHAR map_GB_2312_80[] = {
  0x3000, 0x3001, 0x3002, 0x30fb, 0x02c9, 0x02c7, 0x00a8, 0x3003,
  0x3005, 0x2015, 0xff5e, 0x2225, 0x2026, 0x2018, 0x2019, 0x201c,
  0x201d, 0x3014, 0x3015, 0x3008, 0x3009, 0x300a, 0x300b, 0x300c,
  0x300d, 0x300e, 0x300f, 0x3016, 0x3017, 0x3010, 0x3011, 0x00b1,
  0x00d7, 0x00f7, 0x2236, 0x2227, 0x2228, 0x2211, 0x220f, 0x222a,
  0x2229, 0x2208, 0x2237, 0x221a, 0x22a5, 0x2225, 0x2220, 0x2312,
  0x2299, 0x222b, 0x222e, 0x2261, 0x224c, 0x2248, 0x223d, 0x221d,
  0x2260, 0x226e, 0x226f, 0x2264, 0x2265, 0x221e, 0x2235, 0x2234,
  0x2642, 0x2640, 0x00b0, 0x2032, 0x2033, 0x2103, 0xff04, 0x00a4,
  0xffe0, 0xffe1, 0x2030, 0x00a7, 0x2116, 0x2606, 0x2605, 0x25cb,
  0x25cf, 0x25ce, 0x25c7, 0x25c6, 0x25a1, 0x25a0, 0x25b3, 0x25b2,
  0x203b, 0x2192, 0x2190, 0x2191, 0x2193, 0x3013, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x2488, 0x2489,
  0x248a, 0x248b, 0x248c, 0x248d, 0x248e, 0x248f, 0x2490, 0x2491,
  0x2492, 0x2493, 0x2494, 0x2495, 0x2496, 0x2497, 0x2498, 0x2499,
  0x249a, 0x249b, 0x2474, 0x2475, 0x2476, 0x2477, 0x2478, 0x2479,
  0x247a, 0x247b, 0x247c, 0x247d, 0x247e, 0x247f, 0x2480, 0x2481,
  0x2482, 0x2483, 0x2484, 0x2485, 0x2486, 0x2487, 0x2460, 0x2461,
  0x2462, 0x2463, 0x2464, 0x2465, 0x2466, 0x2467, 0x2468, 0x2469,
  0xfffd, 0xfffd, 0x3220, 0x3221, 0x3222, 0x3223, 0x3224, 0x3225,
  0x3226, 0x3227, 0x3228, 0x3229, 0xfffd, 0xfffd, 0x2160, 0x2161,
  0x2162, 0x2163, 0x2164, 0x2165, 0x2166, 0x2167, 0x2168, 0x2169,
  0x216a, 0x216b, 0xfffd, 0xfffd, 0xff01, 0xff02, 0xff03, 0xffe5,
  0xff05, 0xff06, 0xff07, 0xff08, 0xff09, 0xff0a, 0xff0b, 0xff0c,
  0xff0d, 0xff0e, 0xff0f, 0xff10, 0xff11, 0xff12, 0xff13, 0xff14,
  0xff15, 0xff16, 0xff17, 0xff18, 0xff19, 0xff1a, 0xff1b, 0xff1c,
  0xff1d, 0xff1e, 0xff1f, 0xff20, 0xff21, 0xff22, 0xff23, 0xff24,
  0xff25, 0xff26, 0xff27, 0xff28, 0xff29, 0xff2a, 0xff2b, 0xff2c,
  0xff2d, 0xff2e, 0xff2f, 0xff30, 0xff31, 0xff32, 0xff33, 0xff34,
  0xff35, 0xff36, 0xff37, 0xff38, 0xff39, 0xff3a, 0xff3b, 0xff3c,
  0xff3d, 0xff3e, 0xff3f, 0xff40, 0xff41, 0xff42, 0xff43, 0xff44,
  0xff45, 0xff46, 0xff47, 0xff48, 0xff49, 0xff4a, 0xff4b, 0xff4c,
  0xff4d, 0xff4e, 0xff4f, 0xff50, 0xff51, 0xff52, 0xff53, 0xff54,
  0xff55, 0xff56, 0xff57, 0xff58, 0xff59, 0xff5a, 0xff5b, 0xff5c,
  0xff5d, 0xffe3, 0x3041, 0x3042, 0x3043, 0x3044, 0x3045, 0x3046,
  0x3047, 0x3048, 0x3049, 0x304a, 0x304b, 0x304c, 0x304d, 0x304e,
  0x304f, 0x3050, 0x3051, 0x3052, 0x3053, 0x3054, 0x3055, 0x3056,
  0x3057, 0x3058, 0x3059, 0x305a, 0x305b, 0x305c, 0x305d, 0x305e,
  0x305f, 0x3060, 0x3061, 0x3062, 0x3063, 0x3064, 0x3065, 0x3066,
  0x3067, 0x3068, 0x3069, 0x306a, 0x306b, 0x306c, 0x306d, 0x306e,
  0x306f, 0x3070, 0x3071, 0x3072, 0x3073, 0x3074, 0x3075, 0x3076,
  0x3077, 0x3078, 0x3079, 0x307a, 0x307b, 0x307c, 0x307d, 0x307e,
  0x307f, 0x3080, 0x3081, 0x3082, 0x3083, 0x3084, 0x3085, 0x3086,
  0x3087, 0x3088, 0x3089, 0x308a, 0x308b, 0x308c, 0x308d, 0x308e,
  0x308f, 0x3090, 0x3091, 0x3092, 0x3093, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0x30a1, 0x30a2, 0x30a3, 0x30a4, 0x30a5, 0x30a6, 0x30a7, 0x30a8,
  0x30a9, 0x30aa, 0x30ab, 0x30ac, 0x30ad, 0x30ae, 0x30af, 0x30b0,
  0x30b1, 0x30b2, 0x30b3, 0x30b4, 0x30b5, 0x30b6, 0x30b7, 0x30b8,
  0x30b9, 0x30ba, 0x30bb, 0x30bc, 0x30bd, 0x30be, 0x30bf, 0x30c0,
  0x30c1, 0x30c2, 0x30c3, 0x30c4, 0x30c5, 0x30c6, 0x30c7, 0x30c8,
  0x30c9, 0x30ca, 0x30cb, 0x30cc, 0x30cd, 0x30ce, 0x30cf, 0x30d0,
  0x30d1, 0x30d2, 0x30d3, 0x30d4, 0x30d5, 0x30d6, 0x30d7, 0x30d8,
  0x30d9, 0x30da, 0x30db, 0x30dc, 0x30dd, 0x30de, 0x30df, 0x30e0,
  0x30e1, 0x30e2, 0x30e3, 0x30e4, 0x30e5, 0x30e6, 0x30e7, 0x30e8,
  0x30e9, 0x30ea, 0x30eb, 0x30ec, 0x30ed, 0x30ee, 0x30ef, 0x30f0,
  0x30f1, 0x30f2, 0x30f3, 0x30f4, 0x30f5, 0x30f6, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x0391, 0x0392,
  0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 0x0398, 0x0399, 0x039a,
  0x039b, 0x039c, 0x039d, 0x039e, 0x039f, 0x03a0, 0x03a1, 0x03a3,
  0x03a4, 0x03a5, 0x03a6, 0x03a7, 0x03a8, 0x03a9, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x03b1, 0x03b2,
  0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7, 0x03b8, 0x03b9, 0x03ba,
  0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf, 0x03c0, 0x03c1, 0x03c3,
  0x03c4, 0x03c5, 0x03c6, 0x03c7, 0x03c8, 0x03c9, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x0410, 0x0411, 0x0412, 0x0413,
  0x0414, 0x0415, 0x0401, 0x0416, 0x0417, 0x0418, 0x0419, 0x041a,
  0x041b, 0x041c, 0x041d, 0x041e, 0x041f, 0x0420, 0x0421, 0x0422,
  0x0423, 0x0424, 0x0425, 0x0426, 0x0427, 0x0428, 0x0429, 0x042a,
  0x042b, 0x042c, 0x042d, 0x042e, 0x042f, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x0430, 0x0431, 0x0432, 0x0433,
  0x0434, 0x0435, 0x0451, 0x0436, 0x0437, 0x0438, 0x0439, 0x043a,
  0x043b, 0x043c, 0x043d, 0x043e, 0x043f, 0x0440, 0x0441, 0x0442,
  0x0443, 0x0444, 0x0445, 0x0446, 0x0447, 0x0448, 0x0449, 0x044a,
  0x044b, 0x044c, 0x044d, 0x044e, 0x044f, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x0101, 0x00e1, 0x01ce, 0x00e0, 0x0113, 0x00e9,
  0x011b, 0x00e8, 0x012b, 0x00ed, 0x01d0, 0x00ec, 0x014d, 0x00f3,
  0x01d2, 0x00f2, 0x016b, 0x00fa, 0x01d4, 0x00f9, 0x01d6, 0x01d8,
  0x01da, 0x01dc, 0x00fc, 0x00ea, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x3105, 0x3106,
  0x3107, 0x3108, 0x3109, 0x310a, 0x310b, 0x310c, 0x310d, 0x310e,
  0x310f, 0x3110, 0x3111, 0x3112, 0x3113, 0x3114, 0x3115, 0x3116,
  0x3117, 0x3118, 0x3119, 0x311a, 0x311b, 0x311c, 0x311d, 0x311e,
  0x311f, 0x3120, 0x3121, 0x3122, 0x3123, 0x3124, 0x3125, 0x3126,
  0x3127, 0x3128, 0x3129, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0x2500, 0x2501, 0x2502, 0x2503, 0x2504,
  0x2505, 0x2506, 0x2507, 0x2508, 0x2509, 0x250a, 0x250b, 0x250c,
  0x250d, 0x250e, 0x250f, 0x2510, 0x2511, 0x2512, 0x2513, 0x2514,
  0x2515, 0x2516, 0x2517, 0x2518, 0x2519, 0x251a, 0x251b, 0x251c,
  0x251d, 0x251e, 0x251f, 0x2520, 0x2521, 0x2522, 0x2523, 0x2524,
  0x2525, 0x2526, 0x2527, 0x2528, 0x2529, 0x252a, 0x252b, 0x252c,
  0x252d, 0x252e, 0x252f, 0x2530, 0x2531, 0x2532, 0x2533, 0x2534,
  0x2535, 0x2536, 0x2537, 0x2538, 0x2539, 0x253a, 0x253b, 0x253c,
  0x253d, 0x253e, 0x253f, 0x2540, 0x2541, 0x2542, 0x2543, 0x2544,
  0x2545, 0x2546, 0x2547, 0x2548, 0x2549, 0x254a, 0x254b, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x554a, 0x963f, 0x57c3, 0x6328, 0x54ce, 0x5509,
  0x54c0, 0x7691, 0x764c, 0x853c, 0x77ee, 0x827e, 0x788d, 0x7231,
  0x9698, 0x978d, 0x6c28, 0x5b89, 0x4ffa, 0x6309, 0x6697, 0x5cb8,
  0x80fa, 0x6848, 0x80ae, 0x6602, 0x76ce, 0x51f9, 0x6556, 0x71ac,
  0x7ff1, 0x8884, 0x50b2, 0x5965, 0x61ca, 0x6fb3, 0x82ad, 0x634c,
  0x6252, 0x53ed, 0x5427, 0x7b06, 0x516b, 0x75a4, 0x5df4, 0x62d4,
  0x8dcb, 0x9776, 0x628a, 0x8019, 0x575d, 0x9738, 0x7f62, 0x7238,
  0x767d, 0x67cf, 0x767e, 0x6446, 0x4f70, 0x8d25, 0x62dc, 0x7a17,
  0x6591, 0x73ed, 0x642c, 0x6273, 0x822c, 0x9881, 0x677f, 0x7248,
  0x626e, 0x62cc, 0x4f34, 0x74e3, 0x534a, 0x529e, 0x7eca, 0x90a6,
  0x5e2e, 0x6886, 0x699c, 0x8180, 0x7ed1, 0x68d2, 0x78c5, 0x868c,
  0x9551, 0x508d, 0x8c24, 0x82de, 0x80de, 0x5305, 0x8912, 0x5265,
  0x8584, 0x96f9, 0x4fdd, 0x5821, 0x9971, 0x5b9d, 0x62b1, 0x62a5,
  0x66b4, 0x8c79, 0x9c8d, 0x7206, 0x676f, 0x7891, 0x60b2, 0x5351,
  0x5317, 0x8f88, 0x80cc, 0x8d1d, 0x94a1, 0x500d, 0x72c8, 0x5907,
  0x60eb, 0x7119, 0x88ab, 0x5954, 0x82ef, 0x672c, 0x7b28, 0x5d29,
  0x7ef7, 0x752d, 0x6cf5, 0x8e66, 0x8ff8, 0x903c, 0x9f3b, 0x6bd4,
  0x9119, 0x7b14, 0x5f7c, 0x78a7, 0x84d6, 0x853d, 0x6bd5, 0x6bd9,
  0x6bd6, 0x5e01, 0x5e87, 0x75f9, 0x95ed, 0x655d, 0x5f0a, 0x5fc5,
  0x8f9f, 0x58c1, 0x81c2, 0x907f, 0x965b, 0x97ad, 0x8fb9, 0x7f16,
  0x8d2c, 0x6241, 0x4fbf, 0x53d8, 0x535e, 0x8fa8, 0x8fa9, 0x8fab,
  0x904d, 0x6807, 0x5f6a, 0x8198, 0x8868, 0x9cd6, 0x618b, 0x522b,
  0x762a, 0x5f6c, 0x658c, 0x6fd2, 0x6ee8, 0x5bbe, 0x6448, 0x5175,
  0x51b0, 0x67c4, 0x4e19, 0x79c9, 0x997c, 0x70b3, 0x75c5, 0x5e76,
  0x73bb, 0x83e0, 0x64ad, 0x62e8, 0x94b5, 0x6ce2, 0x535a, 0x52c3,
  0x640f, 0x94c2, 0x7b94, 0x4f2f, 0x5e1b, 0x8236, 0x8116, 0x818a,
  0x6e24, 0x6cca, 0x9a73, 0x6355, 0x535c, 0x54fa, 0x8865, 0x57e0,
  0x4e0d, 0x5e03, 0x6b65, 0x7c3f, 0x90e8, 0x6016, 0x64e6, 0x731c,
  0x88c1, 0x6750, 0x624d, 0x8d22, 0x776c, 0x8e29, 0x91c7, 0x5f69,
  0x83dc, 0x8521, 0x9910, 0x53c2, 0x8695, 0x6b8b, 0x60ed, 0x60e8,
  0x707f, 0x82cd, 0x8231, 0x4ed3, 0x6ca7, 0x85cf, 0x64cd, 0x7cd9,
  0x69fd, 0x66f9, 0x8349, 0x5395, 0x7b56, 0x4fa7, 0x518c, 0x6d4b,
  0x5c42, 0x8e6d, 0x63d2, 0x53c9, 0x832c, 0x8336, 0x67e5, 0x78b4,
  0x643d, 0x5bdf, 0x5c94, 0x5dee, 0x8be7, 0x62c6, 0x67f4, 0x8c7a,
  0x6400, 0x63ba, 0x8749, 0x998b, 0x8c17, 0x7f20, 0x94f2, 0x4ea7,
  0x9610, 0x98a4, 0x660c, 0x7316, 0x573a, 0x5c1d, 0x5e38, 0x957f,
  0x507f, 0x80a0, 0x5382, 0x655e, 0x7545, 0x5531, 0x5021, 0x8d85,
  0x6284, 0x949e, 0x671d, 0x5632, 0x6f6e, 0x5de2, 0x5435, 0x7092,
  0x8f66, 0x626f, 0x64a4, 0x63a3, 0x5f7b, 0x6f88, 0x90f4, 0x81e3,
  0x8fb0, 0x5c18, 0x6668, 0x5ff1, 0x6c89, 0x9648, 0x8d81, 0x886c,
  0x6491, 0x79f0, 0x57ce, 0x6a59, 0x6210, 0x5448, 0x4e58, 0x7a0b,
  0x60e9, 0x6f84, 0x8bda, 0x627f, 0x901e, 0x9a8b, 0x79e4, 0x5403,
  0x75f4, 0x6301, 0x5319, 0x6c60, 0x8fdf, 0x5f1b, 0x9a70, 0x803b,
  0x9f7f, 0x4f88, 0x5c3a, 0x8d64, 0x7fc5, 0x65a5, 0x70bd, 0x5145,
  0x51b2, 0x866b, 0x5d07, 0x5ba0, 0x62bd, 0x916c, 0x7574, 0x8e0c,
  0x7a20, 0x6101, 0x7b79, 0x4ec7, 0x7ef8, 0x7785, 0x4e11, 0x81ed,
  0x521d, 0x51fa, 0x6a71, 0x53a8, 0x8e87, 0x9504, 0x96cf, 0x6ec1,
  0x9664, 0x695a, 0x7840, 0x50a8, 0x77d7, 0x6410, 0x89e6, 0x5904,
  0x63e3, 0x5ddd, 0x7a7f, 0x693d, 0x4f20, 0x8239, 0x5598, 0x4e32,
  0x75ae, 0x7a97, 0x5e62, 0x5e8a, 0x95ef, 0x521b, 0x5439, 0x708a,
  0x6376, 0x9524, 0x5782, 0x6625, 0x693f, 0x9187, 0x5507, 0x6df3,
  0x7eaf, 0x8822, 0x6233, 0x7ef0, 0x75b5, 0x8328, 0x78c1, 0x96cc,
  0x8f9e, 0x6148, 0x74f7, 0x8bcd, 0x6b64, 0x523a, 0x8d50, 0x6b21,
  0x806a, 0x8471, 0x56f1, 0x5306, 0x4ece, 0x4e1b, 0x51d1, 0x7c97,
  0x918b, 0x7c07, 0x4fc3, 0x8e7f, 0x7be1, 0x7a9c, 0x6467, 0x5d14,
  0x50ac, 0x8106, 0x7601, 0x7cb9, 0x6dec, 0x7fe0, 0x6751, 0x5b58,
  0x5bf8, 0x78cb, 0x64ae, 0x6413, 0x63aa, 0x632b, 0x9519, 0x642d,
  0x8fbe, 0x7b54, 0x7629, 0x6253, 0x5927, 0x5446, 0x6b79, 0x50a3,
  0x6234, 0x5e26, 0x6b86, 0x4ee3, 0x8d37, 0x888b, 0x5f85, 0x902e,
  0x6020, 0x803d, 0x62c5, 0x4e39, 0x5355, 0x90f8, 0x63b8, 0x80c6,
  0x65e6, 0x6c2e, 0x4f46, 0x60ee, 0x6de1, 0x8bde, 0x5f39, 0x86cb,
  0x5f53, 0x6321, 0x515a, 0x8361, 0x6863, 0x5200, 0x6363, 0x8e48,
  0x5012, 0x5c9b, 0x7977, 0x5bfc, 0x5230, 0x7a3b, 0x60bc, 0x9053,
  0x76d7, 0x5fb7, 0x5f97, 0x7684, 0x8e6c, 0x706f, 0x767b, 0x7b49,
  0x77aa, 0x51f3, 0x9093, 0x5824, 0x4f4e, 0x6ef4, 0x8fea, 0x654c,
  0x7b1b, 0x72c4, 0x6da4, 0x7fdf, 0x5ae1, 0x62b5, 0x5e95, 0x5730,
  0x8482, 0x7b2c, 0x5e1d, 0x5f1f, 0x9012, 0x7f14, 0x98a0, 0x6382,
  0x6ec7, 0x7898, 0x70b9, 0x5178, 0x975b, 0x57ab, 0x7535, 0x4f43,
  0x7538, 0x5e97, 0x60e6, 0x5960, 0x6dc0, 0x6bbf, 0x7889, 0x53fc,
  0x96d5, 0x51cb, 0x5201, 0x6389, 0x540a, 0x9493, 0x8c03, 0x8dcc,
  0x7239, 0x789f, 0x8776, 0x8fed, 0x8c0d, 0x53e0, 0x4e01, 0x76ef,
  0x53ee, 0x9489, 0x9876, 0x9f0e, 0x952d, 0x5b9a, 0x8ba2, 0x4e22,
  0x4e1c, 0x51ac, 0x8463, 0x61c2, 0x52a8, 0x680b, 0x4f97, 0x606b,
  0x51bb, 0x6d1e, 0x515c, 0x6296, 0x6597, 0x9661, 0x8c46, 0x9017,
  0x75d8, 0x90fd, 0x7763, 0x6bd2, 0x728a, 0x72ec, 0x8bfb, 0x5835,
  0x7779, 0x8d4c, 0x675c, 0x9540, 0x809a, 0x5ea6, 0x6e21, 0x5992,
  0x7aef, 0x77ed, 0x953b, 0x6bb5, 0x65ad, 0x7f0e, 0x5806, 0x5151,
  0x961f, 0x5bf9, 0x58a9, 0x5428, 0x8e72, 0x6566, 0x987f, 0x56e4,
  0x949d, 0x76fe, 0x9041, 0x6387, 0x54c6, 0x591a, 0x593a, 0x579b,
  0x8eb2, 0x6735, 0x8dfa, 0x8235, 0x5241, 0x60f0, 0x5815, 0x86fe,
  0x5ce8, 0x9e45, 0x4fc4, 0x989d, 0x8bb9, 0x5a25, 0x6076, 0x5384,
  0x627c, 0x904f, 0x9102, 0x997f, 0x6069, 0x800c, 0x513f, 0x8033,
  0x5c14, 0x9975, 0x6d31, 0x4e8c, 0x8d30, 0x53d1, 0x7f5a, 0x7b4f,
  0x4f10, 0x4e4f, 0x9600, 0x6cd5, 0x73d0, 0x85e9, 0x5e06, 0x756a,
  0x7ffb, 0x6a0a, 0x77fe, 0x9492, 0x7e41, 0x51e1, 0x70e6, 0x53cd,
  0x8fd4, 0x8303, 0x8d29, 0x72af, 0x996d, 0x6cdb, 0x574a, 0x82b3,
  0x65b9, 0x80aa, 0x623f, 0x9632, 0x59a8, 0x4eff, 0x8bbf, 0x7eba,
  0x653e, 0x83f2, 0x975e, 0x5561, 0x98de, 0x80a5, 0x532a, 0x8bfd,
  0x5420, 0x80ba, 0x5e9f, 0x6cb8, 0x8d39, 0x82ac, 0x915a, 0x5429,
  0x6c1b, 0x5206, 0x7eb7, 0x575f, 0x711a, 0x6c7e, 0x7c89, 0x594b,
  0x4efd, 0x5fff, 0x6124, 0x7caa, 0x4e30, 0x5c01, 0x67ab, 0x8702,
  0x5cf0, 0x950b, 0x98ce, 0x75af, 0x70fd, 0x9022, 0x51af, 0x7f1d,
  0x8bbd, 0x5949, 0x51e4, 0x4f5b, 0x5426, 0x592b, 0x6577, 0x80a4,
  0x5b75, 0x6276, 0x62c2, 0x8f90, 0x5e45, 0x6c1f, 0x7b26, 0x4f0f,
  0x4fd8, 0x670d, 0x6d6e, 0x6daa, 0x798f, 0x88b1, 0x5f17, 0x752b,
  0x629a, 0x8f85, 0x4fef, 0x91dc, 0x65a7, 0x812f, 0x8151, 0x5e9c,
  0x8150, 0x8d74, 0x526f, 0x8986, 0x8d4b, 0x590d, 0x5085, 0x4ed8,
  0x961c, 0x7236, 0x8179, 0x8d1f, 0x5bcc, 0x8ba3, 0x9644, 0x5987,
  0x7f1a, 0x5490, 0x5676, 0x560e, 0x8be5, 0x6539, 0x6982, 0x9499,
  0x76d6, 0x6e89, 0x5e72, 0x7518, 0x6746, 0x67d1, 0x7aff, 0x809d,
  0x8d76, 0x611f, 0x79c6, 0x6562, 0x8d63, 0x5188, 0x521a, 0x94a2,
  0x7f38, 0x809b, 0x7eb2, 0x5c97, 0x6e2f, 0x6760, 0x7bd9, 0x768b,
  0x9ad8, 0x818f, 0x7f94, 0x7cd5, 0x641e, 0x9550, 0x7a3f, 0x544a,
  0x54e5, 0x6b4c, 0x6401, 0x6208, 0x9e3d, 0x80f3, 0x7599, 0x5272,
  0x9769, 0x845b, 0x683c, 0x86e4, 0x9601, 0x9694, 0x94ec, 0x4e2a,
  0x5404, 0x7ed9, 0x6839, 0x8ddf, 0x8015, 0x66f4, 0x5e9a, 0x7fb9,
  0x57c2, 0x803f, 0x6897, 0x5de5, 0x653b, 0x529f, 0x606d, 0x9f9a,
  0x4f9b, 0x8eac, 0x516c, 0x5bab, 0x5f13, 0x5de9, 0x6c5e, 0x62f1,
  0x8d21, 0x5171, 0x94a9, 0x52fe, 0x6c9f, 0x82df, 0x72d7, 0x57a2,
  0x6784, 0x8d2d, 0x591f, 0x8f9c, 0x83c7, 0x5495, 0x7b8d, 0x4f30,
  0x6cbd, 0x5b64, 0x59d1, 0x9f13, 0x53e4, 0x86ca, 0x9aa8, 0x8c37,
  0x80a1, 0x6545, 0x987e, 0x56fa, 0x96c7, 0x522e, 0x74dc, 0x5250,
  0x5be1, 0x6302, 0x8902, 0x4e56, 0x62d0, 0x602a, 0x68fa, 0x5173,
  0x5b98, 0x51a0, 0x89c2, 0x7ba1, 0x9986, 0x7f50, 0x60ef, 0x704c,
  0x8d2f, 0x5149, 0x5e7f, 0x901b, 0x7470, 0x89c4, 0x572d, 0x7845,
  0x5f52, 0x9f9f, 0x95fa, 0x8f68, 0x9b3c, 0x8be1, 0x7678, 0x6842,
  0x67dc, 0x8dea, 0x8d35, 0x523d, 0x8f8a, 0x6eda, 0x68cd, 0x9505,
  0x90ed, 0x56fd, 0x679c, 0x88f9, 0x8fc7, 0x54c8, 0x9ab8, 0x5b69,
  0x6d77, 0x6c26, 0x4ea5, 0x5bb3, 0x9a87, 0x9163, 0x61a8, 0x90af,
  0x97e9, 0x542b, 0x6db5, 0x5bd2, 0x51fd, 0x558a, 0x7f55, 0x7ff0,
  0x64bc, 0x634d, 0x65f1, 0x61be, 0x608d, 0x710a, 0x6c57, 0x6c49,
  0x592f, 0x676d, 0x822a, 0x58d5, 0x568e, 0x8c6a, 0x6beb, 0x90dd,
  0x597d, 0x8017, 0x53f7, 0x6d69, 0x5475, 0x559d, 0x8377, 0x83cf,
  0x6838, 0x79be, 0x548c, 0x4f55, 0x5408, 0x76d2, 0x8c89, 0x9602,
  0x6cb3, 0x6db8, 0x8d6b, 0x8910, 0x9e64, 0x8d3a, 0x563f, 0x9ed1,
  0x75d5, 0x5f88, 0x72e0, 0x6068, 0x54fc, 0x4ea8, 0x6a2a, 0x8861,
  0x6052, 0x8f70, 0x54c4, 0x70d8, 0x8679, 0x9e3f, 0x6d2a, 0x5b8f,
  0x5f18, 0x7ea2, 0x5589, 0x4faf, 0x7334, 0x543c, 0x539a, 0x5019,
  0x540e, 0x547c, 0x4e4e, 0x5ffd, 0x745a, 0x58f6, 0x846b, 0x80e1,
  0x8774, 0x72d0, 0x7cca, 0x6e56, 0x5f27, 0x864e, 0x552c, 0x62a4,
  0x4e92, 0x6caa, 0x6237, 0x82b1, 0x54d7, 0x534e, 0x733e, 0x6ed1,
  0x753b, 0x5212, 0x5316, 0x8bdd, 0x69d0, 0x5f8a, 0x6000, 0x6dee,
  0x574f, 0x6b22, 0x73af, 0x6853, 0x8fd8, 0x7f13, 0x6362, 0x60a3,
  0x5524, 0x75ea, 0x8c62, 0x7115, 0x6da3, 0x5ba6, 0x5e7b, 0x8352,
  0x614c, 0x9ec4, 0x78fa, 0x8757, 0x7c27, 0x7687, 0x51f0, 0x60f6,
  0x714c, 0x6643, 0x5e4c, 0x604d, 0x8c0e, 0x7070, 0x6325, 0x8f89,
  0x5fbd, 0x6062, 0x86d4, 0x56de, 0x6bc1, 0x6094, 0x6167, 0x5349,
  0x60e0, 0x6666, 0x8d3f, 0x79fd, 0x4f1a, 0x70e9, 0x6c47, 0x8bb3,
  0x8bf2, 0x7ed8, 0x8364, 0x660f, 0x5a5a, 0x9b42, 0x6d51, 0x6df7,
  0x8c41, 0x6d3b, 0x4f19, 0x706b, 0x83b7, 0x6216, 0x60d1, 0x970d,
  0x8d27, 0x7978, 0x51fb, 0x573e, 0x57fa, 0x673a, 0x7578, 0x7a3d,
  0x79ef, 0x7b95, 0x808c, 0x9965, 0x8ff9, 0x6fc0, 0x8ba5, 0x9e21,
  0x59ec, 0x7ee9, 0x7f09, 0x5409, 0x6781, 0x68d8, 0x8f91, 0x7c4d,
  0x96c6, 0x53ca, 0x6025, 0x75be, 0x6c72, 0x5373, 0x5ac9, 0x7ea7,
  0x6324, 0x51e0, 0x810a, 0x5df1, 0x84df, 0x6280, 0x5180, 0x5b63,
  0x4f0e, 0x796d, 0x5242, 0x60b8, 0x6d4e, 0x5bc4, 0x5bc2, 0x8ba1,
  0x8bb0, 0x65e2, 0x5fcc, 0x9645, 0x5993, 0x7ee7, 0x7eaa, 0x5609,
  0x67b7, 0x5939, 0x4f73, 0x5bb6, 0x52a0, 0x835a, 0x988a, 0x8d3e,
  0x7532, 0x94be, 0x5047, 0x7a3c, 0x4ef7, 0x67b6, 0x9a7e, 0x5ac1,
  0x6b7c, 0x76d1, 0x575a, 0x5c16, 0x7b3a, 0x95f4, 0x714e, 0x517c,
  0x80a9, 0x8270, 0x5978, 0x7f04, 0x8327, 0x68c0, 0x67ec, 0x78b1,
  0x7877, 0x62e3, 0x6361, 0x7b80, 0x4fed, 0x526a, 0x51cf, 0x8350,
  0x69db, 0x9274, 0x8df5, 0x8d31, 0x89c1, 0x952e, 0x7bad, 0x4ef6,
  0x5065, 0x8230, 0x5251, 0x996f, 0x6e10, 0x6e85, 0x6da7, 0x5efa,
  0x50f5, 0x59dc, 0x5c06, 0x6d46, 0x6c5f, 0x7586, 0x848b, 0x6868,
  0x5956, 0x8bb2, 0x5320, 0x9171, 0x964d, 0x8549, 0x6912, 0x7901,
  0x7126, 0x80f6, 0x4ea4, 0x90ca, 0x6d47, 0x9a84, 0x5a07, 0x56bc,
  0x6405, 0x94f0, 0x77eb, 0x4fa5, 0x811a, 0x72e1, 0x89d2, 0x997a,
  0x7f34, 0x7ede, 0x527f, 0x6559, 0x9175, 0x8f7f, 0x8f83, 0x53eb,
  0x7a96, 0x63ed, 0x63a5, 0x7686, 0x79f8, 0x8857, 0x9636, 0x622a,
  0x52ab, 0x8282, 0x6854, 0x6770, 0x6377, 0x776b, 0x7aed, 0x6d01,
  0x7ed3, 0x89e3, 0x59d0, 0x6212, 0x85c9, 0x82a5, 0x754c, 0x501f,
  0x4ecb, 0x75a5, 0x8beb, 0x5c4a, 0x5dfe, 0x7b4b, 0x65a4, 0x91d1,
  0x4eca, 0x6d25, 0x895f, 0x7d27, 0x9526, 0x4ec5, 0x8c28, 0x8fdb,
  0x9773, 0x664b, 0x7981, 0x8fd1, 0x70ec, 0x6d78, 0x5c3d, 0x52b2,
  0x8346, 0x5162, 0x830e, 0x775b, 0x6676, 0x9cb8, 0x4eac, 0x60ca,
  0x7cbe, 0x7cb3, 0x7ecf, 0x4e95, 0x8b66, 0x666f, 0x9888, 0x9759,
  0x5883, 0x656c, 0x955c, 0x5f84, 0x75c9, 0x9756, 0x7adf, 0x7ade,
  0x51c0, 0x70af, 0x7a98, 0x63ea, 0x7a76, 0x7ea0, 0x7396, 0x97ed,
  0x4e45, 0x7078, 0x4e5d, 0x9152, 0x53a9, 0x6551, 0x65e7, 0x81fc,
  0x8205, 0x548e, 0x5c31, 0x759a, 0x97a0, 0x62d8, 0x72d9, 0x75bd,
  0x5c45, 0x9a79, 0x83ca, 0x5c40, 0x5480, 0x77e9, 0x4e3e, 0x6cae,
  0x805a, 0x62d2, 0x636e, 0x5de8, 0x5177, 0x8ddd, 0x8e1e, 0x952f,
  0x4ff1, 0x53e5, 0x60e7, 0x70ac, 0x5267, 0x6350, 0x9e43, 0x5a1f,
  0x5026, 0x7737, 0x5377, 0x7ee2, 0x6485, 0x652b, 0x6289, 0x6398,
  0x5014, 0x7235, 0x89c9, 0x51b3, 0x8bc0, 0x7edd, 0x5747, 0x83cc,
  0x94a7, 0x519b, 0x541b, 0x5cfb, 0x4fca, 0x7ae3, 0x6d5a, 0x90e1,
  0x9a8f, 0x5580, 0x5496, 0x5361, 0x54af, 0x5f00, 0x63e9, 0x6977,
  0x51ef, 0x6168, 0x520a, 0x582a, 0x52d8, 0x574e, 0x780d, 0x770b,
  0x5eb7, 0x6177, 0x7ce0, 0x625b, 0x6297, 0x4ea2, 0x7095, 0x8003,
  0x62f7, 0x70e4, 0x9760, 0x5777, 0x82db, 0x67ef, 0x68f5, 0x78d5,
  0x9897, 0x79d1, 0x58f3, 0x54b3, 0x53ef, 0x6e34, 0x514b, 0x523b,
  0x5ba2, 0x8bfe, 0x80af, 0x5543, 0x57a6, 0x6073, 0x5751, 0x542d,
  0x7a7a, 0x6050, 0x5b54, 0x63a7, 0x62a0, 0x53e3, 0x6263, 0x5bc7,
  0x67af, 0x54ed, 0x7a9f, 0x82e6, 0x9177, 0x5e93, 0x88e4, 0x5938,
  0x57ae, 0x630e, 0x8de8, 0x80ef, 0x5757, 0x7b77, 0x4fa9, 0x5feb,
  0x5bbd, 0x6b3e, 0x5321, 0x7b50, 0x72c2, 0x6846, 0x77ff, 0x7736,
  0x65f7, 0x51b5, 0x4e8f, 0x76d4, 0x5cbf, 0x7aa5, 0x8475, 0x594e,
  0x9b41, 0x5080, 0x9988, 0x6127, 0x6e83, 0x5764, 0x6606, 0x6346,
  0x56f0, 0x62ec, 0x6269, 0x5ed3, 0x9614, 0x5783, 0x62c9, 0x5587,
  0x8721, 0x814a, 0x8fa3, 0x5566, 0x83b1, 0x6765, 0x8d56, 0x84dd,
  0x5a6a, 0x680f, 0x62e6, 0x7bee, 0x9611, 0x5170, 0x6f9c, 0x8c30,
  0x63fd, 0x89c8, 0x61d2, 0x7f06, 0x70c2, 0x6ee5, 0x7405, 0x6994,
  0x72fc, 0x5eca, 0x90ce, 0x6717, 0x6d6a, 0x635e, 0x52b3, 0x7262,
  0x8001, 0x4f6c, 0x59e5, 0x916a, 0x70d9, 0x6d9d, 0x52d2, 0x4e50,
  0x96f7, 0x956d, 0x857e, 0x78ca, 0x7d2f, 0x5121, 0x5792, 0x64c2,
  0x808b, 0x7c7b, 0x6cea, 0x68f1, 0x695e, 0x51b7, 0x5398, 0x68a8,
  0x7281, 0x9ece, 0x7bf1, 0x72f8, 0x79bb, 0x6f13, 0x7406, 0x674e,
  0x91cc, 0x9ca4, 0x793c, 0x8389, 0x8354, 0x540f, 0x6817, 0x4e3d,
  0x5389, 0x52b1, 0x783e, 0x5386, 0x5229, 0x5088, 0x4f8b, 0x4fd0,
  0x75e2, 0x7acb, 0x7c92, 0x6ca5, 0x96b6, 0x529b, 0x7483, 0x54e9,
  0x4fe9, 0x8054, 0x83b2, 0x8fde, 0x9570, 0x5ec9, 0x601c, 0x6d9f,
  0x5e18, 0x655b, 0x8138, 0x94fe, 0x604b, 0x70bc, 0x7ec3, 0x7cae,
  0x51c9, 0x6881, 0x7cb1, 0x826f, 0x4e24, 0x8f86, 0x91cf, 0x667e,
  0x4eae, 0x8c05, 0x64a9, 0x804a, 0x50da, 0x7597, 0x71ce, 0x5be5,
  0x8fbd, 0x6f66, 0x4e86, 0x6482, 0x9563, 0x5ed6, 0x6599, 0x5217,
  0x88c2, 0x70c8, 0x52a3, 0x730e, 0x7433, 0x6797, 0x78f7, 0x9716,
  0x4e34, 0x90bb, 0x9cde, 0x6dcb, 0x51db, 0x8d41, 0x541d, 0x62ce,
  0x73b2, 0x83f1, 0x96f6, 0x9f84, 0x94c3, 0x4f36, 0x7f9a, 0x51cc,
  0x7075, 0x9675, 0x5cad, 0x9886, 0x53e6, 0x4ee4, 0x6e9c, 0x7409,
  0x69b4, 0x786b, 0x998f, 0x7559, 0x5218, 0x7624, 0x6d41, 0x67f3,
  0x516d, 0x9f99, 0x804b, 0x5499, 0x7b3c, 0x7abf, 0x9686, 0x5784,
  0x62e2, 0x9647, 0x697c, 0x5a04, 0x6402, 0x7bd3, 0x6f0f, 0x964b,
  0x82a6, 0x5362, 0x9885, 0x5e90, 0x7089, 0x63b3, 0x5364, 0x864f,
  0x9c81, 0x9e93, 0x788c, 0x9732, 0x8def, 0x8d42, 0x9e7f, 0x6f5e,
  0x7984, 0x5f55, 0x9646, 0x622e, 0x9a74, 0x5415, 0x94dd, 0x4fa3,
  0x65c5, 0x5c65, 0x5c61, 0x7f15, 0x8651, 0x6c2f, 0x5f8b, 0x7387,
  0x6ee4, 0x7eff, 0x5ce6, 0x631b, 0x5b6a, 0x6ee6, 0x5375, 0x4e71,
  0x63a0, 0x7565, 0x62a1, 0x8f6e, 0x4f26, 0x4ed1, 0x6ca6, 0x7eb6,
  0x8bba, 0x841d, 0x87ba, 0x7f57, 0x903b, 0x9523, 0x7ba9, 0x9aa1,
  0x88f8, 0x843d, 0x6d1b, 0x9a86, 0x7edc, 0x5988, 0x9ebb, 0x739b,
  0x7801, 0x8682, 0x9a6c, 0x9a82, 0x561b, 0x5417, 0x57cb, 0x4e70,
  0x9ea6, 0x5356, 0x8fc8, 0x8109, 0x7792, 0x9992, 0x86ee, 0x6ee1,
  0x8513, 0x66fc, 0x6162, 0x6f2b, 0x8c29, 0x8292, 0x832b, 0x76f2,
  0x6c13, 0x5fd9, 0x83bd, 0x732b, 0x8305, 0x951a, 0x6bdb, 0x77db,
  0x94c6, 0x536f, 0x8302, 0x5192, 0x5e3d, 0x8c8c, 0x8d38, 0x4e48,
  0x73ab, 0x679a, 0x6885, 0x9176, 0x9709, 0x7164, 0x6ca1, 0x7709,
  0x5a92, 0x9541, 0x6bcf, 0x7f8e, 0x6627, 0x5bd0, 0x59b9, 0x5a9a,
  0x95e8, 0x95f7, 0x4eec, 0x840c, 0x8499, 0x6aac, 0x76df, 0x9530,
  0x731b, 0x68a6, 0x5b5f, 0x772f, 0x919a, 0x9761, 0x7cdc, 0x8ff7,
  0x8c1c, 0x5f25, 0x7c73, 0x79d8, 0x89c5, 0x6ccc, 0x871c, 0x5bc6,
  0x5e42, 0x68c9, 0x7720, 0x7ef5, 0x5195, 0x514d, 0x52c9, 0x5a29,
  0x7f05, 0x9762, 0x82d7, 0x63cf, 0x7784, 0x85d0, 0x79d2, 0x6e3a,
  0x5e99, 0x5999, 0x8511, 0x706d, 0x6c11, 0x62bf, 0x76bf, 0x654f,
  0x60af, 0x95fd, 0x660e, 0x879f, 0x9e23, 0x94ed, 0x540d, 0x547d,
  0x8c2c, 0x6478, 0x6479, 0x8611, 0x6a21, 0x819c, 0x78e8, 0x6469,
  0x9b54, 0x62b9, 0x672b, 0x83ab, 0x58a8, 0x9ed8, 0x6cab, 0x6f20,
  0x5bde, 0x964c, 0x8c0b, 0x725f, 0x67d0, 0x62c7, 0x7261, 0x4ea9,
  0x59c6, 0x6bcd, 0x5893, 0x66ae, 0x5e55, 0x52df, 0x6155, 0x6728,
  0x76ee, 0x7766, 0x7267, 0x7a46, 0x62ff, 0x54ea, 0x5450, 0x94a0,
  0x90a3, 0x5a1c, 0x7eb3, 0x6c16, 0x4e43, 0x5976, 0x8010, 0x5948,
  0x5357, 0x7537, 0x96be, 0x56ca, 0x6320, 0x8111, 0x607c, 0x95f9,
  0x6dd6, 0x5462, 0x9981, 0x5185, 0x5ae9, 0x80fd, 0x59ae, 0x9713,
  0x502a, 0x6ce5, 0x5c3c, 0x62df, 0x4f60, 0x533f, 0x817b, 0x9006,
  0x6eba, 0x852b, 0x62c8, 0x5e74, 0x78be, 0x64b5, 0x637b, 0x5ff5,
  0x5a18, 0x917f, 0x9e1f, 0x5c3f, 0x634f, 0x8042, 0x5b7d, 0x556e,
  0x954a, 0x954d, 0x6d85, 0x60a8, 0x67e0, 0x72de, 0x51dd, 0x5b81,
  0x62e7, 0x6cde, 0x725b, 0x626d, 0x94ae, 0x7ebd, 0x8113, 0x6d53,
  0x519c, 0x5f04, 0x5974, 0x52aa, 0x6012, 0x5973, 0x6696, 0x8650,
  0x759f, 0x632a, 0x61e6, 0x7cef, 0x8bfa, 0x54e6, 0x6b27, 0x9e25,
  0x6bb4, 0x85d5, 0x5455, 0x5076, 0x6ca4, 0x556a, 0x8db4, 0x722c,
  0x5e15, 0x6015, 0x7436, 0x62cd, 0x6392, 0x724c, 0x5f98, 0x6e43,
  0x6d3e, 0x6500, 0x6f58, 0x76d8, 0x78d0, 0x76fc, 0x7554, 0x5224,
  0x53db, 0x4e53, 0x5e9e, 0x65c1, 0x802a, 0x80d6, 0x629b, 0x5486,
  0x5228, 0x70ae, 0x888d, 0x8dd1, 0x6ce1, 0x5478, 0x80da, 0x57f9,
  0x88f4, 0x8d54, 0x966a, 0x914d, 0x4f69, 0x6c9b, 0x55b7, 0x76c6,
  0x7830, 0x62a8, 0x70f9, 0x6f8e, 0x5f6d, 0x84ec, 0x68da, 0x787c,
  0x7bf7, 0x81a8, 0x670b, 0x9e4f, 0x6367, 0x78b0, 0x576f, 0x7812,
  0x9739, 0x6279, 0x62ab, 0x5288, 0x7435, 0x6bd7, 0x5564, 0x813e,
  0x75b2, 0x76ae, 0x5339, 0x75de, 0x50fb, 0x5c41, 0x8b6c, 0x7bc7,
  0x504f, 0x7247, 0x9a97, 0x98d8, 0x6f02, 0x74e2, 0x7968, 0x6487,
  0x77a5, 0x62fc, 0x9891, 0x8d2b, 0x54c1, 0x8058, 0x4e52, 0x576a,
  0x82f9, 0x840d, 0x5e73, 0x51ed, 0x74f6, 0x8bc4, 0x5c4f, 0x5761,
  0x6cfc, 0x9887, 0x5a46, 0x7834, 0x9b44, 0x8feb, 0x7c95, 0x5256,
  0x6251, 0x94fa, 0x4ec6, 0x8386, 0x8461, 0x83e9, 0x84b2, 0x57d4,
  0x6734, 0x5703, 0x666e, 0x6d66, 0x8c31, 0x66dd, 0x7011, 0x671f,
  0x6b3a, 0x6816, 0x621a, 0x59bb, 0x4e03, 0x51c4, 0x6f06, 0x67d2,
  0x6c8f, 0x5176, 0x68cb, 0x5947, 0x6b67, 0x7566, 0x5d0e, 0x8110,
  0x9f50, 0x65d7, 0x7948, 0x7941, 0x9a91, 0x8d77, 0x5c82, 0x4e5e,
  0x4f01, 0x542f, 0x5951, 0x780c, 0x5668, 0x6c14, 0x8fc4, 0x5f03,
  0x6c7d, 0x6ce3, 0x8bab, 0x6390, 0x6070, 0x6d3d, 0x7275, 0x6266,
  0x948e, 0x94c5, 0x5343, 0x8fc1, 0x7b7e, 0x4edf, 0x8c26, 0x4e7e,
  0x9ed4, 0x94b1, 0x94b3, 0x524d, 0x6f5c, 0x9063, 0x6d45, 0x8c34,
  0x5811, 0x5d4c, 0x6b20, 0x6b49, 0x67aa, 0x545b, 0x8154, 0x7f8c,
  0x5899, 0x8537, 0x5f3a, 0x62a2, 0x6a47, 0x9539, 0x6572, 0x6084,
  0x6865, 0x77a7, 0x4e54, 0x4fa8, 0x5de7, 0x9798, 0x64ac, 0x7fd8,
  0x5ced, 0x4fcf, 0x7a8d, 0x5207, 0x8304, 0x4e14, 0x602f, 0x7a83,
  0x94a6, 0x4fb5, 0x4eb2, 0x79e6, 0x7434, 0x52e4, 0x82b9, 0x64d2,
  0x79bd, 0x5bdd, 0x6c81, 0x9752, 0x8f7b, 0x6c22, 0x503e, 0x537f,
  0x6e05, 0x64ce, 0x6674, 0x6c30, 0x60c5, 0x9877, 0x8bf7, 0x5e86,
  0x743c, 0x7a77, 0x79cb, 0x4e18, 0x90b1, 0x7403, 0x6c42, 0x56da,
  0x914b, 0x6cc5, 0x8d8b, 0x533a, 0x86c6, 0x66f2, 0x8eaf, 0x5c48,
  0x9a71, 0x6e20, 0x53d6, 0x5a36, 0x9f8b, 0x8da3, 0x53bb, 0x5708,
  0x98a7, 0x6743, 0x919b, 0x6cc9, 0x5168, 0x75ca, 0x62f3, 0x72ac,
  0x5238, 0x529d, 0x7f3a, 0x7094, 0x7638, 0x5374, 0x9e4a, 0x69b7,
  0x786e, 0x96c0, 0x88d9, 0x7fa4, 0x7136, 0x71c3, 0x5189, 0x67d3,
  0x74e4, 0x58e4, 0x6518, 0x56b7, 0x8ba9, 0x9976, 0x6270, 0x7ed5,
  0x60f9, 0x70ed, 0x58ec, 0x4ec1, 0x4eba, 0x5fcd, 0x97e7, 0x4efb,
  0x8ba4, 0x5203, 0x598a, 0x7eab, 0x6254, 0x4ecd, 0x65e5, 0x620e,
  0x8338, 0x84c9, 0x8363, 0x878d, 0x7194, 0x6eb6, 0x5bb9, 0x7ed2,
  0x5197, 0x63c9, 0x67d4, 0x8089, 0x8339, 0x8815, 0x5112, 0x5b7a,
  0x5982, 0x8fb1, 0x4e73, 0x6c5d, 0x5165, 0x8925, 0x8f6f, 0x962e,
  0x854a, 0x745e, 0x9510, 0x95f0, 0x6da6, 0x82e5, 0x5f31, 0x6492,
  0x6d12, 0x8428, 0x816e, 0x9cc3, 0x585e, 0x8d5b, 0x4e09, 0x53c1,
  0x4f1e, 0x6563, 0x6851, 0x55d3, 0x4e27, 0x6414, 0x9a9a, 0x626b,
  0x5ac2, 0x745f, 0x8272, 0x6da9, 0x68ee, 0x50e7, 0x838e, 0x7802,
  0x6740, 0x5239, 0x6c99, 0x7eb1, 0x50bb, 0x5565, 0x715e, 0x7b5b,
  0x6652, 0x73ca, 0x82eb, 0x6749, 0x5c71, 0x5220, 0x717d, 0x886b,
  0x95ea, 0x9655, 0x64c5, 0x8d61, 0x81b3, 0x5584, 0x6c55, 0x6247,
  0x7f2e, 0x5892, 0x4f24, 0x5546, 0x8d4f, 0x664c, 0x4e0a, 0x5c1a,
  0x88f3, 0x68a2, 0x634e, 0x7a0d, 0x70e7, 0x828d, 0x52fa, 0x97f6,
  0x5c11, 0x54e8, 0x90b5, 0x7ecd, 0x5962, 0x8d4a, 0x86c7, 0x820c,
  0x820d, 0x8d66, 0x6444, 0x5c04, 0x6151, 0x6d89, 0x793e, 0x8bbe,
  0x7837, 0x7533, 0x547b, 0x4f38, 0x8eab, 0x6df1, 0x5a20, 0x7ec5,
  0x795e, 0x6c88, 0x5ba1, 0x5a76, 0x751a, 0x80be, 0x614e, 0x6e17,
  0x58f0, 0x751f, 0x7525, 0x7272, 0x5347, 0x7ef3, 0x7701, 0x76db,
  0x5269, 0x80dc, 0x5723, 0x5e08, 0x5931, 0x72ee, 0x65bd, 0x6e7f,
  0x8bd7, 0x5c38, 0x8671, 0x5341, 0x77f3, 0x62fe, 0x65f6, 0x4ec0,
  0x98df, 0x8680, 0x5b9e, 0x8bc6, 0x53f2, 0x77e2, 0x4f7f, 0x5c4e,
  0x9a76, 0x59cb, 0x5f0f, 0x793a, 0x58eb, 0x4e16, 0x67ff, 0x4e8b,
  0x62ed, 0x8a93, 0x901d, 0x52bf, 0x662f, 0x55dc, 0x566c, 0x9002,
  0x4ed5, 0x4f8d, 0x91ca, 0x9970, 0x6c0f, 0x5e02, 0x6043, 0x5ba4,
  0x89c6, 0x8bd5, 0x6536, 0x624b, 0x9996, 0x5b88, 0x5bff, 0x6388,
  0x552e, 0x53d7, 0x7626, 0x517d, 0x852c, 0x67a2, 0x68b3, 0x6b8a,
  0x6292, 0x8f93, 0x53d4, 0x8212, 0x6dd1, 0x758f, 0x4e66, 0x8d4e,
  0x5b70, 0x719f, 0x85af, 0x6691, 0x66d9, 0x7f72, 0x8700, 0x9ecd,
  0x9f20, 0x5c5e, 0x672f, 0x8ff0, 0x6811, 0x675f, 0x620d, 0x7ad6,
  0x5885, 0x5eb6, 0x6570, 0x6f31, 0x6055, 0x5237, 0x800d, 0x6454,
  0x8870, 0x7529, 0x5e05, 0x6813, 0x62f4, 0x971c, 0x53cc, 0x723d,
  0x8c01, 0x6c34, 0x7761, 0x7a0e, 0x542e, 0x77ac, 0x987a, 0x821c,
  0x8bf4, 0x7855, 0x6714, 0x70c1, 0x65af, 0x6495, 0x5636, 0x601d,
  0x79c1, 0x53f8, 0x4e1d, 0x6b7b, 0x8086, 0x5bfa, 0x55e3, 0x56db,
  0x4f3a, 0x4f3c, 0x9972, 0x5df3, 0x677e, 0x8038, 0x6002, 0x9882,
  0x9001, 0x5b8b, 0x8bbc, 0x8bf5, 0x641c, 0x8258, 0x64de, 0x55fd,
  0x82cf, 0x9165, 0x4fd7, 0x7d20, 0x901f, 0x7c9f, 0x50f3, 0x5851,
  0x6eaf, 0x5bbf, 0x8bc9, 0x8083, 0x9178, 0x849c, 0x7b97, 0x867d,
  0x968b, 0x968f, 0x7ee5, 0x9ad3, 0x788e, 0x5c81, 0x7a57, 0x9042,
  0x96a7, 0x795f, 0x5b59, 0x635f, 0x7b0b, 0x84d1, 0x68ad, 0x5506,
  0x7f29, 0x7410, 0x7d22, 0x9501, 0x6240, 0x584c, 0x4ed6, 0x5b83,
  0x5979, 0x5854, 0x736d, 0x631e, 0x8e4b, 0x8e0f, 0x80ce, 0x82d4,
  0x62ac, 0x53f0, 0x6cf0, 0x915e, 0x592a, 0x6001, 0x6c70, 0x574d,
  0x644a, 0x8d2a, 0x762b, 0x6ee9, 0x575b, 0x6a80, 0x75f0, 0x6f6d,
  0x8c2d, 0x8c08, 0x5766, 0x6bef, 0x8892, 0x78b3, 0x63a2, 0x53f9,
  0x70ad, 0x6c64, 0x5858, 0x642a, 0x5802, 0x68e0, 0x819b, 0x5510,
  0x7cd6, 0x5018, 0x8eba, 0x6dcc, 0x8d9f, 0x70eb, 0x638f, 0x6d9b,
  0x6ed4, 0x7ee6, 0x8404, 0x6843, 0x9003, 0x6dd8, 0x9676, 0x8ba8,
  0x5957, 0x7279, 0x85e4, 0x817e, 0x75bc, 0x8a8a, 0x68af, 0x5254,
  0x8e22, 0x9511, 0x63d0, 0x9898, 0x8e44, 0x557c, 0x4f53, 0x66ff,
  0x568f, 0x60d5, 0x6d95, 0x5243, 0x5c49, 0x5929, 0x6dfb, 0x586b,
  0x7530, 0x751c, 0x606c, 0x8214, 0x8146, 0x6311, 0x6761, 0x8fe2,
  0x773a, 0x8df3, 0x8d34, 0x94c1, 0x5e16, 0x5385, 0x542c, 0x70c3,
  0x6c40, 0x5ef7, 0x505c, 0x4ead, 0x5ead, 0x633a, 0x8247, 0x901a,
  0x6850, 0x916e, 0x77b3, 0x540c, 0x94dc, 0x5f64, 0x7ae5, 0x6876,
  0x6345, 0x7b52, 0x7edf, 0x75db, 0x5077, 0x6295, 0x5934, 0x900f,
  0x51f8, 0x79c3, 0x7a81, 0x56fe, 0x5f92, 0x9014, 0x6d82, 0x5c60,
  0x571f, 0x5410, 0x5154, 0x6e4d, 0x56e2, 0x63a8, 0x9893, 0x817f,
  0x8715, 0x892a, 0x9000, 0x541e, 0x5c6f, 0x81c0, 0x62d6, 0x6258,
  0x8131, 0x9e35, 0x9640, 0x9a6e, 0x9a7c, 0x692d, 0x59a5, 0x62d3,
  0x553e, 0x6316, 0x54c7, 0x86d9, 0x6d3c, 0x5a03, 0x74e6, 0x889c,
  0x6b6a, 0x5916, 0x8c4c, 0x5f2f, 0x6e7e, 0x73a9, 0x987d, 0x4e38,
  0x70f7, 0x5b8c, 0x7897, 0x633d, 0x665a, 0x7696, 0x60cb, 0x5b9b,
  0x5a49, 0x4e07, 0x8155, 0x6c6a, 0x738b, 0x4ea1, 0x6789, 0x7f51,
  0x5f80, 0x65fa, 0x671b, 0x5fd8, 0x5984, 0x5a01, 0x5dcd, 0x5fae,
  0x5371, 0x97e6, 0x8fdd, 0x6845, 0x56f4, 0x552f, 0x60df, 0x4e3a,
  0x6f4d, 0x7ef4, 0x82c7, 0x840e, 0x59d4, 0x4f1f, 0x4f2a, 0x5c3e,
  0x7eac, 0x672a, 0x851a, 0x5473, 0x754f, 0x80c3, 0x5582, 0x9b4f,
  0x4f4d, 0x6e2d, 0x8c13, 0x5c09, 0x6170, 0x536b, 0x761f, 0x6e29,
  0x868a, 0x6587, 0x95fb, 0x7eb9, 0x543b, 0x7a33, 0x7d0a, 0x95ee,
  0x55e1, 0x7fc1, 0x74ee, 0x631d, 0x8717, 0x6da1, 0x7a9d, 0x6211,
  0x65a1, 0x5367, 0x63e1, 0x6c83, 0x5deb, 0x545c, 0x94a8, 0x4e4c,
  0x6c61, 0x8bec, 0x5c4b, 0x65e0, 0x829c, 0x68a7, 0x543e, 0x5434,
  0x6bcb, 0x6b66, 0x4e94, 0x6342, 0x5348, 0x821e, 0x4f0d, 0x4fae,
  0x575e, 0x620a, 0x96fe, 0x6664, 0x7269, 0x52ff, 0x52a1, 0x609f,
  0x8bef, 0x6614, 0x7199, 0x6790, 0x897f, 0x7852, 0x77fd, 0x6670,
  0x563b, 0x5438, 0x9521, 0x727a, 0x7a00, 0x606f, 0x5e0c, 0x6089,
  0x819d, 0x5915, 0x60dc, 0x7184, 0x70ef, 0x6eaa, 0x6c50, 0x7280,
  0x6a84, 0x88ad, 0x5e2d, 0x4e60, 0x5ab3, 0x559c, 0x94e3, 0x6d17,
  0x7cfb, 0x9699, 0x620f, 0x7ec6, 0x778e, 0x867e, 0x5323, 0x971e,
  0x8f96, 0x6687, 0x5ce1, 0x4fa0, 0x72ed, 0x4e0b, 0x53a6, 0x590f,
  0x5413, 0x6380, 0x9528, 0x5148, 0x4ed9, 0x9c9c, 0x7ea4, 0x54b8,
  0x8d24, 0x8854, 0x8237, 0x95f2, 0x6d8e, 0x5f26, 0x5acc, 0x663e,
  0x9669, 0x73b0, 0x732e, 0x53bf, 0x817a, 0x9985, 0x7fa1, 0x5baa,
  0x9677, 0x9650, 0x7ebf, 0x76f8, 0x53a2, 0x9576, 0x9999, 0x7bb1,
  0x8944, 0x6e58, 0x4e61, 0x7fd4, 0x7965, 0x8be6, 0x60f3, 0x54cd,
  0x4eab, 0x9879, 0x5df7, 0x6a61, 0x50cf, 0x5411, 0x8c61, 0x8427,
  0x785d, 0x9704, 0x524a, 0x54ee, 0x56a3, 0x9500, 0x6d88, 0x5bb5,
  0x6dc6, 0x6653, 0x5c0f, 0x5b5d, 0x6821, 0x8096, 0x5578, 0x7b11,
  0x6548, 0x6954, 0x4e9b, 0x6b47, 0x874e, 0x978b, 0x534f, 0x631f,
  0x643a, 0x90aa, 0x659c, 0x80c1, 0x8c10, 0x5199, 0x68b0, 0x5378,
  0x87f9, 0x61c8, 0x6cc4, 0x6cfb, 0x8c22, 0x5c51, 0x85aa, 0x82af,
  0x950c, 0x6b23, 0x8f9b, 0x65b0, 0x5ffb, 0x5fc3, 0x4fe1, 0x8845,
  0x661f, 0x8165, 0x7329, 0x60fa, 0x5174, 0x5211, 0x578b, 0x5f62,
  0x90a2, 0x884c, 0x9192, 0x5e78, 0x674f, 0x6027, 0x59d3, 0x5144,
  0x51f6, 0x80f8, 0x5308, 0x6c79, 0x96c4, 0x718a, 0x4f11, 0x4fee,
  0x7f9e, 0x673d, 0x55c5, 0x9508, 0x79c0, 0x8896, 0x7ee3, 0x589f,
  0x620c, 0x9700, 0x865a, 0x5618, 0x987b, 0x5f90, 0x8bb8, 0x84c4,
  0x9157, 0x53d9, 0x65ed, 0x5e8f, 0x755c, 0x6064, 0x7d6e, 0x5a7f,
  0x7eea, 0x7eed, 0x8f69, 0x55a7, 0x5ba3, 0x60ac, 0x65cb, 0x7384,
  0x9009, 0x7663, 0x7729, 0x7eda, 0x9774, 0x859b, 0x5b66, 0x7a74,
  0x96ea, 0x8840, 0x52cb, 0x718f, 0x5faa, 0x65ec, 0x8be2, 0x5bfb,
  0x9a6f, 0x5de1, 0x6b89, 0x6c5b, 0x8bad, 0x8baf, 0x900a, 0x8fc5,
  0x538b, 0x62bc, 0x9e26, 0x9e2d, 0x5440, 0x4e2b, 0x82bd, 0x7259,
  0x869c, 0x5d16, 0x8859, 0x6daf, 0x96c5, 0x54d1, 0x4e9a, 0x8bb6,
  0x7109, 0x54bd, 0x9609, 0x70df, 0x6df9, 0x76d0, 0x4e25, 0x7814,
  0x8712, 0x5ca9, 0x5ef6, 0x8a00, 0x989c, 0x960e, 0x708e, 0x6cbf,
  0x5944, 0x63a9, 0x773c, 0x884d, 0x6f14, 0x8273, 0x5830, 0x71d5,
  0x538c, 0x781a, 0x96c1, 0x5501, 0x5f66, 0x7130, 0x5bb4, 0x8c1a,
  0x9a8c, 0x6b83, 0x592e, 0x9e2f, 0x79e7, 0x6768, 0x626c, 0x4f6f,
  0x75a1, 0x7f8a, 0x6d0b, 0x9633, 0x6c27, 0x4ef0, 0x75d2, 0x517b,
  0x6837, 0x6f3e, 0x9080, 0x8170, 0x5996, 0x7476, 0x6447, 0x5c27,
  0x9065, 0x7a91, 0x8c23, 0x59da, 0x54ac, 0x8200, 0x836f, 0x8981,
  0x8000, 0x6930, 0x564e, 0x8036, 0x7237, 0x91ce, 0x51b6, 0x4e5f,
  0x9875, 0x6396, 0x4e1a, 0x53f6, 0x66f3, 0x814b, 0x591c, 0x6db2,
  0x4e00, 0x58f9, 0x533b, 0x63d6, 0x94f1, 0x4f9d, 0x4f0a, 0x8863,
  0x9890, 0x5937, 0x9057, 0x79fb, 0x4eea, 0x80f0, 0x7591, 0x6c82,
  0x5b9c, 0x59e8, 0x5f5d, 0x6905, 0x8681, 0x501a, 0x5df2, 0x4e59,
  0x77e3, 0x4ee5, 0x827a, 0x6291, 0x6613, 0x9091, 0x5c79, 0x4ebf,
  0x5f79, 0x81c6, 0x9038, 0x8084, 0x75ab, 0x4ea6, 0x88d4, 0x610f,
  0x6bc5, 0x5fc6, 0x4e49, 0x76ca, 0x6ea2, 0x8be3, 0x8bae, 0x8c0a,
  0x8bd1, 0x5f02, 0x7ffc, 0x7fcc, 0x7ece, 0x8335, 0x836b, 0x56e0,
  0x6bb7, 0x97f3, 0x9634, 0x59fb, 0x541f, 0x94f6, 0x6deb, 0x5bc5,
  0x996e, 0x5c39, 0x5f15, 0x9690, 0x5370, 0x82f1, 0x6a31, 0x5a74,
  0x9e70, 0x5e94, 0x7f28, 0x83b9, 0x8424, 0x8425, 0x8367, 0x8747,
  0x8fce, 0x8d62, 0x76c8, 0x5f71, 0x9896, 0x786c, 0x6620, 0x54df,
  0x62e5, 0x4f63, 0x81c3, 0x75c8, 0x5eb8, 0x96cd, 0x8e0a, 0x86f9,
  0x548f, 0x6cf3, 0x6d8c, 0x6c38, 0x607f, 0x52c7, 0x7528, 0x5e7d,
  0x4f18, 0x60a0, 0x5fe7, 0x5c24, 0x7531, 0x90ae, 0x94c0, 0x72b9,
  0x6cb9, 0x6e38, 0x9149, 0x6709, 0x53cb, 0x53f3, 0x4f51, 0x91c9,
  0x8bf1, 0x53c8, 0x5e7c, 0x8fc2, 0x6de4, 0x4e8e, 0x76c2, 0x6986,
  0x865e, 0x611a, 0x8206, 0x4f59, 0x4fde, 0x903e, 0x9c7c, 0x6109,
  0x6e1d, 0x6e14, 0x9685, 0x4e88, 0x5a31, 0x96e8, 0x4e0e, 0x5c7f,
  0x79b9, 0x5b87, 0x8bed, 0x7fbd, 0x7389, 0x57df, 0x828b, 0x90c1,
  0x5401, 0x9047, 0x55bb, 0x5cea, 0x5fa1, 0x6108, 0x6b32, 0x72f1,
  0x80b2, 0x8a89, 0x6d74, 0x5bd3, 0x88d5, 0x9884, 0x8c6b, 0x9a6d,
  0x9e33, 0x6e0a, 0x51a4, 0x5143, 0x57a3, 0x8881, 0x539f, 0x63f4,
  0x8f95, 0x56ed, 0x5458, 0x5706, 0x733f, 0x6e90, 0x7f18, 0x8fdc,
  0x82d1, 0x613f, 0x6028, 0x9662, 0x66f0, 0x7ea6, 0x8d8a, 0x8dc3,
  0x94a5, 0x5cb3, 0x7ca4, 0x6708, 0x60a6, 0x9605, 0x8018, 0x4e91,
  0x90e7, 0x5300, 0x9668, 0x5141, 0x8fd0, 0x8574, 0x915d, 0x6655,
  0x97f5, 0x5b55, 0x531d, 0x7838, 0x6742, 0x683d, 0x54c9, 0x707e,
  0x5bb0, 0x8f7d, 0x518d, 0x5728, 0x54b1, 0x6512, 0x6682, 0x8d5e,
  0x8d43, 0x810f, 0x846c, 0x906d, 0x7cdf, 0x51ff, 0x85fb, 0x67a3,
  0x65e9, 0x6fa1, 0x86a4, 0x8e81, 0x566a, 0x9020, 0x7682, 0x7076,
  0x71e5, 0x8d23, 0x62e9, 0x5219, 0x6cfd, 0x8d3c, 0x600e, 0x589e,
  0x618e, 0x66fe, 0x8d60, 0x624e, 0x55b3, 0x6e23, 0x672d, 0x8f67,
  0x94e1, 0x95f8, 0x7728, 0x6805, 0x69a8, 0x548b, 0x4e4d, 0x70b8,
  0x8bc8, 0x6458, 0x658b, 0x5b85, 0x7a84, 0x503a, 0x5be8, 0x77bb,
  0x6be1, 0x8a79, 0x7c98, 0x6cbe, 0x76cf, 0x65a9, 0x8f97, 0x5d2d,
  0x5c55, 0x8638, 0x6808, 0x5360, 0x6218, 0x7ad9, 0x6e5b, 0x7efd,
  0x6a1f, 0x7ae0, 0x5f70, 0x6f33, 0x5f20, 0x638c, 0x6da8, 0x6756,
  0x4e08, 0x5e10, 0x8d26, 0x4ed7, 0x80c0, 0x7634, 0x969c, 0x62db,
  0x662d, 0x627e, 0x6cbc, 0x8d75, 0x7167, 0x7f69, 0x5146, 0x8087,
  0x53ec, 0x906e, 0x6298, 0x54f2, 0x86f0, 0x8f99, 0x8005, 0x9517,
  0x8517, 0x8fd9, 0x6d59, 0x73cd, 0x659f, 0x771f, 0x7504, 0x7827,
  0x81fb, 0x8d1e, 0x9488, 0x4fa6, 0x6795, 0x75b9, 0x8bca, 0x9707,
  0x632f, 0x9547, 0x9635, 0x84b8, 0x6323, 0x7741, 0x5f81, 0x72f0,
  0x4e89, 0x6014, 0x6574, 0x62ef, 0x6b63, 0x653f, 0x5e27, 0x75c7,
  0x90d1, 0x8bc1, 0x829d, 0x679d, 0x652f, 0x5431, 0x8718, 0x77e5,
  0x80a2, 0x8102, 0x6c41, 0x4e4b, 0x7ec7, 0x804c, 0x76f4, 0x690d,
  0x6b96, 0x6267, 0x503c, 0x4f84, 0x5740, 0x6307, 0x6b62, 0x8dbe,
  0x53ea, 0x65e8, 0x7eb8, 0x5fd7, 0x631a, 0x63b7, 0x81f3, 0x81f4,
  0x7f6e, 0x5e1c, 0x5cd9, 0x5236, 0x667a, 0x79e9, 0x7a1a, 0x8d28,
  0x7099, 0x75d4, 0x6ede, 0x6cbb, 0x7a92, 0x4e2d, 0x76c5, 0x5fe0,
  0x949f, 0x8877, 0x7ec8, 0x79cd, 0x80bf, 0x91cd, 0x4ef2, 0x4f17,
  0x821f, 0x5468, 0x5dde, 0x6d32, 0x8bcc, 0x7ca5, 0x8f74, 0x8098,
  0x5e1a, 0x5492, 0x76b1, 0x5b99, 0x663c, 0x9aa4, 0x73e0, 0x682a,
  0x86db, 0x6731, 0x732a, 0x8bf8, 0x8bdb, 0x9010, 0x7af9, 0x70db,
  0x716e, 0x62c4, 0x77a9, 0x5631, 0x4e3b, 0x8457, 0x67f1, 0x52a9,
  0x86c0, 0x8d2e, 0x94f8, 0x7b51, 0x4f4f, 0x6ce8, 0x795d, 0x9a7b,
  0x6293, 0x722a, 0x62fd, 0x4e13, 0x7816, 0x8f6c, 0x64b0, 0x8d5a,
  0x7bc6, 0x6869, 0x5e84, 0x88c5, 0x5986, 0x649e, 0x58ee, 0x72b6,
  0x690e, 0x9525, 0x8ffd, 0x8d58, 0x5760, 0x7f00, 0x8c06, 0x51c6,
  0x6349, 0x62d9, 0x5353, 0x684c, 0x7422, 0x8301, 0x914c, 0x5544,
  0x7740, 0x707c, 0x6d4a, 0x5179, 0x54a8, 0x8d44, 0x59ff, 0x6ecb,
  0x6dc4, 0x5b5c, 0x7d2b, 0x4ed4, 0x7c7d, 0x6ed3, 0x5b50, 0x81ea,
  0x6e0d, 0x5b57, 0x9b03, 0x68d5, 0x8e2a, 0x5b97, 0x7efc, 0x603b,
  0x7eb5, 0x90b9, 0x8d70, 0x594f, 0x63cd, 0x79df, 0x8db3, 0x5352,
  0x65cf, 0x7956, 0x8bc5, 0x963b, 0x7ec4, 0x94bb, 0x7e82, 0x5634,
  0x9189, 0x6700, 0x7f6a, 0x5c0a, 0x9075, 0x6628, 0x5de6, 0x4f50,
  0x67de, 0x505a, 0x4f5c, 0x5750, 0x5ea7, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x4e8d, 0x4e0c, 0x5140, 0x4e10, 0x5eff, 0x5345,
  0x4e15, 0x4e98, 0x4e1e, 0x9b32, 0x5b6c, 0x5669, 0x4e28, 0x79ba,
  0x4e3f, 0x5315, 0x4e47, 0x592d, 0x723b, 0x536e, 0x6c10, 0x56df,
  0x80e4, 0x9997, 0x6bd3, 0x777e, 0x9f17, 0x4e36, 0x4e9f, 0x9f10,
  0x4e5c, 0x4e69, 0x4e93, 0x8288, 0x5b5b, 0x556c, 0x560f, 0x4ec4,
  0x538d, 0x539d, 0x53a3, 0x53a5, 0x53ae, 0x9765, 0x8d5d, 0x531a,
  0x53f5, 0x5326, 0x532e, 0x533e, 0x8d5c, 0x5366, 0x5363, 0x5202,
  0x5208, 0x520e, 0x522d, 0x5233, 0x523f, 0x5240, 0x524c, 0x525e,
  0x5261, 0x525c, 0x84af, 0x527d, 0x5282, 0x5281, 0x5290, 0x5293,
  0x5182, 0x7f54, 0x4ebb, 0x4ec3, 0x4ec9, 0x4ec2, 0x4ee8, 0x4ee1,
  0x4eeb, 0x4ede, 0x4f1b, 0x4ef3, 0x4f22, 0x4f64, 0x4ef5, 0x4f25,
  0x4f27, 0x4f09, 0x4f2b, 0x4f5e, 0x4f67, 0x6538, 0x4f5a, 0x4f5d,
  0x4f5f, 0x4f57, 0x4f32, 0x4f3d, 0x4f76, 0x4f74, 0x4f91, 0x4f89,
  0x4f83, 0x4f8f, 0x4f7e, 0x4f7b, 0x4faa, 0x4f7c, 0x4fac, 0x4f94,
  0x4fe6, 0x4fe8, 0x4fea, 0x4fc5, 0x4fda, 0x4fe3, 0x4fdc, 0x4fd1,
  0x4fdf, 0x4ff8, 0x5029, 0x504c, 0x4ff3, 0x502c, 0x500f, 0x502e,
  0x502d, 0x4ffe, 0x501c, 0x500c, 0x5025, 0x5028, 0x507e, 0x5043,
  0x5055, 0x5048, 0x504e, 0x506c, 0x507b, 0x50a5, 0x50a7, 0x50a9,
  0x50ba, 0x50d6, 0x5106, 0x50ed, 0x50ec, 0x50e6, 0x50ee, 0x5107,
  0x510b, 0x4edd, 0x6c3d, 0x4f58, 0x4f65, 0x4fce, 0x9fa0, 0x6c46,
  0x7c74, 0x516e, 0x5dfd, 0x9ec9, 0x9998, 0x5181, 0x5914, 0x52f9,
  0x530d, 0x8a07, 0x5310, 0x51eb, 0x5919, 0x5155, 0x4ea0, 0x5156,
  0x4eb3, 0x886e, 0x88a4, 0x4eb5, 0x8114, 0x88d2, 0x7980, 0x5b34,
  0x8803, 0x7fb8, 0x51ab, 0x51b1, 0x51bd, 0x51bc, 0x51c7, 0x5196,
  0x51a2, 0x51a5, 0x8ba0, 0x8ba6, 0x8ba7, 0x8baa, 0x8bb4, 0x8bb5,
  0x8bb7, 0x8bc2, 0x8bc3, 0x8bcb, 0x8bcf, 0x8bce, 0x8bd2, 0x8bd3,
  0x8bd4, 0x8bd6, 0x8bd8, 0x8bd9, 0x8bdc, 0x8bdf, 0x8be0, 0x8be4,
  0x8be8, 0x8be9, 0x8bee, 0x8bf0, 0x8bf3, 0x8bf6, 0x8bf9, 0x8bfc,
  0x8bff, 0x8c00, 0x8c02, 0x8c04, 0x8c07, 0x8c0c, 0x8c0f, 0x8c11,
  0x8c12, 0x8c14, 0x8c15, 0x8c16, 0x8c19, 0x8c1b, 0x8c18, 0x8c1d,
  0x8c1f, 0x8c20, 0x8c21, 0x8c25, 0x8c27, 0x8c2a, 0x8c2b, 0x8c2e,
  0x8c2f, 0x8c32, 0x8c33, 0x8c35, 0x8c36, 0x5369, 0x537a, 0x961d,
  0x9622, 0x9621, 0x9631, 0x962a, 0x963d, 0x963c, 0x9642, 0x9649,
  0x9654, 0x965f, 0x9667, 0x966c, 0x9672, 0x9674, 0x9688, 0x968d,
  0x9697, 0x96b0, 0x9097, 0x909b, 0x909d, 0x9099, 0x90ac, 0x90a1,
  0x90b4, 0x90b3, 0x90b6, 0x90ba, 0x90b8, 0x90b0, 0x90cf, 0x90c5,
  0x90be, 0x90d0, 0x90c4, 0x90c7, 0x90d3, 0x90e6, 0x90e2, 0x90dc,
  0x90d7, 0x90db, 0x90eb, 0x90ef, 0x90fe, 0x9104, 0x9122, 0x911e,
  0x9123, 0x9131, 0x912f, 0x9139, 0x9143, 0x9146, 0x520d, 0x5942,
  0x52a2, 0x52ac, 0x52ad, 0x52be, 0x54ff, 0x52d0, 0x52d6, 0x52f0,
  0x53df, 0x71ee, 0x77cd, 0x5ef4, 0x51f5, 0x51fc, 0x9b2f, 0x53b6,
  0x5f01, 0x755a, 0x5def, 0x574c, 0x57a9, 0x57a1, 0x587e, 0x58bc,
  0x58c5, 0x58d1, 0x5729, 0x572c, 0x572a, 0x5733, 0x5739, 0x572e,
  0x572f, 0x575c, 0x573b, 0x5742, 0x5769, 0x5785, 0x576b, 0x5786,
  0x577c, 0x577b, 0x5768, 0x576d, 0x5776, 0x5773, 0x57ad, 0x57a4,
  0x578c, 0x57b2, 0x57cf, 0x57a7, 0x57b4, 0x5793, 0x57a0, 0x57d5,
  0x57d8, 0x57da, 0x57d9, 0x57d2, 0x57b8, 0x57f4, 0x57ef, 0x57f8,
  0x57e4, 0x57dd, 0x580b, 0x580d, 0x57fd, 0x57ed, 0x5800, 0x581e,
  0x5819, 0x5844, 0x5820, 0x5865, 0x586c, 0x5881, 0x5889, 0x589a,
  0x5880, 0x99a8, 0x9f19, 0x61ff, 0x8279, 0x827d, 0x827f, 0x828f,
  0x828a, 0x82a8, 0x8284, 0x828e, 0x8291, 0x8297, 0x8299, 0x82ab,
  0x82b8, 0x82be, 0x82b0, 0x82c8, 0x82ca, 0x82e3, 0x8298, 0x82b7,
  0x82ae, 0x82cb, 0x82cc, 0x82c1, 0x82a9, 0x82b4, 0x82a1, 0x82aa,
  0x829f, 0x82c4, 0x82ce, 0x82a4, 0x82e1, 0x8309, 0x82f7, 0x82e4,
  0x830f, 0x8307, 0x82dc, 0x82f4, 0x82d2, 0x82d8, 0x830c, 0x82fb,
  0x82d3, 0x8311, 0x831a, 0x8306, 0x8314, 0x8315, 0x82e0, 0x82d5,
  0x831c, 0x8351, 0x835b, 0x835c, 0x8308, 0x8392, 0x833c, 0x8334,
  0x8331, 0x839b, 0x835e, 0x832f, 0x834f, 0x8347, 0x8343, 0x835f,
  0x8340, 0x8317, 0x8360, 0x832d, 0x833a, 0x8333, 0x8366, 0x8365,
  0x8368, 0x831b, 0x8369, 0x836c, 0x836a, 0x836d, 0x836e, 0x83b0,
  0x8378, 0x83b3, 0x83b4, 0x83a0, 0x83aa, 0x8393, 0x839c, 0x8385,
  0x837c, 0x83b6, 0x83a9, 0x837d, 0x83b8, 0x837b, 0x8398, 0x839e,
  0x83a8, 0x83ba, 0x83bc, 0x83c1, 0x8401, 0x83e5, 0x83d8, 0x5807,
  0x8418, 0x840b, 0x83dd, 0x83fd, 0x83d6, 0x841c, 0x8438, 0x8411,
  0x8406, 0x83d4, 0x83df, 0x840f, 0x8403, 0x83f8, 0x83f9, 0x83ea,
  0x83c5, 0x83c0, 0x8426, 0x83f0, 0x83e1, 0x845c, 0x8451, 0x845a,
  0x8459, 0x8473, 0x8487, 0x8488, 0x847a, 0x8489, 0x8478, 0x843c,
  0x8446, 0x8469, 0x8476, 0x848c, 0x848e, 0x8431, 0x846d, 0x84c1,
  0x84cd, 0x84d0, 0x84e6, 0x84bd, 0x84d3, 0x84ca, 0x84bf, 0x84ba,
  0x84e0, 0x84a1, 0x84b9, 0x84b4, 0x8497, 0x84e5, 0x84e3, 0x850c,
  0x750d, 0x8538, 0x84f0, 0x8539, 0x851f, 0x853a, 0x8556, 0x853b,
  0x84ff, 0x84fc, 0x8559, 0x8548, 0x8568, 0x8564, 0x855e, 0x857a,
  0x77a2, 0x8543, 0x8572, 0x857b, 0x85a4, 0x85a8, 0x8587, 0x858f,
  0x8579, 0x85ae, 0x859c, 0x8585, 0x85b9, 0x85b7, 0x85b0, 0x85d3,
  0x85c1, 0x85dc, 0x85ff, 0x8627, 0x8605, 0x8629, 0x8616, 0x863c,
  0x5efe, 0x5f08, 0x593c, 0x5941, 0x8037, 0x5955, 0x595a, 0x5958,
  0x530f, 0x5c22, 0x5c25, 0x5c2c, 0x5c34, 0x624c, 0x626a, 0x629f,
  0x62bb, 0x62ca, 0x62da, 0x62d7, 0x62ee, 0x6322, 0x62f6, 0x6339,
  0x634b, 0x6343, 0x63ad, 0x63f6, 0x6371, 0x637a, 0x638e, 0x63b4,
  0x636d, 0x63ac, 0x638a, 0x6369, 0x63ae, 0x63bc, 0x63f2, 0x63f8,
  0x63e0, 0x63ff, 0x63c4, 0x63de, 0x63ce, 0x6452, 0x63c6, 0x63be,
  0x6445, 0x6441, 0x640b, 0x641b, 0x6420, 0x640c, 0x6426, 0x6421,
  0x645e, 0x6484, 0x646d, 0x6496, 0x647a, 0x64b7, 0x64b8, 0x6499,
  0x64ba, 0x64c0, 0x64d0, 0x64d7, 0x64e4, 0x64e2, 0x6509, 0x6525,
  0x652e, 0x5f0b, 0x5fd2, 0x7519, 0x5f11, 0x535f, 0x53f1, 0x53fd,
  0x53e9, 0x53e8, 0x53fb, 0x5412, 0x5416, 0x5406, 0x544b, 0x5452,
  0x5453, 0x5454, 0x5456, 0x5443, 0x5421, 0x5457, 0x5459, 0x5423,
  0x5432, 0x5482, 0x5494, 0x5477, 0x5471, 0x5464, 0x549a, 0x549b,
  0x5484, 0x5476, 0x5466, 0x549d, 0x54d0, 0x54ad, 0x54c2, 0x54b4,
  0x54d2, 0x54a7, 0x54a6, 0x54d3, 0x54d4, 0x5472, 0x54a3, 0x54d5,
  0x54bb, 0x54bf, 0x54cc, 0x54d9, 0x54da, 0x54dc, 0x54a9, 0x54aa,
  0x54a4, 0x54dd, 0x54cf, 0x54de, 0x551b, 0x54e7, 0x5520, 0x54fd,
  0x5514, 0x54f3, 0x5522, 0x5523, 0x550f, 0x5511, 0x5527, 0x552a,
  0x5567, 0x558f, 0x55b5, 0x5549, 0x556d, 0x5541, 0x5555, 0x553f,
  0x5550, 0x553c, 0x5537, 0x5556, 0x5575, 0x5576, 0x5577, 0x5533,
  0x5530, 0x555c, 0x558b, 0x55d2, 0x5583, 0x55b1, 0x55b9, 0x5588,
  0x5581, 0x559f, 0x557e, 0x55d6, 0x5591, 0x557b, 0x55df, 0x55bd,
  0x55be, 0x5594, 0x5599, 0x55ea, 0x55f7, 0x55c9, 0x561f, 0x55d1,
  0x55eb, 0x55ec, 0x55d4, 0x55e6, 0x55dd, 0x55c4, 0x55ef, 0x55e5,
  0x55f2, 0x55f3, 0x55cc, 0x55cd, 0x55e8, 0x55f5, 0x55e4, 0x8f94,
  0x561e, 0x5608, 0x560c, 0x5601, 0x5624, 0x5623, 0x55fe, 0x5600,
  0x5627, 0x562d, 0x5658, 0x5639, 0x5657, 0x562c, 0x564d, 0x5662,
  0x5659, 0x565c, 0x564c, 0x5654, 0x5686, 0x5664, 0x5671, 0x566b,
  0x567b, 0x567c, 0x5685, 0x5693, 0x56af, 0x56d4, 0x56d7, 0x56dd,
  0x56e1, 0x56f5, 0x56eb, 0x56f9, 0x56ff, 0x5704, 0x570a, 0x5709,
  0x571c, 0x5e0f, 0x5e19, 0x5e14, 0x5e11, 0x5e31, 0x5e3b, 0x5e3c,
  0x5e37, 0x5e44, 0x5e54, 0x5e5b, 0x5e5e, 0x5e61, 0x5c8c, 0x5c7a,
  0x5c8d, 0x5c90, 0x5c96, 0x5c88, 0x5c98, 0x5c99, 0x5c91, 0x5c9a,
  0x5c9c, 0x5cb5, 0x5ca2, 0x5cbd, 0x5cac, 0x5cab, 0x5cb1, 0x5ca3,
  0x5cc1, 0x5cb7, 0x5cc4, 0x5cd2, 0x5ce4, 0x5ccb, 0x5ce5, 0x5d02,
  0x5d03, 0x5d27, 0x5d26, 0x5d2e, 0x5d24, 0x5d1e, 0x5d06, 0x5d1b,
  0x5d58, 0x5d3e, 0x5d34, 0x5d3d, 0x5d6c, 0x5d5b, 0x5d6f, 0x5d5d,
  0x5d6b, 0x5d4b, 0x5d4a, 0x5d69, 0x5d74, 0x5d82, 0x5d99, 0x5d9d,
  0x8c73, 0x5db7, 0x5dc5, 0x5f73, 0x5f77, 0x5f82, 0x5f87, 0x5f89,
  0x5f8c, 0x5f95, 0x5f99, 0x5f9c, 0x5fa8, 0x5fad, 0x5fb5, 0x5fbc,
  0x8862, 0x5f61, 0x72ad, 0x72b0, 0x72b4, 0x72b7, 0x72b8, 0x72c3,
  0x72c1, 0x72ce, 0x72cd, 0x72d2, 0x72e8, 0x72ef, 0x72e9, 0x72f2,
  0x72f4, 0x72f7, 0x7301, 0x72f3, 0x7303, 0x72fa, 0x72fb, 0x7317,
  0x7313, 0x7321, 0x730a, 0x731e, 0x731d, 0x7315, 0x7322, 0x7339,
  0x7325, 0x732c, 0x7338, 0x7331, 0x7350, 0x734d, 0x7357, 0x7360,
  0x736c, 0x736f, 0x737e, 0x821b, 0x5925, 0x98e7, 0x5924, 0x5902,
  0x9963, 0x9967, 0x9968, 0x9969, 0x996a, 0x996b, 0x996c, 0x9974,
  0x9977, 0x997d, 0x9980, 0x9984, 0x9987, 0x998a, 0x998d, 0x9990,
  0x9991, 0x9993, 0x9994, 0x9995, 0x5e80, 0x5e91, 0x5e8b, 0x5e96,
  0x5ea5, 0x5ea0, 0x5eb9, 0x5eb5, 0x5ebe, 0x5eb3, 0x8d53, 0x5ed2,
  0x5ed1, 0x5edb, 0x5ee8, 0x5eea, 0x81ba, 0x5fc4, 0x5fc9, 0x5fd6,
  0x5fcf, 0x6003, 0x5fee, 0x6004, 0x5fe1, 0x5fe4, 0x5ffe, 0x6005,
  0x6006, 0x5fea, 0x5fed, 0x5ff8, 0x6019, 0x6035, 0x6026, 0x601b,
  0x600f, 0x600d, 0x6029, 0x602b, 0x600a, 0x603f, 0x6021, 0x6078,
  0x6079, 0x607b, 0x607a, 0x6042, 0x606a, 0x607d, 0x6096, 0x609a,
  0x60ad, 0x609d, 0x6083, 0x6092, 0x608c, 0x609b, 0x60ec, 0x60bb,
  0x60b1, 0x60dd, 0x60d8, 0x60c6, 0x60da, 0x60b4, 0x6120, 0x6126,
  0x6115, 0x6123, 0x60f4, 0x6100, 0x610e, 0x612b, 0x614a, 0x6175,
  0x61ac, 0x6194, 0x61a7, 0x61b7, 0x61d4, 0x61f5, 0x5fdd, 0x96b3,
  0x95e9, 0x95eb, 0x95f1, 0x95f3, 0x95f5, 0x95f6, 0x95fc, 0x95fe,
  0x9603, 0x9604, 0x9606, 0x9608, 0x960a, 0x960b, 0x960c, 0x960d,
  0x960f, 0x9612, 0x9615, 0x9616, 0x9617, 0x9619, 0x961a, 0x4e2c,
  0x723f, 0x6215, 0x6c35, 0x6c54, 0x6c5c, 0x6c4a, 0x6ca3, 0x6c85,
  0x6c90, 0x6c94, 0x6c8c, 0x6c68, 0x6c69, 0x6c74, 0x6c76, 0x6c86,
  0x6ca9, 0x6cd0, 0x6cd4, 0x6cad, 0x6cf7, 0x6cf8, 0x6cf1, 0x6cd7,
  0x6cb2, 0x6ce0, 0x6cd6, 0x6cfa, 0x6ceb, 0x6cee, 0x6cb1, 0x6cd3,
  0x6cef, 0x6cfe, 0x6d39, 0x6d27, 0x6d0c, 0x6d43, 0x6d48, 0x6d07,
  0x6d04, 0x6d19, 0x6d0e, 0x6d2b, 0x6d4d, 0x6d2e, 0x6d35, 0x6d1a,
  0x6d4f, 0x6d52, 0x6d54, 0x6d33, 0x6d91, 0x6d6f, 0x6d9e, 0x6da0,
  0x6d5e, 0x6d93, 0x6d94, 0x6d5c, 0x6d60, 0x6d7c, 0x6d63, 0x6e1a,
  0x6dc7, 0x6dc5, 0x6dde, 0x6e0e, 0x6dbf, 0x6de0, 0x6e11, 0x6de6,
  0x6ddd, 0x6dd9, 0x6e16, 0x6dab, 0x6e0c, 0x6dae, 0x6e2b, 0x6e6e,
  0x6e4e, 0x6e6b, 0x6eb2, 0x6e5f, 0x6e86, 0x6e53, 0x6e54, 0x6e32,
  0x6e25, 0x6e44, 0x6edf, 0x6eb1, 0x6e98, 0x6ee0, 0x6f2d, 0x6ee2,
  0x6ea5, 0x6ea7, 0x6ebd, 0x6ebb, 0x6eb7, 0x6ed7, 0x6eb4, 0x6ecf,
  0x6e8f, 0x6ec2, 0x6e9f, 0x6f62, 0x6f46, 0x6f47, 0x6f24, 0x6f15,
  0x6ef9, 0x6f2f, 0x6f36, 0x6f4b, 0x6f74, 0x6f2a, 0x6f09, 0x6f29,
  0x6f89, 0x6f8d, 0x6f8c, 0x6f78, 0x6f72, 0x6f7c, 0x6f7a, 0x6fd1,
  0x6fc9, 0x6fa7, 0x6fb9, 0x6fb6, 0x6fc2, 0x6fe1, 0x6fee, 0x6fde,
  0x6fe0, 0x6fef, 0x701a, 0x7023, 0x701b, 0x7039, 0x7035, 0x704f,
  0x705e, 0x5b80, 0x5b84, 0x5b95, 0x5b93, 0x5ba5, 0x5bb8, 0x752f,
  0x9a9e, 0x6434, 0x5be4, 0x5bee, 0x8930, 0x5bf0, 0x8e47, 0x8b07,
  0x8fb6, 0x8fd3, 0x8fd5, 0x8fe5, 0x8fee, 0x8fe4, 0x8fe9, 0x8fe6,
  0x8ff3, 0x8fe8, 0x9005, 0x9004, 0x900b, 0x9026, 0x9011, 0x900d,
  0x9016, 0x9021, 0x9035, 0x9036, 0x902d, 0x902f, 0x9044, 0x9051,
  0x9052, 0x9050, 0x9068, 0x9058, 0x9062, 0x905b, 0x66b9, 0x9074,
  0x907d, 0x9082, 0x9088, 0x9083, 0x908b, 0x5f50, 0x5f57, 0x5f56,
  0x5f58, 0x5c3b, 0x54ab, 0x5c50, 0x5c59, 0x5b71, 0x5c63, 0x5c66,
  0x7fbc, 0x5f2a, 0x5f29, 0x5f2d, 0x8274, 0x5f3c, 0x9b3b, 0x5c6e,
  0x5981, 0x5983, 0x598d, 0x59a9, 0x59aa, 0x59a3, 0x5997, 0x59ca,
  0x59ab, 0x599e, 0x59a4, 0x59d2, 0x59b2, 0x59af, 0x59d7, 0x59be,
  0x5a05, 0x5a06, 0x59dd, 0x5a08, 0x59e3, 0x59d8, 0x59f9, 0x5a0c,
  0x5a09, 0x5a32, 0x5a34, 0x5a11, 0x5a23, 0x5a13, 0x5a40, 0x5a67,
  0x5a4a, 0x5a55, 0x5a3c, 0x5a62, 0x5a75, 0x80ec, 0x5aaa, 0x5a9b,
  0x5a77, 0x5a7a, 0x5abe, 0x5aeb, 0x5ab2, 0x5ad2, 0x5ad4, 0x5ab8,
  0x5ae0, 0x5ae3, 0x5af1, 0x5ad6, 0x5ae6, 0x5ad8, 0x5adc, 0x5b09,
  0x5b17, 0x5b16, 0x5b32, 0x5b37, 0x5b40, 0x5c15, 0x5c1c, 0x5b5a,
  0x5b65, 0x5b73, 0x5b51, 0x5b53, 0x5b62, 0x9a75, 0x9a77, 0x9a78,
  0x9a7a, 0x9a7f, 0x9a7d, 0x9a80, 0x9a81, 0x9a85, 0x9a88, 0x9a8a,
  0x9a90, 0x9a92, 0x9a93, 0x9a96, 0x9a98, 0x9a9b, 0x9a9c, 0x9a9d,
  0x9a9f, 0x9aa0, 0x9aa2, 0x9aa3, 0x9aa5, 0x9aa7, 0x7e9f, 0x7ea1,
  0x7ea3, 0x7ea5, 0x7ea8, 0x7ea9, 0x7ead, 0x7eb0, 0x7ebe, 0x7ec0,
  0x7ec1, 0x7ec2, 0x7ec9, 0x7ecb, 0x7ecc, 0x7ed0, 0x7ed4, 0x7ed7,
  0x7edb, 0x7ee0, 0x7ee1, 0x7ee8, 0x7eeb, 0x7eee, 0x7eef, 0x7ef1,
  0x7ef2, 0x7f0d, 0x7ef6, 0x7efa, 0x7efb, 0x7efe, 0x7f01, 0x7f02,
  0x7f03, 0x7f07, 0x7f08, 0x7f0b, 0x7f0c, 0x7f0f, 0x7f11, 0x7f12,
  0x7f17, 0x7f19, 0x7f1c, 0x7f1b, 0x7f1f, 0x7f21, 0x7f22, 0x7f23,
  0x7f24, 0x7f25, 0x7f26, 0x7f27, 0x7f2a, 0x7f2b, 0x7f2c, 0x7f2d,
  0x7f2f, 0x7f30, 0x7f31, 0x7f32, 0x7f33, 0x7f35, 0x5e7a, 0x757f,
  0x5ddb, 0x753e, 0x9095, 0x738e, 0x7391, 0x73ae, 0x73a2, 0x739f,
  0x73cf, 0x73c2, 0x73d1, 0x73b7, 0x73b3, 0x73c0, 0x73c9, 0x73c8,
  0x73e5, 0x73d9, 0x987c, 0x740a, 0x73e9, 0x73e7, 0x73de, 0x73ba,
  0x73f2, 0x740f, 0x742a, 0x745b, 0x7426, 0x7425, 0x7428, 0x7430,
  0x742e, 0x742c, 0x741b, 0x741a, 0x7441, 0x745c, 0x7457, 0x7455,
  0x7459, 0x7477, 0x746d, 0x747e, 0x749c, 0x748e, 0x7480, 0x7481,
  0x7487, 0x748b, 0x749e, 0x74a8, 0x74a9, 0x7490, 0x74a7, 0x74d2,
  0x74ba, 0x97ea, 0x97eb, 0x97ec, 0x674c, 0x6753, 0x675e, 0x6748,
  0x6769, 0x67a5, 0x6787, 0x676a, 0x6773, 0x6798, 0x67a7, 0x6775,
  0x67a8, 0x679e, 0x67ad, 0x678b, 0x6777, 0x677c, 0x67f0, 0x6809,
  0x67d8, 0x680a, 0x67e9, 0x67b0, 0x680c, 0x67d9, 0x67b5, 0x67da,
  0x67b3, 0x67dd, 0x6800, 0x67c3, 0x67b8, 0x67e2, 0x680e, 0x67c1,
  0x67fd, 0x6832, 0x6833, 0x6860, 0x6861, 0x684e, 0x6862, 0x6844,
  0x6864, 0x6883, 0x681d, 0x6855, 0x6866, 0x6841, 0x6867, 0x6840,
  0x683e, 0x684a, 0x6849, 0x6829, 0x68b5, 0x688f, 0x6874, 0x6877,
  0x6893, 0x686b, 0x68c2, 0x696e, 0x68fc, 0x691f, 0x6920, 0x68f9,
  0x6924, 0x68f0, 0x690b, 0x6901, 0x6957, 0x68e3, 0x6910, 0x6971,
  0x6939, 0x6960, 0x6942, 0x695d, 0x6984, 0x696b, 0x6980, 0x6998,
  0x6978, 0x6934, 0x69cc, 0x6987, 0x6988, 0x69ce, 0x6989, 0x6966,
  0x6963, 0x6979, 0x699b, 0x69a7, 0x69bb, 0x69ab, 0x69ad, 0x69d4,
  0x69b1, 0x69c1, 0x69ca, 0x69df, 0x6995, 0x69e0, 0x698d, 0x69ff,
  0x6a2f, 0x69ed, 0x6a17, 0x6a18, 0x6a65, 0x69f2, 0x6a44, 0x6a3e,
  0x6aa0, 0x6a50, 0x6a5b, 0x6a35, 0x6a8e, 0x6a79, 0x6a3d, 0x6a28,
  0x6a58, 0x6a7c, 0x6a91, 0x6a90, 0x6aa9, 0x6a97, 0x6aab, 0x7337,
  0x7352, 0x6b81, 0x6b82, 0x6b87, 0x6b84, 0x6b92, 0x6b93, 0x6b8d,
  0x6b9a, 0x6b9b, 0x6ba1, 0x6baa, 0x8f6b, 0x8f6d, 0x8f71, 0x8f72,
  0x8f73, 0x8f75, 0x8f76, 0x8f78, 0x8f77, 0x8f79, 0x8f7a, 0x8f7c,
  0x8f7e, 0x8f81, 0x8f82, 0x8f84, 0x8f87, 0x8f8b, 0x8f8d, 0x8f8e,
  0x8f8f, 0x8f98, 0x8f9a, 0x8ece, 0x620b, 0x6217, 0x621b, 0x621f,
  0x6222, 0x6221, 0x6225, 0x6224, 0x622c, 0x81e7, 0x74ef, 0x74f4,
  0x74ff, 0x750f, 0x7511, 0x7513, 0x6534, 0x65ee, 0x65ef, 0x65f0,
  0x660a, 0x6619, 0x6772, 0x6603, 0x6615, 0x6600, 0x7085, 0x66f7,
  0x661d, 0x6634, 0x6631, 0x6636, 0x6635, 0x8006, 0x665f, 0x6654,
  0x6641, 0x664f, 0x6656, 0x6661, 0x6657, 0x6677, 0x6684, 0x668c,
  0x66a7, 0x669d, 0x66be, 0x66db, 0x66dc, 0x66e6, 0x66e9, 0x8d32,
  0x8d33, 0x8d36, 0x8d3b, 0x8d3d, 0x8d40, 0x8d45, 0x8d46, 0x8d48,
  0x8d49, 0x8d47, 0x8d4d, 0x8d55, 0x8d59, 0x89c7, 0x89ca, 0x89cb,
  0x89cc, 0x89ce, 0x89cf, 0x89d0, 0x89d1, 0x726e, 0x729f, 0x725d,
  0x7266, 0x726f, 0x727e, 0x727f, 0x7284, 0x728b, 0x728d, 0x728f,
  0x7292, 0x6308, 0x6332, 0x63b0, 0x643f, 0x64d8, 0x8004, 0x6bea,
  0x6bf3, 0x6bfd, 0x6bf5, 0x6bf9, 0x6c05, 0x6c07, 0x6c06, 0x6c0d,
  0x6c15, 0x6c18, 0x6c19, 0x6c1a, 0x6c21, 0x6c29, 0x6c24, 0x6c2a,
  0x6c32, 0x6535, 0x6555, 0x656b, 0x724d, 0x7252, 0x7256, 0x7230,
  0x8662, 0x5216, 0x809f, 0x809c, 0x8093, 0x80bc, 0x670a, 0x80bd,
  0x80b1, 0x80ab, 0x80ad, 0x80b4, 0x80b7, 0x80e7, 0x80e8, 0x80e9,
  0x80ea, 0x80db, 0x80c2, 0x80c4, 0x80d9, 0x80cd, 0x80d7, 0x6710,
  0x80dd, 0x80eb, 0x80f1, 0x80f4, 0x80ed, 0x810d, 0x810e, 0x80f2,
  0x80fc, 0x6715, 0x8112, 0x8c5a, 0x8136, 0x811e, 0x812c, 0x8118,
  0x8132, 0x8148, 0x814c, 0x8153, 0x8174, 0x8159, 0x815a, 0x8171,
  0x8160, 0x8169, 0x817c, 0x817d, 0x816d, 0x8167, 0x584d, 0x5ab5,
  0x8188, 0x8182, 0x8191, 0x6ed5, 0x81a3, 0x81aa, 0x81cc, 0x6726,
  0x81ca, 0x81bb, 0x81c1, 0x81a6, 0x6b24, 0x6b37, 0x6b39, 0x6b43,
  0x6b46, 0x6b59, 0x98d1, 0x98d2, 0x98d3, 0x98d5, 0x98d9, 0x98da,
  0x6bb3, 0x5f40, 0x6bc2, 0x89f3, 0x6590, 0x9f51, 0x6593, 0x65bc,
  0x65c6, 0x65c4, 0x65c3, 0x65cc, 0x65ce, 0x65d2, 0x65d6, 0x7080,
  0x709c, 0x7096, 0x709d, 0x70bb, 0x70c0, 0x70b7, 0x70ab, 0x70b1,
  0x70e8, 0x70ca, 0x7110, 0x7113, 0x7116, 0x712f, 0x7131, 0x7173,
  0x715c, 0x7168, 0x7145, 0x7172, 0x714a, 0x7178, 0x717a, 0x7198,
  0x71b3, 0x71b5, 0x71a8, 0x71a0, 0x71e0, 0x71d4, 0x71e7, 0x71f9,
  0x721d, 0x7228, 0x706c, 0x7118, 0x7166, 0x71b9, 0x623e, 0x623d,
  0x6243, 0x6248, 0x6249, 0x793b, 0x7940, 0x7946, 0x7949, 0x795b,
  0x795c, 0x7953, 0x795a, 0x7962, 0x7957, 0x7960, 0x796f, 0x7967,
  0x797a, 0x7985, 0x798a, 0x799a, 0x79a7, 0x79b3, 0x5fd1, 0x5fd0,
  0x603c, 0x605d, 0x605a, 0x6067, 0x6041, 0x6059, 0x6063, 0x60ab,
  0x6106, 0x610d, 0x615d, 0x61a9, 0x619d, 0x61cb, 0x61d1, 0x6206,
  0x8080, 0x807f, 0x6c93, 0x6cf6, 0x6dfc, 0x77f6, 0x77f8, 0x7800,
  0x7809, 0x7817, 0x7818, 0x7811, 0x65ab, 0x782d, 0x781c, 0x781d,
  0x7839, 0x783a, 0x783b, 0x781f, 0x783c, 0x7825, 0x782c, 0x7823,
  0x7829, 0x784e, 0x786d, 0x7856, 0x7857, 0x7826, 0x7850, 0x7847,
  0x784c, 0x786a, 0x789b, 0x7893, 0x789a, 0x7887, 0x789c, 0x78a1,
  0x78a3, 0x78b2, 0x78b9, 0x78a5, 0x78d4, 0x78d9, 0x78c9, 0x78ec,
  0x78f2, 0x7905, 0x78f4, 0x7913, 0x7924, 0x791e, 0x7934, 0x9f9b,
  0x9ef9, 0x9efb, 0x9efc, 0x76f1, 0x7704, 0x770d, 0x76f9, 0x7707,
  0x7708, 0x771a, 0x7722, 0x7719, 0x772d, 0x7726, 0x7735, 0x7738,
  0x7750, 0x7751, 0x7747, 0x7743, 0x775a, 0x7768, 0x7762, 0x7765,
  0x777f, 0x778d, 0x777d, 0x7780, 0x778c, 0x7791, 0x779f, 0x77a0,
  0x77b0, 0x77b5, 0x77bd, 0x753a, 0x7540, 0x754e, 0x754b, 0x7548,
  0x755b, 0x7572, 0x7579, 0x7583, 0x7f58, 0x7f61, 0x7f5f, 0x8a48,
  0x7f68, 0x7f74, 0x7f71, 0x7f79, 0x7f81, 0x7f7e, 0x76cd, 0x76e5,
  0x8832, 0x9485, 0x9486, 0x9487, 0x948b, 0x948a, 0x948c, 0x948d,
  0x948f, 0x9490, 0x9494, 0x9497, 0x9495, 0x949a, 0x949b, 0x949c,
  0x94a3, 0x94a4, 0x94ab, 0x94aa, 0x94ad, 0x94ac, 0x94af, 0x94b0,
  0x94b2, 0x94b4, 0x94b6, 0x94b7, 0x94b8, 0x94b9, 0x94ba, 0x94bc,
  0x94bd, 0x94bf, 0x94c4, 0x94c8, 0x94c9, 0x94ca, 0x94cb, 0x94cc,
  0x94cd, 0x94ce, 0x94d0, 0x94d1, 0x94d2, 0x94d5, 0x94d6, 0x94d7,
  0x94d9, 0x94d8, 0x94db, 0x94de, 0x94df, 0x94e0, 0x94e2, 0x94e4,
  0x94e5, 0x94e7, 0x94e8, 0x94ea, 0x94e9, 0x94eb, 0x94ee, 0x94ef,
  0x94f3, 0x94f4, 0x94f5, 0x94f7, 0x94f9, 0x94fc, 0x94fd, 0x94ff,
  0x9503, 0x9502, 0x9506, 0x9507, 0x9509, 0x950a, 0x950d, 0x950e,
  0x950f, 0x9512, 0x9513, 0x9514, 0x9515, 0x9516, 0x9518, 0x951b,
  0x951d, 0x951e, 0x951f, 0x9522, 0x952a, 0x952b, 0x9529, 0x952c,
  0x9531, 0x9532, 0x9534, 0x9536, 0x9537, 0x9538, 0x953c, 0x953e,
  0x953f, 0x9542, 0x9535, 0x9544, 0x9545, 0x9546, 0x9549, 0x954c,
  0x954e, 0x954f, 0x9552, 0x9553, 0x9554, 0x9556, 0x9557, 0x9558,
  0x9559, 0x955b, 0x955e, 0x955f, 0x955d, 0x9561, 0x9562, 0x9564,
  0x9565, 0x9566, 0x9567, 0x9568, 0x9569, 0x956a, 0x956b, 0x956c,
  0x956f, 0x9571, 0x9572, 0x9573, 0x953a, 0x77e7, 0x77ec, 0x96c9,
  0x79d5, 0x79ed, 0x79e3, 0x79eb, 0x7a06, 0x5d47, 0x7a03, 0x7a02,
  0x7a1e, 0x7a14, 0x7a39, 0x7a37, 0x7a51, 0x9ecf, 0x99a5, 0x7a70,
  0x7688, 0x768e, 0x7693, 0x7699, 0x76a4, 0x74de, 0x74e0, 0x752c,
  0x9e20, 0x9e22, 0x9e28, 0x9e29, 0x9e2a, 0x9e2b, 0x9e2c, 0x9e32,
  0x9e31, 0x9e36, 0x9e38, 0x9e37, 0x9e39, 0x9e3a, 0x9e3e, 0x9e41,
  0x9e42, 0x9e44, 0x9e46, 0x9e47, 0x9e48, 0x9e49, 0x9e4b, 0x9e4c,
  0x9e4e, 0x9e51, 0x9e55, 0x9e57, 0x9e5a, 0x9e5b, 0x9e5c, 0x9e5e,
  0x9e63, 0x9e66, 0x9e67, 0x9e68, 0x9e69, 0x9e6a, 0x9e6b, 0x9e6c,
  0x9e71, 0x9e6d, 0x9e73, 0x7592, 0x7594, 0x7596, 0x75a0, 0x759d,
  0x75ac, 0x75a3, 0x75b3, 0x75b4, 0x75b8, 0x75c4, 0x75b1, 0x75b0,
  0x75c3, 0x75c2, 0x75d6, 0x75cd, 0x75e3, 0x75e8, 0x75e6, 0x75e4,
  0x75eb, 0x75e7, 0x7603, 0x75f1, 0x75fc, 0x75ff, 0x7610, 0x7600,
  0x7605, 0x760c, 0x7617, 0x760a, 0x7625, 0x7618, 0x7615, 0x7619,
  0x761b, 0x763c, 0x7622, 0x7620, 0x7640, 0x762d, 0x7630, 0x763f,
  0x7635, 0x7643, 0x763e, 0x7633, 0x764d, 0x765e, 0x7654, 0x765c,
  0x7656, 0x766b, 0x766f, 0x7fca, 0x7ae6, 0x7a78, 0x7a79, 0x7a80,
  0x7a86, 0x7a88, 0x7a95, 0x7aa6, 0x7aa0, 0x7aac, 0x7aa8, 0x7aad,
  0x7ab3, 0x8864, 0x8869, 0x8872, 0x887d, 0x887f, 0x8882, 0x88a2,
  0x88c6, 0x88b7, 0x88bc, 0x88c9, 0x88e2, 0x88ce, 0x88e3, 0x88e5,
  0x88f1, 0x891a, 0x88fc, 0x88e8, 0x88fe, 0x88f0, 0x8921, 0x8919,
  0x8913, 0x891b, 0x890a, 0x8934, 0x892b, 0x8936, 0x8941, 0x8966,
  0x897b, 0x758b, 0x80e5, 0x76b2, 0x76b4, 0x77dc, 0x8012, 0x8014,
  0x8016, 0x801c, 0x8020, 0x8022, 0x8025, 0x8026, 0x8027, 0x8029,
  0x8028, 0x8031, 0x800b, 0x8035, 0x8043, 0x8046, 0x804d, 0x8052,
  0x8069, 0x8071, 0x8983, 0x9878, 0x9880, 0x9883, 0x9889, 0x988c,
  0x988d, 0x988f, 0x9894, 0x989a, 0x989b, 0x989e, 0x989f, 0x98a1,
  0x98a2, 0x98a5, 0x98a6, 0x864d, 0x8654, 0x866c, 0x866e, 0x867f,
  0x867a, 0x867c, 0x867b, 0x86a8, 0x868d, 0x868b, 0x86ac, 0x869d,
  0x86a7, 0x86a3, 0x86aa, 0x8693, 0x86a9, 0x86b6, 0x86c4, 0x86b5,
  0x86ce, 0x86b0, 0x86ba, 0x86b1, 0x86af, 0x86c9, 0x86cf, 0x86b4,
  0x86e9, 0x86f1, 0x86f2, 0x86ed, 0x86f3, 0x86d0, 0x8713, 0x86de,
  0x86f4, 0x86df, 0x86d8, 0x86d1, 0x8703, 0x8707, 0x86f8, 0x8708,
  0x870a, 0x870d, 0x8709, 0x8723, 0x873b, 0x871e, 0x8725, 0x872e,
  0x871a, 0x873e, 0x8748, 0x8734, 0x8731, 0x8729, 0x8737, 0x873f,
  0x8782, 0x8722, 0x877d, 0x877e, 0x877b, 0x8760, 0x8770, 0x874c,
  0x876e, 0x878b, 0x8753, 0x8763, 0x877c, 0x8764, 0x8759, 0x8765,
  0x8793, 0x87af, 0x87a8, 0x87d2, 0x87c6, 0x8788, 0x8785, 0x87ad,
  0x8797, 0x8783, 0x87ab, 0x87e5, 0x87ac, 0x87b5, 0x87b3, 0x87cb,
  0x87d3, 0x87bd, 0x87d1, 0x87c0, 0x87ca, 0x87db, 0x87ea, 0x87e0,
  0x87ee, 0x8816, 0x8813, 0x87fe, 0x880a, 0x881b, 0x8821, 0x8839,
  0x883c, 0x7f36, 0x7f42, 0x7f44, 0x7f45, 0x8210, 0x7afa, 0x7afd,
  0x7b08, 0x7b03, 0x7b04, 0x7b15, 0x7b0a, 0x7b2b, 0x7b0f, 0x7b47,
  0x7b38, 0x7b2a, 0x7b19, 0x7b2e, 0x7b31, 0x7b20, 0x7b25, 0x7b24,
  0x7b33, 0x7b3e, 0x7b1e, 0x7b58, 0x7b5a, 0x7b45, 0x7b75, 0x7b4c,
  0x7b5d, 0x7b60, 0x7b6e, 0x7b7b, 0x7b62, 0x7b72, 0x7b71, 0x7b90,
  0x7ba6, 0x7ba7, 0x7bb8, 0x7bac, 0x7b9d, 0x7ba8, 0x7b85, 0x7baa,
  0x7b9c, 0x7ba2, 0x7bab, 0x7bb4, 0x7bd1, 0x7bc1, 0x7bcc, 0x7bdd,
  0x7bda, 0x7be5, 0x7be6, 0x7bea, 0x7c0c, 0x7bfe, 0x7bfc, 0x7c0f,
  0x7c16, 0x7c0b, 0x7c1f, 0x7c2a, 0x7c26, 0x7c38, 0x7c41, 0x7c40,
  0x81fe, 0x8201, 0x8202, 0x8204, 0x81ec, 0x8844, 0x8221, 0x8222,
  0x8223, 0x822d, 0x822f, 0x8228, 0x822b, 0x8238, 0x823b, 0x8233,
  0x8234, 0x823e, 0x8244, 0x8249, 0x824b, 0x824f, 0x825a, 0x825f,
  0x8268, 0x887e, 0x8885, 0x8888, 0x88d8, 0x88df, 0x895e, 0x7f9d,
  0x7f9f, 0x7fa7, 0x7faf, 0x7fb0, 0x7fb2, 0x7c7c, 0x6549, 0x7c91,
  0x7c9d, 0x7c9c, 0x7c9e, 0x7ca2, 0x7cb2, 0x7cbc, 0x7cbd, 0x7cc1,
  0x7cc7, 0x7ccc, 0x7ccd, 0x7cc8, 0x7cc5, 0x7cd7, 0x7ce8, 0x826e,
  0x66a8, 0x7fbf, 0x7fce, 0x7fd5, 0x7fe5, 0x7fe1, 0x7fe6, 0x7fe9,
  0x7fee, 0x7ff3, 0x7cf8, 0x7d77, 0x7da6, 0x7dae, 0x7e47, 0x7e9b,
  0x9eb8, 0x9eb4, 0x8d73, 0x8d84, 0x8d94, 0x8d91, 0x8db1, 0x8d67,
  0x8d6d, 0x8c47, 0x8c49, 0x914a, 0x9150, 0x914e, 0x914f, 0x9164,
  0x9162, 0x9161, 0x9170, 0x9169, 0x916f, 0x917d, 0x917e, 0x9172,
  0x9174, 0x9179, 0x918c, 0x9185, 0x9190, 0x918d, 0x9191, 0x91a2,
  0x91a3, 0x91aa, 0x91ad, 0x91ae, 0x91af, 0x91b5, 0x91b4, 0x91ba,
  0x8c55, 0x9e7e, 0x8db8, 0x8deb, 0x8e05, 0x8e59, 0x8e69, 0x8db5,
  0x8dbf, 0x8dbc, 0x8dba, 0x8dc4, 0x8dd6, 0x8dd7, 0x8dda, 0x8dde,
  0x8dce, 0x8dcf, 0x8ddb, 0x8dc6, 0x8dec, 0x8df7, 0x8df8, 0x8de3,
  0x8df9, 0x8dfb, 0x8de4, 0x8e09, 0x8dfd, 0x8e14, 0x8e1d, 0x8e1f,
  0x8e2c, 0x8e2e, 0x8e23, 0x8e2f, 0x8e3a, 0x8e40, 0x8e39, 0x8e35,
  0x8e3d, 0x8e31, 0x8e49, 0x8e41, 0x8e42, 0x8e51, 0x8e52, 0x8e4a,
  0x8e70, 0x8e76, 0x8e7c, 0x8e6f, 0x8e74, 0x8e85, 0x8e8f, 0x8e94,
  0x8e90, 0x8e9c, 0x8e9e, 0x8c78, 0x8c82, 0x8c8a, 0x8c85, 0x8c98,
  0x8c94, 0x659b, 0x89d6, 0x89de, 0x89da, 0x89dc, 0x89e5, 0x89eb,
  0x89ef, 0x8a3e, 0x8b26, 0x9753, 0x96e9, 0x96f3, 0x96ef, 0x9706,
  0x9701, 0x9708, 0x970f, 0x970e, 0x972a, 0x972d, 0x9730, 0x973e,
  0x9f80, 0x9f83, 0x9f85, 0x9f86, 0x9f87, 0x9f88, 0x9f89, 0x9f8a,
  0x9f8c, 0x9efe, 0x9f0b, 0x9f0d, 0x96b9, 0x96bc, 0x96bd, 0x96ce,
  0x96d2, 0x77bf, 0x96e0, 0x928e, 0x92ae, 0x92c8, 0x933e, 0x936a,
  0x93ca, 0x938f, 0x943e, 0x946b, 0x9c7f, 0x9c82, 0x9c85, 0x9c86,
  0x9c87, 0x9c88, 0x7a23, 0x9c8b, 0x9c8e, 0x9c90, 0x9c91, 0x9c92,
  0x9c94, 0x9c95, 0x9c9a, 0x9c9b, 0x9c9e, 0x9c9f, 0x9ca0, 0x9ca1,
  0x9ca2, 0x9ca3, 0x9ca5, 0x9ca6, 0x9ca7, 0x9ca8, 0x9ca9, 0x9cab,
  0x9cad, 0x9cae, 0x9cb0, 0x9cb1, 0x9cb2, 0x9cb3, 0x9cb4, 0x9cb5,
  0x9cb6, 0x9cb7, 0x9cba, 0x9cbb, 0x9cbc, 0x9cbd, 0x9cc4, 0x9cc5,
  0x9cc6, 0x9cc7, 0x9cca, 0x9ccb, 0x9ccc, 0x9ccd, 0x9cce, 0x9ccf,
  0x9cd0, 0x9cd3, 0x9cd4, 0x9cd5, 0x9cd7, 0x9cd8, 0x9cd9, 0x9cdc,
  0x9cdd, 0x9cdf, 0x9ce2, 0x977c, 0x9785, 0x9791, 0x9792, 0x9794,
  0x97af, 0x97ab, 0x97a3, 0x97b2, 0x97b4, 0x9ab1, 0x9ab0, 0x9ab7,
  0x9e58, 0x9ab6, 0x9aba, 0x9abc, 0x9ac1, 0x9ac0, 0x9ac5, 0x9ac2,
  0x9acb, 0x9acc, 0x9ad1, 0x9b45, 0x9b43, 0x9b47, 0x9b49, 0x9b48,
  0x9b4d, 0x9b51, 0x98e8, 0x990d, 0x992e, 0x9955, 0x9954, 0x9adf,
  0x9ae1, 0x9ae6, 0x9aef, 0x9aeb, 0x9afb, 0x9aed, 0x9af9, 0x9b08,
  0x9b0f, 0x9b13, 0x9b1f, 0x9b23, 0x9ebd, 0x9ebe, 0x7e3b, 0x9e82,
  0x9e87, 0x9e88, 0x9e8b, 0x9e92, 0x93d6, 0x9e9d, 0x9e9f, 0x9edb,
  0x9edc, 0x9edd, 0x9ee0, 0x9edf, 0x9ee2, 0x9ee9, 0x9ee7, 0x9ee5,
  0x9eea, 0x9eef, 0x9f22, 0x9f2c, 0x9f2f, 0x9f39, 0x9f37, 0x9f3d,
  0x9f3e, 0x9f44, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, };
UNICHAR map_JIS_C6226_1983[] = {
  0x3000, 0x3001, 0x3002, 0xff0c, 0xff0e, 0x30fb, 0xff1a, 0xff1b,
  0xff1f, 0xff01, 0x309b, 0x309c, 0x00b4, 0xff40, 0x00a8, 0xff3e,
  0xffe3, 0xff3f, 0x30fd, 0x30fe, 0x309d, 0x309e, 0x3003, 0x4edd,
  0x3005, 0x3006, 0x3007, 0x30fc, 0x2015, 0x2010, 0xff0f, 0x005c,
  0x301c, 0x2016, 0xff5c, 0x2026, 0x2025, 0x2018, 0x2019, 0x201c,
  0x201d, 0xff08, 0xff09, 0x3014, 0x3015, 0xff3b, 0xff3d, 0xff5b,
  0xff5d, 0x3008, 0x3009, 0x300a, 0x300b, 0x300c, 0x300d, 0x300e,
  0x300f, 0x3010, 0x3011, 0xff0b, 0x2212, 0x00b1, 0x00d7, 0x00f7,
  0xff1d, 0x2260, 0xff1c, 0xff1e, 0x2266, 0x2267, 0x221e, 0x2234,
  0x2642, 0x2640, 0x00b0, 0x2032, 0x2033, 0x2103, 0xffe5, 0xff04,
  0x00a2, 0x00a3, 0xff05, 0xff03, 0xff06, 0xff0a, 0xff20, 0x00a7,
  0x2606, 0x2605, 0x25cb, 0x25cf, 0x25ce, 0x25c7, 0x25c6, 0x25a1,
  0x25a0, 0x25b3, 0x25b2, 0x25bd, 0x25bc, 0x203b, 0x3012, 0x2192,
  0x2190, 0x2191, 0x2193, 0x3013, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x2208,
  0x220b, 0x2286, 0x2287, 0x2282, 0x2283, 0x222a, 0x2229, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x2227,
  0x2228, 0x00ac, 0x21d2, 0x21d4, 0x2200, 0x2203, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0x2220, 0x22a5, 0x2312, 0x2202, 0x2207, 0x2261, 0x2252,
  0x226a, 0x226b, 0x221a, 0x223d, 0x221d, 0x2235, 0x222b, 0x222c,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x212b,
  0x2030, 0x266f, 0x266d, 0x266a, 0x2020, 0x2021, 0x00b6, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0x25ef, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xff10, 0xff11, 0xff12, 0xff13, 0xff14,
  0xff15, 0xff16, 0xff17, 0xff18, 0xff19, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xff21, 0xff22, 0xff23, 0xff24,
  0xff25, 0xff26, 0xff27, 0xff28, 0xff29, 0xff2a, 0xff2b, 0xff2c,
  0xff2d, 0xff2e, 0xff2f, 0xff30, 0xff31, 0xff32, 0xff33, 0xff34,
  0xff35, 0xff36, 0xff37, 0xff38, 0xff39, 0xff3a, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xff41, 0xff42, 0xff43, 0xff44,
  0xff45, 0xff46, 0xff47, 0xff48, 0xff49, 0xff4a, 0xff4b, 0xff4c,
  0xff4d, 0xff4e, 0xff4f, 0xff50, 0xff51, 0xff52, 0xff53, 0xff54,
  0xff55, 0xff56, 0xff57, 0xff58, 0xff59, 0xff5a, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x3041, 0x3042, 0x3043, 0x3044, 0x3045, 0x3046,
  0x3047, 0x3048, 0x3049, 0x304a, 0x304b, 0x304c, 0x304d, 0x304e,
  0x304f, 0x3050, 0x3051, 0x3052, 0x3053, 0x3054, 0x3055, 0x3056,
  0x3057, 0x3058, 0x3059, 0x305a, 0x305b, 0x305c, 0x305d, 0x305e,
  0x305f, 0x3060, 0x3061, 0x3062, 0x3063, 0x3064, 0x3065, 0x3066,
  0x3067, 0x3068, 0x3069, 0x306a, 0x306b, 0x306c, 0x306d, 0x306e,
  0x306f, 0x3070, 0x3071, 0x3072, 0x3073, 0x3074, 0x3075, 0x3076,
  0x3077, 0x3078, 0x3079, 0x307a, 0x307b, 0x307c, 0x307d, 0x307e,
  0x307f, 0x3080, 0x3081, 0x3082, 0x3083, 0x3084, 0x3085, 0x3086,
  0x3087, 0x3088, 0x3089, 0x308a, 0x308b, 0x308c, 0x308d, 0x308e,
  0x308f, 0x3090, 0x3091, 0x3092, 0x3093, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0x30a1, 0x30a2, 0x30a3, 0x30a4, 0x30a5, 0x30a6, 0x30a7, 0x30a8,
  0x30a9, 0x30aa, 0x30ab, 0x30ac, 0x30ad, 0x30ae, 0x30af, 0x30b0,
  0x30b1, 0x30b2, 0x30b3, 0x30b4, 0x30b5, 0x30b6, 0x30b7, 0x30b8,
  0x30b9, 0x30ba, 0x30bb, 0x30bc, 0x30bd, 0x30be, 0x30bf, 0x30c0,
  0x30c1, 0x30c2, 0x30c3, 0x30c4, 0x30c5, 0x30c6, 0x30c7, 0x30c8,
  0x30c9, 0x30ca, 0x30cb, 0x30cc, 0x30cd, 0x30ce, 0x30cf, 0x30d0,
  0x30d1, 0x30d2, 0x30d3, 0x30d4, 0x30d5, 0x30d6, 0x30d7, 0x30d8,
  0x30d9, 0x30da, 0x30db, 0x30dc, 0x30dd, 0x30de, 0x30df, 0x30e0,
  0x30e1, 0x30e2, 0x30e3, 0x30e4, 0x30e5, 0x30e6, 0x30e7, 0x30e8,
  0x30e9, 0x30ea, 0x30eb, 0x30ec, 0x30ed, 0x30ee, 0x30ef, 0x30f0,
  0x30f1, 0x30f2, 0x30f3, 0x30f4, 0x30f5, 0x30f6, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x0391, 0x0392,
  0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 0x0398, 0x0399, 0x039a,
  0x039b, 0x039c, 0x039d, 0x039e, 0x039f, 0x03a0, 0x03a1, 0x03a3,
  0x03a4, 0x03a5, 0x03a6, 0x03a7, 0x03a8, 0x03a9, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x03b1, 0x03b2,
  0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7, 0x03b8, 0x03b9, 0x03ba,
  0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf, 0x03c0, 0x03c1, 0x03c3,
  0x03c4, 0x03c5, 0x03c6, 0x03c7, 0x03c8, 0x03c9, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x0410, 0x0411, 0x0412, 0x0413,
  0x0414, 0x0415, 0x0401, 0x0416, 0x0417, 0x0418, 0x0419, 0x041a,
  0x041b, 0x041c, 0x041d, 0x041e, 0x041f, 0x0420, 0x0421, 0x0422,
  0x0423, 0x0424, 0x0425, 0x0426, 0x0427, 0x0428, 0x0429, 0x042a,
  0x042b, 0x042c, 0x042d, 0x042e, 0x042f, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x0430, 0x0431, 0x0432, 0x0433,
  0x0434, 0x0435, 0x0451, 0x0436, 0x0437, 0x0438, 0x0439, 0x043a,
  0x043b, 0x043c, 0x043d, 0x043e, 0x043f, 0x0440, 0x0441, 0x0442,
  0x0443, 0x0444, 0x0445, 0x0446, 0x0447, 0x0448, 0x0449, 0x044a,
  0x044b, 0x044c, 0x044d, 0x044e, 0x044f, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x2500, 0x2502, 0x250c, 0x2510, 0x2518, 0x2514,
  0x251c, 0x252c, 0x2524, 0x2534, 0x253c, 0x2501, 0x2503, 0x250f,
  0x2513, 0x251b, 0x2517, 0x2523, 0x2533, 0x252b, 0x253b, 0x254b,
  0x2520, 0x252f, 0x2528, 0x2537, 0x253f, 0x251d, 0x2530, 0x2525,
  0x2538, 0x2542, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x4e9c, 0x5516, 0x5a03, 0x963f, 0x54c0, 0x611b,
  0x6328, 0x59f6, 0x9022, 0x8475, 0x831c, 0x7a50, 0x60aa, 0x63e1,
  0x6e25, 0x65ed, 0x8466, 0x82a6, 0x9bf5, 0x6893, 0x5727, 0x65a1,
  0x6271, 0x5b9b, 0x59d0, 0x867b, 0x98f4, 0x7d62, 0x7dbe, 0x9b8e,
  0x6216, 0x7c9f, 0x88b7, 0x5b89, 0x5eb5, 0x6309, 0x6697, 0x6848,
  0x95c7, 0x978d, 0x674f, 0x4ee5, 0x4f0a, 0x4f4d, 0x4f9d, 0x5049,
  0x56f2, 0x5937, 0x59d4, 0x5a01, 0x5c09, 0x60df, 0x610f, 0x6170,
  0x6613, 0x6905, 0x70ba, 0x754f, 0x7570, 0x79fb, 0x7dad, 0x7def,
  0x80c3, 0x840e, 0x8863, 0x8b02, 0x9055, 0x907a, 0x533b, 0x4e95,
  0x4ea5, 0x57df, 0x80b2, 0x90c1, 0x78ef, 0x4e00, 0x58f1, 0x6ea2,
  0x9038, 0x7a32, 0x8328, 0x828b, 0x9c2f, 0x5141, 0x5370, 0x54bd,
  0x54e1, 0x56e0, 0x59fb, 0x5f15, 0x98f2, 0x6deb, 0x80e4, 0x852d,
  0x9662, 0x9670, 0x96a0, 0x97fb, 0x540b, 0x53f3, 0x5b87, 0x70cf,
  0x7fbd, 0x8fc2, 0x96e8, 0x536f, 0x9d5c, 0x7aba, 0x4e11, 0x7893,
  0x81fc, 0x6e26, 0x5618, 0x5504, 0x6b1d, 0x851a, 0x9c3b, 0x59e5,
  0x53a9, 0x6d66, 0x74dc, 0x958f, 0x5642, 0x4e91, 0x904b, 0x96f2,
  0x834f, 0x990c, 0x53e1, 0x55b6, 0x5b30, 0x5f71, 0x6620, 0x66f3,
  0x6804, 0x6c38, 0x6cf3, 0x6d29, 0x745b, 0x76c8, 0x7a4e, 0x9834,
  0x82f1, 0x885b, 0x8a60, 0x92ed, 0x6db2, 0x75ab, 0x76ca, 0x99c5,
  0x60a6, 0x8b01, 0x8d8a, 0x95b2, 0x698e, 0x53ad, 0x5186, 0x5712,
  0x5830, 0x5944, 0x5bb4, 0x5ef6, 0x6028, 0x63a9, 0x63f4, 0x6cbf,
  0x6f14, 0x708e, 0x7114, 0x7159, 0x71d5, 0x733f, 0x7e01, 0x8276,
  0x82d1, 0x8597, 0x9060, 0x925b, 0x9d1b, 0x5869, 0x65bc, 0x6c5a,
  0x7525, 0x51f9, 0x592e, 0x5965, 0x5f80, 0x5fdc, 0x62bc, 0x65fa,
  0x6a2a, 0x6b27, 0x6bb4, 0x738b, 0x7fc1, 0x8956, 0x9d2c, 0x9d0e,
  0x9ec4, 0x5ca1, 0x6c96, 0x837b, 0x5104, 0x5c4b, 0x61b6, 0x81c6,
  0x6876, 0x7261, 0x4e59, 0x4ffa, 0x5378, 0x6069, 0x6e29, 0x7a4f,
  0x97f3, 0x4e0b, 0x5316, 0x4eee, 0x4f55, 0x4f3d, 0x4fa1, 0x4f73,
  0x52a0, 0x53ef, 0x5609, 0x590f, 0x5ac1, 0x5bb6, 0x5be1, 0x79d1,
  0x6687, 0x679c, 0x67b6, 0x6b4c, 0x6cb3, 0x706b, 0x73c2, 0x798d,
  0x79be, 0x7a3c, 0x7b87, 0x82b1, 0x82db, 0x8304, 0x8377, 0x83ef,
  0x83d3, 0x8766, 0x8ab2, 0x5629, 0x8ca8, 0x8fe6, 0x904e, 0x971e,
  0x868a, 0x4fc4, 0x5ce8, 0x6211, 0x7259, 0x753b, 0x81e5, 0x82bd,
  0x86fe, 0x8cc0, 0x96c5, 0x9913, 0x99d5, 0x4ecb, 0x4f1a, 0x89e3,
  0x56de, 0x584a, 0x58ca, 0x5efb, 0x5feb, 0x602a, 0x6094, 0x6062,
  0x61d0, 0x6212, 0x62d0, 0x6539, 0x9b41, 0x6666, 0x68b0, 0x6d77,
  0x7070, 0x754c, 0x7686, 0x7d75, 0x82a5, 0x87f9, 0x958b, 0x968e,
  0x8c9d, 0x51f1, 0x52be, 0x5916, 0x54b3, 0x5bb3, 0x5d16, 0x6168,
  0x6982, 0x6daf, 0x788d, 0x84cb, 0x8857, 0x8a72, 0x93a7, 0x9ab8,
  0x6d6c, 0x99a8, 0x86d9, 0x57a3, 0x67ff, 0x86ce, 0x920e, 0x5283,
  0x5687, 0x5404, 0x5ed3, 0x62e1, 0x64b9, 0x683c, 0x6838, 0x6bbb,
  0x7372, 0x78ba, 0x7a6b, 0x899a, 0x89d2, 0x8d6b, 0x8f03, 0x90ed,
  0x95a3, 0x9694, 0x9769, 0x5b66, 0x5cb3, 0x697d, 0x984d, 0x984e,
  0x639b, 0x7b20, 0x6a2b, 0x6a7f, 0x68b6, 0x9c0d, 0x6f5f, 0x5272,
  0x559d, 0x6070, 0x62ec, 0x6d3b, 0x6e07, 0x6ed1, 0x845b, 0x8910,
  0x8f44, 0x4e14, 0x9c39, 0x53f6, 0x691b, 0x6a3a, 0x9784, 0x682a,
  0x515c, 0x7ac3, 0x84b2, 0x91dc, 0x938c, 0x565b, 0x9d28, 0x6822,
  0x8305, 0x8431, 0x7ca5, 0x5208, 0x82c5, 0x74e6, 0x4e7e, 0x4f83,
  0x51a0, 0x5bd2, 0x520a, 0x52d8, 0x52e7, 0x5dfb, 0x559a, 0x582a,
  0x59e6, 0x5b8c, 0x5b98, 0x5bdb, 0x5e72, 0x5e79, 0x60a3, 0x611f,
  0x6163, 0x61be, 0x63db, 0x6562, 0x67d1, 0x6853, 0x68fa, 0x6b3e,
  0x6b53, 0x6c57, 0x6f22, 0x6f97, 0x6f45, 0x74b0, 0x7518, 0x76e3,
  0x770b, 0x7aff, 0x7ba1, 0x7c21, 0x7de9, 0x7f36, 0x7ff0, 0x809d,
  0x8266, 0x839e, 0x89b3, 0x8acc, 0x8cab, 0x9084, 0x9451, 0x9593,
  0x9591, 0x95a2, 0x9665, 0x97d3, 0x9928, 0x8218, 0x4e38, 0x542b,
  0x5cb8, 0x5dcc, 0x73a9, 0x764c, 0x773c, 0x5ca9, 0x7feb, 0x8d0b,
  0x96c1, 0x9811, 0x9854, 0x9858, 0x4f01, 0x4f0e, 0x5371, 0x559c,
  0x5668, 0x57fa, 0x5947, 0x5b09, 0x5bc4, 0x5c90, 0x5e0c, 0x5e7e,
  0x5fcc, 0x63ee, 0x673a, 0x65d7, 0x65e2, 0x671f, 0x68cb, 0x68c4,
  0x6a5f, 0x5e30, 0x6bc5, 0x6c17, 0x6c7d, 0x757f, 0x7948, 0x5b63,
  0x7a00, 0x7d00, 0x5fbd, 0x898f, 0x8a18, 0x8cb4, 0x8d77, 0x8ecc,
  0x8f1d, 0x98e2, 0x9a0e, 0x9b3c, 0x4e80, 0x507d, 0x5100, 0x5993,
  0x5b9c, 0x622f, 0x6280, 0x64ec, 0x6b3a, 0x72a0, 0x7591, 0x7947,
  0x7fa9, 0x87fb, 0x8abc, 0x8b70, 0x63ac, 0x83ca, 0x97a0, 0x5409,
  0x5403, 0x55ab, 0x6854, 0x6a58, 0x8a70, 0x7827, 0x6775, 0x9ecd,
  0x5374, 0x5ba2, 0x811a, 0x8650, 0x9006, 0x4e18, 0x4e45, 0x4ec7,
  0x4f11, 0x53ca, 0x5438, 0x5bae, 0x5f13, 0x6025, 0x6551, 0x673d,
  0x6c42, 0x6c72, 0x6ce3, 0x7078, 0x7403, 0x7a76, 0x7aae, 0x7b08,
  0x7d1a, 0x7cfe, 0x7d66, 0x65e7, 0x725b, 0x53bb, 0x5c45, 0x5de8,
  0x62d2, 0x62e0, 0x6319, 0x6e20, 0x865a, 0x8a31, 0x8ddd, 0x92f8,
  0x6f01, 0x79a6, 0x9b5a, 0x4ea8, 0x4eab, 0x4eac, 0x4f9b, 0x4fa0,
  0x50d1, 0x5147, 0x7af6, 0x5171, 0x51f6, 0x5354, 0x5321, 0x537f,
  0x53eb, 0x55ac, 0x5883, 0x5ce1, 0x5f37, 0x5f4a, 0x602f, 0x6050,
  0x606d, 0x631f, 0x6559, 0x6a4b, 0x6cc1, 0x72c2, 0x72ed, 0x77ef,
  0x80f8, 0x8105, 0x8208, 0x854e, 0x90f7, 0x93e1, 0x97ff, 0x9957,
  0x9a5a, 0x4ef0, 0x51dd, 0x5c2d, 0x6681, 0x696d, 0x5c40, 0x66f2,
  0x6975, 0x7389, 0x6850, 0x7c81, 0x50c5, 0x52e4, 0x5747, 0x5dfe,
  0x9326, 0x65a4, 0x6b23, 0x6b3d, 0x7434, 0x7981, 0x79bd, 0x7b4b,
  0x7dca, 0x82b9, 0x83cc, 0x887f, 0x895f, 0x8b39, 0x8fd1, 0x91d1,
  0x541f, 0x9280, 0x4e5d, 0x5036, 0x53e5, 0x533a, 0x72d7, 0x7396,
  0x77e9, 0x82e6, 0x8eaf, 0x99c6, 0x99c8, 0x99d2, 0x5177, 0x611a,
  0x865e, 0x55b0, 0x7a7a, 0x5076, 0x5bd3, 0x9047, 0x9685, 0x4e32,
  0x6adb, 0x91e7, 0x5c51, 0x5c48, 0x6398, 0x7a9f, 0x6c93, 0x9774,
  0x8f61, 0x7aaa, 0x718a, 0x9688, 0x7c82, 0x6817, 0x7e70, 0x6851,
  0x936c, 0x52f2, 0x541b, 0x85ab, 0x8a13, 0x7fa4, 0x8ecd, 0x90e1,
  0x5366, 0x8888, 0x7941, 0x4fc2, 0x50be, 0x5211, 0x5144, 0x5553,
  0x572d, 0x73ea, 0x578b, 0x5951, 0x5f62, 0x5f84, 0x6075, 0x6176,
  0x6167, 0x61a9, 0x63b2, 0x643a, 0x656c, 0x666f, 0x6842, 0x6e13,
  0x7566, 0x7a3d, 0x7cfb, 0x7d4c, 0x7d99, 0x7e4b, 0x7f6b, 0x830e,
  0x834a, 0x86cd, 0x8a08, 0x8a63, 0x8b66, 0x8efd, 0x981a, 0x9d8f,
  0x82b8, 0x8fce, 0x9be8, 0x5287, 0x621f, 0x6483, 0x6fc0, 0x9699,
  0x6841, 0x5091, 0x6b20, 0x6c7a, 0x6f54, 0x7a74, 0x7d50, 0x8840,
  0x8a23, 0x6708, 0x4ef6, 0x5039, 0x5026, 0x5065, 0x517c, 0x5238,
  0x5263, 0x55a7, 0x570f, 0x5805, 0x5acc, 0x5efa, 0x61b2, 0x61f8,
  0x62f3, 0x6372, 0x691c, 0x6a29, 0x727d, 0x72ac, 0x732e, 0x7814,
  0x786f, 0x7d79, 0x770c, 0x80a9, 0x898b, 0x8b19, 0x8ce2, 0x8ed2,
  0x9063, 0x9375, 0x967a, 0x9855, 0x9a13, 0x9e78, 0x5143, 0x539f,
  0x53b3, 0x5e7b, 0x5f26, 0x6e1b, 0x6e90, 0x7384, 0x73fe, 0x7d43,
  0x8237, 0x8a00, 0x8afa, 0x9650, 0x4e4e, 0x500b, 0x53e4, 0x547c,
  0x56fa, 0x59d1, 0x5b64, 0x5df1, 0x5eab, 0x5f27, 0x6238, 0x6545,
  0x67af, 0x6e56, 0x72d0, 0x7cca, 0x88b4, 0x80a1, 0x80e1, 0x83f0,
  0x864e, 0x8a87, 0x8de8, 0x9237, 0x96c7, 0x9867, 0x9f13, 0x4e94,
  0x4e92, 0x4f0d, 0x5348, 0x5449, 0x543e, 0x5a2f, 0x5f8c, 0x5fa1,
  0x609f, 0x68a7, 0x6a8e, 0x745a, 0x7881, 0x8a9e, 0x8aa4, 0x8b77,
  0x9190, 0x4e5e, 0x9bc9, 0x4ea4, 0x4f7c, 0x4faf, 0x5019, 0x5016,
  0x5149, 0x516c, 0x529f, 0x52b9, 0x52fe, 0x539a, 0x53e3, 0x5411,
  0x540e, 0x5589, 0x5751, 0x57a2, 0x597d, 0x5b54, 0x5b5d, 0x5b8f,
  0x5de5, 0x5de7, 0x5df7, 0x5e78, 0x5e83, 0x5e9a, 0x5eb7, 0x5f18,
  0x6052, 0x614c, 0x6297, 0x62d8, 0x63a7, 0x653b, 0x6602, 0x6643,
  0x66f4, 0x676d, 0x6821, 0x6897, 0x69cb, 0x6c5f, 0x6d2a, 0x6d69,
  0x6e2f, 0x6e9d, 0x7532, 0x7687, 0x786c, 0x7a3f, 0x7ce0, 0x7d05,
  0x7d18, 0x7d5e, 0x7db1, 0x8015, 0x8003, 0x80af, 0x80b1, 0x8154,
  0x818f, 0x822a, 0x8352, 0x884c, 0x8861, 0x8b1b, 0x8ca2, 0x8cfc,
  0x90ca, 0x9175, 0x9271, 0x783f, 0x92fc, 0x95a4, 0x964d, 0x9805,
  0x9999, 0x9ad8, 0x9d3b, 0x525b, 0x52ab, 0x53f7, 0x5408, 0x58d5,
  0x62f7, 0x6fe0, 0x8c6a, 0x8f5f, 0x9eb9, 0x514b, 0x523b, 0x544a,
  0x56fd, 0x7a40, 0x9177, 0x9d60, 0x9ed2, 0x7344, 0x6f09, 0x8170,
  0x7511, 0x5ffd, 0x60da, 0x9aa8, 0x72db, 0x8fbc, 0x6b64, 0x9803,
  0x4eca, 0x56f0, 0x5764, 0x58be, 0x5a5a, 0x6068, 0x61c7, 0x660f,
  0x6606, 0x6839, 0x68b1, 0x6df7, 0x75d5, 0x7d3a, 0x826e, 0x9b42,
  0x4e9b, 0x4f50, 0x53c9, 0x5506, 0x5d6f, 0x5de6, 0x5dee, 0x67fb,
  0x6c99, 0x7473, 0x7802, 0x8a50, 0x9396, 0x88df, 0x5750, 0x5ea7,
  0x632b, 0x50b5, 0x50ac, 0x518d, 0x6700, 0x54c9, 0x585e, 0x59bb,
  0x5bb0, 0x5f69, 0x624d, 0x63a1, 0x683d, 0x6b73, 0x6e08, 0x707d,
  0x91c7, 0x7280, 0x7815, 0x7826, 0x796d, 0x658e, 0x7d30, 0x83dc,
  0x88c1, 0x8f09, 0x969b, 0x5264, 0x5728, 0x6750, 0x7f6a, 0x8ca1,
  0x51b4, 0x5742, 0x962a, 0x583a, 0x698a, 0x80b4, 0x54b2, 0x5d0e,
  0x57fc, 0x7895, 0x9dfa, 0x4f5c, 0x524a, 0x548b, 0x643e, 0x6628,
  0x6714, 0x67f5, 0x7a84, 0x7b56, 0x7d22, 0x932f, 0x685c, 0x9bad,
  0x7b39, 0x5319, 0x518a, 0x5237, 0x5bdf, 0x62f6, 0x64ae, 0x64e6,
  0x672d, 0x6bba, 0x85a9, 0x96d1, 0x7690, 0x9bd6, 0x634c, 0x9306,
  0x9bab, 0x76bf, 0x6652, 0x4e09, 0x5098, 0x53c2, 0x5c71, 0x60e8,
  0x6492, 0x6563, 0x685f, 0x71e6, 0x73ca, 0x7523, 0x7b97, 0x7e82,
  0x8695, 0x8b83, 0x8cdb, 0x9178, 0x9910, 0x65ac, 0x66ab, 0x6b8b,
  0x4ed5, 0x4ed4, 0x4f3a, 0x4f7f, 0x523a, 0x53f8, 0x53f2, 0x55e3,
  0x56db, 0x58eb, 0x59cb, 0x59c9, 0x59ff, 0x5b50, 0x5c4d, 0x5e02,
  0x5e2b, 0x5fd7, 0x601d, 0x6307, 0x652f, 0x5b5c, 0x65af, 0x65bd,
  0x65e8, 0x679d, 0x6b62, 0x6b7b, 0x6c0f, 0x7345, 0x7949, 0x79c1,
  0x7cf8, 0x7d19, 0x7d2b, 0x80a2, 0x8102, 0x81f3, 0x8996, 0x8a5e,
  0x8a69, 0x8a66, 0x8a8c, 0x8aee, 0x8cc7, 0x8cdc, 0x96cc, 0x98fc,
  0x6b6f, 0x4e8b, 0x4f3c, 0x4f8d, 0x5150, 0x5b57, 0x5bfa, 0x6148,
  0x6301, 0x6642, 0x6b21, 0x6ecb, 0x6cbb, 0x723e, 0x74bd, 0x75d4,
  0x78c1, 0x793a, 0x800c, 0x8033, 0x81ea, 0x8494, 0x8f9e, 0x6c50,
  0x9e7f, 0x5f0f, 0x8b58, 0x9d2b, 0x7afa, 0x8ef8, 0x5b8d, 0x96eb,
  0x4e03, 0x53f1, 0x57f7, 0x5931, 0x5ac9, 0x5ba4, 0x6089, 0x6e7f,
  0x6f06, 0x75be, 0x8cea, 0x5b9f, 0x8500, 0x7be0, 0x5072, 0x67f4,
  0x829d, 0x5c61, 0x854a, 0x7e1e, 0x820e, 0x5199, 0x5c04, 0x6368,
  0x8d66, 0x659c, 0x716e, 0x793e, 0x7d17, 0x8005, 0x8b1d, 0x8eca,
  0x906e, 0x86c7, 0x90aa, 0x501f, 0x52fa, 0x5c3a, 0x6753, 0x707c,
  0x7235, 0x914c, 0x91c8, 0x932b, 0x82e5, 0x5bc2, 0x5f31, 0x60f9,
  0x4e3b, 0x53d6, 0x5b88, 0x624b, 0x6731, 0x6b8a, 0x72e9, 0x73e0,
  0x7a2e, 0x816b, 0x8da3, 0x9152, 0x9996, 0x5112, 0x53d7, 0x546a,
  0x5bff, 0x6388, 0x6a39, 0x7dac, 0x9700, 0x56da, 0x53ce, 0x5468,
  0x5b97, 0x5c31, 0x5dde, 0x4fee, 0x6101, 0x62fe, 0x6d32, 0x79c0,
  0x79cb, 0x7d42, 0x7e4d, 0x7fd2, 0x81ed, 0x821f, 0x8490, 0x8846,
  0x8972, 0x8b90, 0x8e74, 0x8f2f, 0x9031, 0x914b, 0x916c, 0x96c6,
  0x919c, 0x4ec0, 0x4f4f, 0x5145, 0x5341, 0x5f93, 0x620e, 0x67d4,
  0x6c41, 0x6e0b, 0x7363, 0x7e26, 0x91cd, 0x9283, 0x53d4, 0x5919,
  0x5bbf, 0x6dd1, 0x795d, 0x7e2e, 0x7c9b, 0x587e, 0x719f, 0x51fa,
  0x8853, 0x8ff0, 0x4fca, 0x5cfb, 0x6625, 0x77ac, 0x7ae3, 0x821c,
  0x99ff, 0x51c6, 0x5faa, 0x65ec, 0x696f, 0x6b89, 0x6df3, 0x6e96,
  0x6f64, 0x76fe, 0x7d14, 0x5de1, 0x9075, 0x9187, 0x9806, 0x51e6,
  0x521d, 0x6240, 0x6691, 0x66d9, 0x6e1a, 0x5eb6, 0x7dd2, 0x7f72,
  0x66f8, 0x85af, 0x85f7, 0x8af8, 0x52a9, 0x53d9, 0x5973, 0x5e8f,
  0x5f90, 0x6055, 0x92e4, 0x9664, 0x50b7, 0x511f, 0x52dd, 0x5320,
  0x5347, 0x53ec, 0x54e8, 0x5546, 0x5531, 0x5617, 0x5968, 0x59be,
  0x5a3c, 0x5bb5, 0x5c06, 0x5c0f, 0x5c11, 0x5c1a, 0x5e84, 0x5e8a,
  0x5ee0, 0x5f70, 0x627f, 0x6284, 0x62db, 0x638c, 0x6377, 0x6607,
  0x660c, 0x662d, 0x6676, 0x677e, 0x68a2, 0x6a1f, 0x6a35, 0x6cbc,
  0x6d88, 0x6e09, 0x6e58, 0x713c, 0x7126, 0x7167, 0x75c7, 0x7701,
  0x785d, 0x7901, 0x7965, 0x79f0, 0x7ae0, 0x7b11, 0x7ca7, 0x7d39,
  0x8096, 0x83d6, 0x848b, 0x8549, 0x885d, 0x88f3, 0x8a1f, 0x8a3c,
  0x8a54, 0x8a73, 0x8c61, 0x8cde, 0x91a4, 0x9266, 0x937e, 0x9418,
  0x969c, 0x9798, 0x4e0a, 0x4e08, 0x4e1e, 0x4e57, 0x5197, 0x5270,
  0x57ce, 0x5834, 0x58cc, 0x5b22, 0x5e38, 0x60c5, 0x64fe, 0x6761,
  0x6756, 0x6d44, 0x72b6, 0x7573, 0x7a63, 0x84b8, 0x8b72, 0x91b8,
  0x9320, 0x5631, 0x57f4, 0x98fe, 0x62ed, 0x690d, 0x6b96, 0x71ed,
  0x7e54, 0x8077, 0x8272, 0x89e6, 0x98df, 0x8755, 0x8fb1, 0x5c3b,
  0x4f38, 0x4fe1, 0x4fb5, 0x5507, 0x5a20, 0x5bdd, 0x5be9, 0x5fc3,
  0x614e, 0x632f, 0x65b0, 0x664b, 0x68ee, 0x699b, 0x6d78, 0x6df1,
  0x7533, 0x75b9, 0x771f, 0x795e, 0x79e6, 0x7d33, 0x81e3, 0x82af,
  0x85aa, 0x89aa, 0x8a3a, 0x8eab, 0x8f9b, 0x9032, 0x91dd, 0x9707,
  0x4eba, 0x4ec1, 0x5203, 0x5875, 0x58ec, 0x5c0b, 0x751a, 0x5c3d,
  0x814e, 0x8a0a, 0x8fc5, 0x9663, 0x976d, 0x7b25, 0x8acf, 0x9808,
  0x9162, 0x56f3, 0x53a8, 0x9017, 0x5439, 0x5782, 0x5e25, 0x63a8,
  0x6c34, 0x708a, 0x7761, 0x7c8b, 0x7fe0, 0x8870, 0x9042, 0x9154,
  0x9310, 0x9318, 0x968f, 0x745e, 0x9ac4, 0x5d07, 0x5d69, 0x6570,
  0x67a2, 0x8da8, 0x96db, 0x636e, 0x6749, 0x6919, 0x83c5, 0x9817,
  0x96c0, 0x88fe, 0x6f84, 0x647a, 0x5bf8, 0x4e16, 0x702c, 0x755d,
  0x662f, 0x51c4, 0x5236, 0x52e2, 0x59d3, 0x5f81, 0x6027, 0x6210,
  0x653f, 0x6574, 0x661f, 0x6674, 0x68f2, 0x6816, 0x6b63, 0x6e05,
  0x7272, 0x751f, 0x76db, 0x7cbe, 0x8056, 0x58f0, 0x88fd, 0x897f,
  0x8aa0, 0x8a93, 0x8acb, 0x901d, 0x9192, 0x9752, 0x9759, 0x6589,
  0x7a0e, 0x8106, 0x96bb, 0x5e2d, 0x60dc, 0x621a, 0x65a5, 0x6614,
  0x6790, 0x77f3, 0x7a4d, 0x7c4d, 0x7e3e, 0x810a, 0x8cac, 0x8d64,
  0x8de1, 0x8e5f, 0x78a9, 0x5207, 0x62d9, 0x63a5, 0x6442, 0x6298,
  0x8a2d, 0x7a83, 0x7bc0, 0x8aac, 0x96ea, 0x7d76, 0x820c, 0x8749,
  0x4ed9, 0x5148, 0x5343, 0x5360, 0x5ba3, 0x5c02, 0x5c16, 0x5ddd,
  0x6226, 0x6247, 0x64b0, 0x6813, 0x6834, 0x6cc9, 0x6d45, 0x6d17,
  0x67d3, 0x6f5c, 0x714e, 0x717d, 0x65cb, 0x7a7f, 0x7bad, 0x7dda,
  0x7e4a, 0x7fa8, 0x817a, 0x821b, 0x8239, 0x85a6, 0x8a6e, 0x8cce,
  0x8df5, 0x9078, 0x9077, 0x92ad, 0x9291, 0x9583, 0x9bae, 0x524d,
  0x5584, 0x6f38, 0x7136, 0x5168, 0x7985, 0x7e55, 0x81b3, 0x7cce,
  0x564c, 0x5851, 0x5ca8, 0x63aa, 0x66fe, 0x66fd, 0x695a, 0x72d9,
  0x758f, 0x758e, 0x790e, 0x7956, 0x79df, 0x7c97, 0x7d20, 0x7d44,
  0x8607, 0x8a34, 0x963b, 0x9061, 0x9f20, 0x50e7, 0x5275, 0x53cc,
  0x53e2, 0x5009, 0x55aa, 0x58ee, 0x594f, 0x723d, 0x5b8b, 0x5c64,
  0x531d, 0x60e3, 0x60f3, 0x635c, 0x6383, 0x633f, 0x63bb, 0x64cd,
  0x65e9, 0x66f9, 0x5de3, 0x69cd, 0x69fd, 0x6f15, 0x71e5, 0x4e89,
  0x75e9, 0x76f8, 0x7a93, 0x7cdf, 0x7dcf, 0x7d9c, 0x8061, 0x8349,
  0x8358, 0x846c, 0x84bc, 0x85fb, 0x88c5, 0x8d70, 0x9001, 0x906d,
  0x9397, 0x971c, 0x9a12, 0x50cf, 0x5897, 0x618e, 0x81d3, 0x8535,
  0x8d08, 0x9020, 0x4fc3, 0x5074, 0x5247, 0x5373, 0x606f, 0x6349,
  0x675f, 0x6e2c, 0x8db3, 0x901f, 0x4fd7, 0x5c5e, 0x8cca, 0x65cf,
  0x7d9a, 0x5352, 0x8896, 0x5176, 0x63c3, 0x5b58, 0x5b6b, 0x5c0a,
  0x640d, 0x6751, 0x905c, 0x4ed6, 0x591a, 0x592a, 0x6c70, 0x8a51,
  0x553e, 0x5815, 0x59a5, 0x60f0, 0x6253, 0x67c1, 0x8235, 0x6955,
  0x9640, 0x99c4, 0x9a28, 0x4f53, 0x5806, 0x5bfe, 0x8010, 0x5cb1,
  0x5e2f, 0x5f85, 0x6020, 0x614b, 0x6234, 0x66ff, 0x6cf0, 0x6ede,
  0x80ce, 0x817f, 0x82d4, 0x888b, 0x8cb8, 0x9000, 0x902e, 0x968a,
  0x9edb, 0x9bdb, 0x4ee3, 0x53f0, 0x5927, 0x7b2c, 0x918d, 0x984c,
  0x9df9, 0x6edd, 0x7027, 0x5353, 0x5544, 0x5b85, 0x6258, 0x629e,
  0x62d3, 0x6ca2, 0x6fef, 0x7422, 0x8a17, 0x9438, 0x6fc1, 0x8afe,
  0x8338, 0x51e7, 0x86f8, 0x53ea, 0x53e9, 0x4f46, 0x9054, 0x8fb0,
  0x596a, 0x8131, 0x5dfd, 0x7aea, 0x8fbf, 0x68da, 0x8c37, 0x72f8,
  0x9c48, 0x6a3d, 0x8ab0, 0x4e39, 0x5358, 0x5606, 0x5766, 0x62c5,
  0x63a2, 0x65e6, 0x6b4e, 0x6de1, 0x6e5b, 0x70ad, 0x77ed, 0x7aef,
  0x7baa, 0x7dbb, 0x803d, 0x80c6, 0x86cb, 0x8a95, 0x935b, 0x56e3,
  0x58c7, 0x5f3e, 0x65ad, 0x6696, 0x6a80, 0x6bb5, 0x7537, 0x8ac7,
  0x5024, 0x77e5, 0x5730, 0x5f1b, 0x6065, 0x667a, 0x6c60, 0x75f4,
  0x7a1a, 0x7f6e, 0x81f4, 0x8718, 0x9045, 0x99b3, 0x7bc9, 0x755c,
  0x7af9, 0x7b51, 0x84c4, 0x9010, 0x79e9, 0x7a92, 0x8336, 0x5ae1,
  0x7740, 0x4e2d, 0x4ef2, 0x5b99, 0x5fe0, 0x62bd, 0x663c, 0x67f1,
  0x6ce8, 0x866b, 0x8877, 0x8a3b, 0x914e, 0x92f3, 0x99d0, 0x6a17,
  0x7026, 0x732a, 0x82e7, 0x8457, 0x8caf, 0x4e01, 0x5146, 0x51cb,
  0x558b, 0x5bf5, 0x5e16, 0x5e33, 0x5e81, 0x5f14, 0x5f35, 0x5f6b,
  0x5fb4, 0x61f2, 0x6311, 0x66a2, 0x671d, 0x6f6e, 0x7252, 0x753a,
  0x773a, 0x8074, 0x8139, 0x8178, 0x8776, 0x8abf, 0x8adc, 0x8d85,
  0x8df3, 0x929a, 0x9577, 0x9802, 0x9ce5, 0x52c5, 0x6357, 0x76f4,
  0x6715, 0x6c88, 0x73cd, 0x8cc3, 0x93ae, 0x9673, 0x6d25, 0x589c,
  0x690e, 0x69cc, 0x8ffd, 0x939a, 0x75db, 0x901a, 0x585a, 0x6802,
  0x63b4, 0x69fb, 0x4f43, 0x6f2c, 0x67d8, 0x8fbb, 0x8526, 0x7db4,
  0x9354, 0x693f, 0x6f70, 0x576a, 0x58f7, 0x5b2c, 0x7d2c, 0x722a,
  0x540a, 0x91e3, 0x9db4, 0x4ead, 0x4f4e, 0x505c, 0x5075, 0x5243,
  0x8c9e, 0x5448, 0x5824, 0x5b9a, 0x5e1d, 0x5e95, 0x5ead, 0x5ef7,
  0x5f1f, 0x608c, 0x62b5, 0x633a, 0x63d0, 0x68af, 0x6c40, 0x7887,
  0x798e, 0x7a0b, 0x7de0, 0x8247, 0x8a02, 0x8ae6, 0x8e44, 0x9013,
  0x90b8, 0x912d, 0x91d8, 0x9f0e, 0x6ce5, 0x6458, 0x64e2, 0x6575,
  0x6ef4, 0x7684, 0x7b1b, 0x9069, 0x93d1, 0x6eba, 0x54f2, 0x5fb9,
  0x64a4, 0x8f4d, 0x8fed, 0x9244, 0x5178, 0x586b, 0x5929, 0x5c55,
  0x5e97, 0x6dfb, 0x7e8f, 0x751c, 0x8cbc, 0x8ee2, 0x985b, 0x70b9,
  0x4f1d, 0x6bbf, 0x6fb1, 0x7530, 0x96fb, 0x514e, 0x5410, 0x5835,
  0x5857, 0x59ac, 0x5c60, 0x5f92, 0x6597, 0x675c, 0x6e21, 0x767b,
  0x83df, 0x8ced, 0x9014, 0x90fd, 0x934d, 0x7825, 0x783a, 0x52aa,
  0x5ea6, 0x571f, 0x5974, 0x6012, 0x5012, 0x515a, 0x51ac, 0x51cd,
  0x5200, 0x5510, 0x5854, 0x5858, 0x5957, 0x5b95, 0x5cf6, 0x5d8b,
  0x60bc, 0x6295, 0x642d, 0x6771, 0x6843, 0x68bc, 0x68df, 0x76d7,
  0x6dd8, 0x6e6f, 0x6d9b, 0x706f, 0x71c8, 0x5f53, 0x75d8, 0x7977,
  0x7b49, 0x7b54, 0x7b52, 0x7cd6, 0x7d71, 0x5230, 0x8463, 0x8569,
  0x85e4, 0x8a0e, 0x8b04, 0x8c46, 0x8e0f, 0x9003, 0x900f, 0x9419,
  0x9676, 0x982d, 0x9a30, 0x95d8, 0x50cd, 0x52d5, 0x540c, 0x5802,
  0x5c0e, 0x61a7, 0x649e, 0x6d1e, 0x77b3, 0x7ae5, 0x80f4, 0x8404,
  0x9053, 0x9285, 0x5ce0, 0x9d07, 0x533f, 0x5f97, 0x5fb3, 0x6d9c,
  0x7279, 0x7763, 0x79bf, 0x7be4, 0x6bd2, 0x72ec, 0x8aad, 0x6803,
  0x6a61, 0x51f8, 0x7a81, 0x6934, 0x5c4a, 0x9cf6, 0x82eb, 0x5bc5,
  0x9149, 0x701e, 0x5678, 0x5c6f, 0x60c7, 0x6566, 0x6c8c, 0x8c5a,
  0x9041, 0x9813, 0x5451, 0x66c7, 0x920d, 0x5948, 0x90a3, 0x5185,
  0x4e4d, 0x51ea, 0x8599, 0x8b0e, 0x7058, 0x637a, 0x934b, 0x6962,
  0x99b4, 0x7e04, 0x7577, 0x5357, 0x6960, 0x8edf, 0x96e3, 0x6c5d,
  0x4e8c, 0x5c3c, 0x5f10, 0x8fe9, 0x5302, 0x8cd1, 0x8089, 0x8679,
  0x5eff, 0x65e5, 0x4e73, 0x5165, 0x5982, 0x5c3f, 0x97ee, 0x4efb,
  0x598a, 0x5fcd, 0x8a8d, 0x6fe1, 0x79b0, 0x7962, 0x5be7, 0x8471,
  0x732b, 0x71b1, 0x5e74, 0x5ff5, 0x637b, 0x649a, 0x71c3, 0x7c98,
  0x4e43, 0x5efc, 0x4e4b, 0x57dc, 0x56a2, 0x60a9, 0x6fc3, 0x7d0d,
  0x80fd, 0x8133, 0x81bf, 0x8fb2, 0x8997, 0x86a4, 0x5df4, 0x628a,
  0x64ad, 0x8987, 0x6777, 0x6ce2, 0x6d3e, 0x7436, 0x7834, 0x5a46,
  0x7f75, 0x82ad, 0x99ac, 0x4ff3, 0x5ec3, 0x62dd, 0x6392, 0x6557,
  0x676f, 0x76c3, 0x724c, 0x80cc, 0x80ba, 0x8f29, 0x914d, 0x500d,
  0x57f9, 0x5a92, 0x6885, 0x6973, 0x7164, 0x72fd, 0x8cb7, 0x58f2,
  0x8ce0, 0x966a, 0x9019, 0x877f, 0x79e4, 0x77e7, 0x8429, 0x4f2f,
  0x5265, 0x535a, 0x62cd, 0x67cf, 0x6cca, 0x767d, 0x7b94, 0x7c95,
  0x8236, 0x8584, 0x8feb, 0x66dd, 0x6f20, 0x7206, 0x7e1b, 0x83ab,
  0x99c1, 0x9ea6, 0x51fd, 0x7bb1, 0x7872, 0x7bb8, 0x8087, 0x7b48,
  0x6ae8, 0x5e61, 0x808c, 0x7551, 0x7560, 0x516b, 0x9262, 0x6e8c,
  0x767a, 0x9197, 0x9aea, 0x4f10, 0x7f70, 0x629c, 0x7b4f, 0x95a5,
  0x9ce9, 0x567a, 0x5859, 0x86e4, 0x96bc, 0x4f34, 0x5224, 0x534a,
  0x53cd, 0x53db, 0x5e06, 0x642c, 0x6591, 0x677f, 0x6c3e, 0x6c4e,
  0x7248, 0x72af, 0x73ed, 0x7554, 0x7e41, 0x822c, 0x85e9, 0x8ca9,
  0x7bc4, 0x91c6, 0x7169, 0x9812, 0x98ef, 0x633d, 0x6669, 0x756a,
  0x76e4, 0x78d0, 0x8543, 0x86ee, 0x532a, 0x5351, 0x5426, 0x5983,
  0x5e87, 0x5f7c, 0x60b2, 0x6249, 0x6279, 0x62ab, 0x6590, 0x6bd4,
  0x6ccc, 0x75b2, 0x76ae, 0x7891, 0x79d8, 0x7dcb, 0x7f77, 0x80a5,
  0x88ab, 0x8ab9, 0x8cbb, 0x907f, 0x975e, 0x98db, 0x6a0b, 0x7c38,
  0x5099, 0x5c3e, 0x5fae, 0x6787, 0x6bd8, 0x7435, 0x7709, 0x7f8e,
  0x9f3b, 0x67ca, 0x7a17, 0x5339, 0x758b, 0x9aed, 0x5f66, 0x819d,
  0x83f1, 0x8098, 0x5f3c, 0x5fc5, 0x7562, 0x7b46, 0x903c, 0x6867,
  0x59eb, 0x5a9b, 0x7d10, 0x767e, 0x8b2c, 0x4ff5, 0x5f6a, 0x6a19,
  0x6c37, 0x6f02, 0x74e2, 0x7968, 0x8868, 0x8a55, 0x8c79, 0x5edf,
  0x63cf, 0x75c5, 0x79d2, 0x82d7, 0x9328, 0x92f2, 0x849c, 0x86ed,
  0x9c2d, 0x54c1, 0x5f6c, 0x658c, 0x6d5c, 0x7015, 0x8ca7, 0x8cd3,
  0x983b, 0x654f, 0x74f6, 0x4e0d, 0x4ed8, 0x57e0, 0x592b, 0x5a66,
  0x5bcc, 0x51a8, 0x5e03, 0x5e9c, 0x6016, 0x6276, 0x6577, 0x65a7,
  0x666e, 0x6d6e, 0x7236, 0x7b26, 0x8150, 0x819a, 0x8299, 0x8b5c,
  0x8ca0, 0x8ce6, 0x8d74, 0x961c, 0x9644, 0x4fae, 0x64ab, 0x6b66,
  0x821e, 0x8461, 0x856a, 0x90e8, 0x5c01, 0x6953, 0x98a8, 0x847a,
  0x8557, 0x4f0f, 0x526f, 0x5fa9, 0x5e45, 0x670d, 0x798f, 0x8179,
  0x8907, 0x8986, 0x6df5, 0x5f17, 0x6255, 0x6cb8, 0x4ecf, 0x7269,
  0x9b92, 0x5206, 0x543b, 0x5674, 0x58b3, 0x61a4, 0x626e, 0x711a,
  0x596e, 0x7c89, 0x7cde, 0x7d1b, 0x96f0, 0x6587, 0x805e, 0x4e19,
  0x4f75, 0x5175, 0x5840, 0x5e63, 0x5e73, 0x5f0a, 0x67c4, 0x4e26,
  0x853d, 0x9589, 0x965b, 0x7c73, 0x9801, 0x50fb, 0x58c1, 0x7656,
  0x78a7, 0x5225, 0x77a5, 0x8511, 0x7b86, 0x504f, 0x5909, 0x7247,
  0x7bc7, 0x7de8, 0x8fba, 0x8fd4, 0x904d, 0x4fbf, 0x52c9, 0x5a29,
  0x5f01, 0x97ad, 0x4fdd, 0x8217, 0x92ea, 0x5703, 0x6355, 0x6b69,
  0x752b, 0x88dc, 0x8f14, 0x7a42, 0x52df, 0x5893, 0x6155, 0x620a,
  0x66ae, 0x6bcd, 0x7c3f, 0x83e9, 0x5023, 0x4ff8, 0x5305, 0x5446,
  0x5831, 0x5949, 0x5b9d, 0x5cf0, 0x5cef, 0x5d29, 0x5e96, 0x62b1,
  0x6367, 0x653e, 0x65b9, 0x670b, 0x6cd5, 0x6ce1, 0x70f9, 0x7832,
  0x7e2b, 0x80de, 0x82b3, 0x840c, 0x84ec, 0x8702, 0x8912, 0x8a2a,
  0x8c4a, 0x90a6, 0x92d2, 0x98fd, 0x9cf3, 0x9d6c, 0x4e4f, 0x4ea1,
  0x508d, 0x5256, 0x574a, 0x59a8, 0x5e3d, 0x5fd8, 0x5fd9, 0x623f,
  0x66b4, 0x671b, 0x67d0, 0x68d2, 0x5192, 0x7d21, 0x80aa, 0x81a8,
  0x8b00, 0x8c8c, 0x8cbf, 0x927e, 0x9632, 0x5420, 0x982c, 0x5317,
  0x50d5, 0x535c, 0x58a8, 0x64b2, 0x6734, 0x7267, 0x7766, 0x7a46,
  0x91e6, 0x52c3, 0x6ca1, 0x6b86, 0x5800, 0x5e4c, 0x5954, 0x672c,
  0x7ffb, 0x51e1, 0x76c6, 0x6469, 0x78e8, 0x9b54, 0x9ebb, 0x57cb,
  0x59b9, 0x6627, 0x679a, 0x6bce, 0x54e9, 0x69d9, 0x5e55, 0x819c,
  0x6795, 0x9baa, 0x67fe, 0x9c52, 0x685d, 0x4ea6, 0x4fe3, 0x53c8,
  0x62b9, 0x672b, 0x6cab, 0x8fc4, 0x4fad, 0x7e6d, 0x9ebf, 0x4e07,
  0x6162, 0x6e80, 0x6f2b, 0x8513, 0x5473, 0x672a, 0x9b45, 0x5df3,
  0x7b95, 0x5cac, 0x5bc6, 0x871c, 0x6e4a, 0x84d1, 0x7a14, 0x8108,
  0x5999, 0x7c8d, 0x6c11, 0x7720, 0x52d9, 0x5922, 0x7121, 0x725f,
  0x77db, 0x9727, 0x9d61, 0x690b, 0x5a7f, 0x5a18, 0x51a5, 0x540d,
  0x547d, 0x660e, 0x76df, 0x8ff7, 0x9298, 0x9cf4, 0x59ea, 0x725d,
  0x6ec5, 0x514d, 0x68c9, 0x7dbf, 0x7dec, 0x9762, 0x9eba, 0x6478,
  0x6a21, 0x8302, 0x5984, 0x5b5f, 0x6bdb, 0x731b, 0x76f2, 0x7db2,
  0x8017, 0x8499, 0x5132, 0x6728, 0x9ed9, 0x76ee, 0x6762, 0x52ff,
  0x9905, 0x5c24, 0x623b, 0x7c7e, 0x8cb0, 0x554f, 0x60b6, 0x7d0b,
  0x9580, 0x5301, 0x4e5f, 0x51b6, 0x591c, 0x723a, 0x8036, 0x91ce,
  0x5f25, 0x77e2, 0x5384, 0x5f79, 0x7d04, 0x85ac, 0x8a33, 0x8e8d,
  0x9756, 0x67f3, 0x85ae, 0x9453, 0x6109, 0x6108, 0x6cb9, 0x7652,
  0x8aed, 0x8f38, 0x552f, 0x4f51, 0x512a, 0x52c7, 0x53cb, 0x5ba5,
  0x5e7d, 0x60a0, 0x6182, 0x63d6, 0x6709, 0x67da, 0x6e67, 0x6d8c,
  0x7336, 0x7337, 0x7531, 0x7950, 0x88d5, 0x8a98, 0x904a, 0x9091,
  0x90f5, 0x96c4, 0x878d, 0x5915, 0x4e88, 0x4f59, 0x4e0e, 0x8a89,
  0x8f3f, 0x9810, 0x50ad, 0x5e7c, 0x5996, 0x5bb9, 0x5eb8, 0x63da,
  0x63fa, 0x64c1, 0x66dc, 0x694a, 0x69d8, 0x6d0b, 0x6eb6, 0x7194,
  0x7528, 0x7aaf, 0x7f8a, 0x8000, 0x8449, 0x84c9, 0x8981, 0x8b21,
  0x8e0a, 0x9065, 0x967d, 0x990a, 0x617e, 0x6291, 0x6b32, 0x6c83,
  0x6d74, 0x7fcc, 0x7ffc, 0x6dc0, 0x7f85, 0x87ba, 0x88f8, 0x6765,
  0x83b1, 0x983c, 0x96f7, 0x6d1b, 0x7d61, 0x843d, 0x916a, 0x4e71,
  0x5375, 0x5d50, 0x6b04, 0x6feb, 0x85cd, 0x862d, 0x89a7, 0x5229,
  0x540f, 0x5c65, 0x674e, 0x68a8, 0x7406, 0x7483, 0x75e2, 0x88cf,
  0x88e1, 0x91cc, 0x96e2, 0x9678, 0x5f8b, 0x7387, 0x7acb, 0x844e,
  0x63a0, 0x7565, 0x5289, 0x6d41, 0x6e9c, 0x7409, 0x7559, 0x786b,
  0x7c92, 0x9686, 0x7adc, 0x9f8d, 0x4fb6, 0x616e, 0x65c5, 0x865c,
  0x4e86, 0x4eae, 0x50da, 0x4e21, 0x51cc, 0x5bee, 0x6599, 0x6881,
  0x6dbc, 0x731f, 0x7642, 0x77ad, 0x7a1c, 0x7ce7, 0x826f, 0x8ad2,
  0x907c, 0x91cf, 0x9675, 0x9818, 0x529b, 0x7dd1, 0x502b, 0x5398,
  0x6797, 0x6dcb, 0x71d0, 0x7433, 0x81e8, 0x8f2a, 0x96a3, 0x9c57,
  0x9e9f, 0x7460, 0x5841, 0x6d99, 0x7d2f, 0x985e, 0x4ee4, 0x4f36,
  0x4f8b, 0x51b7, 0x52b1, 0x5dba, 0x601c, 0x73b2, 0x793c, 0x82d3,
  0x9234, 0x96b7, 0x96f6, 0x970a, 0x9e97, 0x9f62, 0x66a6, 0x6b74,
  0x5217, 0x52a3, 0x70c8, 0x88c2, 0x5ec9, 0x604b, 0x6190, 0x6f23,
  0x7149, 0x7c3e, 0x7df4, 0x806f, 0x84ee, 0x9023, 0x932c, 0x5442,
  0x9b6f, 0x6ad3, 0x7089, 0x8cc2, 0x8def, 0x9732, 0x52b4, 0x5a41,
  0x5eca, 0x5f04, 0x6717, 0x697c, 0x6994, 0x6d6a, 0x6f0f, 0x7262,
  0x72fc, 0x7bed, 0x8001, 0x807e, 0x874b, 0x90ce, 0x516d, 0x9e93,
  0x7984, 0x808b, 0x9332, 0x8ad6, 0x502d, 0x548c, 0x8a71, 0x6b6a,
  0x8cc4, 0x8107, 0x60d1, 0x67a0, 0x9df2, 0x4e99, 0x4e98, 0x9c10,
  0x8a6b, 0x85c1, 0x8568, 0x6900, 0x6e7e, 0x7897, 0x8155, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x5f0c, 0x4e10, 0x4e15, 0x4e2a, 0x4e31, 0x4e36,
  0x4e3c, 0x4e3f, 0x4e42, 0x4e56, 0x4e58, 0x4e82, 0x4e85, 0x8c6b,
  0x4e8a, 0x8212, 0x5f0d, 0x4e8e, 0x4e9e, 0x4e9f, 0x4ea0, 0x4ea2,
  0x4eb0, 0x4eb3, 0x4eb6, 0x4ece, 0x4ecd, 0x4ec4, 0x4ec6, 0x4ec2,
  0x4ed7, 0x4ede, 0x4eed, 0x4edf, 0x4ef7, 0x4f09, 0x4f5a, 0x4f30,
  0x4f5b, 0x4f5d, 0x4f57, 0x4f47, 0x4f76, 0x4f88, 0x4f8f, 0x4f98,
  0x4f7b, 0x4f69, 0x4f70, 0x4f91, 0x4f6f, 0x4f86, 0x4f96, 0x5118,
  0x4fd4, 0x4fdf, 0x4fce, 0x4fd8, 0x4fdb, 0x4fd1, 0x4fda, 0x4fd0,
  0x4fe4, 0x4fe5, 0x501a, 0x5028, 0x5014, 0x502a, 0x5025, 0x5005,
  0x4f1c, 0x4ff6, 0x5021, 0x5029, 0x502c, 0x4ffe, 0x4fef, 0x5011,
  0x5006, 0x5043, 0x5047, 0x6703, 0x5055, 0x5050, 0x5048, 0x505a,
  0x5056, 0x506c, 0x5078, 0x5080, 0x509a, 0x5085, 0x50b4, 0x50b2,
  0x50c9, 0x50ca, 0x50b3, 0x50c2, 0x50d6, 0x50de, 0x50e5, 0x50ed,
  0x50e3, 0x50ee, 0x50f9, 0x50f5, 0x5109, 0x5101, 0x5102, 0x5116,
  0x5115, 0x5114, 0x511a, 0x5121, 0x513a, 0x5137, 0x513c, 0x513b,
  0x513f, 0x5140, 0x5152, 0x514c, 0x5154, 0x5162, 0x7af8, 0x5169,
  0x516a, 0x516e, 0x5180, 0x5182, 0x56d8, 0x518c, 0x5189, 0x518f,
  0x5191, 0x5193, 0x5195, 0x5196, 0x51a4, 0x51a6, 0x51a2, 0x51a9,
  0x51aa, 0x51ab, 0x51b3, 0x51b1, 0x51b2, 0x51b0, 0x51b5, 0x51bd,
  0x51c5, 0x51c9, 0x51db, 0x51e0, 0x8655, 0x51e9, 0x51ed, 0x51f0,
  0x51f5, 0x51fe, 0x5204, 0x520b, 0x5214, 0x520e, 0x5227, 0x522a,
  0x522e, 0x5233, 0x5239, 0x524f, 0x5244, 0x524b, 0x524c, 0x525e,
  0x5254, 0x526a, 0x5274, 0x5269, 0x5273, 0x527f, 0x527d, 0x528d,
  0x5294, 0x5292, 0x5271, 0x5288, 0x5291, 0x8fa8, 0x8fa7, 0x52ac,
  0x52ad, 0x52bc, 0x52b5, 0x52c1, 0x52cd, 0x52d7, 0x52de, 0x52e3,
  0x52e6, 0x98ed, 0x52e0, 0x52f3, 0x52f5, 0x52f8, 0x52f9, 0x5306,
  0x5308, 0x7538, 0x530d, 0x5310, 0x530f, 0x5315, 0x531a, 0x5323,
  0x532f, 0x5331, 0x5333, 0x5338, 0x5340, 0x5346, 0x5345, 0x4e17,
  0x5349, 0x534d, 0x51d6, 0x535e, 0x5369, 0x536e, 0x5918, 0x537b,
  0x5377, 0x5382, 0x5396, 0x53a0, 0x53a6, 0x53a5, 0x53ae, 0x53b0,
  0x53b6, 0x53c3, 0x7c12, 0x96d9, 0x53df, 0x66fc, 0x71ee, 0x53ee,
  0x53e8, 0x53ed, 0x53fa, 0x5401, 0x543d, 0x5440, 0x542c, 0x542d,
  0x543c, 0x542e, 0x5436, 0x5429, 0x541d, 0x544e, 0x548f, 0x5475,
  0x548e, 0x545f, 0x5471, 0x5477, 0x5470, 0x5492, 0x547b, 0x5480,
  0x5476, 0x5484, 0x5490, 0x5486, 0x54c7, 0x54a2, 0x54b8, 0x54a5,
  0x54ac, 0x54c4, 0x54c8, 0x54a8, 0x54ab, 0x54c2, 0x54a4, 0x54be,
  0x54bc, 0x54d8, 0x54e5, 0x54e6, 0x550f, 0x5514, 0x54fd, 0x54ee,
  0x54ed, 0x54fa, 0x54e2, 0x5539, 0x5540, 0x5563, 0x554c, 0x552e,
  0x555c, 0x5545, 0x5556, 0x5557, 0x5538, 0x5533, 0x555d, 0x5599,
  0x5580, 0x54af, 0x558a, 0x559f, 0x557b, 0x557e, 0x5598, 0x559e,
  0x55ae, 0x557c, 0x5583, 0x55a9, 0x5587, 0x55a8, 0x55da, 0x55c5,
  0x55df, 0x55c4, 0x55dc, 0x55e4, 0x55d4, 0x5614, 0x55f7, 0x5616,
  0x55fe, 0x55fd, 0x561b, 0x55f9, 0x564e, 0x5650, 0x71df, 0x5634,
  0x5636, 0x5632, 0x5638, 0x566b, 0x5664, 0x562f, 0x566c, 0x566a,
  0x5686, 0x5680, 0x568a, 0x56a0, 0x5694, 0x568f, 0x56a5, 0x56ae,
  0x56b6, 0x56b4, 0x56c2, 0x56bc, 0x56c1, 0x56c3, 0x56c0, 0x56c8,
  0x56ce, 0x56d1, 0x56d3, 0x56d7, 0x56ee, 0x56f9, 0x5700, 0x56ff,
  0x5704, 0x5709, 0x5708, 0x570b, 0x570d, 0x5713, 0x5718, 0x5716,
  0x55c7, 0x571c, 0x5726, 0x5737, 0x5738, 0x574e, 0x573b, 0x5740,
  0x574f, 0x5769, 0x57c0, 0x5788, 0x5761, 0x577f, 0x5789, 0x5793,
  0x57a0, 0x57b3, 0x57a4, 0x57aa, 0x57b0, 0x57c3, 0x57c6, 0x57d4,
  0x57d2, 0x57d3, 0x580a, 0x57d6, 0x57e3, 0x580b, 0x5819, 0x581d,
  0x5872, 0x5821, 0x5862, 0x584b, 0x5870, 0x6bc0, 0x5852, 0x583d,
  0x5879, 0x5885, 0x58b9, 0x589f, 0x58ab, 0x58ba, 0x58de, 0x58bb,
  0x58b8, 0x58ae, 0x58c5, 0x58d3, 0x58d1, 0x58d7, 0x58d9, 0x58d8,
  0x58e5, 0x58dc, 0x58e4, 0x58df, 0x58ef, 0x58fa, 0x58f9, 0x58fb,
  0x58fc, 0x58fd, 0x5902, 0x590a, 0x5910, 0x591b, 0x68a6, 0x5925,
  0x592c, 0x592d, 0x5932, 0x5938, 0x593e, 0x7ad2, 0x5955, 0x5950,
  0x594e, 0x595a, 0x5958, 0x5962, 0x5960, 0x5967, 0x596c, 0x5969,
  0x5978, 0x5981, 0x599d, 0x4f5e, 0x4fab, 0x59a3, 0x59b2, 0x59c6,
  0x59e8, 0x59dc, 0x598d, 0x59d9, 0x59da, 0x5a25, 0x5a1f, 0x5a11,
  0x5a1c, 0x5a09, 0x5a1a, 0x5a40, 0x5a6c, 0x5a49, 0x5a35, 0x5a36,
  0x5a62, 0x5a6a, 0x5a9a, 0x5abc, 0x5abe, 0x5acb, 0x5ac2, 0x5abd,
  0x5ae3, 0x5ad7, 0x5ae6, 0x5ae9, 0x5ad6, 0x5afa, 0x5afb, 0x5b0c,
  0x5b0b, 0x5b16, 0x5b32, 0x5ad0, 0x5b2a, 0x5b36, 0x5b3e, 0x5b43,
  0x5b45, 0x5b40, 0x5b51, 0x5b55, 0x5b5a, 0x5b5b, 0x5b65, 0x5b69,
  0x5b70, 0x5b73, 0x5b75, 0x5b78, 0x6588, 0x5b7a, 0x5b80, 0x5b83,
  0x5ba6, 0x5bb8, 0x5bc3, 0x5bc7, 0x5bc9, 0x5bd4, 0x5bd0, 0x5be4,
  0x5be6, 0x5be2, 0x5bde, 0x5be5, 0x5beb, 0x5bf0, 0x5bf6, 0x5bf3,
  0x5c05, 0x5c07, 0x5c08, 0x5c0d, 0x5c13, 0x5c20, 0x5c22, 0x5c28,
  0x5c38, 0x5c39, 0x5c41, 0x5c46, 0x5c4e, 0x5c53, 0x5c50, 0x5c4f,
  0x5b71, 0x5c6c, 0x5c6e, 0x4e62, 0x5c76, 0x5c79, 0x5c8c, 0x5c91,
  0x5c94, 0x599b, 0x5cab, 0x5cbb, 0x5cb6, 0x5cbc, 0x5cb7, 0x5cc5,
  0x5cbe, 0x5cc7, 0x5cd9, 0x5ce9, 0x5cfd, 0x5cfa, 0x5ced, 0x5d8c,
  0x5cea, 0x5d0b, 0x5d15, 0x5d17, 0x5d5c, 0x5d1f, 0x5d1b, 0x5d11,
  0x5d14, 0x5d22, 0x5d1a, 0x5d19, 0x5d18, 0x5d4c, 0x5d52, 0x5d4e,
  0x5d4b, 0x5d6c, 0x5d73, 0x5d76, 0x5d87, 0x5d84, 0x5d82, 0x5da2,
  0x5d9d, 0x5dac, 0x5dae, 0x5dbd, 0x5d90, 0x5db7, 0x5dbc, 0x5dc9,
  0x5dcd, 0x5dd3, 0x5dd2, 0x5dd6, 0x5ddb, 0x5deb, 0x5df2, 0x5df5,
  0x5e0b, 0x5e1a, 0x5e19, 0x5e11, 0x5e1b, 0x5e36, 0x5e37, 0x5e44,
  0x5e43, 0x5e40, 0x5e4e, 0x5e57, 0x5e54, 0x5e5f, 0x5e62, 0x5e64,
  0x5e47, 0x5e75, 0x5e76, 0x5e7a, 0x9ebc, 0x5e7f, 0x5ea0, 0x5ec1,
  0x5ec2, 0x5ec8, 0x5ed0, 0x5ecf, 0x5ed6, 0x5ee3, 0x5edd, 0x5eda,
  0x5edb, 0x5ee2, 0x5ee1, 0x5ee8, 0x5ee9, 0x5eec, 0x5ef1, 0x5ef3,
  0x5ef0, 0x5ef4, 0x5ef8, 0x5efe, 0x5f03, 0x5f09, 0x5f5d, 0x5f5c,
  0x5f0b, 0x5f11, 0x5f16, 0x5f29, 0x5f2d, 0x5f38, 0x5f41, 0x5f48,
  0x5f4c, 0x5f4e, 0x5f2f, 0x5f51, 0x5f56, 0x5f57, 0x5f59, 0x5f61,
  0x5f6d, 0x5f73, 0x5f77, 0x5f83, 0x5f82, 0x5f7f, 0x5f8a, 0x5f88,
  0x5f91, 0x5f87, 0x5f9e, 0x5f99, 0x5f98, 0x5fa0, 0x5fa8, 0x5fad,
  0x5fbc, 0x5fd6, 0x5ffb, 0x5fe4, 0x5ff8, 0x5ff1, 0x5fdd, 0x60b3,
  0x5fff, 0x6021, 0x6060, 0x6019, 0x6010, 0x6029, 0x600e, 0x6031,
  0x601b, 0x6015, 0x602b, 0x6026, 0x600f, 0x603a, 0x605a, 0x6041,
  0x606a, 0x6077, 0x605f, 0x604a, 0x6046, 0x604d, 0x6063, 0x6043,
  0x6064, 0x6042, 0x606c, 0x606b, 0x6059, 0x6081, 0x608d, 0x60e7,
  0x6083, 0x609a, 0x6084, 0x609b, 0x6096, 0x6097, 0x6092, 0x60a7,
  0x608b, 0x60e1, 0x60b8, 0x60e0, 0x60d3, 0x60b4, 0x5ff0, 0x60bd,
  0x60c6, 0x60b5, 0x60d8, 0x614d, 0x6115, 0x6106, 0x60f6, 0x60f7,
  0x6100, 0x60f4, 0x60fa, 0x6103, 0x6121, 0x60fb, 0x60f1, 0x610d,
  0x610e, 0x6147, 0x613e, 0x6128, 0x6127, 0x614a, 0x613f, 0x613c,
  0x612c, 0x6134, 0x613d, 0x6142, 0x6144, 0x6173, 0x6177, 0x6158,
  0x6159, 0x615a, 0x616b, 0x6174, 0x616f, 0x6165, 0x6171, 0x615f,
  0x615d, 0x6153, 0x6175, 0x6199, 0x6196, 0x6187, 0x61ac, 0x6194,
  0x619a, 0x618a, 0x6191, 0x61ab, 0x61ae, 0x61cc, 0x61ca, 0x61c9,
  0x61f7, 0x61c8, 0x61c3, 0x61c6, 0x61ba, 0x61cb, 0x7f79, 0x61cd,
  0x61e6, 0x61e3, 0x61f6, 0x61fa, 0x61f4, 0x61ff, 0x61fd, 0x61fc,
  0x61fe, 0x6200, 0x6208, 0x6209, 0x620d, 0x620c, 0x6214, 0x621b,
  0x621e, 0x6221, 0x622a, 0x622e, 0x6230, 0x6232, 0x6233, 0x6241,
  0x624e, 0x625e, 0x6263, 0x625b, 0x6260, 0x6268, 0x627c, 0x6282,
  0x6289, 0x627e, 0x6292, 0x6293, 0x6296, 0x62d4, 0x6283, 0x6294,
  0x62d7, 0x62d1, 0x62bb, 0x62cf, 0x62ff, 0x62c6, 0x64d4, 0x62c8,
  0x62dc, 0x62cc, 0x62ca, 0x62c2, 0x62c7, 0x629b, 0x62c9, 0x630c,
  0x62ee, 0x62f1, 0x6327, 0x6302, 0x6308, 0x62ef, 0x62f5, 0x6350,
  0x633e, 0x634d, 0x641c, 0x634f, 0x6396, 0x638e, 0x6380, 0x63ab,
  0x6376, 0x63a3, 0x638f, 0x6389, 0x639f, 0x63b5, 0x636b, 0x6369,
  0x63be, 0x63e9, 0x63c0, 0x63c6, 0x63e3, 0x63c9, 0x63d2, 0x63f6,
  0x63c4, 0x6416, 0x6434, 0x6406, 0x6413, 0x6426, 0x6436, 0x651d,
  0x6417, 0x6428, 0x640f, 0x6467, 0x646f, 0x6476, 0x644e, 0x652a,
  0x6495, 0x6493, 0x64a5, 0x64a9, 0x6488, 0x64bc, 0x64da, 0x64d2,
  0x64c5, 0x64c7, 0x64bb, 0x64d8, 0x64c2, 0x64f1, 0x64e7, 0x8209,
  0x64e0, 0x64e1, 0x62ac, 0x64e3, 0x64ef, 0x652c, 0x64f6, 0x64f4,
  0x64f2, 0x64fa, 0x6500, 0x64fd, 0x6518, 0x651c, 0x6505, 0x6524,
  0x6523, 0x652b, 0x6534, 0x6535, 0x6537, 0x6536, 0x6538, 0x754b,
  0x6548, 0x6556, 0x6555, 0x654d, 0x6558, 0x655e, 0x655d, 0x6572,
  0x6578, 0x6582, 0x6583, 0x8b8a, 0x659b, 0x659f, 0x65ab, 0x65b7,
  0x65c3, 0x65c6, 0x65c1, 0x65c4, 0x65cc, 0x65d2, 0x65db, 0x65d9,
  0x65e0, 0x65e1, 0x65f1, 0x6772, 0x660a, 0x6603, 0x65fb, 0x6773,
  0x6635, 0x6636, 0x6634, 0x661c, 0x664f, 0x6644, 0x6649, 0x6641,
  0x665e, 0x665d, 0x6664, 0x6667, 0x6668, 0x665f, 0x6662, 0x6670,
  0x6683, 0x6688, 0x668e, 0x6689, 0x6684, 0x6698, 0x669d, 0x66c1,
  0x66b9, 0x66c9, 0x66be, 0x66bc, 0x66c4, 0x66b8, 0x66d6, 0x66da,
  0x66e0, 0x663f, 0x66e6, 0x66e9, 0x66f0, 0x66f5, 0x66f7, 0x670f,
  0x6716, 0x671e, 0x6726, 0x6727, 0x9738, 0x672e, 0x673f, 0x6736,
  0x6741, 0x6738, 0x6737, 0x6746, 0x675e, 0x6760, 0x6759, 0x6763,
  0x6764, 0x6789, 0x6770, 0x67a9, 0x677c, 0x676a, 0x678c, 0x678b,
  0x67a6, 0x67a1, 0x6785, 0x67b7, 0x67ef, 0x67b4, 0x67ec, 0x67b3,
  0x67e9, 0x67b8, 0x67e4, 0x67de, 0x67dd, 0x67e2, 0x67ee, 0x67b9,
  0x67ce, 0x67c6, 0x67e7, 0x6a9c, 0x681e, 0x6846, 0x6829, 0x6840,
  0x684d, 0x6832, 0x684e, 0x68b3, 0x682b, 0x6859, 0x6863, 0x6877,
  0x687f, 0x689f, 0x688f, 0x68ad, 0x6894, 0x689d, 0x689b, 0x6883,
  0x6aae, 0x68b9, 0x6874, 0x68b5, 0x68a0, 0x68ba, 0x690f, 0x688d,
  0x687e, 0x6901, 0x68ca, 0x6908, 0x68d8, 0x6922, 0x6926, 0x68e1,
  0x690c, 0x68cd, 0x68d4, 0x68e7, 0x68d5, 0x6936, 0x6912, 0x6904,
  0x68d7, 0x68e3, 0x6925, 0x68f9, 0x68e0, 0x68ef, 0x6928, 0x692a,
  0x691a, 0x6923, 0x6921, 0x68c6, 0x6979, 0x6977, 0x695c, 0x6978,
  0x696b, 0x6954, 0x697e, 0x696e, 0x6939, 0x6974, 0x693d, 0x6959,
  0x6930, 0x6961, 0x695e, 0x695d, 0x6981, 0x696a, 0x69b2, 0x69ae,
  0x69d0, 0x69bf, 0x69c1, 0x69d3, 0x69be, 0x69ce, 0x5be8, 0x69ca,
  0x69dd, 0x69bb, 0x69c3, 0x69a7, 0x6a2e, 0x6991, 0x69a0, 0x699c,
  0x6995, 0x69b4, 0x69de, 0x69e8, 0x6a02, 0x6a1b, 0x69ff, 0x6b0a,
  0x69f9, 0x69f2, 0x69e7, 0x6a05, 0x69b1, 0x6a1e, 0x69ed, 0x6a14,
  0x69eb, 0x6a0a, 0x6a12, 0x6ac1, 0x6a23, 0x6a13, 0x6a44, 0x6a0c,
  0x6a72, 0x6a36, 0x6a78, 0x6a47, 0x6a62, 0x6a59, 0x6a66, 0x6a48,
  0x6a38, 0x6a22, 0x6a90, 0x6a8d, 0x6aa0, 0x6a84, 0x6aa2, 0x6aa3,
  0x6a97, 0x8617, 0x6abb, 0x6ac3, 0x6ac2, 0x6ab8, 0x6ab3, 0x6aac,
  0x6ade, 0x6ad1, 0x6adf, 0x6aaa, 0x6ada, 0x6aea, 0x6afb, 0x6b05,
  0x8616, 0x6afa, 0x6b12, 0x6b16, 0x9b31, 0x6b1f, 0x6b38, 0x6b37,
  0x76dc, 0x6b39, 0x98ee, 0x6b47, 0x6b43, 0x6b49, 0x6b50, 0x6b59,
  0x6b54, 0x6b5b, 0x6b5f, 0x6b61, 0x6b78, 0x6b79, 0x6b7f, 0x6b80,
  0x6b84, 0x6b83, 0x6b8d, 0x6b98, 0x6b95, 0x6b9e, 0x6ba4, 0x6baa,
  0x6bab, 0x6baf, 0x6bb2, 0x6bb1, 0x6bb3, 0x6bb7, 0x6bbc, 0x6bc6,
  0x6bcb, 0x6bd3, 0x6bdf, 0x6bec, 0x6beb, 0x6bf3, 0x6bef, 0x9ebe,
  0x6c08, 0x6c13, 0x6c14, 0x6c1b, 0x6c24, 0x6c23, 0x6c5e, 0x6c55,
  0x6c62, 0x6c6a, 0x6c82, 0x6c8d, 0x6c9a, 0x6c81, 0x6c9b, 0x6c7e,
  0x6c68, 0x6c73, 0x6c92, 0x6c90, 0x6cc4, 0x6cf1, 0x6cd3, 0x6cbd,
  0x6cd7, 0x6cc5, 0x6cdd, 0x6cae, 0x6cb1, 0x6cbe, 0x6cba, 0x6cdb,
  0x6cef, 0x6cd9, 0x6cea, 0x6d1f, 0x884d, 0x6d36, 0x6d2b, 0x6d3d,
  0x6d38, 0x6d19, 0x6d35, 0x6d33, 0x6d12, 0x6d0c, 0x6d63, 0x6d93,
  0x6d64, 0x6d5a, 0x6d79, 0x6d59, 0x6d8e, 0x6d95, 0x6fe4, 0x6d85,
  0x6df9, 0x6e15, 0x6e0a, 0x6db5, 0x6dc7, 0x6de6, 0x6db8, 0x6dc6,
  0x6dec, 0x6dde, 0x6dcc, 0x6de8, 0x6dd2, 0x6dc5, 0x6dfa, 0x6dd9,
  0x6de4, 0x6dd5, 0x6dea, 0x6dee, 0x6e2d, 0x6e6e, 0x6e2e, 0x6e19,
  0x6e72, 0x6e5f, 0x6e3e, 0x6e23, 0x6e6b, 0x6e2b, 0x6e76, 0x6e4d,
  0x6e1f, 0x6e43, 0x6e3a, 0x6e4e, 0x6e24, 0x6eff, 0x6e1d, 0x6e38,
  0x6e82, 0x6eaa, 0x6e98, 0x6ec9, 0x6eb7, 0x6ed3, 0x6ebd, 0x6eaf,
  0x6ec4, 0x6eb2, 0x6ed4, 0x6ed5, 0x6e8f, 0x6ea5, 0x6ec2, 0x6e9f,
  0x6f41, 0x6f11, 0x704c, 0x6eec, 0x6ef8, 0x6efe, 0x6f3f, 0x6ef2,
  0x6f31, 0x6eef, 0x6f32, 0x6ecc, 0x6f3e, 0x6f13, 0x6ef7, 0x6f86,
  0x6f7a, 0x6f78, 0x6f81, 0x6f80, 0x6f6f, 0x6f5b, 0x6ff3, 0x6f6d,
  0x6f82, 0x6f7c, 0x6f58, 0x6f8e, 0x6f91, 0x6fc2, 0x6f66, 0x6fb3,
  0x6fa3, 0x6fa1, 0x6fa4, 0x6fb9, 0x6fc6, 0x6faa, 0x6fdf, 0x6fd5,
  0x6fec, 0x6fd4, 0x6fd8, 0x6ff1, 0x6fee, 0x6fdb, 0x7009, 0x700b,
  0x6ffa, 0x7011, 0x7001, 0x700f, 0x6ffe, 0x701b, 0x701a, 0x6f74,
  0x701d, 0x7018, 0x701f, 0x7030, 0x703e, 0x7032, 0x7051, 0x7063,
  0x7099, 0x7092, 0x70af, 0x70f1, 0x70ac, 0x70b8, 0x70b3, 0x70ae,
  0x70df, 0x70cb, 0x70dd, 0x70d9, 0x7109, 0x70fd, 0x711c, 0x7119,
  0x7165, 0x7155, 0x7188, 0x7166, 0x7162, 0x714c, 0x7156, 0x716c,
  0x718f, 0x71fb, 0x7184, 0x7195, 0x71a8, 0x71ac, 0x71d7, 0x71b9,
  0x71be, 0x71d2, 0x71c9, 0x71d4, 0x71ce, 0x71e0, 0x71ec, 0x71e7,
  0x71f5, 0x71fc, 0x71f9, 0x71ff, 0x720d, 0x7210, 0x721b, 0x7228,
  0x722d, 0x722c, 0x7230, 0x7232, 0x723b, 0x723c, 0x723f, 0x7240,
  0x7246, 0x724b, 0x7258, 0x7274, 0x727e, 0x7282, 0x7281, 0x7287,
  0x7292, 0x7296, 0x72a2, 0x72a7, 0x72b9, 0x72b2, 0x72c3, 0x72c6,
  0x72c4, 0x72ce, 0x72d2, 0x72e2, 0x72e0, 0x72e1, 0x72f9, 0x72f7,
  0x500f, 0x7317, 0x730a, 0x731c, 0x7316, 0x731d, 0x7334, 0x732f,
  0x7329, 0x7325, 0x733e, 0x734e, 0x734f, 0x9ed8, 0x7357, 0x736a,
  0x7368, 0x7370, 0x7378, 0x7375, 0x737b, 0x737a, 0x73c8, 0x73b3,
  0x73ce, 0x73bb, 0x73c0, 0x73e5, 0x73ee, 0x73de, 0x74a2, 0x7405,
  0x746f, 0x7425, 0x73f8, 0x7432, 0x743a, 0x7455, 0x743f, 0x745f,
  0x7459, 0x7441, 0x745c, 0x7469, 0x7470, 0x7463, 0x746a, 0x7476,
  0x747e, 0x748b, 0x749e, 0x74a7, 0x74ca, 0x74cf, 0x74d4, 0x73f1,
  0x74e0, 0x74e3, 0x74e7, 0x74e9, 0x74ee, 0x74f2, 0x74f0, 0x74f1,
  0x74f8, 0x74f7, 0x7504, 0x7503, 0x7505, 0x750c, 0x750e, 0x750d,
  0x7515, 0x7513, 0x751e, 0x7526, 0x752c, 0x753c, 0x7544, 0x754d,
  0x754a, 0x7549, 0x755b, 0x7546, 0x755a, 0x7569, 0x7564, 0x7567,
  0x756b, 0x756d, 0x7578, 0x7576, 0x7586, 0x7587, 0x7574, 0x758a,
  0x7589, 0x7582, 0x7594, 0x759a, 0x759d, 0x75a5, 0x75a3, 0x75c2,
  0x75b3, 0x75c3, 0x75b5, 0x75bd, 0x75b8, 0x75bc, 0x75b1, 0x75cd,
  0x75ca, 0x75d2, 0x75d9, 0x75e3, 0x75de, 0x75fe, 0x75ff, 0x75fc,
  0x7601, 0x75f0, 0x75fa, 0x75f2, 0x75f3, 0x760b, 0x760d, 0x7609,
  0x761f, 0x7627, 0x7620, 0x7621, 0x7622, 0x7624, 0x7634, 0x7630,
  0x763b, 0x7647, 0x7648, 0x7646, 0x765c, 0x7658, 0x7661, 0x7662,
  0x7668, 0x7669, 0x766a, 0x7667, 0x766c, 0x7670, 0x7672, 0x7676,
  0x7678, 0x767c, 0x7680, 0x7683, 0x7688, 0x768b, 0x768e, 0x7696,
  0x7693, 0x7699, 0x769a, 0x76b0, 0x76b4, 0x76b8, 0x76b9, 0x76ba,
  0x76c2, 0x76cd, 0x76d6, 0x76d2, 0x76de, 0x76e1, 0x76e5, 0x76e7,
  0x76ea, 0x862f, 0x76fb, 0x7708, 0x7707, 0x7704, 0x7729, 0x7724,
  0x771e, 0x7725, 0x7726, 0x771b, 0x7737, 0x7738, 0x7747, 0x775a,
  0x7768, 0x776b, 0x775b, 0x7765, 0x777f, 0x777e, 0x7779, 0x778e,
  0x778b, 0x7791, 0x77a0, 0x779e, 0x77b0, 0x77b6, 0x77b9, 0x77bf,
  0x77bc, 0x77bd, 0x77bb, 0x77c7, 0x77cd, 0x77d7, 0x77da, 0x77dc,
  0x77e3, 0x77ee, 0x77fc, 0x780c, 0x7812, 0x7926, 0x7820, 0x792a,
  0x7845, 0x788e, 0x7874, 0x7886, 0x787c, 0x789a, 0x788c, 0x78a3,
  0x78b5, 0x78aa, 0x78af, 0x78d1, 0x78c6, 0x78cb, 0x78d4, 0x78be,
  0x78bc, 0x78c5, 0x78ca, 0x78ec, 0x78e7, 0x78da, 0x78fd, 0x78f4,
  0x7907, 0x7912, 0x7911, 0x7919, 0x792c, 0x792b, 0x7940, 0x7960,
  0x7957, 0x795f, 0x795a, 0x7955, 0x7953, 0x797a, 0x797f, 0x798a,
  0x799d, 0x79a7, 0x9f4b, 0x79aa, 0x79ae, 0x79b3, 0x79b9, 0x79ba,
  0x79c9, 0x79d5, 0x79e7, 0x79ec, 0x79e1, 0x79e3, 0x7a08, 0x7a0d,
  0x7a18, 0x7a19, 0x7a20, 0x7a1f, 0x7980, 0x7a31, 0x7a3b, 0x7a3e,
  0x7a37, 0x7a43, 0x7a57, 0x7a49, 0x7a61, 0x7a62, 0x7a69, 0x9f9d,
  0x7a70, 0x7a79, 0x7a7d, 0x7a88, 0x7a97, 0x7a95, 0x7a98, 0x7a96,
  0x7aa9, 0x7ac8, 0x7ab0, 0x7ab6, 0x7ac5, 0x7ac4, 0x7abf, 0x9083,
  0x7ac7, 0x7aca, 0x7acd, 0x7acf, 0x7ad5, 0x7ad3, 0x7ad9, 0x7ada,
  0x7add, 0x7ae1, 0x7ae2, 0x7ae6, 0x7aed, 0x7af0, 0x7b02, 0x7b0f,
  0x7b0a, 0x7b06, 0x7b33, 0x7b18, 0x7b19, 0x7b1e, 0x7b35, 0x7b28,
  0x7b36, 0x7b50, 0x7b7a, 0x7b04, 0x7b4d, 0x7b0b, 0x7b4c, 0x7b45,
  0x7b75, 0x7b65, 0x7b74, 0x7b67, 0x7b70, 0x7b71, 0x7b6c, 0x7b6e,
  0x7b9d, 0x7b98, 0x7b9f, 0x7b8d, 0x7b9c, 0x7b9a, 0x7b8b, 0x7b92,
  0x7b8f, 0x7b5d, 0x7b99, 0x7bcb, 0x7bc1, 0x7bcc, 0x7bcf, 0x7bb4,
  0x7bc6, 0x7bdd, 0x7be9, 0x7c11, 0x7c14, 0x7be6, 0x7be5, 0x7c60,
  0x7c00, 0x7c07, 0x7c13, 0x7bf3, 0x7bf7, 0x7c17, 0x7c0d, 0x7bf6,
  0x7c23, 0x7c27, 0x7c2a, 0x7c1f, 0x7c37, 0x7c2b, 0x7c3d, 0x7c4c,
  0x7c43, 0x7c54, 0x7c4f, 0x7c40, 0x7c50, 0x7c58, 0x7c5f, 0x7c64,
  0x7c56, 0x7c65, 0x7c6c, 0x7c75, 0x7c83, 0x7c90, 0x7ca4, 0x7cad,
  0x7ca2, 0x7cab, 0x7ca1, 0x7ca8, 0x7cb3, 0x7cb2, 0x7cb1, 0x7cae,
  0x7cb9, 0x7cbd, 0x7cc0, 0x7cc5, 0x7cc2, 0x7cd8, 0x7cd2, 0x7cdc,
  0x7ce2, 0x9b3b, 0x7cef, 0x7cf2, 0x7cf4, 0x7cf6, 0x7cfa, 0x7d06,
  0x7d02, 0x7d1c, 0x7d15, 0x7d0a, 0x7d45, 0x7d4b, 0x7d2e, 0x7d32,
  0x7d3f, 0x7d35, 0x7d46, 0x7d73, 0x7d56, 0x7d4e, 0x7d72, 0x7d68,
  0x7d6e, 0x7d4f, 0x7d63, 0x7d93, 0x7d89, 0x7d5b, 0x7d8f, 0x7d7d,
  0x7d9b, 0x7dba, 0x7dae, 0x7da3, 0x7db5, 0x7dc7, 0x7dbd, 0x7dab,
  0x7e3d, 0x7da2, 0x7daf, 0x7ddc, 0x7db8, 0x7d9f, 0x7db0, 0x7dd8,
  0x7ddd, 0x7de4, 0x7dde, 0x7dfb, 0x7df2, 0x7de1, 0x7e05, 0x7e0a,
  0x7e23, 0x7e21, 0x7e12, 0x7e31, 0x7e1f, 0x7e09, 0x7e0b, 0x7e22,
  0x7e46, 0x7e66, 0x7e3b, 0x7e35, 0x7e39, 0x7e43, 0x7e37, 0x7e32,
  0x7e3a, 0x7e67, 0x7e5d, 0x7e56, 0x7e5e, 0x7e59, 0x7e5a, 0x7e79,
  0x7e6a, 0x7e69, 0x7e7c, 0x7e7b, 0x7e83, 0x7dd5, 0x7e7d, 0x8fae,
  0x7e7f, 0x7e88, 0x7e89, 0x7e8c, 0x7e92, 0x7e90, 0x7e93, 0x7e94,
  0x7e96, 0x7e8e, 0x7e9b, 0x7e9c, 0x7f38, 0x7f3a, 0x7f45, 0x7f4c,
  0x7f4d, 0x7f4e, 0x7f50, 0x7f51, 0x7f55, 0x7f54, 0x7f58, 0x7f5f,
  0x7f60, 0x7f68, 0x7f69, 0x7f67, 0x7f78, 0x7f82, 0x7f86, 0x7f83,
  0x7f88, 0x7f87, 0x7f8c, 0x7f94, 0x7f9e, 0x7f9d, 0x7f9a, 0x7fa3,
  0x7faf, 0x7fb2, 0x7fb9, 0x7fae, 0x7fb6, 0x7fb8, 0x8b71, 0x7fc5,
  0x7fc6, 0x7fca, 0x7fd5, 0x7fd4, 0x7fe1, 0x7fe6, 0x7fe9, 0x7ff3,
  0x7ff9, 0x98dc, 0x8006, 0x8004, 0x800b, 0x8012, 0x8018, 0x8019,
  0x801c, 0x8021, 0x8028, 0x803f, 0x803b, 0x804a, 0x8046, 0x8052,
  0x8058, 0x805a, 0x805f, 0x8062, 0x8068, 0x8073, 0x8072, 0x8070,
  0x8076, 0x8079, 0x807d, 0x807f, 0x8084, 0x8086, 0x8085, 0x809b,
  0x8093, 0x809a, 0x80ad, 0x5190, 0x80ac, 0x80db, 0x80e5, 0x80d9,
  0x80dd, 0x80c4, 0x80da, 0x80d6, 0x8109, 0x80ef, 0x80f1, 0x811b,
  0x8129, 0x8123, 0x812f, 0x814b, 0x968b, 0x8146, 0x813e, 0x8153,
  0x8151, 0x80fc, 0x8171, 0x816e, 0x8165, 0x8166, 0x8174, 0x8183,
  0x8188, 0x818a, 0x8180, 0x8182, 0x81a0, 0x8195, 0x81a4, 0x81a3,
  0x815f, 0x8193, 0x81a9, 0x81b0, 0x81b5, 0x81be, 0x81b8, 0x81bd,
  0x81c0, 0x81c2, 0x81ba, 0x81c9, 0x81cd, 0x81d1, 0x81d9, 0x81d8,
  0x81c8, 0x81da, 0x81df, 0x81e0, 0x81e7, 0x81fa, 0x81fb, 0x81fe,
  0x8201, 0x8202, 0x8205, 0x8207, 0x820a, 0x820d, 0x8210, 0x8216,
  0x8229, 0x822b, 0x8238, 0x8233, 0x8240, 0x8259, 0x8258, 0x825d,
  0x825a, 0x825f, 0x8264, 0x8262, 0x8268, 0x826a, 0x826b, 0x822e,
  0x8271, 0x8277, 0x8278, 0x827e, 0x828d, 0x8292, 0x82ab, 0x829f,
  0x82bb, 0x82ac, 0x82e1, 0x82e3, 0x82df, 0x82d2, 0x82f4, 0x82f3,
  0x82fa, 0x8393, 0x8303, 0x82fb, 0x82f9, 0x82de, 0x8306, 0x82dc,
  0x8309, 0x82d9, 0x8335, 0x8334, 0x8316, 0x8332, 0x8331, 0x8340,
  0x8339, 0x8350, 0x8345, 0x832f, 0x832b, 0x8317, 0x8318, 0x8385,
  0x839a, 0x83aa, 0x839f, 0x83a2, 0x8396, 0x8323, 0x838e, 0x8387,
  0x838a, 0x837c, 0x83b5, 0x8373, 0x8375, 0x83a0, 0x8389, 0x83a8,
  0x83f4, 0x8413, 0x83eb, 0x83ce, 0x83fd, 0x8403, 0x83d8, 0x840b,
  0x83c1, 0x83f7, 0x8407, 0x83e0, 0x83f2, 0x840d, 0x8422, 0x8420,
  0x83bd, 0x8438, 0x8506, 0x83fb, 0x846d, 0x842a, 0x843c, 0x855a,
  0x8484, 0x8477, 0x846b, 0x84ad, 0x846e, 0x8482, 0x8469, 0x8446,
  0x842c, 0x846f, 0x8479, 0x8435, 0x84ca, 0x8462, 0x84b9, 0x84bf,
  0x849f, 0x84d9, 0x84cd, 0x84bb, 0x84da, 0x84d0, 0x84c1, 0x84c6,
  0x84d6, 0x84a1, 0x8521, 0x84ff, 0x84f4, 0x8517, 0x8518, 0x852c,
  0x851f, 0x8515, 0x8514, 0x84fc, 0x8540, 0x8563, 0x8558, 0x8548,
  0x8541, 0x8602, 0x854b, 0x8555, 0x8580, 0x85a4, 0x8588, 0x8591,
  0x858a, 0x85a8, 0x856d, 0x8594, 0x859b, 0x85ea, 0x8587, 0x859c,
  0x8577, 0x857e, 0x8590, 0x85c9, 0x85ba, 0x85cf, 0x85b9, 0x85d0,
  0x85d5, 0x85dd, 0x85e5, 0x85dc, 0x85f9, 0x860a, 0x8613, 0x860b,
  0x85fe, 0x85fa, 0x8606, 0x8622, 0x861a, 0x8630, 0x863f, 0x864d,
  0x4e55, 0x8654, 0x865f, 0x8667, 0x8671, 0x8693, 0x86a3, 0x86a9,
  0x86aa, 0x868b, 0x868c, 0x86b6, 0x86af, 0x86c4, 0x86c6, 0x86b0,
  0x86c9, 0x8823, 0x86ab, 0x86d4, 0x86de, 0x86e9, 0x86ec, 0x86df,
  0x86db, 0x86ef, 0x8712, 0x8706, 0x8708, 0x8700, 0x8703, 0x86fb,
  0x8711, 0x8709, 0x870d, 0x86f9, 0x870a, 0x8734, 0x873f, 0x8737,
  0x873b, 0x8725, 0x8729, 0x871a, 0x8760, 0x875f, 0x8778, 0x874c,
  0x874e, 0x8774, 0x8757, 0x8768, 0x876e, 0x8759, 0x8753, 0x8763,
  0x876a, 0x8805, 0x87a2, 0x879f, 0x8782, 0x87af, 0x87cb, 0x87bd,
  0x87c0, 0x87d0, 0x96d6, 0x87ab, 0x87c4, 0x87b3, 0x87c7, 0x87c6,
  0x87bb, 0x87ef, 0x87f2, 0x87e0, 0x880f, 0x880d, 0x87fe, 0x87f6,
  0x87f7, 0x880e, 0x87d2, 0x8811, 0x8816, 0x8815, 0x8822, 0x8821,
  0x8831, 0x8836, 0x8839, 0x8827, 0x883b, 0x8844, 0x8842, 0x8852,
  0x8859, 0x885e, 0x8862, 0x886b, 0x8881, 0x887e, 0x889e, 0x8875,
  0x887d, 0x88b5, 0x8872, 0x8882, 0x8897, 0x8892, 0x88ae, 0x8899,
  0x88a2, 0x888d, 0x88a4, 0x88b0, 0x88bf, 0x88b1, 0x88c3, 0x88c4,
  0x88d4, 0x88d8, 0x88d9, 0x88dd, 0x88f9, 0x8902, 0x88fc, 0x88f4,
  0x88e8, 0x88f2, 0x8904, 0x890c, 0x890a, 0x8913, 0x8943, 0x891e,
  0x8925, 0x892a, 0x892b, 0x8941, 0x8944, 0x893b, 0x8936, 0x8938,
  0x894c, 0x891d, 0x8960, 0x895e, 0x8966, 0x8964, 0x896d, 0x896a,
  0x896f, 0x8974, 0x8977, 0x897e, 0x8983, 0x8988, 0x898a, 0x8993,
  0x8998, 0x89a1, 0x89a9, 0x89a6, 0x89ac, 0x89af, 0x89b2, 0x89ba,
  0x89bd, 0x89bf, 0x89c0, 0x89da, 0x89dc, 0x89dd, 0x89e7, 0x89f4,
  0x89f8, 0x8a03, 0x8a16, 0x8a10, 0x8a0c, 0x8a1b, 0x8a1d, 0x8a25,
  0x8a36, 0x8a41, 0x8a5b, 0x8a52, 0x8a46, 0x8a48, 0x8a7c, 0x8a6d,
  0x8a6c, 0x8a62, 0x8a85, 0x8a82, 0x8a84, 0x8aa8, 0x8aa1, 0x8a91,
  0x8aa5, 0x8aa6, 0x8a9a, 0x8aa3, 0x8ac4, 0x8acd, 0x8ac2, 0x8ada,
  0x8aeb, 0x8af3, 0x8ae7, 0x8ae4, 0x8af1, 0x8b14, 0x8ae0, 0x8ae2,
  0x8af7, 0x8ade, 0x8adb, 0x8b0c, 0x8b07, 0x8b1a, 0x8ae1, 0x8b16,
  0x8b10, 0x8b17, 0x8b20, 0x8b33, 0x97ab, 0x8b26, 0x8b2b, 0x8b3e,
  0x8b28, 0x8b41, 0x8b4c, 0x8b4f, 0x8b4e, 0x8b49, 0x8b56, 0x8b5b,
  0x8b5a, 0x8b6b, 0x8b5f, 0x8b6c, 0x8b6f, 0x8b74, 0x8b7d, 0x8b80,
  0x8b8c, 0x8b8e, 0x8b92, 0x8b93, 0x8b96, 0x8b99, 0x8b9a, 0x8c3a,
  0x8c41, 0x8c3f, 0x8c48, 0x8c4c, 0x8c4e, 0x8c50, 0x8c55, 0x8c62,
  0x8c6c, 0x8c78, 0x8c7a, 0x8c82, 0x8c89, 0x8c85, 0x8c8a, 0x8c8d,
  0x8c8e, 0x8c94, 0x8c7c, 0x8c98, 0x621d, 0x8cad, 0x8caa, 0x8cbd,
  0x8cb2, 0x8cb3, 0x8cae, 0x8cb6, 0x8cc8, 0x8cc1, 0x8ce4, 0x8ce3,
  0x8cda, 0x8cfd, 0x8cfa, 0x8cfb, 0x8d04, 0x8d05, 0x8d0a, 0x8d07,
  0x8d0f, 0x8d0d, 0x8d10, 0x9f4e, 0x8d13, 0x8ccd, 0x8d14, 0x8d16,
  0x8d67, 0x8d6d, 0x8d71, 0x8d73, 0x8d81, 0x8d99, 0x8dc2, 0x8dbe,
  0x8dba, 0x8dcf, 0x8dda, 0x8dd6, 0x8dcc, 0x8ddb, 0x8dcb, 0x8dea,
  0x8deb, 0x8ddf, 0x8de3, 0x8dfc, 0x8e08, 0x8e09, 0x8dff, 0x8e1d,
  0x8e1e, 0x8e10, 0x8e1f, 0x8e42, 0x8e35, 0x8e30, 0x8e34, 0x8e4a,
  0x8e47, 0x8e49, 0x8e4c, 0x8e50, 0x8e48, 0x8e59, 0x8e64, 0x8e60,
  0x8e2a, 0x8e63, 0x8e55, 0x8e76, 0x8e72, 0x8e7c, 0x8e81, 0x8e87,
  0x8e85, 0x8e84, 0x8e8b, 0x8e8a, 0x8e93, 0x8e91, 0x8e94, 0x8e99,
  0x8eaa, 0x8ea1, 0x8eac, 0x8eb0, 0x8ec6, 0x8eb1, 0x8ebe, 0x8ec5,
  0x8ec8, 0x8ecb, 0x8edb, 0x8ee3, 0x8efc, 0x8efb, 0x8eeb, 0x8efe,
  0x8f0a, 0x8f05, 0x8f15, 0x8f12, 0x8f19, 0x8f13, 0x8f1c, 0x8f1f,
  0x8f1b, 0x8f0c, 0x8f26, 0x8f33, 0x8f3b, 0x8f39, 0x8f45, 0x8f42,
  0x8f3e, 0x8f4c, 0x8f49, 0x8f46, 0x8f4e, 0x8f57, 0x8f5c, 0x8f62,
  0x8f63, 0x8f64, 0x8f9c, 0x8f9f, 0x8fa3, 0x8fad, 0x8faf, 0x8fb7,
  0x8fda, 0x8fe5, 0x8fe2, 0x8fea, 0x8fef, 0x9087, 0x8ff4, 0x9005,
  0x8ff9, 0x8ffa, 0x9011, 0x9015, 0x9021, 0x900d, 0x901e, 0x9016,
  0x900b, 0x9027, 0x9036, 0x9035, 0x9039, 0x8ff8, 0x904f, 0x9050,
  0x9051, 0x9052, 0x900e, 0x9049, 0x903e, 0x9056, 0x9058, 0x905e,
  0x9068, 0x906f, 0x9076, 0x96a8, 0x9072, 0x9082, 0x907d, 0x9081,
  0x9080, 0x908a, 0x9089, 0x908f, 0x90a8, 0x90af, 0x90b1, 0x90b5,
  0x90e2, 0x90e4, 0x6248, 0x90db, 0x9102, 0x9112, 0x9119, 0x9132,
  0x9130, 0x914a, 0x9156, 0x9158, 0x9163, 0x9165, 0x9169, 0x9173,
  0x9172, 0x918b, 0x9189, 0x9182, 0x91a2, 0x91ab, 0x91af, 0x91aa,
  0x91b5, 0x91b4, 0x91ba, 0x91c0, 0x91c1, 0x91c9, 0x91cb, 0x91d0,
  0x91d6, 0x91df, 0x91e1, 0x91db, 0x91fc, 0x91f5, 0x91f6, 0x921e,
  0x91ff, 0x9214, 0x922c, 0x9215, 0x9211, 0x925e, 0x9257, 0x9245,
  0x9249, 0x9264, 0x9248, 0x9295, 0x923f, 0x924b, 0x9250, 0x929c,
  0x9296, 0x9293, 0x929b, 0x925a, 0x92cf, 0x92b9, 0x92b7, 0x92e9,
  0x930f, 0x92fa, 0x9344, 0x932e, 0x9319, 0x9322, 0x931a, 0x9323,
  0x933a, 0x9335, 0x933b, 0x935c, 0x9360, 0x937c, 0x936e, 0x9356,
  0x93b0, 0x93ac, 0x93ad, 0x9394, 0x93b9, 0x93d6, 0x93d7, 0x93e8,
  0x93e5, 0x93d8, 0x93c3, 0x93dd, 0x93d0, 0x93c8, 0x93e4, 0x941a,
  0x9414, 0x9413, 0x9403, 0x9407, 0x9410, 0x9436, 0x942b, 0x9435,
  0x9421, 0x943a, 0x9441, 0x9452, 0x9444, 0x945b, 0x9460, 0x9462,
  0x945e, 0x946a, 0x9229, 0x9470, 0x9475, 0x9477, 0x947d, 0x945a,
  0x947c, 0x947e, 0x9481, 0x947f, 0x9582, 0x9587, 0x958a, 0x9594,
  0x9596, 0x9598, 0x9599, 0x95a0, 0x95a8, 0x95a7, 0x95ad, 0x95bc,
  0x95bb, 0x95b9, 0x95be, 0x95ca, 0x6ff6, 0x95c3, 0x95cd, 0x95cc,
  0x95d5, 0x95d4, 0x95d6, 0x95dc, 0x95e1, 0x95e5, 0x95e2, 0x9621,
  0x9628, 0x962e, 0x962f, 0x9642, 0x964c, 0x964f, 0x964b, 0x9677,
  0x965c, 0x965e, 0x965d, 0x965f, 0x9666, 0x9672, 0x966c, 0x968d,
  0x9698, 0x9695, 0x9697, 0x96aa, 0x96a7, 0x96b1, 0x96b2, 0x96b0,
  0x96b4, 0x96b6, 0x96b8, 0x96b9, 0x96ce, 0x96cb, 0x96c9, 0x96cd,
  0x894d, 0x96dc, 0x970d, 0x96d5, 0x96f9, 0x9704, 0x9706, 0x9708,
  0x9713, 0x970e, 0x9711, 0x970f, 0x9716, 0x9719, 0x9724, 0x972a,
  0x9730, 0x9739, 0x973d, 0x973e, 0x9744, 0x9746, 0x9748, 0x9742,
  0x9749, 0x975c, 0x9760, 0x9764, 0x9766, 0x9768, 0x52d2, 0x976b,
  0x9771, 0x9779, 0x9785, 0x977c, 0x9781, 0x977a, 0x9786, 0x978b,
  0x978f, 0x9790, 0x979c, 0x97a8, 0x97a6, 0x97a3, 0x97b3, 0x97b4,
  0x97c3, 0x97c6, 0x97c8, 0x97cb, 0x97dc, 0x97ed, 0x9f4f, 0x97f2,
  0x7adf, 0x97f6, 0x97f5, 0x980f, 0x980c, 0x9838, 0x9824, 0x9821,
  0x9837, 0x983d, 0x9846, 0x984f, 0x984b, 0x986b, 0x986f, 0x9870,
  0x9871, 0x9874, 0x9873, 0x98aa, 0x98af, 0x98b1, 0x98b6, 0x98c4,
  0x98c3, 0x98c6, 0x98e9, 0x98eb, 0x9903, 0x9909, 0x9912, 0x9914,
  0x9918, 0x9921, 0x991d, 0x991e, 0x9924, 0x9920, 0x992c, 0x992e,
  0x993d, 0x993e, 0x9942, 0x9949, 0x9945, 0x9950, 0x994b, 0x9951,
  0x9952, 0x994c, 0x9955, 0x9997, 0x9998, 0x99a5, 0x99ad, 0x99ae,
  0x99bc, 0x99df, 0x99db, 0x99dd, 0x99d8, 0x99d1, 0x99ed, 0x99ee,
  0x99f1, 0x99f2, 0x99fb, 0x99f8, 0x9a01, 0x9a0f, 0x9a05, 0x99e2,
  0x9a19, 0x9a2b, 0x9a37, 0x9a45, 0x9a42, 0x9a40, 0x9a43, 0x9a3e,
  0x9a55, 0x9a4d, 0x9a5b, 0x9a57, 0x9a5f, 0x9a62, 0x9a65, 0x9a64,
  0x9a69, 0x9a6b, 0x9a6a, 0x9aad, 0x9ab0, 0x9abc, 0x9ac0, 0x9acf,
  0x9ad1, 0x9ad3, 0x9ad4, 0x9ade, 0x9adf, 0x9ae2, 0x9ae3, 0x9ae6,
  0x9aef, 0x9aeb, 0x9aee, 0x9af4, 0x9af1, 0x9af7, 0x9afb, 0x9b06,
  0x9b18, 0x9b1a, 0x9b1f, 0x9b22, 0x9b23, 0x9b25, 0x9b27, 0x9b28,
  0x9b29, 0x9b2a, 0x9b2e, 0x9b2f, 0x9b32, 0x9b44, 0x9b43, 0x9b4f,
  0x9b4d, 0x9b4e, 0x9b51, 0x9b58, 0x9b74, 0x9b93, 0x9b83, 0x9b91,
  0x9b96, 0x9b97, 0x9b9f, 0x9ba0, 0x9ba8, 0x9bb4, 0x9bc0, 0x9bca,
  0x9bb9, 0x9bc6, 0x9bcf, 0x9bd1, 0x9bd2, 0x9be3, 0x9be2, 0x9be4,
  0x9bd4, 0x9be1, 0x9c3a, 0x9bf2, 0x9bf1, 0x9bf0, 0x9c15, 0x9c14,
  0x9c09, 0x9c13, 0x9c0c, 0x9c06, 0x9c08, 0x9c12, 0x9c0a, 0x9c04,
  0x9c2e, 0x9c1b, 0x9c25, 0x9c24, 0x9c21, 0x9c30, 0x9c47, 0x9c32,
  0x9c46, 0x9c3e, 0x9c5a, 0x9c60, 0x9c67, 0x9c76, 0x9c78, 0x9ce7,
  0x9cec, 0x9cf0, 0x9d09, 0x9d08, 0x9ceb, 0x9d03, 0x9d06, 0x9d2a,
  0x9d26, 0x9daf, 0x9d23, 0x9d1f, 0x9d44, 0x9d15, 0x9d12, 0x9d41,
  0x9d3f, 0x9d3e, 0x9d46, 0x9d48, 0x9d5d, 0x9d5e, 0x9d64, 0x9d51,
  0x9d50, 0x9d59, 0x9d72, 0x9d89, 0x9d87, 0x9dab, 0x9d6f, 0x9d7a,
  0x9d9a, 0x9da4, 0x9da9, 0x9db2, 0x9dc4, 0x9dc1, 0x9dbb, 0x9db8,
  0x9dba, 0x9dc6, 0x9dcf, 0x9dc2, 0x9dd9, 0x9dd3, 0x9df8, 0x9de6,
  0x9ded, 0x9def, 0x9dfd, 0x9e1a, 0x9e1b, 0x9e1e, 0x9e75, 0x9e79,
  0x9e7d, 0x9e81, 0x9e88, 0x9e8b, 0x9e8c, 0x9e92, 0x9e95, 0x9e91,
  0x9e9d, 0x9ea5, 0x9ea9, 0x9eb8, 0x9eaa, 0x9ead, 0x9761, 0x9ecc,
  0x9ece, 0x9ecf, 0x9ed0, 0x9ed4, 0x9edc, 0x9ede, 0x9edd, 0x9ee0,
  0x9ee5, 0x9ee8, 0x9eef, 0x9ef4, 0x9ef6, 0x9ef7, 0x9ef9, 0x9efb,
  0x9efc, 0x9efd, 0x9f07, 0x9f08, 0x76b7, 0x9f15, 0x9f21, 0x9f2c,
  0x9f3e, 0x9f4a, 0x9f52, 0x9f54, 0x9f63, 0x9f5f, 0x9f60, 0x9f61,
  0x9f66, 0x9f67, 0x9f6c, 0x9f6a, 0x9f77, 0x9f72, 0x9f76, 0x9f95,
  0x9f9c, 0x9fa0, 0x582f, 0x69c7, 0x9059, 0x7464, 0x51dc, 0x7199,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, };
UNICHAR map_KS_C_5601_1987[] = {
  0x3000, 0x3001, 0x3002, 0x30fb, 0x2025, 0x2026, 0x00a8, 0x3003,
  0x2013, 0x2014, 0x2016, 0xff3c, 0xff5e, 0x2018, 0x2019, 0x201c,
  0x201d, 0x3014, 0x3015, 0x3008, 0x3009, 0x300a, 0x300b, 0x300c,
  0x300d, 0x300e, 0x300f, 0x3010, 0x3011, 0x00b1, 0x00d7, 0x00f7,
  0x2260, 0x2264, 0x2265, 0x221e, 0x2234, 0x00b0, 0x2032, 0x2033,
  0x2103, 0x212b, 0xffe0, 0xffe1, 0xffe5, 0x2642, 0x2640, 0x2220,
  0x22a5, 0x2312, 0x2202, 0x2207, 0x2261, 0x2252, 0x00a7, 0x203b,
  0x2606, 0x2605, 0x25cb, 0x25cf, 0x25ce, 0x25c7, 0x25c6, 0x25a1,
  0x25a0, 0x25b3, 0x25b2, 0x25bd, 0x25bc, 0x2192, 0x2190, 0x2191,
  0x2193, 0x2194, 0x3013, 0x00ab, 0x00bb, 0x221a, 0x223d, 0x221d,
  0x2235, 0x222b, 0x222c, 0x2208, 0x220b, 0x2286, 0x2287, 0x2282,
  0x2283, 0x222a, 0x2229, 0x2227, 0x2228, 0xffe2, 0x21d2, 0x21d4,
  0x2200, 0x2203, 0x00b4, 0x02dc, 0x02c7, 0x02d8, 0x02dd, 0x02da,
  0x02d9, 0x00b8, 0x02db, 0x00a1, 0x00bf, 0x2236, 0x222e, 0x2211,
  0x220f, 0x00a4, 0x2109, 0x2030, 0x25c1, 0x25c0, 0x25b7, 0x25b6,
  0x2664, 0x2660, 0x2661, 0x2665, 0x2667, 0x2663, 0x25c9, 0x25c8,
  0x25a3, 0x25d0, 0x25d1, 0x2592, 0x25a4, 0x25a5, 0x25a8, 0x25a7,
  0x25a6, 0x25a9, 0x2668, 0x260f, 0x260e, 0x261c, 0x261e, 0x00b6,
  0x2020, 0x2021, 0x2195, 0x2197, 0x2199, 0x2196, 0x2198, 0x266d,
  0x2669, 0x266a, 0x266c, 0x327f, 0x321c, 0x2116, 0x33c7, 0x2122,
  0x33c2, 0x33d8, 0x2121, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xff01, 0xff02, 0xff03, 0xff04,
  0xff05, 0xff06, 0xff07, 0xff08, 0xff09, 0xff0a, 0xff0b, 0xff0c,
  0xff0d, 0xff0e, 0xff0f, 0xff10, 0xff11, 0xff12, 0xff13, 0xff14,
  0xff15, 0xff16, 0xff17, 0xff18, 0xff19, 0xff1a, 0xff1b, 0xff1c,
  0xff1d, 0xff1e, 0xff1f, 0xff20, 0xff21, 0xff22, 0xff23, 0xff24,
  0xff25, 0xff26, 0xff27, 0xff28, 0xff29, 0xff2a, 0xff2b, 0xff2c,
  0xff2d, 0xff2e, 0xff2f, 0xff30, 0xff31, 0xff32, 0xff33, 0xff34,
  0xff35, 0xff36, 0xff37, 0xff38, 0xff39, 0xff3a, 0xff3b, 0xffe6,
  0xff3d, 0xff3e, 0xff3f, 0xff40, 0xff41, 0xff42, 0xff43, 0xff44,
  0xff45, 0xff46, 0xff47, 0xff48, 0xff49, 0xff4a, 0xff4b, 0xff4c,
  0xff4d, 0xff4e, 0xff4f, 0xff50, 0xff51, 0xff52, 0xff53, 0xff54,
  0xff55, 0xff56, 0xff57, 0xff58, 0xff59, 0xff5a, 0xff5b, 0xff5c,
  0xff5d, 0xffe3, 0x3131, 0x3132, 0x3133, 0x3134, 0x3135, 0x3136,
  0x3137, 0x3138, 0x3139, 0x313a, 0x313b, 0x313c, 0x313d, 0x313e,
  0x313f, 0x3140, 0x3141, 0x3142, 0x3143, 0x3144, 0x3145, 0x3146,
  0x3147, 0x3148, 0x3149, 0x314a, 0x314b, 0x314c, 0x314d, 0x314e,
  0x314f, 0x3150, 0x3151, 0x3152, 0x3153, 0x3154, 0x3155, 0x3156,
  0x3157, 0x3158, 0x3159, 0x315a, 0x315b, 0x315c, 0x315d, 0x315e,
  0x315f, 0x3160, 0x3161, 0x3162, 0x3163, 0x3164, 0x3165, 0x3166,
  0x3167, 0x3168, 0x3169, 0x316a, 0x316b, 0x316c, 0x316d, 0x316e,
  0x316f, 0x3170, 0x3171, 0x3172, 0x3173, 0x3174, 0x3175, 0x3176,
  0x3177, 0x3178, 0x3179, 0x317a, 0x317b, 0x317c, 0x317d, 0x317e,
  0x317f, 0x3180, 0x3181, 0x3182, 0x3183, 0x3184, 0x3185, 0x3186,
  0x3187, 0x3188, 0x3189, 0x318a, 0x318b, 0x318c, 0x318d, 0x318e,
  0x2170, 0x2171, 0x2172, 0x2173, 0x2174, 0x2175, 0x2176, 0x2177,
  0x2178, 0x2179, 0x217a, 0x217b, 0xfffd, 0xfffd, 0xfffd, 0x2160,
  0x2161, 0x2162, 0x2163, 0x2164, 0x2165, 0x2166, 0x2167, 0x2168,
  0x2169, 0x216a, 0x216b, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 0x0398,
  0x0399, 0x039a, 0x039b, 0x039c, 0x039d, 0x039e, 0x039f, 0x03a0,
  0x03a1, 0x03a3, 0x03a4, 0x03a5, 0x03a6, 0x03a7, 0x03a8, 0x03a9,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0x03b1, 0x03b2, 0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7, 0x03b8,
  0x03b9, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf, 0x03c0,
  0x03c1, 0x03c3, 0x03c4, 0x03c5, 0x03c6, 0x03c7, 0x03c8, 0x03c9,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x2500, 0x2502,
  0x250c, 0x2510, 0x2518, 0x2514, 0x251c, 0x252c, 0x2524, 0x2534,
  0x253c, 0x2501, 0x2503, 0x250f, 0x2513, 0x251b, 0x2517, 0x2523,
  0x2533, 0x252b, 0x253b, 0x254b, 0x2520, 0x252f, 0x2528, 0x2537,
  0x253f, 0x251d, 0x2530, 0x2525, 0x2538, 0x2542, 0x2512, 0x2511,
  0x251a, 0x2519, 0x2516, 0x2515, 0x250e, 0x250d, 0x251e, 0x251f,
  0x2521, 0x2522, 0x2526, 0x2527, 0x2529, 0x252a, 0x252d, 0x252e,
  0x2531, 0x2532, 0x2535, 0x2536, 0x2539, 0x253a, 0x253d, 0x253e,
  0x2540, 0x2541, 0x2543, 0x2544, 0x2545, 0x2546, 0x2547, 0x2548,
  0x2549, 0x254a, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x3395, 0x3396, 0x3397, 0x2113,
  0x3398, 0x33c4, 0x33a3, 0x33a4, 0x33a5, 0x33a6, 0x3399, 0x339a,
  0x339b, 0x339c, 0x339d, 0x339e, 0x339f, 0x33a0, 0x33a1, 0x33a2,
  0x33ca, 0x338d, 0x338e, 0x338f, 0x33cf, 0x3388, 0x3389, 0x33c8,
  0x33a7, 0x33a8, 0x33b0, 0x33b1, 0x33b2, 0x33b3, 0x33b4, 0x33b5,
  0x33b6, 0x33b7, 0x33b8, 0x33b9, 0x3380, 0x3381, 0x3382, 0x3383,
  0x3384, 0x33ba, 0x33bb, 0x33bc, 0x33bd, 0x33be, 0x33bf, 0x3390,
  0x3391, 0x3392, 0x3393, 0x3394, 0x2126, 0x33c0, 0x33c1, 0x338a,
  0x338b, 0x338c, 0x33d6, 0x33c5, 0x33ad, 0x33ae, 0x33af, 0x33db,
  0x33a9, 0x33aa, 0x33ab, 0x33ac, 0x33dd, 0x33d0, 0x33d3, 0x33c3,
  0x33c9, 0x33dc, 0x33c6, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x00c6, 0x00d0, 0x00aa, 0x0126, 0xfffd, 0x0132,
  0xfffd, 0x013f, 0x0141, 0x00d8, 0x0152, 0x00ba, 0x00de, 0x0166,
  0x014a, 0xfffd, 0x3260, 0x3261, 0x3262, 0x3263, 0x3264, 0x3265,
  0x3266, 0x3267, 0x3268, 0x3269, 0x326a, 0x326b, 0x326c, 0x326d,
  0x326e, 0x326f, 0x3270, 0x3271, 0x3272, 0x3273, 0x3274, 0x3275,
  0x3276, 0x3277, 0x3278, 0x3279, 0x327a, 0x327b, 0x24d0, 0x24d1,
  0x24d2, 0x24d3, 0x24d4, 0x24d5, 0x24d6, 0x24d7, 0x24d8, 0x24d9,
  0x24da, 0x24db, 0x24dc, 0x24dd, 0x24de, 0x24df, 0x24e0, 0x24e1,
  0x24e2, 0x24e3, 0x24e4, 0x24e5, 0x24e6, 0x24e7, 0x24e8, 0x24e9,
  0x2460, 0x2461, 0x2462, 0x2463, 0x2464, 0x2465, 0x2466, 0x2467,
  0x2468, 0x2469, 0x246a, 0x246b, 0x246c, 0x246d, 0x246e, 0x00bd,
  0x2153, 0x2154, 0x00bc, 0x00be, 0x215b, 0x215c, 0x215d, 0x215e,
  0x00e6, 0x0111, 0x00f0, 0x0127, 0x0131, 0x0133, 0x0138, 0x0140,
  0x0142, 0x00f8, 0x0153, 0x00df, 0x00fe, 0x0167, 0x014b, 0x0149,
  0x3200, 0x3201, 0x3202, 0x3203, 0x3204, 0x3205, 0x3206, 0x3207,
  0x3208, 0x3209, 0x320a, 0x320b, 0x320c, 0x320d, 0x320e, 0x320f,
  0x3210, 0x3211, 0x3212, 0x3213, 0x3214, 0x3215, 0x3216, 0x3217,
  0x3218, 0x3219, 0x321a, 0x321b, 0x249c, 0x249d, 0x249e, 0x249f,
  0x24a0, 0x24a1, 0x24a2, 0x24a3, 0x24a4, 0x24a5, 0x24a6, 0x24a7,
  0x24a8, 0x24a9, 0x24aa, 0x24ab, 0x24ac, 0x24ad, 0x24ae, 0x24af,
  0x24b0, 0x24b1, 0x24b2, 0x24b3, 0x24b4, 0x24b5, 0x2474, 0x2475,
  0x2476, 0x2477, 0x2478, 0x2479, 0x247a, 0x247b, 0x247c, 0x247d,
  0x247e, 0x247f, 0x2480, 0x2481, 0x2482, 0x00b9, 0x00b2, 0x00b3,
  0x2074, 0x207f, 0x2081, 0x2082, 0x2083, 0x2084, 0x3041, 0x3042,
  0x3043, 0x3044, 0x3045, 0x3046, 0x3047, 0x3048, 0x3049, 0x304a,
  0x304b, 0x304c, 0x304d, 0x304e, 0x304f, 0x3050, 0x3051, 0x3052,
  0x3053, 0x3054, 0x3055, 0x3056, 0x3057, 0x3058, 0x3059, 0x305a,
  0x305b, 0x305c, 0x305d, 0x305e, 0x305f, 0x3060, 0x3061, 0x3062,
  0x3063, 0x3064, 0x3065, 0x3066, 0x3067, 0x3068, 0x3069, 0x306a,
  0x306b, 0x306c, 0x306d, 0x306e, 0x306f, 0x3070, 0x3071, 0x3072,
  0x3073, 0x3074, 0x3075, 0x3076, 0x3077, 0x3078, 0x3079, 0x307a,
  0x307b, 0x307c, 0x307d, 0x307e, 0x307f, 0x3080, 0x3081, 0x3082,
  0x3083, 0x3084, 0x3085, 0x3086, 0x3087, 0x3088, 0x3089, 0x308a,
  0x308b, 0x308c, 0x308d, 0x308e, 0x308f, 0x3090, 0x3091, 0x3092,
  0x3093, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x30a1, 0x30a2, 0x30a3, 0x30a4,
  0x30a5, 0x30a6, 0x30a7, 0x30a8, 0x30a9, 0x30aa, 0x30ab, 0x30ac,
  0x30ad, 0x30ae, 0x30af, 0x30b0, 0x30b1, 0x30b2, 0x30b3, 0x30b4,
  0x30b5, 0x30b6, 0x30b7, 0x30b8, 0x30b9, 0x30ba, 0x30bb, 0x30bc,
  0x30bd, 0x30be, 0x30bf, 0x30c0, 0x30c1, 0x30c2, 0x30c3, 0x30c4,
  0x30c5, 0x30c6, 0x30c7, 0x30c8, 0x30c9, 0x30ca, 0x30cb, 0x30cc,
  0x30cd, 0x30ce, 0x30cf, 0x30d0, 0x30d1, 0x30d2, 0x30d3, 0x30d4,
  0x30d5, 0x30d6, 0x30d7, 0x30d8, 0x30d9, 0x30da, 0x30db, 0x30dc,
  0x30dd, 0x30de, 0x30df, 0x30e0, 0x30e1, 0x30e2, 0x30e3, 0x30e4,
  0x30e5, 0x30e6, 0x30e7, 0x30e8, 0x30e9, 0x30ea, 0x30eb, 0x30ec,
  0x30ed, 0x30ee, 0x30ef, 0x30f0, 0x30f1, 0x30f2, 0x30f3, 0x30f4,
  0x30f5, 0x30f6, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415,
  0x0401, 0x0416, 0x0417, 0x0418, 0x0419, 0x041a, 0x041b, 0x041c,
  0x041d, 0x041e, 0x041f, 0x0420, 0x0421, 0x0422, 0x0423, 0x0424,
  0x0425, 0x0426, 0x0427, 0x0428, 0x0429, 0x042a, 0x042b, 0x042c,
  0x042d, 0x042e, 0x042f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435,
  0x0451, 0x0436, 0x0437, 0x0438, 0x0439, 0x043a, 0x043b, 0x043c,
  0x043d, 0x043e, 0x043f, 0x0440, 0x0441, 0x0442, 0x0443, 0x0444,
  0x0445, 0x0446, 0x0447, 0x0448, 0x0449, 0x044a, 0x044b, 0x044c,
  0x044d, 0x044e, 0x044f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x3400, 0x3401, 0x3402, 0x3403, 0x3404, 0x3405,
  0x3406, 0x3407, 0x3408, 0x3409, 0x340a, 0x340b, 0x340c, 0x340d,
  0x340e, 0x340f, 0x3410, 0x3411, 0x3412, 0x3413, 0x3414, 0x3415,
  0x3416, 0x3417, 0x3418, 0x3419, 0x341a, 0x341b, 0x341c, 0x341d,
  0x341e, 0x341f, 0x3420, 0x3421, 0x3422, 0x3423, 0x3424, 0x3425,
  0x3426, 0x3427, 0x3428, 0x3429, 0x342a, 0x342b, 0x342c, 0x342d,
  0x342e, 0x342f, 0x3430, 0x3431, 0x3432, 0x3433, 0x3434, 0x3435,
  0x3436, 0x3437, 0x3438, 0x3439, 0x343a, 0x343b, 0x343c, 0x343d,
  0x343e, 0x343f, 0x3440, 0x3441, 0x3442, 0x3443, 0x3444, 0x3445,
  0x3446, 0x3447, 0x3448, 0x3449, 0x344a, 0x344b, 0x344c, 0x344d,
  0x344e, 0x344f, 0x3450, 0x3451, 0x3452, 0x3453, 0x3454, 0x3455,
  0x3456, 0x3457, 0x3458, 0x3459, 0x345a, 0x345b, 0x345c, 0x345d,
  0x345e, 0x345f, 0x3460, 0x3461, 0x3462, 0x3463, 0x3464, 0x3465,
  0x3466, 0x3467, 0x3468, 0x3469, 0x346a, 0x346b, 0x346c, 0x346d,
  0x346e, 0x346f, 0x3470, 0x3471, 0x3472, 0x3473, 0x3474, 0x3475,
  0x3476, 0x3477, 0x3478, 0x3479, 0x347a, 0x347b, 0x347c, 0x347d,
  0x347e, 0x347f, 0x3480, 0x3481, 0x3482, 0x3483, 0x3484, 0x3485,
  0x3486, 0x3487, 0x3488, 0x3489, 0x348a, 0x348b, 0x348c, 0x348d,
  0x348e, 0x348f, 0x3490, 0x3491, 0x3492, 0x3493, 0x3494, 0x3495,
  0x3496, 0x3497, 0x3498, 0x3499, 0x349a, 0x349b, 0x349c, 0x349d,
  0x349e, 0x349f, 0x34a0, 0x34a1, 0x34a2, 0x34a3, 0x34a4, 0x34a5,
  0x34a6, 0x34a7, 0x34a8, 0x34a9, 0x34aa, 0x34ab, 0x34ac, 0x34ad,
  0x34ae, 0x34af, 0x34b0, 0x34b1, 0x34b2, 0x34b3, 0x34b4, 0x34b5,
  0x34b6, 0x34b7, 0x34b8, 0x34b9, 0x34ba, 0x34bb, 0x34bc, 0x34bd,
  0x34be, 0x34bf, 0x34c0, 0x34c1, 0x34c2, 0x34c3, 0x34c4, 0x34c5,
  0x34c6, 0x34c7, 0x34c8, 0x34c9, 0x34ca, 0x34cb, 0x34cc, 0x34cd,
  0x34ce, 0x34cf, 0x34d0, 0x34d1, 0x34d2, 0x34d3, 0x34d4, 0x34d5,
  0x34d6, 0x34d7, 0x34d8, 0x34d9, 0x34da, 0x34db, 0x34dc, 0x34dd,
  0x34de, 0x34df, 0x34e0, 0x34e1, 0x34e2, 0x34e3, 0x34e4, 0x34e5,
  0x34e6, 0x34e7, 0x34e8, 0x34e9, 0x34ea, 0x34eb, 0x34ec, 0x34ed,
  0x34ee, 0x34ef, 0x34f0, 0x34f1, 0x34f2, 0x34f3, 0x34f4, 0x34f5,
  0x34f6, 0x34f7, 0x34f8, 0x34f9, 0x34fa, 0x34fb, 0x34fc, 0x34fd,
  0x34fe, 0x34ff, 0x3500, 0x3501, 0x3502, 0x3503, 0x3504, 0x3505,
  0x3506, 0x3507, 0x3508, 0x3509, 0x350a, 0x350b, 0x350c, 0x350d,
  0x350e, 0x350f, 0x3510, 0x3511, 0x3512, 0x3513, 0x3514, 0x3515,
  0x3516, 0x3517, 0x3518, 0x3519, 0x351a, 0x351b, 0x351c, 0x351d,
  0x351e, 0x351f, 0x3520, 0x3521, 0x3522, 0x3523, 0x3524, 0x3525,
  0x3526, 0x3527, 0x3528, 0x3529, 0x352a, 0x352b, 0x352c, 0x352d,
  0x352e, 0x352f, 0x3530, 0x3531, 0x3532, 0x3533, 0x3534, 0x3535,
  0x3536, 0x3537, 0x3538, 0x3539, 0x353a, 0x353b, 0x353c, 0x353d,
  0x353e, 0x353f, 0x3540, 0x3541, 0x3542, 0x3543, 0x3544, 0x3545,
  0x3546, 0x3547, 0x3548, 0x3549, 0x354a, 0x354b, 0x354c, 0x354d,
  0x354e, 0x354f, 0x3550, 0x3551, 0x3552, 0x3553, 0x3554, 0x3555,
  0x3556, 0x3557, 0x3558, 0x3559, 0x355a, 0x355b, 0x355c, 0x355d,
  0x355e, 0x355f, 0x3560, 0x3561, 0x3562, 0x3563, 0x3564, 0x3565,
  0x3566, 0x3567, 0x3568, 0x3569, 0x356a, 0x356b, 0x356c, 0x356d,
  0x356e, 0x356f, 0x3570, 0x3571, 0x3572, 0x3573, 0x3574, 0x3575,
  0x3576, 0x3577, 0x3578, 0x3579, 0x357a, 0x357b, 0x357c, 0x357d,
  0x357e, 0x357f, 0x3580, 0x3581, 0x3582, 0x3583, 0x3584, 0x3585,
  0x3586, 0x3587, 0x3588, 0x3589, 0x358a, 0x358b, 0x358c, 0x358d,
  0x358e, 0x358f, 0x3590, 0x3591, 0x3592, 0x3593, 0x3594, 0x3595,
  0x3596, 0x3597, 0x3598, 0x3599, 0x359a, 0x359b, 0x359c, 0x359d,
  0x359e, 0x359f, 0x35a0, 0x35a1, 0x35a2, 0x35a3, 0x35a4, 0x35a5,
  0x35a6, 0x35a7, 0x35a8, 0x35a9, 0x35aa, 0x35ab, 0x35ac, 0x35ad,
  0x35ae, 0x35af, 0x35b0, 0x35b1, 0x35b2, 0x35b3, 0x35b4, 0x35b5,
  0x35b6, 0x35b7, 0x35b8, 0x35b9, 0x35ba, 0x35bb, 0x35bc, 0x35bd,
  0x35be, 0x35bf, 0x35c0, 0x35c1, 0x35c2, 0x35c3, 0x35c4, 0x35c5,
  0x35c6, 0x35c7, 0x35c8, 0x35c9, 0x35ca, 0x35cb, 0x35cc, 0x35cd,
  0x35ce, 0x35cf, 0x35d0, 0x35d1, 0x35d2, 0x35d3, 0x35d4, 0x35d5,
  0x35d6, 0x35d7, 0x35d8, 0x35d9, 0x35da, 0x35db, 0x35dc, 0x35dd,
  0x35de, 0x35df, 0x35e0, 0x35e1, 0x35e2, 0x35e3, 0x35e4, 0x35e5,
  0x35e6, 0x35e7, 0x35e8, 0x35e9, 0x35ea, 0x35eb, 0x35ec, 0x35ed,
  0x35ee, 0x35ef, 0x35f0, 0x35f1, 0x35f2, 0x35f3, 0x35f4, 0x35f5,
  0x35f6, 0x35f7, 0x35f8, 0x35f9, 0x35fa, 0x35fb, 0x35fc, 0x35fd,
  0x35fe, 0x35ff, 0x3600, 0x3601, 0x3602, 0x3603, 0x3604, 0x3605,
  0x3606, 0x3607, 0x3608, 0x3609, 0x360a, 0x360b, 0x360c, 0x360d,
  0x360e, 0x360f, 0x3610, 0x3611, 0x3612, 0x3613, 0x3614, 0x3615,
  0x3616, 0x3617, 0x3618, 0x3619, 0x361a, 0x361b, 0x361c, 0x361d,
  0x361e, 0x361f, 0x3620, 0x3621, 0x3622, 0x3623, 0x3624, 0x3625,
  0x3626, 0x3627, 0x3628, 0x3629, 0x362a, 0x362b, 0x362c, 0x362d,
  0x362e, 0x362f, 0x3630, 0x3631, 0x3632, 0x3633, 0x3634, 0x3635,
  0x3636, 0x3637, 0x3638, 0x3639, 0x363a, 0x363b, 0x363c, 0x363d,
  0x363e, 0x363f, 0x3640, 0x3641, 0x3642, 0x3643, 0x3644, 0x3645,
  0x3646, 0x3647, 0x3648, 0x3649, 0x364a, 0x364b, 0x364c, 0x364d,
  0x364e, 0x364f, 0x3650, 0x3651, 0x3652, 0x3653, 0x3654, 0x3655,
  0x3656, 0x3657, 0x3658, 0x3659, 0x365a, 0x365b, 0x365c, 0x365d,
  0x365e, 0x365f, 0x3660, 0x3661, 0x3662, 0x3663, 0x3664, 0x3665,
  0x3666, 0x3667, 0x3668, 0x3669, 0x366a, 0x366b, 0x366c, 0x366d,
  0x366e, 0x366f, 0x3670, 0x3671, 0x3672, 0x3673, 0x3674, 0x3675,
  0x3676, 0x3677, 0x3678, 0x3679, 0x367a, 0x367b, 0x367c, 0x367d,
  0x367e, 0x367f, 0x3680, 0x3681, 0x3682, 0x3683, 0x3684, 0x3685,
  0x3686, 0x3687, 0x3688, 0x3689, 0x368a, 0x368b, 0x368c, 0x368d,
  0x368e, 0x368f, 0x3690, 0x3691, 0x3692, 0x3693, 0x3694, 0x3695,
  0x3696, 0x3697, 0x3698, 0x3699, 0x369a, 0x369b, 0x369c, 0x369d,
  0x369e, 0x369f, 0x36a0, 0x36a1, 0x36a2, 0x36a3, 0x36a4, 0x36a5,
  0x36a6, 0x36a7, 0x36a8, 0x36a9, 0x36aa, 0x36ab, 0x36ac, 0x36ad,
  0x36ae, 0x36af, 0x36b0, 0x36b1, 0x36b2, 0x36b3, 0x36b4, 0x36b5,
  0x36b6, 0x36b7, 0x36b8, 0x36b9, 0x36ba, 0x36bb, 0x36bc, 0x36bd,
  0x36be, 0x36bf, 0x36c0, 0x36c1, 0x36c2, 0x36c3, 0x36c4, 0x36c5,
  0x36c6, 0x36c7, 0x36c8, 0x36c9, 0x36ca, 0x36cb, 0x36cc, 0x36cd,
  0x36ce, 0x36cf, 0x36d0, 0x36d1, 0x36d2, 0x36d3, 0x36d4, 0x36d5,
  0x36d6, 0x36d7, 0x36d8, 0x36d9, 0x36da, 0x36db, 0x36dc, 0x36dd,
  0x36de, 0x36df, 0x36e0, 0x36e1, 0x36e2, 0x36e3, 0x36e4, 0x36e5,
  0x36e6, 0x36e7, 0x36e8, 0x36e9, 0x36ea, 0x36eb, 0x36ec, 0x36ed,
  0x36ee, 0x36ef, 0x36f0, 0x36f1, 0x36f2, 0x36f3, 0x36f4, 0x36f5,
  0x36f6, 0x36f7, 0x36f8, 0x36f9, 0x36fa, 0x36fb, 0x36fc, 0x36fd,
  0x36fe, 0x36ff, 0x3700, 0x3701, 0x3702, 0x3703, 0x3704, 0x3705,
  0x3706, 0x3707, 0x3708, 0x3709, 0x370a, 0x370b, 0x370c, 0x370d,
  0x370e, 0x370f, 0x3710, 0x3711, 0x3712, 0x3713, 0x3714, 0x3715,
  0x3716, 0x3717, 0x3718, 0x3719, 0x371a, 0x371b, 0x371c, 0x371d,
  0x371e, 0x371f, 0x3720, 0x3721, 0x3722, 0x3723, 0x3724, 0x3725,
  0x3726, 0x3727, 0x3728, 0x3729, 0x372a, 0x372b, 0x372c, 0x372d,
  0x372e, 0x372f, 0x3730, 0x3731, 0x3732, 0x3733, 0x3734, 0x3735,
  0x3736, 0x3737, 0x3738, 0x3739, 0x373a, 0x373b, 0x373c, 0x373d,
  0x373e, 0x373f, 0x3740, 0x3741, 0x3742, 0x3743, 0x3744, 0x3745,
  0x3746, 0x3747, 0x3748, 0x3749, 0x374a, 0x374b, 0x374c, 0x374d,
  0x374e, 0x374f, 0x3750, 0x3751, 0x3752, 0x3753, 0x3754, 0x3755,
  0x3756, 0x3757, 0x3758, 0x3759, 0x375a, 0x375b, 0x375c, 0x375d,
  0x375e, 0x375f, 0x3760, 0x3761, 0x3762, 0x3763, 0x3764, 0x3765,
  0x3766, 0x3767, 0x3768, 0x3769, 0x376a, 0x376b, 0x376c, 0x376d,
  0x376e, 0x376f, 0x3770, 0x3771, 0x3772, 0x3773, 0x3774, 0x3775,
  0x3776, 0x3777, 0x3778, 0x3779, 0x377a, 0x377b, 0x377c, 0x377d,
  0x377e, 0x377f, 0x3780, 0x3781, 0x3782, 0x3783, 0x3784, 0x3785,
  0x3786, 0x3787, 0x3788, 0x3789, 0x378a, 0x378b, 0x378c, 0x378d,
  0x378e, 0x378f, 0x3790, 0x3791, 0x3792, 0x3793, 0x3794, 0x3795,
  0x3796, 0x3797, 0x3798, 0x3799, 0x379a, 0x379b, 0x379c, 0x379d,
  0x379e, 0x379f, 0x37a0, 0x37a1, 0x37a2, 0x37a3, 0x37a4, 0x37a5,
  0x37a6, 0x37a7, 0x37a8, 0x37a9, 0x37aa, 0x37ab, 0x37ac, 0x37ad,
  0x37ae, 0x37af, 0x37b0, 0x37b1, 0x37b2, 0x37b3, 0x37b4, 0x37b5,
  0x37b6, 0x37b7, 0x37b8, 0x37b9, 0x37ba, 0x37bb, 0x37bc, 0x37bd,
  0x37be, 0x37bf, 0x37c0, 0x37c1, 0x37c2, 0x37c3, 0x37c4, 0x37c5,
  0x37c6, 0x37c7, 0x37c8, 0x37c9, 0x37ca, 0x37cb, 0x37cc, 0x37cd,
  0x37ce, 0x37cf, 0x37d0, 0x37d1, 0x37d2, 0x37d3, 0x37d4, 0x37d5,
  0x37d6, 0x37d7, 0x37d8, 0x37d9, 0x37da, 0x37db, 0x37dc, 0x37dd,
  0x37de, 0x37df, 0x37e0, 0x37e1, 0x37e2, 0x37e3, 0x37e4, 0x37e5,
  0x37e6, 0x37e7, 0x37e8, 0x37e9, 0x37ea, 0x37eb, 0x37ec, 0x37ed,
  0x37ee, 0x37ef, 0x37f0, 0x37f1, 0x37f2, 0x37f3, 0x37f4, 0x37f5,
  0x37f6, 0x37f7, 0x37f8, 0x37f9, 0x37fa, 0x37fb, 0x37fc, 0x37fd,
  0x37fe, 0x37ff, 0x3800, 0x3801, 0x3802, 0x3803, 0x3804, 0x3805,
  0x3806, 0x3807, 0x3808, 0x3809, 0x380a, 0x380b, 0x380c, 0x380d,
  0x380e, 0x380f, 0x3810, 0x3811, 0x3812, 0x3813, 0x3814, 0x3815,
  0x3816, 0x3817, 0x3818, 0x3819, 0x381a, 0x381b, 0x381c, 0x381d,
  0x381e, 0x381f, 0x3820, 0x3821, 0x3822, 0x3823, 0x3824, 0x3825,
  0x3826, 0x3827, 0x3828, 0x3829, 0x382a, 0x382b, 0x382c, 0x382d,
  0x382e, 0x382f, 0x3830, 0x3831, 0x3832, 0x3833, 0x3834, 0x3835,
  0x3836, 0x3837, 0x3838, 0x3839, 0x383a, 0x383b, 0x383c, 0x383d,
  0x383e, 0x383f, 0x3840, 0x3841, 0x3842, 0x3843, 0x3844, 0x3845,
  0x3846, 0x3847, 0x3848, 0x3849, 0x384a, 0x384b, 0x384c, 0x384d,
  0x384e, 0x384f, 0x3850, 0x3851, 0x3852, 0x3853, 0x3854, 0x3855,
  0x3856, 0x3857, 0x3858, 0x3859, 0x385a, 0x385b, 0x385c, 0x385d,
  0x385e, 0x385f, 0x3860, 0x3861, 0x3862, 0x3863, 0x3864, 0x3865,
  0x3866, 0x3867, 0x3868, 0x3869, 0x386a, 0x386b, 0x386c, 0x386d,
  0x386e, 0x386f, 0x3870, 0x3871, 0x3872, 0x3873, 0x3874, 0x3875,
  0x3876, 0x3877, 0x3878, 0x3879, 0x387a, 0x387b, 0x387c, 0x387d,
  0x387e, 0x387f, 0x3880, 0x3881, 0x3882, 0x3883, 0x3884, 0x3885,
  0x3886, 0x3887, 0x3888, 0x3889, 0x388a, 0x388b, 0x388c, 0x388d,
  0x388e, 0x388f, 0x3890, 0x3891, 0x3892, 0x3893, 0x3894, 0x3895,
  0x3896, 0x3897, 0x3898, 0x3899, 0x389a, 0x389b, 0x389c, 0x389d,
  0x389e, 0x389f, 0x38a0, 0x38a1, 0x38a2, 0x38a3, 0x38a4, 0x38a5,
  0x38a6, 0x38a7, 0x38a8, 0x38a9, 0x38aa, 0x38ab, 0x38ac, 0x38ad,
  0x38ae, 0x38af, 0x38b0, 0x38b1, 0x38b2, 0x38b3, 0x38b4, 0x38b5,
  0x38b6, 0x38b7, 0x38b8, 0x38b9, 0x38ba, 0x38bb, 0x38bc, 0x38bd,
  0x38be, 0x38bf, 0x38c0, 0x38c1, 0x38c2, 0x38c3, 0x38c4, 0x38c5,
  0x38c6, 0x38c7, 0x38c8, 0x38c9, 0x38ca, 0x38cb, 0x38cc, 0x38cd,
  0x38ce, 0x38cf, 0x38d0, 0x38d1, 0x38d2, 0x38d3, 0x38d4, 0x38d5,
  0x38d6, 0x38d7, 0x38d8, 0x38d9, 0x38da, 0x38db, 0x38dc, 0x38dd,
  0x38de, 0x38df, 0x38e0, 0x38e1, 0x38e2, 0x38e3, 0x38e4, 0x38e5,
  0x38e6, 0x38e7, 0x38e8, 0x38e9, 0x38ea, 0x38eb, 0x38ec, 0x38ed,
  0x38ee, 0x38ef, 0x38f0, 0x38f1, 0x38f2, 0x38f3, 0x38f4, 0x38f5,
  0x38f6, 0x38f7, 0x38f8, 0x38f9, 0x38fa, 0x38fb, 0x38fc, 0x38fd,
  0x38fe, 0x38ff, 0x3900, 0x3901, 0x3902, 0x3903, 0x3904, 0x3905,
  0x3906, 0x3907, 0x3908, 0x3909, 0x390a, 0x390b, 0x390c, 0x390d,
  0x390e, 0x390f, 0x3910, 0x3911, 0x3912, 0x3913, 0x3914, 0x3915,
  0x3916, 0x3917, 0x3918, 0x3919, 0x391a, 0x391b, 0x391c, 0x391d,
  0x391e, 0x391f, 0x3920, 0x3921, 0x3922, 0x3923, 0x3924, 0x3925,
  0x3926, 0x3927, 0x3928, 0x3929, 0x392a, 0x392b, 0x392c, 0x392d,
  0x392e, 0x392f, 0x3930, 0x3931, 0x3932, 0x3933, 0x3934, 0x3935,
  0x3936, 0x3937, 0x3938, 0x3939, 0x393a, 0x393b, 0x393c, 0x393d,
  0x393e, 0x393f, 0x3940, 0x3941, 0x3942, 0x3943, 0x3944, 0x3945,
  0x3946, 0x3947, 0x3948, 0x3949, 0x394a, 0x394b, 0x394c, 0x394d,
  0x394e, 0x394f, 0x3950, 0x3951, 0x3952, 0x3953, 0x3954, 0x3955,
  0x3956, 0x3957, 0x3958, 0x3959, 0x395a, 0x395b, 0x395c, 0x395d,
  0x395e, 0x395f, 0x3960, 0x3961, 0x3962, 0x3963, 0x3964, 0x3965,
  0x3966, 0x3967, 0x3968, 0x3969, 0x396a, 0x396b, 0x396c, 0x396d,
  0x396e, 0x396f, 0x3970, 0x3971, 0x3972, 0x3973, 0x3974, 0x3975,
  0x3976, 0x3977, 0x3978, 0x3979, 0x397a, 0x397b, 0x397c, 0x397d,
  0x397e, 0x397f, 0x3980, 0x3981, 0x3982, 0x3983, 0x3984, 0x3985,
  0x3986, 0x3987, 0x3988, 0x3989, 0x398a, 0x398b, 0x398c, 0x398d,
  0x398e, 0x398f, 0x3990, 0x3991, 0x3992, 0x3993, 0x3994, 0x3995,
  0x3996, 0x3997, 0x3998, 0x3999, 0x399a, 0x399b, 0x399c, 0x399d,
  0x399e, 0x399f, 0x39a0, 0x39a1, 0x39a2, 0x39a3, 0x39a4, 0x39a5,
  0x39a6, 0x39a7, 0x39a8, 0x39a9, 0x39aa, 0x39ab, 0x39ac, 0x39ad,
  0x39ae, 0x39af, 0x39b0, 0x39b1, 0x39b2, 0x39b3, 0x39b4, 0x39b5,
  0x39b6, 0x39b7, 0x39b8, 0x39b9, 0x39ba, 0x39bb, 0x39bc, 0x39bd,
  0x39be, 0x39bf, 0x39c0, 0x39c1, 0x39c2, 0x39c3, 0x39c4, 0x39c5,
  0x39c6, 0x39c7, 0x39c8, 0x39c9, 0x39ca, 0x39cb, 0x39cc, 0x39cd,
  0x39ce, 0x39cf, 0x39d0, 0x39d1, 0x39d2, 0x39d3, 0x39d4, 0x39d5,
  0x39d6, 0x39d7, 0x39d8, 0x39d9, 0x39da, 0x39db, 0x39dc, 0x39dd,
  0x39de, 0x39df, 0x39e0, 0x39e1, 0x39e2, 0x39e3, 0x39e4, 0x39e5,
  0x39e6, 0x39e7, 0x39e8, 0x39e9, 0x39ea, 0x39eb, 0x39ec, 0x39ed,
  0x39ee, 0x39ef, 0x39f0, 0x39f1, 0x39f2, 0x39f3, 0x39f4, 0x39f5,
  0x39f6, 0x39f7, 0x39f8, 0x39f9, 0x39fa, 0x39fb, 0x39fc, 0x39fd,
  0x39fe, 0x39ff, 0x3a00, 0x3a01, 0x3a02, 0x3a03, 0x3a04, 0x3a05,
  0x3a06, 0x3a07, 0x3a08, 0x3a09, 0x3a0a, 0x3a0b, 0x3a0c, 0x3a0d,
  0x3a0e, 0x3a0f, 0x3a10, 0x3a11, 0x3a12, 0x3a13, 0x3a14, 0x3a15,
  0x3a16, 0x3a17, 0x3a18, 0x3a19, 0x3a1a, 0x3a1b, 0x3a1c, 0x3a1d,
  0x3a1e, 0x3a1f, 0x3a20, 0x3a21, 0x3a22, 0x3a23, 0x3a24, 0x3a25,
  0x3a26, 0x3a27, 0x3a28, 0x3a29, 0x3a2a, 0x3a2b, 0x3a2c, 0x3a2d,
  0x3a2e, 0x3a2f, 0x3a30, 0x3a31, 0x3a32, 0x3a33, 0x3a34, 0x3a35,
  0x3a36, 0x3a37, 0x3a38, 0x3a39, 0x3a3a, 0x3a3b, 0x3a3c, 0x3a3d,
  0x3a3e, 0x3a3f, 0x3a40, 0x3a41, 0x3a42, 0x3a43, 0x3a44, 0x3a45,
  0x3a46, 0x3a47, 0x3a48, 0x3a49, 0x3a4a, 0x3a4b, 0x3a4c, 0x3a4d,
  0x3a4e, 0x3a4f, 0x3a50, 0x3a51, 0x3a52, 0x3a53, 0x3a54, 0x3a55,
  0x3a56, 0x3a57, 0x3a58, 0x3a59, 0x3a5a, 0x3a5b, 0x3a5c, 0x3a5d,
  0x3a5e, 0x3a5f, 0x3a60, 0x3a61, 0x3a62, 0x3a63, 0x3a64, 0x3a65,
  0x3a66, 0x3a67, 0x3a68, 0x3a69, 0x3a6a, 0x3a6b, 0x3a6c, 0x3a6d,
  0x3a6e, 0x3a6f, 0x3a70, 0x3a71, 0x3a72, 0x3a73, 0x3a74, 0x3a75,
  0x3a76, 0x3a77, 0x3a78, 0x3a79, 0x3a7a, 0x3a7b, 0x3a7c, 0x3a7d,
  0x3a7e, 0x3a7f, 0x3a80, 0x3a81, 0x3a82, 0x3a83, 0x3a84, 0x3a85,
  0x3a86, 0x3a87, 0x3a88, 0x3a89, 0x3a8a, 0x3a8b, 0x3a8c, 0x3a8d,
  0x3a8e, 0x3a8f, 0x3a90, 0x3a91, 0x3a92, 0x3a93, 0x3a94, 0x3a95,
  0x3a96, 0x3a97, 0x3a98, 0x3a99, 0x3a9a, 0x3a9b, 0x3a9c, 0x3a9d,
  0x3a9e, 0x3a9f, 0x3aa0, 0x3aa1, 0x3aa2, 0x3aa3, 0x3aa4, 0x3aa5,
  0x3aa6, 0x3aa7, 0x3aa8, 0x3aa9, 0x3aaa, 0x3aab, 0x3aac, 0x3aad,
  0x3aae, 0x3aaf, 0x3ab0, 0x3ab1, 0x3ab2, 0x3ab3, 0x3ab4, 0x3ab5,
  0x3ab6, 0x3ab7, 0x3ab8, 0x3ab9, 0x3aba, 0x3abb, 0x3abc, 0x3abd,
  0x3abe, 0x3abf, 0x3ac0, 0x3ac1, 0x3ac2, 0x3ac3, 0x3ac4, 0x3ac5,
  0x3ac6, 0x3ac7, 0x3ac8, 0x3ac9, 0x3aca, 0x3acb, 0x3acc, 0x3acd,
  0x3ace, 0x3acf, 0x3ad0, 0x3ad1, 0x3ad2, 0x3ad3, 0x3ad4, 0x3ad5,
  0x3ad6, 0x3ad7, 0x3ad8, 0x3ad9, 0x3ada, 0x3adb, 0x3adc, 0x3add,
  0x3ade, 0x3adf, 0x3ae0, 0x3ae1, 0x3ae2, 0x3ae3, 0x3ae4, 0x3ae5,
  0x3ae6, 0x3ae7, 0x3ae8, 0x3ae9, 0x3aea, 0x3aeb, 0x3aec, 0x3aed,
  0x3aee, 0x3aef, 0x3af0, 0x3af1, 0x3af2, 0x3af3, 0x3af4, 0x3af5,
  0x3af6, 0x3af7, 0x3af8, 0x3af9, 0x3afa, 0x3afb, 0x3afc, 0x3afd,
  0x3afe, 0x3aff, 0x3b00, 0x3b01, 0x3b02, 0x3b03, 0x3b04, 0x3b05,
  0x3b06, 0x3b07, 0x3b08, 0x3b09, 0x3b0a, 0x3b0b, 0x3b0c, 0x3b0d,
  0x3b0e, 0x3b0f, 0x3b10, 0x3b11, 0x3b12, 0x3b13, 0x3b14, 0x3b15,
  0x3b16, 0x3b17, 0x3b18, 0x3b19, 0x3b1a, 0x3b1b, 0x3b1c, 0x3b1d,
  0x3b1e, 0x3b1f, 0x3b20, 0x3b21, 0x3b22, 0x3b23, 0x3b24, 0x3b25,
  0x3b26, 0x3b27, 0x3b28, 0x3b29, 0x3b2a, 0x3b2b, 0x3b2c, 0x3b2d,
  0x3b2e, 0x3b2f, 0x3b30, 0x3b31, 0x3b32, 0x3b33, 0x3b34, 0x3b35,
  0x3b36, 0x3b37, 0x3b38, 0x3b39, 0x3b3a, 0x3b3b, 0x3b3c, 0x3b3d,
  0x3b3e, 0x3b3f, 0x3b40, 0x3b41, 0x3b42, 0x3b43, 0x3b44, 0x3b45,
  0x3b46, 0x3b47, 0x3b48, 0x3b49, 0x3b4a, 0x3b4b, 0x3b4c, 0x3b4d,
  0x3b4e, 0x3b4f, 0x3b50, 0x3b51, 0x3b52, 0x3b53, 0x3b54, 0x3b55,
  0x3b56, 0x3b57, 0x3b58, 0x3b59, 0x3b5a, 0x3b5b, 0x3b5c, 0x3b5d,
  0x3b5e, 0x3b5f, 0x3b60, 0x3b61, 0x3b62, 0x3b63, 0x3b64, 0x3b65,
  0x3b66, 0x3b67, 0x3b68, 0x3b69, 0x3b6a, 0x3b6b, 0x3b6c, 0x3b6d,
  0x3b6e, 0x3b6f, 0x3b70, 0x3b71, 0x3b72, 0x3b73, 0x3b74, 0x3b75,
  0x3b76, 0x3b77, 0x3b78, 0x3b79, 0x3b7a, 0x3b7b, 0x3b7c, 0x3b7d,
  0x3b7e, 0x3b7f, 0x3b80, 0x3b81, 0x3b82, 0x3b83, 0x3b84, 0x3b85,
  0x3b86, 0x3b87, 0x3b88, 0x3b89, 0x3b8a, 0x3b8b, 0x3b8c, 0x3b8d,
  0x3b8e, 0x3b8f, 0x3b90, 0x3b91, 0x3b92, 0x3b93, 0x3b94, 0x3b95,
  0x3b96, 0x3b97, 0x3b98, 0x3b99, 0x3b9a, 0x3b9b, 0x3b9c, 0x3b9d,
  0x3b9e, 0x3b9f, 0x3ba0, 0x3ba1, 0x3ba2, 0x3ba3, 0x3ba4, 0x3ba5,
  0x3ba6, 0x3ba7, 0x3ba8, 0x3ba9, 0x3baa, 0x3bab, 0x3bac, 0x3bad,
  0x3bae, 0x3baf, 0x3bb0, 0x3bb1, 0x3bb2, 0x3bb3, 0x3bb4, 0x3bb5,
  0x3bb6, 0x3bb7, 0x3bb8, 0x3bb9, 0x3bba, 0x3bbb, 0x3bbc, 0x3bbd,
  0x3bbe, 0x3bbf, 0x3bc0, 0x3bc1, 0x3bc2, 0x3bc3, 0x3bc4, 0x3bc5,
  0x3bc6, 0x3bc7, 0x3bc8, 0x3bc9, 0x3bca, 0x3bcb, 0x3bcc, 0x3bcd,
  0x3bce, 0x3bcf, 0x3bd0, 0x3bd1, 0x3bd2, 0x3bd3, 0x3bd4, 0x3bd5,
  0x3bd6, 0x3bd7, 0x3bd8, 0x3bd9, 0x3bda, 0x3bdb, 0x3bdc, 0x3bdd,
  0x3bde, 0x3bdf, 0x3be0, 0x3be1, 0x3be2, 0x3be3, 0x3be4, 0x3be5,
  0x3be6, 0x3be7, 0x3be8, 0x3be9, 0x3bea, 0x3beb, 0x3bec, 0x3bed,
  0x3bee, 0x3bef, 0x3bf0, 0x3bf1, 0x3bf2, 0x3bf3, 0x3bf4, 0x3bf5,
  0x3bf6, 0x3bf7, 0x3bf8, 0x3bf9, 0x3bfa, 0x3bfb, 0x3bfc, 0x3bfd,
  0x3bfe, 0x3bff, 0x3c00, 0x3c01, 0x3c02, 0x3c03, 0x3c04, 0x3c05,
  0x3c06, 0x3c07, 0x3c08, 0x3c09, 0x3c0a, 0x3c0b, 0x3c0c, 0x3c0d,
  0x3c0e, 0x3c0f, 0x3c10, 0x3c11, 0x3c12, 0x3c13, 0x3c14, 0x3c15,
  0x3c16, 0x3c17, 0x3c18, 0x3c19, 0x3c1a, 0x3c1b, 0x3c1c, 0x3c1d,
  0x3c1e, 0x3c1f, 0x3c20, 0x3c21, 0x3c22, 0x3c23, 0x3c24, 0x3c25,
  0x3c26, 0x3c27, 0x3c28, 0x3c29, 0x3c2a, 0x3c2b, 0x3c2c, 0x3c2d,
  0x3c2e, 0x3c2f, 0x3c30, 0x3c31, 0x3c32, 0x3c33, 0x3c34, 0x3c35,
  0x3c36, 0x3c37, 0x3c38, 0x3c39, 0x3c3a, 0x3c3b, 0x3c3c, 0x3c3d,
  0x3c3e, 0x3c3f, 0x3c40, 0x3c41, 0x3c42, 0x3c43, 0x3c44, 0x3c45,
  0x3c46, 0x3c47, 0x3c48, 0x3c49, 0x3c4a, 0x3c4b, 0x3c4c, 0x3c4d,
  0x3c4e, 0x3c4f, 0x3c50, 0x3c51, 0x3c52, 0x3c53, 0x3c54, 0x3c55,
  0x3c56, 0x3c57, 0x3c58, 0x3c59, 0x3c5a, 0x3c5b, 0x3c5c, 0x3c5d,
  0x3c5e, 0x3c5f, 0x3c60, 0x3c61, 0x3c62, 0x3c63, 0x3c64, 0x3c65,
  0x3c66, 0x3c67, 0x3c68, 0x3c69, 0x3c6a, 0x3c6b, 0x3c6c, 0x3c6d,
  0x3c6e, 0x3c6f, 0x3c70, 0x3c71, 0x3c72, 0x3c73, 0x3c74, 0x3c75,
  0x3c76, 0x3c77, 0x3c78, 0x3c79, 0x3c7a, 0x3c7b, 0x3c7c, 0x3c7d,
  0x3c7e, 0x3c7f, 0x3c80, 0x3c81, 0x3c82, 0x3c83, 0x3c84, 0x3c85,
  0x3c86, 0x3c87, 0x3c88, 0x3c89, 0x3c8a, 0x3c8b, 0x3c8c, 0x3c8d,
  0x3c8e, 0x3c8f, 0x3c90, 0x3c91, 0x3c92, 0x3c93, 0x3c94, 0x3c95,
  0x3c96, 0x3c97, 0x3c98, 0x3c99, 0x3c9a, 0x3c9b, 0x3c9c, 0x3c9d,
  0x3c9e, 0x3c9f, 0x3ca0, 0x3ca1, 0x3ca2, 0x3ca3, 0x3ca4, 0x3ca5,
  0x3ca6, 0x3ca7, 0x3ca8, 0x3ca9, 0x3caa, 0x3cab, 0x3cac, 0x3cad,
  0x3cae, 0x3caf, 0x3cb0, 0x3cb1, 0x3cb2, 0x3cb3, 0x3cb4, 0x3cb5,
  0x3cb6, 0x3cb7, 0x3cb8, 0x3cb9, 0x3cba, 0x3cbb, 0x3cbc, 0x3cbd,
  0x3cbe, 0x3cbf, 0x3cc0, 0x3cc1, 0x3cc2, 0x3cc3, 0x3cc4, 0x3cc5,
  0x3cc6, 0x3cc7, 0x3cc8, 0x3cc9, 0x3cca, 0x3ccb, 0x3ccc, 0x3ccd,
  0x3cce, 0x3ccf, 0x3cd0, 0x3cd1, 0x3cd2, 0x3cd3, 0x3cd4, 0x3cd5,
  0x3cd6, 0x3cd7, 0x3cd8, 0x3cd9, 0x3cda, 0x3cdb, 0x3cdc, 0x3cdd,
  0x3cde, 0x3cdf, 0x3ce0, 0x3ce1, 0x3ce2, 0x3ce3, 0x3ce4, 0x3ce5,
  0x3ce6, 0x3ce7, 0x3ce8, 0x3ce9, 0x3cea, 0x3ceb, 0x3cec, 0x3ced,
  0x3cee, 0x3cef, 0x3cf0, 0x3cf1, 0x3cf2, 0x3cf3, 0x3cf4, 0x3cf5,
  0x3cf6, 0x3cf7, 0x3cf8, 0x3cf9, 0x3cfa, 0x3cfb, 0x3cfc, 0x3cfd,
  0x3cfe, 0x3cff, 0x3d00, 0x3d01, 0x3d02, 0x3d03, 0x3d04, 0x3d05,
  0x3d06, 0x3d07, 0x3d08, 0x3d09, 0x3d0a, 0x3d0b, 0x3d0c, 0x3d0d,
  0x3d0e, 0x3d0f, 0x3d10, 0x3d11, 0x3d12, 0x3d13, 0x3d14, 0x3d15,
  0x3d16, 0x3d17, 0x3d18, 0x3d19, 0x3d1a, 0x3d1b, 0x3d1c, 0x3d1d,
  0x3d1e, 0x3d1f, 0x3d20, 0x3d21, 0x3d22, 0x3d23, 0x3d24, 0x3d25,
  0x3d26, 0x3d27, 0x3d28, 0x3d29, 0x3d2a, 0x3d2b, 0x3d2c, 0x3d2d,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x4f3d, 0x4f73,
  0x5047, 0x50f9, 0x52a0, 0x53ef, 0x5475, 0x54e5, 0x5609, 0x5ac1,
  0x5bb6, 0x6687, 0x67b6, 0x67b7, 0x67ef, 0x6b4c, 0x73c2, 0x75c2,
  0x7a3c, 0x82db, 0x8304, 0x8857, 0x8888, 0x8a36, 0x8cc8, 0x8dcf,
  0x8efb, 0x8fe6, 0x99d5, 0x523b, 0x5374, 0x5404, 0x606a, 0x6164,
  0x6bbc, 0x73cf, 0x811a, 0x89ba, 0x89d2, 0x95a3, 0x4f83, 0x520a,
  0x58be, 0x5978, 0x59e6, 0x5e72, 0x5e79, 0x61c7, 0x63c0, 0x6746,
  0x67ec, 0x687f, 0x6f97, 0x764e, 0x770b, 0x78f5, 0x7a08, 0x7aff,
  0x7c21, 0x809d, 0x826e, 0x8271, 0x8aeb, 0x9593, 0x4e6b, 0x559d,
  0x66f7, 0x6e34, 0x78a3, 0x7aed, 0x845b, 0x8910, 0x874e, 0x97a8,
  0x52d8, 0x574e, 0x582a, 0x5d4c, 0x611f, 0x61be, 0x6221, 0x6562,
  0x67d1, 0x6a44, 0x6e1b, 0x7518, 0x75b3, 0x76e3, 0x77b0, 0x7d3a,
  0x90af, 0x9451, 0x9452, 0x9f95, 0x5323, 0x5cac, 0x7532, 0x80db,
  0x9240, 0x9598, 0x525b, 0x5808, 0x59dc, 0x5ca1, 0x5d17, 0x5eb7,
  0x5f3a, 0x5f4a, 0x6177, 0x6c5f, 0x757a, 0x7586, 0x7ce0, 0x7d73,
  0x7db1, 0x7f8c, 0x8154, 0x8221, 0x8591, 0x8941, 0x8b1b, 0x92fc,
  0x964d, 0x9c47, 0x4ecb, 0x4ef7, 0x500b, 0x51f1, 0x584f, 0x6137,
  0x613e, 0x6168, 0x6539, 0x69ea, 0x6f11, 0x75a5, 0x7686, 0x76d6,
  0x7b87, 0x82a5, 0x84cb, 0xf900, 0x93a7, 0x958b, 0x5580, 0x5ba2,
  0x5751, 0xf901, 0x7cb3, 0x7fb9, 0x91b5, 0x5028, 0x53bb, 0x5c45,
  0x5de8, 0x62d2, 0x636e, 0x64da, 0x64e7, 0x6e20, 0x70ac, 0x795b,
  0x8ddd, 0x8e1e, 0xf902, 0x907d, 0x9245, 0x92f8, 0x4e7e, 0x4ef6,
  0x5065, 0x5dfe, 0x5efa, 0x6106, 0x6957, 0x8171, 0x8654, 0x8e47,
  0x9375, 0x9a2b, 0x4e5e, 0x5091, 0x6770, 0x6840, 0x5109, 0x528d,
  0x5292, 0x6aa2, 0x77bc, 0x9210, 0x9ed4, 0x52ab, 0x602f, 0x8ff2,
  0x5048, 0x61a9, 0x63ed, 0x64ca, 0x683c, 0x6a84, 0x6fc0, 0x8188,
  0x89a1, 0x9694, 0x5805, 0x727d, 0x72ac, 0x7504, 0x7d79, 0x7e6d,
  0x80a9, 0x898b, 0x8b74, 0x9063, 0x9d51, 0x6289, 0x6c7a, 0x6f54,
  0x7d50, 0x7f3a, 0x8a23, 0x517c, 0x614a, 0x7b9d, 0x8b19, 0x9257,
  0x938c, 0x4eac, 0x4fd3, 0x501e, 0x50be, 0x5106, 0x52c1, 0x52cd,
  0x537f, 0x5770, 0x5883, 0x5e9a, 0x5f91, 0x6176, 0x61ac, 0x64ce,
  0x656c, 0x666f, 0x66bb, 0x66f4, 0x6897, 0x6d87, 0x7085, 0x70f1,
  0x749f, 0x74a5, 0x74ca, 0x75d9, 0x786c, 0x78ec, 0x7adf, 0x7af6,
  0x7d45, 0x7d93, 0x8015, 0x803f, 0x811b, 0x8396, 0x8b66, 0x8f15,
  0x9015, 0x93e1, 0x9803, 0x9838, 0x9a5a, 0x9be8, 0x4fc2, 0x5553,
  0x583a, 0x5951, 0x5b63, 0x5c46, 0x60b8, 0x6212, 0x6842, 0x68b0,
  0x68e8, 0x6eaa, 0x754c, 0x7678, 0x78ce, 0x7a3d, 0x7cfb, 0x7e6b,
  0x7e7c, 0x8a08, 0x8aa1, 0x8c3f, 0x968e, 0x9dc4, 0x53e4, 0x53e9,
  0x544a, 0x5471, 0x56fa, 0x59d1, 0x5b64, 0x5c3b, 0x5eab, 0x62f7,
  0x6537, 0x6545, 0x6572, 0x66a0, 0x67af, 0x69c1, 0x6cbd, 0x75fc,
  0x7690, 0x777e, 0x7a3f, 0x7f94, 0x8003, 0x80a1, 0x818f, 0x82e6,
  0x82fd, 0x83f0, 0x85c1, 0x8831, 0x88b4, 0x8aa5, 0xf903, 0x8f9c,
  0x932e, 0x96c7, 0x9867, 0x9ad8, 0x9f13, 0x54ed, 0x659b, 0x66f2,
  0x688f, 0x7a40, 0x8c37, 0x9d60, 0x56f0, 0x5764, 0x5d11, 0x6606,
  0x68b1, 0x68cd, 0x6efe, 0x7428, 0x889e, 0x9be4, 0x6c68, 0xf904,
  0x9aa8, 0x4f9b, 0x516c, 0x5171, 0x529f, 0x5b54, 0x5de5, 0x6050,
  0x606d, 0x62f1, 0x63a7, 0x653b, 0x73d9, 0x7a7a, 0x86a3, 0x8ca2,
  0x978f, 0x4e32, 0x5be1, 0x6208, 0x679c, 0x74dc, 0x79d1, 0x83d3,
  0x8a87, 0x8ab2, 0x8de8, 0x904e, 0x934b, 0x9846, 0x5ed3, 0x69e8,
  0x85ff, 0x90ed, 0xf905, 0x51a0, 0x5b98, 0x5bec, 0x6163, 0x68fa,
  0x6b3e, 0x704c, 0x742f, 0x74d8, 0x7ba1, 0x7f50, 0x83c5, 0x89c0,
  0x8cab, 0x95dc, 0x9928, 0x522e, 0x605d, 0x62ec, 0x9002, 0x4f8a,
  0x5149, 0x5321, 0x58d9, 0x5ee3, 0x66e0, 0x6d38, 0x709a, 0x72c2,
  0x73d6, 0x7b50, 0x80f1, 0x945b, 0x5366, 0x639b, 0x7f6b, 0x4e56,
  0x5080, 0x584a, 0x58de, 0x602a, 0x6127, 0x62d0, 0x69d0, 0x9b41,
  0x5b8f, 0x7d18, 0x80b1, 0x8f5f, 0x4ea4, 0x50d1, 0x54ac, 0x55ac,
  0x5b0c, 0x5da0, 0x5de7, 0x652a, 0x654e, 0x6821, 0x6a4b, 0x72e1,
  0x768e, 0x77ef, 0x7d5e, 0x7ff9, 0x81a0, 0x854e, 0x86df, 0x8f03,
  0x8f4e, 0x90ca, 0x9903, 0x9a55, 0x9bab, 0x4e18, 0x4e45, 0x4e5d,
  0x4ec7, 0x4ff1, 0x5177, 0x52fe, 0x5340, 0x53e3, 0x53e5, 0x548e,
  0x5614, 0x5775, 0x57a2, 0x5bc7, 0x5d87, 0x5ed0, 0x61fc, 0x62d8,
  0x6551, 0x67b8, 0x67e9, 0x69cb, 0x6b50, 0x6bc6, 0x6bec, 0x6c42,
  0x6e9d, 0x7078, 0x72d7, 0x7396, 0x7403, 0x77bf, 0x77e9, 0x7a76,
  0x7d7f, 0x8009, 0x81fc, 0x8205, 0x820a, 0x82df, 0x8862, 0x8b33,
  0x8cfc, 0x8ec0, 0x9011, 0x90b1, 0x9264, 0x92b6, 0x99d2, 0x9a45,
  0x9ce9, 0x9dd7, 0x9f9c, 0x570b, 0x5c40, 0x83ca, 0x97a0, 0x97ab,
  0x9eb4, 0x541b, 0x7a98, 0x7fa4, 0x88d9, 0x8ecd, 0x90e1, 0x5800,
  0x5c48, 0x6398, 0x7a9f, 0x5bae, 0x5f13, 0x7a79, 0x7aae, 0x828e,
  0x8eac, 0x5026, 0x5238, 0x52f8, 0x5377, 0x5708, 0x62f3, 0x6372,
  0x6b0a, 0x6dc3, 0x7737, 0x53a5, 0x7357, 0x8568, 0x8e76, 0x95d5,
  0x673a, 0x6ac3, 0x6f70, 0x8a6d, 0x8ecc, 0x994b, 0xf906, 0x6677,
  0x6b78, 0x8cb4, 0x9b3c, 0xf907, 0x53eb, 0x572d, 0x594e, 0x63c6,
  0x69fb, 0x73ea, 0x7845, 0x7aba, 0x7ac5, 0x7cfe, 0x8475, 0x898f,
  0x8d73, 0x9035, 0x95a8, 0x52fb, 0x5747, 0x7547, 0x7b60, 0x83cc,
  0x921e, 0xf908, 0x6a58, 0x514b, 0x524b, 0x5287, 0x621f, 0x68d8,
  0x6975, 0x9699, 0x50c5, 0x52a4, 0x52e4, 0x61c3, 0x65a4, 0x6839,
  0x69ff, 0x747e, 0x7b4b, 0x82b9, 0x83eb, 0x89b2, 0x8b39, 0x8fd1,
  0x9949, 0xf909, 0x4eca, 0x5997, 0x64d2, 0x6611, 0x6a8e, 0x7434,
  0x7981, 0x79bd, 0x82a9, 0x887e, 0x887f, 0x895f, 0xf90a, 0x9326,
  0x4f0b, 0x53ca, 0x6025, 0x6271, 0x6c72, 0x7d1a, 0x7d66, 0x4e98,
  0x5162, 0x77dc, 0x80af, 0x4f01, 0x4f0e, 0x5176, 0x5180, 0x55dc,
  0x5668, 0x573b, 0x57fa, 0x57fc, 0x5914, 0x5947, 0x5993, 0x5bc4,
  0x5c90, 0x5d0e, 0x5df1, 0x5e7e, 0x5fcc, 0x6280, 0x65d7, 0x65e3,
  0x671e, 0x671f, 0x675e, 0x68cb, 0x68c4, 0x6a5f, 0x6b3a, 0x6c23,
  0x6c7d, 0x6c82, 0x6dc7, 0x7398, 0x7426, 0x742a, 0x7482, 0x74a3,
  0x7578, 0x757f, 0x7881, 0x78ef, 0x7941, 0x7947, 0x7948, 0x797a,
  0x7b95, 0x7d00, 0x7dba, 0x7f88, 0x8006, 0x802d, 0x808c, 0x8a18,
  0x8b4f, 0x8c48, 0x8d77, 0x9321, 0x9324, 0x98e2, 0x9951, 0x9a0e,
  0x9a0f, 0x9a65, 0x9e92, 0x7dca, 0x4f76, 0x5409, 0x62ee, 0x6854,
  0x91d1, 0x55ab, 0x513a, 0xf90b, 0xf90c, 0x5a1c, 0x61e6, 0xf90d,
  0x62cf, 0x62ff, 0xf90e, 0xf90f, 0xf910, 0xf911, 0xf912, 0xf913,
  0x90a3, 0xf914, 0xf915, 0xf916, 0xf917, 0xf918, 0x8afe, 0xf919,
  0xf91a, 0xf91b, 0xf91c, 0x6696, 0xf91d, 0x7156, 0xf91e, 0xf91f,
  0x96e3, 0xf920, 0x634f, 0x637a, 0x5357, 0xf921, 0x678f, 0x6960,
  0x6e73, 0xf922, 0x7537, 0xf923, 0xf924, 0xf925, 0x7d0d, 0xf926,
  0xf927, 0x8872, 0x56ca, 0x5a18, 0xf928, 0xf929, 0xf92a, 0xf92b,
  0xf92c, 0x4e43, 0xf92d, 0x5167, 0x5948, 0x67f0, 0x8010, 0xf92e,
  0x5973, 0x5e74, 0x649a, 0x79ca, 0x5ff5, 0x606c, 0x62c8, 0x637b,
  0x5be7, 0x5bd7, 0x52aa, 0xf92f, 0x5974, 0x5f29, 0x6012, 0xf930,
  0xf931, 0xf932, 0x7459, 0xf933, 0xf934, 0xf935, 0xf936, 0xf937,
  0xf938, 0x99d1, 0xf939, 0xf93a, 0xf93b, 0xf93c, 0xf93d, 0xf93e,
  0xf93f, 0xf940, 0xf941, 0xf942, 0xf943, 0x6fc3, 0xf944, 0xf945,
  0x81bf, 0x8fb2, 0x60f1, 0xf946, 0xf947, 0x8166, 0xf948, 0xf949,
  0x5c3f, 0xf94a, 0xf94b, 0xf94c, 0xf94d, 0xf94e, 0xf94f, 0xf950,
  0xf951, 0x5ae9, 0x8a25, 0x677b, 0x7d10, 0xf952, 0xf953, 0xf954,
  0xf955, 0xf956, 0xf957, 0x80fd, 0xf958, 0xf959, 0x5c3c, 0x6ce5,
  0x533f, 0x6eba, 0x591a, 0x8336, 0x4e39, 0x4eb6, 0x4f46, 0x55ae,
  0x5718, 0x58c7, 0x5f56, 0x65b7, 0x65e6, 0x6a80, 0x6bb5, 0x6e4d,
  0x77ed, 0x7aef, 0x7c1e, 0x7dde, 0x86cb, 0x8892, 0x9132, 0x935b,
  0x64bb, 0x6fbe, 0x737a, 0x75b8, 0x9054, 0x5556, 0x574d, 0x61ba,
  0x64d4, 0x66c7, 0x6de1, 0x6e5b, 0x6f6d, 0x6fb9, 0x75f0, 0x8043,
  0x81bd, 0x8541, 0x8983, 0x8ac7, 0x8b5a, 0x931f, 0x6c93, 0x7553,
  0x7b54, 0x8e0f, 0x905d, 0x5510, 0x5802, 0x5858, 0x5e62, 0x6207,
  0x649e, 0x68e0, 0x7576, 0x7cd6, 0x87b3, 0x9ee8, 0x4ee3, 0x5788,
  0x576e, 0x5927, 0x5c0d, 0x5cb1, 0x5e36, 0x5f85, 0x6234, 0x64e1,
  0x73b3, 0x81fa, 0x888b, 0x8cb8, 0x968a, 0x9edb, 0x5b85, 0x5fb7,
  0x60b3, 0x5012, 0x5200, 0x5230, 0x5716, 0x5835, 0x5857, 0x5c0e,
  0x5c60, 0x5cf6, 0x5d8b, 0x5ea6, 0x5f92, 0x60bc, 0x6311, 0x6389,
  0x6417, 0x6843, 0x68f9, 0x6ac2, 0x6dd8, 0x6e21, 0x6ed4, 0x6fe4,
  0x71fe, 0x76dc, 0x7779, 0x79b1, 0x7a3b, 0x8404, 0x89a9, 0x8ced,
  0x8df3, 0x8e48, 0x9003, 0x9014, 0x9053, 0x90fd, 0x934d, 0x9676,
  0x97dc, 0x6bd2, 0x7006, 0x7258, 0x72a2, 0x7368, 0x7763, 0x79bf,
  0x7be4, 0x7e9b, 0x8b80, 0x58a9, 0x60c7, 0x6566, 0x65fd, 0x66be,
  0x6c8c, 0x711e, 0x71c9, 0x8c5a, 0x9813, 0x4e6d, 0x7a81, 0x4edd,
  0x51ac, 0x51cd, 0x52d5, 0x540c, 0x61a7, 0x6771, 0x6850, 0x68df,
  0x6d1e, 0x6f7c, 0x75bc, 0x77b3, 0x7ae5, 0x80f4, 0x8463, 0x9285,
  0x515c, 0x6597, 0x675c, 0x6793, 0x75d8, 0x7ac7, 0x8373, 0xf95a,
  0x8c46, 0x9017, 0x982d, 0x5c6f, 0x81c0, 0x829a, 0x9041, 0x906f,
  0x920d, 0x5f97, 0x5d9d, 0x6a59, 0x71c8, 0x767b, 0x7b49, 0x85e4,
  0x8b04, 0x9127, 0x9a30, 0x5587, 0x61f6, 0xf95b, 0x7669, 0x7f85,
  0x863f, 0x87ba, 0x88f8, 0x908f, 0xf95c, 0x6d1b, 0x70d9, 0x73de,
  0x7d61, 0x843d, 0xf95d, 0x916a, 0x99f1, 0xf95e, 0x4e82, 0x5375,
  0x6b04, 0x6b12, 0x703e, 0x721b, 0x862d, 0x9e1e, 0x524c, 0x8fa3,
  0x5d50, 0x64e5, 0x652c, 0x6b16, 0x6feb, 0x7c43, 0x7e9c, 0x85cd,
  0x8964, 0x89bd, 0x62c9, 0x81d8, 0x881f, 0x5eca, 0x6717, 0x6d6a,
  0x72fc, 0x7405, 0x746f, 0x8782, 0x90de, 0x4f86, 0x5d0d, 0x5fa0,
  0x840a, 0x51b7, 0x63a0, 0x7565, 0x4eae, 0x5006, 0x5169, 0x51c9,
  0x6881, 0x6a11, 0x7cae, 0x7cb1, 0x7ce7, 0x826f, 0x8ad2, 0x8f1b,
  0x91cf, 0x4fb6, 0x5137, 0x52f5, 0x5442, 0x5eec, 0x616e, 0x623e,
  0x65c5, 0x6ada, 0x6ffe, 0x792a, 0x85dc, 0x8823, 0x95ad, 0x9a62,
  0x9a6a, 0x9e97, 0x9ece, 0x529b, 0x66c6, 0x6b77, 0x701d, 0x792b,
  0x8f62, 0x9742, 0x6190, 0x6200, 0x6523, 0x6f23, 0x7149, 0x7489,
  0x7df4, 0x806f, 0x84ee, 0x8f26, 0x9023, 0x934a, 0x51bd, 0x5217,
  0x52a3, 0x6d0c, 0x70c8, 0x88c2, 0x5ec9, 0x6582, 0x6bae, 0x6fc2,
  0x7c3e, 0x7375, 0x4ee4, 0x4f36, 0x56f9, 0xf95f, 0x5cba, 0x5dba,
  0x601c, 0x73b2, 0x7b2d, 0x7f9a, 0x7fce, 0x8046, 0x901e, 0x9234,
  0x96f6, 0x9748, 0x9818, 0x9f61, 0x4f8b, 0x6fa7, 0x79ae, 0x91b4,
  0x96b7, 0x52de, 0xf960, 0x6488, 0x64c4, 0x6ad3, 0x6f5e, 0x7018,
  0x7210, 0x76e7, 0x8001, 0x8606, 0x865c, 0x8def, 0x8f05, 0x9732,
  0x9b6f, 0x9dfa, 0x9e75, 0x788c, 0x797f, 0x7da0, 0x83c9, 0x9304,
  0x9e7f, 0x9e93, 0x8ad6, 0x58df, 0x5f04, 0x6727, 0x7027, 0x74cf,
  0x7c60, 0x807e, 0x5121, 0x7028, 0x7262, 0x78ca, 0x8cc2, 0x8cda,
  0x8cf4, 0x96f7, 0x4e86, 0x50da, 0x5bee, 0x5ed6, 0x6599, 0x71ce,
  0x7642, 0x77ad, 0x804a, 0x84fc, 0x907c, 0x9b27, 0x9f8d, 0x58d8,
  0x5a41, 0x5c62, 0x6a13, 0x6dda, 0x6f0f, 0x763b, 0x7d2f, 0x7e37,
  0x851e, 0x8938, 0x93e4, 0x964b, 0x5289, 0x65d2, 0x67f3, 0x69b4,
  0x6d41, 0x6e9c, 0x700f, 0x7409, 0x7460, 0x7559, 0x7624, 0x786b,
  0x8b2c, 0x985e, 0x516d, 0x622e, 0x9678, 0x4f96, 0x502b, 0x5d19,
  0x6dea, 0x7db8, 0x8f2a, 0x5f8b, 0x6144, 0x6817, 0xf961, 0x9686,
  0x52d2, 0x808b, 0x51dc, 0x51cc, 0x695e, 0x7a1c, 0x7dbe, 0x83f1,
  0x9675, 0x4fda, 0x5229, 0x5398, 0x540f, 0x550e, 0x5c65, 0x60a7,
  0x674e, 0x68a8, 0x6d6c, 0x7281, 0x72f8, 0x7406, 0x7483, 0xf962,
  0x75e2, 0x7c6c, 0x7f79, 0x7fb8, 0x8389, 0x88cf, 0x88e1, 0x91cc,
  0x91d0, 0x96e2, 0x9bc9, 0x541d, 0x6f7e, 0x71d0, 0x7498, 0x85fa,
  0x8eaa, 0x96a3, 0x9c57, 0x9e9f, 0x6797, 0x6dcb, 0x7433, 0x81e8,
  0x9716, 0x782c, 0x7acb, 0x7b20, 0x7c92, 0x6469, 0x746a, 0x75f2,
  0x78bc, 0x78e8, 0x99ac, 0x9b54, 0x9ebb, 0x5bde, 0x5e55, 0x6f20,
  0x819c, 0x83ab, 0x9088, 0x4e07, 0x534d, 0x5a29, 0x5dd2, 0x5f4e,
  0x6162, 0x633d, 0x6669, 0x66fc, 0x6eff, 0x6f2b, 0x7063, 0x779e,
  0x842c, 0x8513, 0x883b, 0x8f13, 0x9945, 0x9c3b, 0x551c, 0x62b9,
  0x672b, 0x6cab, 0x8309, 0x896a, 0x977a, 0x4ea1, 0x5984, 0x5fd8,
  0x5fd9, 0x671b, 0x7db2, 0x7f54, 0x8292, 0x832b, 0x83bd, 0x8f1e,
  0x9099, 0x57cb, 0x59b9, 0x5a92, 0x5bd0, 0x6627, 0x679a, 0x6885,
  0x6bcf, 0x7164, 0x7f75, 0x8cb7, 0x8ce3, 0x9081, 0x9b45, 0x8108,
  0x8c8a, 0x964c, 0x9a40, 0x9ea5, 0x5b5f, 0x6c13, 0x731b, 0x76f2,
  0x76df, 0x840c, 0x51aa, 0x8993, 0x514d, 0x5195, 0x52c9, 0x68c9,
  0x6c94, 0x7704, 0x7720, 0x7dbf, 0x7dec, 0x9762, 0x9eb5, 0x6ec5,
  0x8511, 0x51a5, 0x540d, 0x547d, 0x660e, 0x669d, 0x6927, 0x6e9f,
  0x76bf, 0x7791, 0x8317, 0x84c2, 0x879f, 0x9169, 0x9298, 0x9cf4,
  0x8882, 0x4fae, 0x5192, 0x52df, 0x59c6, 0x5e3d, 0x6155, 0x6478,
  0x6479, 0x66ae, 0x67d0, 0x6a21, 0x6bcd, 0x6bdb, 0x725f, 0x7261,
  0x7441, 0x7738, 0x77db, 0x8017, 0x82bc, 0x8305, 0x8b00, 0x8b28,
  0x8c8c, 0x6728, 0x6c90, 0x7267, 0x76ee, 0x7766, 0x7a46, 0x9da9,
  0x6b7f, 0x6c92, 0x5922, 0x6726, 0x8499, 0x536f, 0x5893, 0x5999,
  0x5edf, 0x63cf, 0x6634, 0x6773, 0x6e3a, 0x732b, 0x7ad7, 0x82d7,
  0x9328, 0x52d9, 0x5deb, 0x61ae, 0x61cb, 0x620a, 0x62c7, 0x64ab,
  0x65e0, 0x6959, 0x6b66, 0x6bcb, 0x7121, 0x73f7, 0x755d, 0x7e46,
  0x821e, 0x8302, 0x856a, 0x8aa3, 0x8cbf, 0x9727, 0x9d61, 0x58a8,
  0x9ed8, 0x5011, 0x520e, 0x543b, 0x554f, 0x6587, 0x6c76, 0x7d0a,
  0x7d0b, 0x805e, 0x868a, 0x9580, 0x96ef, 0x52ff, 0x6c95, 0x7269,
  0x5473, 0x5a9a, 0x5c3e, 0x5d4b, 0x5f4c, 0x5fae, 0x672a, 0x68b6,
  0x6963, 0x6e3c, 0x6e44, 0x7709, 0x7c73, 0x7f8e, 0x8587, 0x8b0e,
  0x8ff7, 0x9761, 0x9ef4, 0x5cb7, 0x60b6, 0x610d, 0x61ab, 0x654f,
  0x65fb, 0x65fc, 0x6c11, 0x6cef, 0x739f, 0x73c9, 0x7de1, 0x9594,
  0x5bc6, 0x871c, 0x8b10, 0x525d, 0x535a, 0x62cd, 0x640f, 0x64b2,
  0x6734, 0x6a38, 0x6cca, 0x73c0, 0x749e, 0x7b94, 0x7c95, 0x7e1b,
  0x818a, 0x8236, 0x8584, 0x8feb, 0x96f9, 0x99c1, 0x4f34, 0x534a,
  0x53cd, 0x53db, 0x62cc, 0x642c, 0x6500, 0x6591, 0x69c3, 0x6cee,
  0x6f58, 0x73ed, 0x7554, 0x7622, 0x76e4, 0x76fc, 0x78d0, 0x78fb,
  0x792c, 0x7d46, 0x822c, 0x87e0, 0x8fd4, 0x9812, 0x98ef, 0x52c3,
  0x62d4, 0x64a5, 0x6e24, 0x6f51, 0x767c, 0x8dcb, 0x91b1, 0x9262,
  0x9aee, 0x9b43, 0x5023, 0x508d, 0x574a, 0x59a8, 0x5c28, 0x5e47,
  0x5f77, 0x623f, 0x653e, 0x65b9, 0x65c1, 0x6609, 0x678b, 0x699c,
  0x6ec2, 0x78c5, 0x7d21, 0x80aa, 0x8180, 0x822b, 0x82b3, 0x84a1,
  0x868c, 0x8a2a, 0x8b17, 0x90a6, 0x9632, 0x9f90, 0x500d, 0x4ff3,
  0xf963, 0x57f9, 0x5f98, 0x62dc, 0x6392, 0x676f, 0x6e43, 0x7119,
  0x76c3, 0x80cc, 0x80da, 0x88f4, 0x88f5, 0x8919, 0x8ce0, 0x8f29,
  0x914d, 0x966a, 0x4f2f, 0x4f70, 0x5e1b, 0x67cf, 0x6822, 0x767d,
  0x767e, 0x9b44, 0x5e61, 0x6a0a, 0x7169, 0x71d4, 0x756a, 0xf964,
  0x7e41, 0x8543, 0x85e9, 0x98dc, 0x4f10, 0x7b4f, 0x7f70, 0x95a5,
  0x51e1, 0x5e06, 0x68b5, 0x6c3e, 0x6c4e, 0x6cdb, 0x72af, 0x7bc4,
  0x8303, 0x6cd5, 0x743a, 0x50fb, 0x5288, 0x58c1, 0x64d8, 0x6a97,
  0x74a7, 0x7656, 0x78a7, 0x8617, 0x95e2, 0x9739, 0xf965, 0x535e,
  0x5f01, 0x8b8a, 0x8fa8, 0x8faf, 0x908a, 0x5225, 0x77a5, 0x9c49,
  0x9f08, 0x4e19, 0x5002, 0x5175, 0x5c5b, 0x5e77, 0x661e, 0x663a,
  0x67c4, 0x68c5, 0x70b3, 0x7501, 0x75c5, 0x79c9, 0x7add, 0x8f27,
  0x9920, 0x9a08, 0x4fdd, 0x5821, 0x5831, 0x5bf6, 0x666e, 0x6b65,
  0x6d11, 0x6e7a, 0x6f7d, 0x73e4, 0x752b, 0x83e9, 0x88dc, 0x8913,
  0x8b5c, 0x8f14, 0x4f0f, 0x50d5, 0x5310, 0x535c, 0x5b93, 0x5fa9,
  0x670d, 0x798f, 0x8179, 0x832f, 0x8514, 0x8907, 0x8986, 0x8f39,
  0x8f3b, 0x99a5, 0x9c12, 0x672c, 0x4e76, 0x4ff8, 0x5949, 0x5c01,
  0x5cef, 0x5cf0, 0x6367, 0x68d2, 0x70fd, 0x71a2, 0x742b, 0x7e2b,
  0x84ec, 0x8702, 0x9022, 0x92d2, 0x9cf3, 0x4e0d, 0x4ed8, 0x4fef,
  0x5085, 0x5256, 0x526f, 0x5426, 0x5490, 0x57e0, 0x592b, 0x5a66,
  0x5b5a, 0x5b75, 0x5bcc, 0x5e9c, 0xf966, 0x6276, 0x6577, 0x65a7,
  0x6d6e, 0x6ea5, 0x7236, 0x7b26, 0x7c3f, 0x7f36, 0x8150, 0x8151,
  0x819a, 0x8240, 0x8299, 0x83a9, 0x8a03, 0x8ca0, 0x8ce6, 0x8cfb,
  0x8d74, 0x8dba, 0x90e8, 0x91dc, 0x961c, 0x9644, 0x99d9, 0x9ce7,
  0x5317, 0x5206, 0x5429, 0x5674, 0x58b3, 0x5954, 0x596e, 0x5fff,
  0x61a4, 0x626e, 0x6610, 0x6c7e, 0x711a, 0x76c6, 0x7c89, 0x7cde,
  0x7d1b, 0x82ac, 0x8cc1, 0x96f0, 0xf967, 0x4f5b, 0x5f17, 0x5f7f,
  0x62c2, 0x5d29, 0x670b, 0x68da, 0x787c, 0x7e43, 0x9d6c, 0x4e15,
  0x5099, 0x5315, 0x532a, 0x5351, 0x5983, 0x5a62, 0x5e87, 0x60b2,
  0x618a, 0x6249, 0x6279, 0x6590, 0x6787, 0x69a7, 0x6bd4, 0x6bd6,
  0x6bd7, 0x6bd8, 0x6cb8, 0xf968, 0x7435, 0x75fa, 0x7812, 0x7891,
  0x79d5, 0x79d8, 0x7c83, 0x7dcb, 0x7fe1, 0x80a5, 0x813e, 0x81c2,
  0x83f2, 0x871a, 0x88e8, 0x8ab9, 0x8b6c, 0x8cbb, 0x9119, 0x975e,
  0x98db, 0x9f3b, 0x56ac, 0x5b2a, 0x5f6c, 0x658c, 0x6ab3, 0x6baf,
  0x6d5c, 0x6ff1, 0x7015, 0x725d, 0x73ad, 0x8ca7, 0x8cd3, 0x983b,
  0x6191, 0x6c37, 0x8058, 0x9a01, 0x4e4d, 0x4e8b, 0x4e9b, 0x4ed5,
  0x4f3a, 0x4f3c, 0x4f7f, 0x4fdf, 0x50ff, 0x53f2, 0x53f8, 0x5506,
  0x55e3, 0x56db, 0x58eb, 0x5962, 0x5a11, 0x5beb, 0x5bfa, 0x5c04,
  0x5df3, 0x5e2b, 0x5f99, 0x601d, 0x6368, 0x659c, 0x65af, 0x67f6,
  0x67fb, 0x68ad, 0x6b7b, 0x6c99, 0x6cd7, 0x6e23, 0x7009, 0x7345,
  0x7802, 0x793e, 0x7940, 0x7960, 0x79c1, 0x7be9, 0x7d17, 0x7d72,
  0x8086, 0x820d, 0x838e, 0x84d1, 0x86c7, 0x88df, 0x8a50, 0x8a5e,
  0x8b1d, 0x8cdc, 0x8d66, 0x8fad, 0x90aa, 0x98fc, 0x99df, 0x9e9d,
  0x524a, 0xf969, 0x6714, 0xf96a, 0x5098, 0x522a, 0x5c71, 0x6563,
  0x6c55, 0x73ca, 0x7523, 0x759d, 0x7b97, 0x849c, 0x9178, 0x9730,
  0x4e77, 0x6492, 0x6bba, 0x715e, 0x85a9, 0x4e09, 0xf96b, 0x6749,
  0x68ee, 0x6e17, 0x829f, 0x8518, 0x886b, 0x63f7, 0x6f81, 0x9212,
  0x98af, 0x4e0a, 0x50b7, 0x50cf, 0x511f, 0x5546, 0x55aa, 0x5617,
  0x5b40, 0x5c19, 0x5ce0, 0x5e38, 0x5e8a, 0x5ea0, 0x5ec2, 0x60f3,
  0x6851, 0x6a61, 0x6e58, 0x723d, 0x7240, 0x72c0, 0x76f8, 0x7965,
  0x7bb1, 0x7fd4, 0x88f3, 0x89f4, 0x8a73, 0x8c61, 0x8cde, 0x971c,
  0x585e, 0x74bd, 0x8cfd, 0x55c7, 0xf96c, 0x7a61, 0x7d22, 0x8272,
  0x7272, 0x751f, 0x7525, 0xf96d, 0x7b19, 0x5885, 0x58fb, 0x5dbc,
  0x5e8f, 0x5eb6, 0x5f90, 0x6055, 0x6292, 0x637f, 0x654d, 0x6691,
  0x66d9, 0x66f8, 0x6816, 0x68f2, 0x7280, 0x745e, 0x7b6e, 0x7d6e,
  0x7dd6, 0x7f72, 0x80e5, 0x8212, 0x85af, 0x897f, 0x8a93, 0x901d,
  0x92e4, 0x9ecd, 0x9f20, 0x5915, 0x596d, 0x5e2d, 0x60dc, 0x6614,
  0x6673, 0x6790, 0x6c50, 0x6dc5, 0x6f5f, 0x77f3, 0x78a9, 0x84c6,
  0x91cb, 0x932b, 0x4ed9, 0x50ca, 0x5148, 0x5584, 0x5b0b, 0x5ba3,
  0x6247, 0x657e, 0x65cb, 0x6e32, 0x717d, 0x7401, 0x7444, 0x7487,
  0x74bf, 0x766c, 0x79aa, 0x7dda, 0x7e55, 0x7fa8, 0x817a, 0x81b3,
  0x8239, 0x861a, 0x87ec, 0x8a75, 0x8de3, 0x9078, 0x9291, 0x9425,
  0x994d, 0x9bae, 0x5368, 0x5c51, 0x6954, 0x6cc4, 0x6d29, 0x6e2b,
  0x820c, 0x859b, 0x893b, 0x8a2d, 0x8aaa, 0x96ea, 0x9f67, 0x5261,
  0x66b9, 0x6bb2, 0x7e96, 0x87fe, 0x8d0d, 0x9583, 0x965d, 0x651d,
  0x6d89, 0x71ee, 0xf96e, 0x57ce, 0x59d3, 0x5bac, 0x6027, 0x60fa,
  0x6210, 0x661f, 0x665f, 0x7329, 0x73f9, 0x76db, 0x7701, 0x7b6c,
  0x8056, 0x8072, 0x8165, 0x8aa0, 0x9192, 0x4e16, 0x52e2, 0x6b72,
  0x6d17, 0x7a05, 0x7b39, 0x7d30, 0xf96f, 0x8cb0, 0x53ec, 0x562f,
  0x5851, 0x5bb5, 0x5c0f, 0x5c11, 0x5de2, 0x6240, 0x6383, 0x6414,
  0x662d, 0x68b3, 0x6cbc, 0x6d88, 0x6eaf, 0x701f, 0x70a4, 0x71d2,
  0x7526, 0x758f, 0x758e, 0x7619, 0x7b11, 0x7be0, 0x7c2b, 0x7d20,
  0x7d39, 0x852c, 0x856d, 0x8607, 0x8a34, 0x900d, 0x9061, 0x90b5,
  0x92b7, 0x97f6, 0x9a37, 0x4fd7, 0x5c6c, 0x675f, 0x6d91, 0x7c9f,
  0x7e8c, 0x8b16, 0x8d16, 0x901f, 0x5b6b, 0x5dfd, 0x640d, 0x84c0,
  0x905c, 0x98e1, 0x7387, 0x5b8b, 0x609a, 0x677e, 0x6dde, 0x8a1f,
  0x8aa6, 0x9001, 0x980c, 0x5237, 0xf970, 0x7051, 0x788e, 0x9396,
  0x8870, 0x91d7, 0x4fee, 0x53d7, 0x55fd, 0x56da, 0x5782, 0x58fd,
  0x5ac2, 0x5b88, 0x5cab, 0x5cc0, 0x5e25, 0x6101, 0x620d, 0x624b,
  0x6388, 0x641c, 0x6536, 0x6578, 0x6a39, 0x6b8a, 0x6c34, 0x6d19,
  0x6f31, 0x71e7, 0x72e9, 0x7378, 0x7407, 0x74b2, 0x7626, 0x7761,
  0x79c0, 0x7a57, 0x7aea, 0x7cb9, 0x7d8f, 0x7dac, 0x7e61, 0x7f9e,
  0x8129, 0x8331, 0x8490, 0x84da, 0x85ea, 0x8896, 0x8ab0, 0x8b90,
  0x8f38, 0x9042, 0x9083, 0x916c, 0x9296, 0x92b9, 0x968b, 0x96a7,
  0x96a8, 0x96d6, 0x9700, 0x9808, 0x9996, 0x9ad3, 0x9b1a, 0x53d4,
  0x587e, 0x5919, 0x5b70, 0x5bbf, 0x6dd1, 0x6f5a, 0x719f, 0x7421,
  0x74b9, 0x8085, 0x83fd, 0x5de1, 0x5f87, 0x5faa, 0x6042, 0x65ec,
  0x6812, 0x696f, 0x6a53, 0x6b89, 0x6d35, 0x6df3, 0x73e3, 0x76fe,
  0x77ac, 0x7b4d, 0x7d14, 0x8123, 0x821c, 0x8340, 0x84f4, 0x8563,
  0x8a62, 0x8ac4, 0x9187, 0x931e, 0x9806, 0x99b4, 0x620c, 0x8853,
  0x8ff0, 0x9265, 0x5d07, 0x5d27, 0x5d69, 0x745f, 0x819d, 0x8768,
  0x6fd5, 0x62fe, 0x7fd2, 0x8936, 0x8972, 0x4e1e, 0x4e58, 0x50e7,
  0x52dd, 0x5347, 0x627f, 0x6607, 0x7e69, 0x8805, 0x965e, 0x4f8d,
  0x5319, 0x5636, 0x59cb, 0x5aa4, 0x5c38, 0x5c4e, 0x5c4d, 0x5e02,
  0x5f11, 0x6043, 0x65bd, 0x662f, 0x6642, 0x67be, 0x67f4, 0x731c,
  0x77e2, 0x793a, 0x7fc5, 0x8494, 0x84cd, 0x8996, 0x8a66, 0x8a69,
  0x8ae1, 0x8c55, 0x8c7a, 0x57f4, 0x5bd4, 0x5f0f, 0x606f, 0x62ed,
  0x690d, 0x6b96, 0x6e5c, 0x7184, 0x7bd2, 0x8755, 0x8b58, 0x8efe,
  0x98df, 0x98fe, 0x4f38, 0x4f81, 0x4fe1, 0x547b, 0x5a20, 0x5bb8,
  0x613c, 0x65b0, 0x6668, 0x71fc, 0x7533, 0x795e, 0x7d33, 0x814e,
  0x81e3, 0x8398, 0x85aa, 0x85ce, 0x8703, 0x8a0a, 0x8eab, 0x8f9b,
  0xf971, 0x8fc5, 0x5931, 0x5ba4, 0x5be6, 0x6089, 0x5be9, 0x5c0b,
  0x5fc3, 0x6c81, 0xf972, 0x6df1, 0x700b, 0x751a, 0x82af, 0x8af6,
  0x4ec0, 0x5341, 0xf973, 0x96d9, 0x6c0f, 0x4e9e, 0x4fc4, 0x5152,
  0x555e, 0x5a25, 0x5ce8, 0x6211, 0x7259, 0x82bd, 0x83aa, 0x86fe,
  0x8859, 0x8a1d, 0x963f, 0x96c5, 0x9913, 0x9d09, 0x9d5d, 0x580a,
  0x5cb3, 0x5dbd, 0x5e44, 0x60e1, 0x6115, 0x63e1, 0x6a02, 0x6e25,
  0x9102, 0x9354, 0x984e, 0x9c10, 0x9f77, 0x5b89, 0x5cb8, 0x6309,
  0x664f, 0x6848, 0x773c, 0x96c1, 0x978d, 0x9854, 0x9b9f, 0x65a1,
  0x8b01, 0x8ecb, 0x95bc, 0x5535, 0x5ca9, 0x5dd6, 0x5eb5, 0x6697,
  0x764c, 0x83f4, 0x95c7, 0x58d3, 0x62bc, 0x72ce, 0x9d28, 0x4ef0,
  0x592e, 0x600f, 0x663b, 0x6b83, 0x79e7, 0x9d26, 0x5393, 0x54c0,
  0x57c3, 0x5d16, 0x611b, 0x66d6, 0x6daf, 0x788d, 0x827e, 0x9698,
  0x9744, 0x5384, 0x627c, 0x6396, 0x6db2, 0x7e0a, 0x814b, 0x984d,
  0x6afb, 0x7f4c, 0x9daf, 0x9e1a, 0x4e5f, 0x503b, 0x51b6, 0x591c,
  0x60f9, 0x63f6, 0x6930, 0x723a, 0x8036, 0xf974, 0x91ce, 0x5f31,
  0xf975, 0xf976, 0x7d04, 0x82e5, 0x846f, 0x84bb, 0x85e5, 0x8e8d,
  0xf977, 0x4f6f, 0xf978, 0xf979, 0x58e4, 0x5b43, 0x6059, 0x63da,
  0x6518, 0x656d, 0x6698, 0xf97a, 0x694a, 0x6a23, 0x6d0b, 0x7001,
  0x716c, 0x75d2, 0x760d, 0x79b3, 0x7a70, 0xf97b, 0x7f8a, 0xf97c,
  0x8944, 0xf97d, 0x8b93, 0x91c0, 0x967d, 0xf97e, 0x990a, 0x5704,
  0x5fa1, 0x65bc, 0x6f01, 0x7600, 0x79a6, 0x8a9e, 0x99ad, 0x9b5a,
  0x9f6c, 0x5104, 0x61b6, 0x6291, 0x6a8d, 0x81c6, 0x5043, 0x5830,
  0x5f66, 0x7109, 0x8a00, 0x8afa, 0x5b7c, 0x8616, 0x4ffa, 0x513c,
  0x56b4, 0x5944, 0x63a9, 0x6df9, 0x5daa, 0x696d, 0x5186, 0x4e88,
  0x4f59, 0xf97f, 0xf980, 0xf981, 0x5982, 0xf982, 0xf983, 0x6b5f,
  0x6c5d, 0xf984, 0x74b5, 0x7916, 0xf985, 0x8207, 0x8245, 0x8339,
  0x8f3f, 0x8f5d, 0xf986, 0x9918, 0xf987, 0xf988, 0xf989, 0x4ea6,
  0xf98a, 0x57df, 0x5f79, 0x6613, 0xf98b, 0xf98c, 0x75ab, 0x7e79,
  0x8b6f, 0xf98d, 0x9006, 0x9a5b, 0x56a5, 0x5827, 0x59f8, 0x5a1f,
  0x5bb4, 0xf98e, 0x5ef6, 0xf98f, 0xf990, 0x6350, 0x633b, 0xf991,
  0x693d, 0x6c87, 0x6cbf, 0x6d8e, 0x6d93, 0x6df5, 0x6f14, 0xf992,
  0x70df, 0x7136, 0x7159, 0xf993, 0x71c3, 0x71d5, 0xf994, 0x784f,
  0x786f, 0xf995, 0x7b75, 0x7de3, 0xf996, 0x7e2f, 0xf997, 0x884d,
  0x8edf, 0xf998, 0xf999, 0xf99a, 0x925b, 0xf99b, 0x9cf6, 0xf99c,
  0xf99d, 0xf99e, 0x6085, 0x6d85, 0xf99f, 0x71b1, 0xf9a0, 0xf9a1,
  0x95b1, 0x53ad, 0xf9a2, 0xf9a3, 0xf9a4, 0x67d3, 0xf9a5, 0x708e,
  0x7130, 0x7430, 0x8276, 0x82d2, 0xf9a6, 0x95bb, 0x9ae5, 0x9e7d,
  0x66c4, 0xf9a7, 0x71c1, 0x8449, 0xf9a8, 0xf9a9, 0x584b, 0xf9aa,
  0xf9ab, 0x5db8, 0x5f71, 0xf9ac, 0x6620, 0x668e, 0x6979, 0x69ae,
  0x6c38, 0x6cf3, 0x6e36, 0x6f41, 0x6fda, 0x701b, 0x702f, 0x7150,
  0x71df, 0x7370, 0xf9ad, 0x745b, 0xf9ae, 0x74d4, 0x76c8, 0x7a4e,
  0x7e93, 0xf9af, 0xf9b0, 0x82f1, 0x8a60, 0x8fce, 0xf9b1, 0x9348,
  0xf9b2, 0x9719, 0xf9b3, 0xf9b4, 0x4e42, 0x502a, 0xf9b5, 0x5208,
  0x53e1, 0x66f3, 0x6c6d, 0x6fca, 0x730a, 0x777f, 0x7a62, 0x82ae,
  0x85dd, 0x8602, 0xf9b6, 0x88d4, 0x8a63, 0x8b7d, 0x8c6b, 0xf9b7,
  0x92b3, 0xf9b8, 0x9713, 0x9810, 0x4e94, 0x4f0d, 0x4fc9, 0x50b2,
  0x5348, 0x543e, 0x5433, 0x55da, 0x5862, 0x58ba, 0x5967, 0x5a1b,
  0x5be4, 0x609f, 0xf9b9, 0x61ca, 0x6556, 0x65ff, 0x6664, 0x68a7,
  0x6c5a, 0x6fb3, 0x70cf, 0x71ac, 0x7352, 0x7b7d, 0x8708, 0x8aa4,
  0x9c32, 0x9f07, 0x5c4b, 0x6c83, 0x7344, 0x7389, 0x923a, 0x6eab,
  0x7465, 0x761f, 0x7a69, 0x7e15, 0x860a, 0x5140, 0x58c5, 0x64c1,
  0x74ee, 0x7515, 0x7670, 0x7fc1, 0x9095, 0x96cd, 0x9954, 0x6e26,
  0x74e6, 0x7aa9, 0x7aaa, 0x81e5, 0x86d9, 0x8778, 0x8a1b, 0x5a49,
  0x5b8c, 0x5b9b, 0x68a1, 0x6900, 0x6d63, 0x73a9, 0x7413, 0x742c,
  0x7897, 0x7de9, 0x7feb, 0x8118, 0x8155, 0x839e, 0x8c4c, 0x962e,
  0x9811, 0x66f0, 0x5f80, 0x65fa, 0x6789, 0x6c6a, 0x738b, 0x502d,
  0x5a03, 0x6b6a, 0x77ee, 0x5916, 0x5d6c, 0x5dcd, 0x7325, 0x754f,
  0xf9ba, 0xf9bb, 0x50e5, 0x51f9, 0x582f, 0x592d, 0x5996, 0x59da,
  0x5be5, 0xf9bc, 0xf9bd, 0x5da2, 0x62d7, 0x6416, 0x6493, 0x64fe,
  0xf9be, 0x66dc, 0xf9bf, 0x6a48, 0xf9c0, 0x71ff, 0x7464, 0xf9c1,
  0x7a88, 0x7aaf, 0x7e47, 0x7e5e, 0x8000, 0x8170, 0xf9c2, 0x87ef,
  0x8981, 0x8b20, 0x9059, 0xf9c3, 0x9080, 0x9952, 0x617e, 0x6b32,
  0x6d74, 0x7e1f, 0x8925, 0x8fb1, 0x4fd1, 0x50ad, 0x5197, 0x52c7,
  0x57c7, 0x5889, 0x5bb9, 0x5eb8, 0x6142, 0x6995, 0x6d8c, 0x6e67,
  0x6eb6, 0x7194, 0x7462, 0x7528, 0x752c, 0x8073, 0x8338, 0x84c9,
  0x8e0a, 0x9394, 0x93de, 0xf9c4, 0x4e8e, 0x4f51, 0x5076, 0x512a,
  0x53c8, 0x53cb, 0x53f3, 0x5b87, 0x5bd3, 0x5c24, 0x611a, 0x6182,
  0x65f4, 0x725b, 0x7397, 0x7440, 0x76c2, 0x7950, 0x7991, 0x79b9,
  0x7d06, 0x7fbd, 0x828b, 0x85d5, 0x865e, 0x8fc2, 0x9047, 0x90f5,
  0x91ea, 0x9685, 0x96e8, 0x96e9, 0x52d6, 0x5f67, 0x65ed, 0x6631,
  0x682f, 0x715c, 0x7a36, 0x90c1, 0x980a, 0x4e91, 0xf9c5, 0x6a52,
  0x6b9e, 0x6f90, 0x7189, 0x8018, 0x82b8, 0x8553, 0x904b, 0x9695,
  0x96f2, 0x97fb, 0x851a, 0x9b31, 0x4e90, 0x718a, 0x96c4, 0x5143,
  0x539f, 0x54e1, 0x5713, 0x5712, 0x57a3, 0x5a9b, 0x5ac4, 0x5bc3,
  0x6028, 0x613f, 0x63f4, 0x6c85, 0x6d39, 0x6e72, 0x6e90, 0x7230,
  0x733f, 0x7457, 0x82d1, 0x8881, 0x8f45, 0x9060, 0xf9c6, 0x9662,
  0x9858, 0x9d1b, 0x6708, 0x8d8a, 0x925e, 0x4f4d, 0x5049, 0x50de,
  0x5371, 0x570d, 0x59d4, 0x5a01, 0x5c09, 0x6170, 0x6690, 0x6e2d,
  0x7232, 0x744b, 0x7def, 0x80c3, 0x840e, 0x8466, 0x853f, 0x875f,
  0x885b, 0x8918, 0x8b02, 0x9055, 0x97cb, 0x9b4f, 0x4e73, 0x4f91,
  0x5112, 0x516a, 0xf9c7, 0x552f, 0x55a9, 0x5b7a, 0x5ba5, 0x5e7c,
  0x5e7d, 0x5ebe, 0x60a0, 0x60df, 0x6108, 0x6109, 0x63c4, 0x6538,
  0x6709, 0xf9c8, 0x67d4, 0x67da, 0xf9c9, 0x6961, 0x6962, 0x6cb9,
  0x6d27, 0xf9ca, 0x6e38, 0xf9cb, 0x6fe1, 0x7336, 0x7337, 0xf9cc,
  0x745c, 0x7531, 0xf9cd, 0x7652, 0xf9ce, 0xf9cf, 0x7dad, 0x81fe,
  0x8438, 0x88d5, 0x8a98, 0x8adb, 0x8aed, 0x8e30, 0x8e42, 0x904a,
  0x903e, 0x907a, 0x9149, 0x91c9, 0x936e, 0xf9d0, 0xf9d1, 0x5809,
  0xf9d2, 0x6bd3, 0x8089, 0x80b2, 0xf9d3, 0xf9d4, 0x5141, 0x596b,
  0x5c39, 0xf9d5, 0xf9d6, 0x6f64, 0x73a7, 0x80e4, 0x8d07, 0xf9d7,
  0x9217, 0x958f, 0xf9d8, 0xf9d9, 0xf9da, 0xf9db, 0x807f, 0x620e,
  0x701c, 0x7d68, 0x878d, 0xf9dc, 0x57a0, 0x6069, 0x6147, 0x6bb7,
  0x8abe, 0x9280, 0x96b1, 0x4e59, 0x541f, 0x6deb, 0x852d, 0x9670,
  0x97f3, 0x98ee, 0x63d6, 0x6ce3, 0x9091, 0x51dd, 0x61c9, 0x81ba,
  0x9df9, 0x4f9d, 0x501a, 0x5100, 0x5b9c, 0x610f, 0x61ff, 0x64ec,
  0x6905, 0x6bc5, 0x7591, 0x77e3, 0x7fa9, 0x8264, 0x858f, 0x87fb,
  0x8863, 0x8abc, 0x8b70, 0x91ab, 0x4e8c, 0x4ee5, 0x4f0a, 0xf9dd,
  0xf9de, 0x5937, 0x59e8, 0xf9df, 0x5df2, 0x5f1b, 0x5f5b, 0x6021,
  0xf9e0, 0xf9e1, 0xf9e2, 0xf9e3, 0x723e, 0x73e5, 0xf9e4, 0x7570,
  0x75cd, 0xf9e5, 0x79fb, 0xf9e6, 0x800c, 0x8033, 0x8084, 0x82e1,
  0x8351, 0xf9e7, 0xf9e8, 0x8cbd, 0x8cb3, 0x9087, 0xf9e9, 0xf9ea,
  0x98f4, 0x990c, 0xf9eb, 0xf9ec, 0x7037, 0x76ca, 0x7fca, 0x7fcc,
  0x7ffc, 0x8b1a, 0x4eba, 0x4ec1, 0x5203, 0x5370, 0xf9ed, 0x54bd,
  0x56e0, 0x59fb, 0x5bc5, 0x5f15, 0x5fcd, 0x6e6e, 0xf9ee, 0xf9ef,
  0x7d6a, 0x8335, 0xf9f0, 0x8693, 0x8a8d, 0xf9f1, 0x976d, 0x9777,
  0xf9f2, 0xf9f3, 0x4e00, 0x4f5a, 0x4f7e, 0x58f9, 0x65e5, 0x6ea2,
  0x9038, 0x93b0, 0x99b9, 0x4efb, 0x58ec, 0x598a, 0x59d9, 0x6041,
  0xf9f4, 0xf9f5, 0x7a14, 0xf9f6, 0x834f, 0x8cc3, 0x5165, 0x5344,
  0xf9f7, 0xf9f8, 0xf9f9, 0x4ecd, 0x5269, 0x5b55, 0x82bf, 0x4ed4,
  0x523a, 0x54a8, 0x59c9, 0x59ff, 0x5b50, 0x5b57, 0x5b5c, 0x6063,
  0x6148, 0x6ecb, 0x7099, 0x716e, 0x7386, 0x74f7, 0x75b5, 0x78c1,
  0x7d2b, 0x8005, 0x81ea, 0x8328, 0x8517, 0x85c9, 0x8aee, 0x8cc7,
  0x96cc, 0x4f5c, 0x52fa, 0x56bc, 0x65ab, 0x6628, 0x707c, 0x70b8,
  0x7235, 0x7dbd, 0x828d, 0x914c, 0x96c0, 0x9d72, 0x5b71, 0x68e7,
  0x6b98, 0x6f7a, 0x76de, 0x5c91, 0x66ab, 0x6f5b, 0x7bb4, 0x7c2a,
  0x8836, 0x96dc, 0x4e08, 0x4ed7, 0x5320, 0x5834, 0x58bb, 0x58ef,
  0x596c, 0x5c07, 0x5e33, 0x5e84, 0x5f35, 0x638c, 0x66b2, 0x6756,
  0x6a1f, 0x6aa3, 0x6b0c, 0x6f3f, 0x7246, 0xf9fa, 0x7350, 0x748b,
  0x7ae0, 0x7ca7, 0x8178, 0x81df, 0x81e7, 0x838a, 0x846c, 0x8523,
  0x8594, 0x85cf, 0x88dd, 0x8d13, 0x91ac, 0x9577, 0x969c, 0x518d,
  0x54c9, 0x5728, 0x5bb0, 0x624d, 0x6750, 0x683d, 0x6893, 0x6e3d,
  0x6ed3, 0x707d, 0x7e21, 0x88c1, 0x8ca1, 0x8f09, 0x9f4b, 0x9f4e,
  0x722d, 0x7b8f, 0x8acd, 0x931a, 0x4f47, 0x4f4e, 0x5132, 0x5480,
  0x59d0, 0x5e95, 0x62b5, 0x6775, 0x696e, 0x6a17, 0x6cae, 0x6e1a,
  0x72d9, 0x732a, 0x75bd, 0x7bb8, 0x7d35, 0x82e7, 0x83f9, 0x8457,
  0x85f7, 0x8a5b, 0x8caf, 0x8e87, 0x9019, 0x90b8, 0x96ce, 0x9f5f,
  0x52e3, 0x540a, 0x5ae1, 0x5bc2, 0x6458, 0x6575, 0x6ef4, 0x72c4,
  0xf9fb, 0x7684, 0x7a4d, 0x7b1b, 0x7c4d, 0x7e3e, 0x7fdf, 0x837b,
  0x8b2b, 0x8cca, 0x8d64, 0x8de1, 0x8e5f, 0x8fea, 0x8ff9, 0x9069,
  0x93d1, 0x4f43, 0x4f7a, 0x50b3, 0x5168, 0x5178, 0x524d, 0x526a,
  0x5861, 0x587c, 0x5960, 0x5c08, 0x5c55, 0x5edb, 0x609b, 0x6230,
  0x6813, 0x6bbf, 0x6c08, 0x6fb1, 0x714e, 0x7420, 0x7530, 0x7538,
  0x7551, 0x7672, 0x7b4c, 0x7b8b, 0x7bad, 0x7bc6, 0x7e8f, 0x8a6e,
  0x8f3e, 0x8f49, 0x923f, 0x9293, 0x9322, 0x942b, 0x96fb, 0x985a,
  0x986b, 0x991e, 0x5207, 0x622a, 0x6298, 0x6d59, 0x7664, 0x7aca,
  0x7bc0, 0x7d76, 0x5360, 0x5cbe, 0x5e97, 0x6f38, 0x70b9, 0x7c98,
  0x9711, 0x9b8e, 0x9ede, 0x63a5, 0x647a, 0x8776, 0x4e01, 0x4e95,
  0x4ead, 0x505c, 0x5075, 0x5448, 0x59c3, 0x5b9a, 0x5e40, 0x5ead,
  0x5ef7, 0x5f81, 0x60c5, 0x633a, 0x653f, 0x6574, 0x65cc, 0x6676,
  0x6678, 0x67fe, 0x6968, 0x6a89, 0x6b63, 0x6c40, 0x6dc0, 0x6de8,
  0x6e1f, 0x6e5e, 0x701e, 0x70a1, 0x738e, 0x73fd, 0x753a, 0x775b,
  0x7887, 0x798e, 0x7a0b, 0x7a7d, 0x7cbe, 0x7d8e, 0x8247, 0x8a02,
  0x8aea, 0x8c9e, 0x912d, 0x914a, 0x91d8, 0x9266, 0x92cc, 0x9320,
  0x9706, 0x9756, 0x975c, 0x9802, 0x9f0e, 0x5236, 0x5291, 0x557c,
  0x5824, 0x5e1d, 0x5f1f, 0x608c, 0x63d0, 0x68af, 0x6fdf, 0x796d,
  0x7b2c, 0x81cd, 0x85ba, 0x88fd, 0x8af8, 0x8e44, 0x918d, 0x9664,
  0x969b, 0x973d, 0x984c, 0x9f4a, 0x4fce, 0x5146, 0x51cb, 0x52a9,
  0x5632, 0x5f14, 0x5f6b, 0x63aa, 0x64cd, 0x65e9, 0x6641, 0x66fa,
  0x66f9, 0x671d, 0x689d, 0x68d7, 0x69fd, 0x6f15, 0x6f6e, 0x7167,
  0x71e5, 0x722a, 0x74aa, 0x773a, 0x7956, 0x795a, 0x79df, 0x7a20,
  0x7a95, 0x7c97, 0x7cdf, 0x7d44, 0x7e70, 0x8087, 0x85fb, 0x86a4,
  0x8a54, 0x8abf, 0x8d99, 0x8e81, 0x9020, 0x906d, 0x91e3, 0x963b,
  0x96d5, 0x9ce5, 0x65cf, 0x7c07, 0x8db3, 0x93c3, 0x5b58, 0x5c0a,
  0x5352, 0x62d9, 0x731d, 0x5027, 0x5b97, 0x5f9e, 0x60b0, 0x616b,
  0x68d5, 0x6dd9, 0x742e, 0x7a2e, 0x7d42, 0x7d9c, 0x7e31, 0x816b,
  0x8e2a, 0x8e35, 0x937e, 0x9418, 0x4f50, 0x5750, 0x5de6, 0x5ea7,
  0x632b, 0x7f6a, 0x4e3b, 0x4f4f, 0x4f8f, 0x505a, 0x59dd, 0x80c4,
  0x546a, 0x5468, 0x55fe, 0x594f, 0x5b99, 0x5dde, 0x5eda, 0x665d,
  0x6731, 0x67f1, 0x682a, 0x6ce8, 0x6d32, 0x6e4a, 0x6f8d, 0x70b7,
  0x73e0, 0x7587, 0x7c4c, 0x7d02, 0x7d2c, 0x7da2, 0x821f, 0x86db,
  0x8a3b, 0x8a85, 0x8d70, 0x8e8a, 0x8f33, 0x9031, 0x914e, 0x9152,
  0x9444, 0x99d0, 0x7af9, 0x7ca5, 0x4fca, 0x5101, 0x51c6, 0x57c8,
  0x5bef, 0x5cfb, 0x6659, 0x6a3d, 0x6d5a, 0x6e96, 0x6fec, 0x710c,
  0x756f, 0x7ae3, 0x8822, 0x9021, 0x9075, 0x96cb, 0x99ff, 0x8301,
  0x4e2d, 0x4ef2, 0x8846, 0x91cd, 0x537d, 0x6adb, 0x696b, 0x6c41,
  0x847a, 0x589e, 0x618e, 0x66fe, 0x62ef, 0x70dd, 0x7511, 0x75c7,
  0x7e52, 0x84b8, 0x8b49, 0x8d08, 0x4e4b, 0x53ea, 0x54ab, 0x5730,
  0x5740, 0x5fd7, 0x6301, 0x6307, 0x646f, 0x652f, 0x65e8, 0x667a,
  0x679d, 0x67b3, 0x6b62, 0x6c60, 0x6c9a, 0x6f2c, 0x77e5, 0x7825,
  0x7949, 0x7957, 0x7d19, 0x80a2, 0x8102, 0x81f3, 0x829d, 0x82b7,
  0x8718, 0x8a8c, 0xf9fc, 0x8d04, 0x8dbe, 0x9072, 0x76f4, 0x7a19,
  0x7a37, 0x7e54, 0x8077, 0x5507, 0x55d4, 0x5875, 0x632f, 0x6422,
  0x6649, 0x664b, 0x686d, 0x699b, 0x6b84, 0x6d25, 0x6eb1, 0x73cd,
  0x7468, 0x74a1, 0x755b, 0x75b9, 0x76e1, 0x771e, 0x778b, 0x79e6,
  0x7e09, 0x7e1d, 0x81fb, 0x852f, 0x8897, 0x8a3a, 0x8cd1, 0x8eeb,
  0x8fb0, 0x9032, 0x93ad, 0x9663, 0x9673, 0x9707, 0x4f84, 0x53f1,
  0x59ea, 0x5ac9, 0x5e19, 0x684e, 0x74c6, 0x75be, 0x79e9, 0x7a92,
  0x81a3, 0x86ed, 0x8cea, 0x8dcc, 0x8fed, 0x659f, 0x6715, 0xf9fd,
  0x57f7, 0x6f57, 0x7ddd, 0x8f2f, 0x93f6, 0x96c6, 0x5fb5, 0x61f2,
  0x6f84, 0x4e14, 0x4f98, 0x501f, 0x53c9, 0x55df, 0x5d6f, 0x5dee,
  0x6b21, 0x6b64, 0x78cb, 0x7b9a, 0xf9fe, 0x8e49, 0x8eca, 0x906e,
  0x6349, 0x643e, 0x7740, 0x7a84, 0x932f, 0x947f, 0x9f6a, 0x64b0,
  0x6faf, 0x71e6, 0x74a8, 0x74da, 0x7ac4, 0x7c12, 0x7e82, 0x7cb2,
  0x7e98, 0x8b9a, 0x8d0a, 0x947d, 0x9910, 0x994c, 0x5239, 0x5bdf,
  0x64e6, 0x672d, 0x7d2e, 0x50ed, 0x53c3, 0x5879, 0x6158, 0x6159,
  0x61fa, 0x65ac, 0x7ad9, 0x8b92, 0x8b96, 0x5009, 0x5021, 0x5275,
  0x5531, 0x5a3c, 0x5ee0, 0x5f70, 0x6134, 0x655e, 0x660c, 0x6636,
  0x66a2, 0x69cd, 0x6ec4, 0x6f32, 0x7316, 0x7621, 0x7a93, 0x8139,
  0x8259, 0x83d6, 0x84bc, 0x50b5, 0x57f0, 0x5bc0, 0x5be8, 0x5f69,
  0x63a1, 0x7826, 0x7db5, 0x83dc, 0x8521, 0x91c7, 0x91f5, 0x518a,
  0x67f5, 0x7b56, 0x8cac, 0x51c4, 0x59bb, 0x60bd, 0x8655, 0x501c,
  0xf9ff, 0x5254, 0x5c3a, 0x617d, 0x621a, 0x62d3, 0x64f2, 0x65a5,
  0x6ecc, 0x7620, 0x810a, 0x8e60, 0x965f, 0x96bb, 0x4edf, 0x5343,
  0x5598, 0x5929, 0x5ddd, 0x64c5, 0x6cc9, 0x6dfa, 0x7394, 0x7a7f,
  0x821b, 0x85a6, 0x8ce4, 0x8e10, 0x9077, 0x91e7, 0x95e1, 0x9621,
  0x97c6, 0x51f8, 0x54f2, 0x5586, 0x5fb9, 0x64a4, 0x6f88, 0x7db4,
  0x8f1f, 0x8f4d, 0x9435, 0x50c9, 0x5c16, 0x6cbe, 0x6dfb, 0x751b,
  0x77bb, 0x7c3d, 0x7c64, 0x8a79, 0x8ac2, 0x581e, 0x59be, 0x5e16,
  0x6377, 0x7252, 0x758a, 0x776b, 0x8adc, 0x8cbc, 0x8f12, 0x5ef3,
  0x6674, 0x6df8, 0x807d, 0x83c1, 0x8acb, 0x9751, 0x9bd6, 0xfa00,
  0x5243, 0x66ff, 0x6d95, 0x6eef, 0x7de0, 0x8ae6, 0x902e, 0x905e,
  0x9ad4, 0x521d, 0x527f, 0x54e8, 0x6194, 0x6284, 0x62db, 0x68a2,
  0x6912, 0x695a, 0x6a35, 0x7092, 0x7126, 0x785d, 0x7901, 0x790e,
  0x79d2, 0x7a0d, 0x8096, 0x8278, 0x82d5, 0x8349, 0x8549, 0x8c82,
  0x8d85, 0x9162, 0x918b, 0x91ae, 0x4fc3, 0x56d1, 0x71ed, 0x77d7,
  0x8700, 0x89f8, 0x5bf8, 0x5fd6, 0x6751, 0x90a8, 0x53e2, 0x585a,
  0x5bf5, 0x60a4, 0x6181, 0x6460, 0x7e3d, 0x8070, 0x8525, 0x9283,
  0x64ae, 0x50ac, 0x5d14, 0x6700, 0x589c, 0x62bd, 0x63a8, 0x690e,
  0x6978, 0x6a1e, 0x6e6b, 0x76ba, 0x79cb, 0x82bb, 0x8429, 0x8acf,
  0x8da8, 0x8ffd, 0x9112, 0x914b, 0x919c, 0x9310, 0x9318, 0x939a,
  0x96db, 0x9a36, 0x9c0d, 0x4e11, 0x755c, 0x795d, 0x7afa, 0x7b51,
  0x7bc9, 0x7e2e, 0x84c4, 0x8e59, 0x8e74, 0x8ef8, 0x9010, 0x6625,
  0x693f, 0x7443, 0x51fa, 0x672e, 0x9edc, 0x5145, 0x5fe0, 0x6c96,
  0x87f2, 0x885d, 0x8877, 0x60b4, 0x81b5, 0x8403, 0x8d05, 0x53d6,
  0x5439, 0x5634, 0x5a36, 0x5c31, 0x708a, 0x7fe0, 0x805a, 0x8106,
  0x81ed, 0x8da3, 0x9189, 0x9a5f, 0x9df2, 0x5074, 0x4ec4, 0x53a0,
  0x60fb, 0x6e2c, 0x5c64, 0x4f88, 0x5024, 0x55e4, 0x5cd9, 0x5e5f,
  0x6065, 0x6894, 0x6cbb, 0x6dc4, 0x71be, 0x75d4, 0x75f4, 0x7661,
  0x7a1a, 0x7a49, 0x7dc7, 0x7dfb, 0x7f6e, 0x81f4, 0x86a9, 0x8f1c,
  0x96c9, 0x99b3, 0x9f52, 0x5247, 0x52c5, 0x98ed, 0x89aa, 0x4e03,
  0x67d2, 0x6f06, 0x4fb5, 0x5be2, 0x6795, 0x6c88, 0x6d78, 0x741b,
  0x7827, 0x91dd, 0x937c, 0x87c4, 0x79e4, 0x7a31, 0x5feb, 0x4ed6,
  0x54a4, 0x553e, 0x58ae, 0x59a5, 0x60f0, 0x6253, 0x62d6, 0x6736,
  0x6955, 0x8235, 0x9640, 0x99b1, 0x99dd, 0x502c, 0x5353, 0x5544,
  0x577c, 0xfa01, 0x6258, 0xfa02, 0x64e2, 0x666b, 0x67dd, 0x6fc1,
  0x6fef, 0x7422, 0x7438, 0x8a17, 0x9438, 0x5451, 0x5606, 0x5766,
  0x5f48, 0x619a, 0x6b4e, 0x7058, 0x70ad, 0x7dbb, 0x8a95, 0x596a,
  0x812b, 0x63a2, 0x7708, 0x803d, 0x8caa, 0x5854, 0x642d, 0x69bb,
  0x5b95, 0x5e11, 0x6e6f, 0xfa03, 0x8569, 0x514c, 0x53f0, 0x592a,
  0x6020, 0x614b, 0x6b86, 0x6c70, 0x6cf0, 0x7b1e, 0x80ce, 0x82d4,
  0x8dc6, 0x90b0, 0x98b1, 0xfa04, 0x64c7, 0x6fa4, 0x6491, 0x6504,
  0x514e, 0x5410, 0x571f, 0x8a0e, 0x615f, 0x6876, 0xfa05, 0x75db,
  0x7b52, 0x7d71, 0x901a, 0x5806, 0x69cc, 0x817f, 0x892a, 0x9000,
  0x9839, 0x5078, 0x5957, 0x59ac, 0x6295, 0x900f, 0x9b2a, 0x615d,
  0x7279, 0x95d6, 0x5761, 0x5a46, 0x5df4, 0x628a, 0x64ad, 0x64fa,
  0x6777, 0x6ce2, 0x6d3e, 0x722c, 0x7436, 0x7834, 0x7f77, 0x82ad,
  0x8ddb, 0x9817, 0x5224, 0x5742, 0x677f, 0x7248, 0x74e3, 0x8ca9,
  0x8fa6, 0x9211, 0x962a, 0x516b, 0x53ed, 0x634c, 0x4f69, 0x5504,
  0x6096, 0x6557, 0x6c9b, 0x6d7f, 0x724c, 0x72fd, 0x7a17, 0x8987,
  0x8c9d, 0x5f6d, 0x6f8e, 0x70f9, 0x81a8, 0x610e, 0x4fbf, 0x504f,
  0x6241, 0x7247, 0x7bc7, 0x7de8, 0x7fe9, 0x904d, 0x97ad, 0x9a19,
  0x8cb6, 0x576a, 0x5e73, 0x67b0, 0x840d, 0x8a55, 0x5420, 0x5b16,
  0x5e63, 0x5ee2, 0x5f0a, 0x6583, 0x80ba, 0x853d, 0x9589, 0x965b,
  0x4f48, 0x5305, 0x530d, 0x530f, 0x5486, 0x54fa, 0x5703, 0x5e03,
  0x6016, 0x629b, 0x62b1, 0x6355, 0xfa06, 0x6ce1, 0x6d66, 0x75b1,
  0x7832, 0x80de, 0x812f, 0x82de, 0x8461, 0x84b2, 0x888d, 0x8912,
  0x900b, 0x92ea, 0x98fd, 0x9b91, 0x5e45, 0x66b4, 0x66dd, 0x7011,
  0x7206, 0xfa07, 0x4ff5, 0x527d, 0x5f6a, 0x6153, 0x6753, 0x6a19,
  0x6f02, 0x74e2, 0x7968, 0x8868, 0x8c79, 0x98c7, 0x98c4, 0x9a43,
  0x54c1, 0x7a1f, 0x6953, 0x8af7, 0x8c4a, 0x98a8, 0x99ae, 0x5f7c,
  0x62ab, 0x75b2, 0x76ae, 0x88ab, 0x907f, 0x9642, 0x5339, 0x5f3c,
  0x5fc5, 0x6ccc, 0x73cc, 0x7562, 0x758b, 0x7b46, 0x82fe, 0x999d,
  0x4e4f, 0x903c, 0x4e0b, 0x4f55, 0x53a6, 0x590f, 0x5ec8, 0x6630,
  0x6cb3, 0x7455, 0x8377, 0x8766, 0x8cc0, 0x9050, 0x971e, 0x9c15,
  0x58d1, 0x5b78, 0x8650, 0x8b14, 0x9db4, 0x5bd2, 0x6068, 0x608d,
  0x65f1, 0x6c57, 0x6f22, 0x6fa3, 0x701a, 0x7f55, 0x7ff0, 0x9591,
  0x9592, 0x9650, 0x97d3, 0x5272, 0x8f44, 0x51fd, 0x542b, 0x54b8,
  0x5563, 0x558a, 0x6abb, 0x6db5, 0x7dd8, 0x8266, 0x929c, 0x9677,
  0x9e79, 0x5408, 0x54c8, 0x76d2, 0x86e4, 0x95a4, 0x95d4, 0x965c,
  0x4ea2, 0x4f09, 0x59ee, 0x5ae6, 0x5df7, 0x6052, 0x6297, 0x676d,
  0x6841, 0x6c86, 0x6e2f, 0x7f38, 0x809b, 0x822a, 0xfa08, 0xfa09,
  0x9805, 0x4ea5, 0x5055, 0x54b3, 0x5793, 0x595a, 0x5b69, 0x5bb3,
  0x61c8, 0x6977, 0x6d77, 0x7023, 0x87f9, 0x89e3, 0x8a72, 0x8ae7,
  0x9082, 0x99ed, 0x9ab8, 0x52be, 0x6838, 0x5016, 0x5e78, 0x674f,
  0x8347, 0x884c, 0x4eab, 0x5411, 0x56ae, 0x73e6, 0x9115, 0x97ff,
  0x9909, 0x9957, 0x9999, 0x5653, 0x589f, 0x865b, 0x8a31, 0x61b2,
  0x6af6, 0x737b, 0x8ed2, 0x6b47, 0x96aa, 0x9a57, 0x5955, 0x7200,
  0x8d6b, 0x9769, 0x4fd4, 0x5cf4, 0x5f26, 0x61f8, 0x665b, 0x6ceb,
  0x70ab, 0x7384, 0x73b9, 0x73fe, 0x7729, 0x774d, 0x7d43, 0x7d62,
  0x7e23, 0x8237, 0x8852, 0xfa0a, 0x8ce2, 0x9249, 0x986f, 0x5b51,
  0x7a74, 0x8840, 0x9801, 0x5acc, 0x4fe0, 0x5354, 0x593e, 0x5cfd,
  0x633e, 0x6d79, 0x72f9, 0x8105, 0x8107, 0x83a2, 0x92cf, 0x9830,
  0x4ea8, 0x5144, 0x5211, 0x578b, 0x5f62, 0x6cc2, 0x6ece, 0x7005,
  0x7050, 0x70af, 0x7192, 0x73e9, 0x7469, 0x834a, 0x87a2, 0x8861,
  0x9008, 0x90a2, 0x93a3, 0x99a8, 0x516e, 0x5f57, 0x60e0, 0x6167,
  0x66b3, 0x8559, 0x8e4a, 0x91af, 0x978b, 0x4e4e, 0x4e92, 0x547c,
  0x58d5, 0x58fa, 0x597d, 0x5cb5, 0x5f27, 0x6236, 0x6248, 0x660a,
  0x6667, 0x6beb, 0x6d69, 0x6dcf, 0x6e56, 0x6ef8, 0x6f94, 0x6fe0,
  0x6fe9, 0x705d, 0x72d0, 0x7425, 0x745a, 0x74e0, 0x7693, 0x795c,
  0x7cca, 0x7e1e, 0x80e1, 0x82a6, 0x846b, 0x84bf, 0x864e, 0x865f,
  0x8774, 0x8b77, 0x8c6a, 0x93ac, 0x9800, 0x9865, 0x60d1, 0x6216,
  0x9177, 0x5a5a, 0x660f, 0x6df7, 0x6e3e, 0x743f, 0x9b42, 0x5ffd,
  0x60da, 0x7b0f, 0x54c4, 0x5f18, 0x6c5e, 0x6cd3, 0x6d2a, 0x70d8,
  0x7d05, 0x8679, 0x8a0c, 0x9d3b, 0x5316, 0x548c, 0x5b05, 0x6a3a,
  0x706b, 0x7575, 0x798d, 0x79be, 0x82b1, 0x83ef, 0x8a71, 0x8b41,
  0x8ca8, 0x9774, 0xfa0b, 0x64f4, 0x652b, 0x78ba, 0x78bb, 0x7a6b,
  0x4e38, 0x559a, 0x5950, 0x5ba6, 0x5e7b, 0x60a3, 0x63db, 0x6b61,
  0x6665, 0x6853, 0x6e19, 0x7165, 0x74b0, 0x7d08, 0x9084, 0x9a69,
  0x9c25, 0x6d3b, 0x6ed1, 0x733e, 0x8c41, 0x95ca, 0x51f0, 0x5e4c,
  0x5fa8, 0x604d, 0x60f6, 0x6130, 0x614c, 0x6643, 0x6644, 0x69a5,
  0x6cc1, 0x6e5f, 0x6ec9, 0x6f62, 0x714c, 0x749c, 0x7687, 0x7bc1,
  0x7c27, 0x8352, 0x8757, 0x9051, 0x968d, 0x9ec3, 0x532f, 0x56de,
  0x5efb, 0x5f8a, 0x6062, 0x6094, 0x61f7, 0x6666, 0x6703, 0x6a9c,
  0x6dee, 0x6fae, 0x7070, 0x736a, 0x7e6a, 0x81be, 0x8334, 0x86d4,
  0x8aa8, 0x8cc4, 0x5283, 0x7372, 0x5b96, 0x6a6b, 0x9404, 0x54ee,
  0x5686, 0x5b5d, 0x6548, 0x6585, 0x66c9, 0x689f, 0x6d8d, 0x6dc6,
  0x723b, 0x80b4, 0x9175, 0x9a4d, 0x4faf, 0x5019, 0x539a, 0x540e,
  0x543c, 0x5589, 0x55c5, 0x5e3f, 0x5f8c, 0x673d, 0x7166, 0x73dd,
  0x9005, 0x52db, 0x52f3, 0x5864, 0x58ce, 0x7104, 0x718f, 0x71fb,
  0x85b0, 0x8a13, 0x6688, 0x85a8, 0x55a7, 0x6684, 0x714a, 0x8431,
  0x5349, 0x5599, 0x6bc1, 0x5f59, 0x5fbd, 0x63ee, 0x6689, 0x7147,
  0x8af1, 0x8f1d, 0x9ebe, 0x4f11, 0x643a, 0x70cb, 0x7566, 0x8667,
  0x6064, 0x8b4e, 0x9df8, 0x5147, 0x51f6, 0x5308, 0x6d36, 0x80f8,
  0x9ed1, 0x6615, 0x6b23, 0x7098, 0x75d5, 0x5403, 0x5c79, 0x7d07,
  0x8a16, 0x6b20, 0x6b3d, 0x6b46, 0x5438, 0x6070, 0x6d3d, 0x7fd5,
  0x8208, 0x50d6, 0x51de, 0x559c, 0x566b, 0x56cd, 0x59ec, 0x5b09,
  0x5e0c, 0x6199, 0x6198, 0x6231, 0x665e, 0x66e6, 0x7199, 0x71b9,
  0x71ba, 0x72a7, 0x79a7, 0x7a00, 0x7fb2, 0x8a70, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, };
UNICHAR map_JIS_X0212_1990[] = {
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x02d8, 0x02c7, 0x00b8, 0x02d9,
  0x02dd, 0x00af, 0x02db, 0x02da, 0x007e, 0x0384, 0x0385, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x00a1,
  0x00a6, 0x00bf, 0x2122, 0x00a4, 0x2116, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0x00ba, 0x00aa, 0x00a9, 0x00ae, 0x2122, 0x00a4, 0x2116, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x0386, 0x0388,
  0x0389, 0x038a, 0x03aa, 0xfffd, 0x038c, 0xfffd, 0x038e, 0x03ab,
  0xfffd, 0x038f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x03ac, 0x03ad,
  0x03ae, 0x03af, 0x03ca, 0x0390, 0x03cc, 0x03c2, 0x03cd, 0x03cb,
  0x03b0, 0x03ce, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x0402, 0x0403, 0x0404,
  0x0405, 0x0406, 0x0407, 0x0408, 0x0409, 0x040a, 0x040b, 0x040c,
  0x040e, 0x040f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x0452, 0x0453, 0x0454,
  0x0455, 0x0456, 0x0457, 0x0458, 0x0459, 0x045a, 0x045b, 0x045c,
  0x045e, 0x045f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0x00c6, 0x0110, 0xfffd, 0x0126, 0xfffd, 0x0132, 0xfffd, 0x0141,
  0x013f, 0xfffd, 0x014a, 0x00d8, 0x0152, 0xfffd, 0x0166, 0x00de,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0x00e6, 0x0111, 0x00f0, 0x0127, 0x0131, 0x0133, 0x0138, 0x0142,
  0x0140, 0x0149, 0x014b, 0x00f8, 0x0153, 0x00df, 0x0167, 0x00fe,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x00c1, 0x00c0,
  0x00c4, 0x00c2, 0x0102, 0x01cd, 0x0100, 0x0104, 0x00c5, 0x00c3,
  0x0106, 0x0108, 0x010c, 0x00c7, 0x010a, 0x010e, 0x00c9, 0x00c8,
  0x00cb, 0x00ca, 0x011a, 0x0116, 0x0112, 0x0118, 0x011c, 0x011c,
  0x011e, 0x0122, 0x0120, 0x0124, 0x00cd, 0x00cc, 0x00cf, 0x00ce,
  0x01cf, 0x0130, 0x012a, 0x012e, 0x0128, 0x0134, 0x0136, 0x0139,
  0x013d, 0x013b, 0x0143, 0x0147, 0x0145, 0x00d1, 0x00d3, 0x00d2,
  0x00d6, 0x00d4, 0x01d1, 0x0150, 0x014c, 0x00d5, 0x0154, 0x0158,
  0x0156, 0x015a, 0x015c, 0x0160, 0x015e, 0x0164, 0x0162, 0x00da,
  0x00d9, 0x00dc, 0x00db, 0x016c, 0x01d3, 0x0170, 0x016a, 0x0172,
  0x016e, 0x0168, 0x01d7, 0x01db, 0x01d9, 0x01d5, 0x0174, 0x00dd,
  0x0178, 0x0176, 0x0179, 0x017d, 0x017b, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x00e1, 0x00e0, 0x00e4, 0x00e2,
  0x0103, 0x01ce, 0x0101, 0x0105, 0x00e5, 0x00e3, 0x0107, 0x0109,
  0x010d, 0x00e7, 0x010b, 0x010f, 0x00e9, 0x00e8, 0x00eb, 0x00ea,
  0x011b, 0x0117, 0x0113, 0x0119, 0x01f5, 0x011d, 0x011f, 0x0121,
  0x0121, 0x0125, 0x00ed, 0x00ec, 0x00ef, 0x00ee, 0x01d0, 0x012b,
  0x012b, 0x012f, 0x0129, 0x0135, 0x0137, 0x013a, 0x013e, 0x013c,
  0x0144, 0x0148, 0x0146, 0x00f1, 0x00f3, 0x00f2, 0x00f6, 0x00f4,
  0x01d2, 0x0151, 0x014d, 0x00f5, 0x0155, 0x0159, 0x0157, 0x015b,
  0x015d, 0x0161, 0x015f, 0x0165, 0x0163, 0x00fa, 0x00f9, 0x00fc,
  0x00fb, 0x016d, 0x01d4, 0x0171, 0x016b, 0x0173, 0x016f, 0x0169,
  0x01d8, 0x01dc, 0x01da, 0x01d6, 0x0175, 0x00fd, 0x00ff, 0x0177,
  0x017a, 0x017e, 0x017c, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x4e02, 0x4e04, 0x4e05, 0x4e0c, 0x4e12, 0x4e1f,
  0x4e23, 0x4e24, 0x4e28, 0x4e2b, 0x4e2e, 0x4e2f, 0x4e30, 0x4e35,
  0x4e40, 0x4e41, 0x4e44, 0x4e47, 0x4e51, 0x4e5a, 0x4e5c, 0x4e63,
  0x4e68, 0x4e69, 0x4e74, 0x4e75, 0x4e79, 0x4e7f, 0x4e8d, 0x4e96,
  0x4e97, 0x4e9d, 0x4eaf, 0x4eb9, 0x4ec3, 0x4ed0, 0x4eda, 0x4edb,
  0x4ee0, 0x4ee1, 0x4ee2, 0x4ee8, 0x4eef, 0x4ef1, 0x4ef3, 0x4ef5,
  0x4efd, 0x4efe, 0x4eff, 0x4f00, 0x4f02, 0x4f03, 0x4f08, 0x4f0b,
  0x4f0c, 0x4f12, 0x4f15, 0x4f16, 0x4f17, 0x4f19, 0x4f2e, 0x4f31,
  0x4f60, 0x4f33, 0x4f35, 0x4f37, 0x4f39, 0x4f3b, 0x4f3e, 0x4f40,
  0x4f42, 0x4f48, 0x4f49, 0x4f4b, 0x4f4c, 0x4f52, 0x4f54, 0x4f56,
  0x4f58, 0x4f5f, 0x4f63, 0x4f6a, 0x4f6c, 0x4f6e, 0x4f71, 0x4f77,
  0x4f78, 0x4f79, 0x4f7a, 0x4f7d, 0x4f7e, 0x4f81, 0x4f82, 0x4f84,
  0x4f85, 0x4f89, 0x4f8a, 0x4f8c, 0x4f8e, 0x4f90, 0x4f92, 0x4f93,
  0x4f94, 0x4f97, 0x4f99, 0x4f9a, 0x4f9e, 0x4f9f, 0x4fb2, 0x4fb7,
  0x4fb9, 0x4fbb, 0x4fbc, 0x4fbd, 0x4fbe, 0x4fc0, 0x4fc1, 0x4fc5,
  0x4fc6, 0x4fc8, 0x4fc9, 0x4fcb, 0x4fcc, 0x4fcd, 0x4fcf, 0x4fd2,
  0x4fdc, 0x4fe0, 0x4fe2, 0x4ff0, 0x4ff2, 0x4ffc, 0x4ffd, 0x4fff,
  0x5000, 0x5001, 0x5004, 0x5007, 0x500a, 0x500c, 0x500e, 0x5010,
  0x5013, 0x5017, 0x5018, 0x501b, 0x501c, 0x501d, 0x501e, 0x5022,
  0x5027, 0x502e, 0x5030, 0x5032, 0x5033, 0x5035, 0x5040, 0x5041,
  0x5042, 0x5045, 0x5046, 0x504a, 0x504c, 0x504e, 0x5051, 0x5052,
  0x5053, 0x5057, 0x5059, 0x505f, 0x5060, 0x5062, 0x5063, 0x5066,
  0x5067, 0x506a, 0x506d, 0x5070, 0x5071, 0x503b, 0x5081, 0x5083,
  0x5084, 0x5086, 0x508a, 0x508e, 0x508f, 0x5090, 0x5092, 0x5093,
  0x5094, 0x5096, 0x509b, 0x509c, 0x509e, 0x509f, 0x50a0, 0x50a1,
  0x50a2, 0x50aa, 0x50af, 0x50b0, 0x50b9, 0x50ba, 0x50bd, 0x50c0,
  0x50c3, 0x50c4, 0x50c7, 0x50cc, 0x50ce, 0x50d0, 0x50d3, 0x50d4,
  0x50d8, 0x50dc, 0x50dd, 0x50df, 0x50e2, 0x50e4, 0x50e6, 0x50e8,
  0x50e9, 0x50ef, 0x50f1, 0x50f6, 0x50fa, 0x50fe, 0x5103, 0x5106,
  0x5107, 0x5108, 0x510b, 0x510c, 0x510d, 0x510e, 0x50f2, 0x5110,
  0x5117, 0x5119, 0x511b, 0x511c, 0x511d, 0x511e, 0x5123, 0x5127,
  0x5128, 0x512c, 0x512d, 0x512f, 0x5131, 0x5133, 0x5134, 0x5135,
  0x5138, 0x5139, 0x5142, 0x514a, 0x514f, 0x5153, 0x5155, 0x5157,
  0x5158, 0x515f, 0x5164, 0x5166, 0x517e, 0x5183, 0x5184, 0x518b,
  0x518e, 0x5198, 0x519d, 0x51a1, 0x51a3, 0x51ad, 0x51b8, 0x51ba,
  0x51bc, 0x51be, 0x51bf, 0x51c2, 0x51c8, 0x51cf, 0x51d1, 0x51d2,
  0x51d3, 0x51d5, 0x51d8, 0x51de, 0x51e2, 0x51e5, 0x51ee, 0x51f2,
  0x51f3, 0x51f4, 0x51f7, 0x5201, 0x5202, 0x5205, 0x5212, 0x5213,
  0x5215, 0x5216, 0x5218, 0x5222, 0x5228, 0x5231, 0x5232, 0x5235,
  0x523c, 0x5245, 0x5249, 0x5255, 0x5257, 0x5258, 0x525a, 0x525c,
  0x525f, 0x5260, 0x5261, 0x5266, 0x526e, 0x5277, 0x5278, 0x5279,
  0x5280, 0x5282, 0x5285, 0x528a, 0x528c, 0x5293, 0x5295, 0x5296,
  0x5297, 0x5298, 0x529a, 0x529c, 0x52a4, 0x52a5, 0x52a6, 0x52a7,
  0x52af, 0x52b0, 0x52b6, 0x52b7, 0x52b8, 0x52ba, 0x52bb, 0x52bd,
  0x52c0, 0x52c4, 0x52c6, 0x52c8, 0x52cc, 0x52cf, 0x52d1, 0x52d4,
  0x52d6, 0x52db, 0x52dc, 0x52e1, 0x52e5, 0x52e8, 0x52e9, 0x52ea,
  0x52ec, 0x52f0, 0x52f1, 0x52f4, 0x52f6, 0x52f7, 0x5300, 0x5303,
  0x530a, 0x530b, 0x530c, 0x5311, 0x5313, 0x5318, 0x531b, 0x531c,
  0x531e, 0x531f, 0x5325, 0x5327, 0x5328, 0x5329, 0x532b, 0x532c,
  0x532d, 0x5330, 0x5332, 0x5335, 0x533c, 0x533d, 0x533e, 0x5342,
  0x534c, 0x534b, 0x5359, 0x535b, 0x5361, 0x5363, 0x5365, 0x536c,
  0x536d, 0x5372, 0x5379, 0x537e, 0x5383, 0x5387, 0x5388, 0x538e,
  0x5393, 0x5394, 0x5399, 0x539d, 0x53a1, 0x53a4, 0x53aa, 0x53ab,
  0x53af, 0x53b2, 0x53b4, 0x53b5, 0x53b7, 0x53b8, 0x53ba, 0x53bd,
  0x53c0, 0x53c5, 0x53cf, 0x53d2, 0x53d3, 0x53d5, 0x53da, 0x53dd,
  0x53de, 0x53e0, 0x53e6, 0x53e7, 0x53f5, 0x5402, 0x5413, 0x541a,
  0x5421, 0x5427, 0x5428, 0x542a, 0x542f, 0x5431, 0x5434, 0x5435,
  0x5443, 0x5444, 0x5447, 0x544d, 0x544f, 0x545e, 0x5462, 0x5464,
  0x5466, 0x5467, 0x5469, 0x546b, 0x546d, 0x546e, 0x5474, 0x547f,
  0x5481, 0x5483, 0x5485, 0x5488, 0x5489, 0x548d, 0x5491, 0x5495,
  0x5496, 0x549c, 0x549f, 0x54a1, 0x54a6, 0x54a7, 0x54a9, 0x54aa,
  0x54ad, 0x54ae, 0x54b1, 0x54b7, 0x54b9, 0x54ba, 0x54bb, 0x54bf,
  0x54c6, 0x54ca, 0x54cd, 0x54ce, 0x54e0, 0x54ea, 0x54ec, 0x54ef,
  0x54f6, 0x54fc, 0x54fe, 0x54ff, 0x5500, 0x5501, 0x5505, 0x5508,
  0x5509, 0x550c, 0x550d, 0x550e, 0x5515, 0x552a, 0x552b, 0x5532,
  0x5535, 0x5536, 0x553b, 0x553c, 0x553d, 0x5541, 0x5547, 0x5549,
  0x554a, 0x554d, 0x5550, 0x5551, 0x5558, 0x555a, 0x555b, 0x555e,
  0x5560, 0x5561, 0x5564, 0x5566, 0x557f, 0x5581, 0x5582, 0x5586,
  0x5588, 0x558e, 0x558f, 0x5591, 0x5592, 0x5593, 0x5594, 0x5597,
  0x55a3, 0x55a4, 0x55ad, 0x55b2, 0x55bf, 0x55c1, 0x55c3, 0x55c6,
  0x55c9, 0x55cb, 0x55cc, 0x55ce, 0x55d1, 0x55d2, 0x55d3, 0x55d7,
  0x55d8, 0x55db, 0x55de, 0x55e2, 0x55e9, 0x55f6, 0x55ff, 0x5605,
  0x5608, 0x560a, 0x560d, 0x560e, 0x560f, 0x5610, 0x5611, 0x5612,
  0x5619, 0x562c, 0x5630, 0x5633, 0x5635, 0x5637, 0x5639, 0x563b,
  0x563c, 0x563d, 0x563f, 0x5640, 0x5641, 0x5643, 0x5644, 0x5646,
  0x5649, 0x564b, 0x564d, 0x564f, 0x5654, 0x565e, 0x5660, 0x5661,
  0x5662, 0x5663, 0x5666, 0x5669, 0x566d, 0x566f, 0x5671, 0x5672,
  0x5675, 0x5684, 0x5685, 0x5688, 0x568b, 0x568c, 0x5695, 0x5699,
  0x569a, 0x569d, 0x569e, 0x569f, 0x56a6, 0x56a7, 0x56a8, 0x56a9,
  0x56ab, 0x56ac, 0x56ad, 0x56b1, 0x56b3, 0x56b7, 0x56be, 0x56c5,
  0x56c9, 0x56ca, 0x56cb, 0x56cf, 0x56d0, 0x56cc, 0x56cd, 0x56d9,
  0x56dc, 0x56dd, 0x56df, 0x56e1, 0x56e4, 0x56e5, 0x56e6, 0x56e7,
  0x56e8, 0x56f1, 0x56eb, 0x56ed, 0x56f6, 0x56f7, 0x5701, 0x5702,
  0x5707, 0x570a, 0x570c, 0x5711, 0x5715, 0x571a, 0x571b, 0x571d,
  0x5720, 0x5722, 0x5723, 0x5724, 0x5725, 0x5729, 0x572a, 0x572c,
  0x572e, 0x572f, 0x5733, 0x5734, 0x573d, 0x573e, 0x573f, 0x5745,
  0x5746, 0x574c, 0x574d, 0x5752, 0x5762, 0x5765, 0x5767, 0x5768,
  0x576b, 0x576d, 0x576e, 0x576f, 0x5770, 0x5771, 0x5773, 0x5774,
  0x5775, 0x5777, 0x5779, 0x577a, 0x577b, 0x577c, 0x577e, 0x5781,
  0x5783, 0x578c, 0x5794, 0x5797, 0x5799, 0x579a, 0x579c, 0x579d,
  0x579e, 0x579f, 0x57a1, 0x5795, 0x57a7, 0x57a8, 0x57a9, 0x57ac,
  0x57b8, 0x57bd, 0x57c7, 0x57c8, 0x57cc, 0x57cf, 0x57d5, 0x57dd,
  0x57de, 0x57e4, 0x57e6, 0x57e7, 0x57e9, 0x57ed, 0x57f0, 0x57f5,
  0x57f6, 0x57f8, 0x57fd, 0x57fe, 0x57ff, 0x5803, 0x5804, 0x5808,
  0x5809, 0x57e1, 0x580c, 0x580d, 0x581b, 0x581e, 0x581f, 0x5820,
  0x5826, 0x5827, 0x582d, 0x5832, 0x5839, 0x583f, 0x5849, 0x584c,
  0x584d, 0x584f, 0x5850, 0x5855, 0x585f, 0x5861, 0x5864, 0x5867,
  0x5868, 0x5878, 0x587c, 0x587f, 0x5880, 0x5881, 0x5887, 0x5888,
  0x5889, 0x588a, 0x588c, 0x588d, 0x588f, 0x5890, 0x5894, 0x5896,
  0x589d, 0x58a0, 0x58a1, 0x58a2, 0x58a6, 0x58a9, 0x58b1, 0x58b2,
  0x58c4, 0x58bc, 0x58c2, 0x58c8, 0x58cd, 0x58ce, 0x58d0, 0x58d2,
  0x58d4, 0x58d6, 0x58da, 0x58dd, 0x58e1, 0x58e2, 0x58e9, 0x58f3,
  0x5905, 0x5906, 0x590b, 0x590c, 0x5912, 0x5913, 0x5914, 0x8641,
  0x591d, 0x5921, 0x5923, 0x5924, 0x5928, 0x592f, 0x5930, 0x5933,
  0x5935, 0x5936, 0x593f, 0x5943, 0x5946, 0x5952, 0x5953, 0x5959,
  0x595b, 0x595d, 0x595e, 0x595f, 0x5961, 0x5963, 0x596b, 0x596d,
  0x596f, 0x5972, 0x5975, 0x5976, 0x5979, 0x597b, 0x597c, 0x598b,
  0x598c, 0x598e, 0x5992, 0x5995, 0x5997, 0x599f, 0x59a4, 0x59a7,
  0x59ad, 0x59ae, 0x59af, 0x59b0, 0x59b3, 0x59b7, 0x59ba, 0x59bc,
  0x59c1, 0x59c3, 0x59c4, 0x59c8, 0x59ca, 0x59cd, 0x59d2, 0x59dd,
  0x59de, 0x59df, 0x59e3, 0x59e4, 0x59e7, 0x59ee, 0x59ef, 0x59f1,
  0x59f2, 0x59f4, 0x59f7, 0x5a00, 0x5a04, 0x5a0c, 0x5a0d, 0x5a0e,
  0x5a12, 0x5a13, 0x5a1e, 0x5a23, 0x5a24, 0x5a27, 0x5a28, 0x5a2a,
  0x5a2d, 0x5a30, 0x5a44, 0x5a45, 0x5a47, 0x5a48, 0x5a4c, 0x5a50,
  0x5a55, 0x5a5e, 0x5a63, 0x5a65, 0x5a67, 0x5a6d, 0x5a77, 0x5a7a,
  0x5a7b, 0x5a7e, 0x5a8b, 0x5a90, 0x5a93, 0x5a96, 0x5a99, 0x5a9c,
  0x5a9e, 0x5a9f, 0x5aa0, 0x5aa2, 0x5aa7, 0x5aac, 0x5ab1, 0x5ab2,
  0x5ab3, 0x5ab5, 0x5ab8, 0x5aba, 0x5abb, 0x5abf, 0x5ac4, 0x5ac6,
  0x5ac8, 0x5acf, 0x5ada, 0x5adc, 0x5ae0, 0x5ae5, 0x5aea, 0x5aee,
  0x5af5, 0x5af6, 0x5afd, 0x5b00, 0x5b01, 0x5b08, 0x5b17, 0x5b34,
  0x5b19, 0x5b1b, 0x5b1d, 0x5b21, 0x5b25, 0x5b2d, 0x5b38, 0x5b41,
  0x5b4b, 0x5b4c, 0x5b52, 0x5b56, 0x5b5e, 0x5b68, 0x5b6e, 0x5b6f,
  0x5b7c, 0x5b7d, 0x5b7e, 0x5b7f, 0x5b81, 0x5b84, 0x5b86, 0x5b8a,
  0x5b8e, 0x5b90, 0x5b91, 0x5b93, 0x5b94, 0x5b96, 0x5ba8, 0x5ba9,
  0x5bac, 0x5bad, 0x5baf, 0x5bb1, 0x5bb2, 0x5bb7, 0x5bba, 0x5bbc,
  0x5bc0, 0x5bc1, 0x5bcd, 0x5bcf, 0x5bd6, 0x5bd7, 0x5bd8, 0x5bd9,
  0x5bda, 0x5be0, 0x5bef, 0x5bf1, 0x5bf4, 0x5bfd, 0x5c0c, 0x5c17,
  0x5c1e, 0x5c1f, 0x5c23, 0x5c26, 0x5c29, 0x5c2b, 0x5c2c, 0x5c2e,
  0x5c30, 0x5c32, 0x5c35, 0x5c36, 0x5c59, 0x5c5a, 0x5c5c, 0x5c62,
  0x5c63, 0x5c67, 0x5c68, 0x5c69, 0x5c6d, 0x5c70, 0x5c74, 0x5c75,
  0x5c7a, 0x5c7b, 0x5c7c, 0x5c7d, 0x5c87, 0x5c88, 0x5c8a, 0x5c8f,
  0x5c92, 0x5c9d, 0x5c9f, 0x5ca0, 0x5ca2, 0x5ca3, 0x5ca6, 0x5caa,
  0x5cb2, 0x5cb4, 0x5cb5, 0x5cba, 0x5cc9, 0x5ccb, 0x5cd2, 0x5cdd,
  0x5cd7, 0x5cee, 0x5cf1, 0x5cf2, 0x5cf4, 0x5d01, 0x5d06, 0x5d0d,
  0x5d12, 0x5d2b, 0x5d23, 0x5d24, 0x5d26, 0x5d27, 0x5d31, 0x5d34,
  0x5d39, 0x5d3d, 0x5d3f, 0x5d42, 0x5d43, 0x5d46, 0x5d48, 0x5d55,
  0x5d51, 0x5d59, 0x5d4a, 0x5d5f, 0x5d60, 0x5d61, 0x5d62, 0x5d64,
  0x5d6a, 0x5d6d, 0x5d70, 0x5d79, 0x5d7a, 0x5d7e, 0x5d7f, 0x5d81,
  0x5d83, 0x5d88, 0x5d8a, 0x5d92, 0x5d93, 0x5d94, 0x5d95, 0x5d99,
  0x5d9b, 0x5d9f, 0x5da0, 0x5da7, 0x5dab, 0x5db0, 0x5db4, 0x5db8,
  0x5db9, 0x5dc3, 0x5dc7, 0x5dcb, 0x5dd0, 0x5dce, 0x5dd8, 0x5dd9,
  0x5de0, 0x5de4, 0x5de9, 0x5df8, 0x5df9, 0x5e00, 0x5e07, 0x5e0d,
  0x5e12, 0x5e14, 0x5e15, 0x5e18, 0x5e1f, 0x5e20, 0x5e2e, 0x5e28,
  0x5e32, 0x5e35, 0x5e3e, 0x5e4b, 0x5e50, 0x5e49, 0x5e51, 0x5e56,
  0x5e58, 0x5e5b, 0x5e5c, 0x5e5e, 0x5e68, 0x5e6a, 0x5e6b, 0x5e6c,
  0x5e6d, 0x5e6e, 0x5e70, 0x5e80, 0x5e8b, 0x5e8e, 0x5ea2, 0x5ea4,
  0x5ea5, 0x5ea8, 0x5eaa, 0x5eac, 0x5eb1, 0x5eb3, 0x5ebd, 0x5ebe,
  0x5ebf, 0x5ec6, 0x5ecc, 0x5ecb, 0x5ece, 0x5ed1, 0x5ed2, 0x5ed4,
  0x5ed5, 0x5edc, 0x5ede, 0x5ee5, 0x5eeb, 0x5f02, 0x5f06, 0x5f07,
  0x5f08, 0x5f0e, 0x5f19, 0x5f1c, 0x5f1d, 0x5f21, 0x5f22, 0x5f23,
  0x5f24, 0x5f28, 0x5f2b, 0x5f2c, 0x5f2e, 0x5f30, 0x5f34, 0x5f36,
  0x5f3b, 0x5f3d, 0x5f3f, 0x5f40, 0x5f44, 0x5f45, 0x5f47, 0x5f4d,
  0x5f50, 0x5f54, 0x5f58, 0x5f5b, 0x5f60, 0x5f63, 0x5f64, 0x5f67,
  0x5f6f, 0x5f72, 0x5f74, 0x5f75, 0x5f78, 0x5f7a, 0x5f7d, 0x5f7e,
  0x5f89, 0x5f8d, 0x5f8f, 0x5f96, 0x5f9c, 0x5f9d, 0x5fa2, 0x5fa7,
  0x5fab, 0x5fa4, 0x5fac, 0x5faf, 0x5fb0, 0x5fb1, 0x5fb8, 0x5fc4,
  0x5fc7, 0x5fc8, 0x5fc9, 0x5fcb, 0x5fd0, 0x5fd1, 0x5fd2, 0x5fd3,
  0x5fd4, 0x5fde, 0x5fe1, 0x5fe2, 0x5fe8, 0x5fe9, 0x5fea, 0x5fec,
  0x5fed, 0x5fee, 0x5fef, 0x5ff2, 0x5ff3, 0x5ff6, 0x5ffa, 0x5ffc,
  0x6007, 0x600a, 0x600d, 0x6013, 0x6014, 0x6017, 0x6018, 0x601a,
  0x601f, 0x6024, 0x602d, 0x6033, 0x6035, 0x6040, 0x6047, 0x6048,
  0x6049, 0x604c, 0x6051, 0x6054, 0x6056, 0x6057, 0x605d, 0x6061,
  0x6067, 0x6071, 0x607e, 0x607f, 0x6082, 0x6086, 0x6088, 0x608a,
  0x608e, 0x6091, 0x6093, 0x6095, 0x6098, 0x609d, 0x609e, 0x60a2,
  0x60a4, 0x60a5, 0x60a8, 0x60b0, 0x60b1, 0x60b7, 0x60bb, 0x60be,
  0x60c2, 0x60c4, 0x60c8, 0x60c9, 0x60ca, 0x60cb, 0x60ce, 0x60cf,
  0x60d4, 0x60d5, 0x60d9, 0x60db, 0x60dd, 0x60de, 0x60e2, 0x60e5,
  0x60f2, 0x60f5, 0x60f8, 0x60fc, 0x60fd, 0x6102, 0x6107, 0x610a,
  0x610c, 0x6110, 0x6111, 0x6112, 0x6113, 0x6114, 0x6116, 0x6117,
  0x6119, 0x611c, 0x611e, 0x6122, 0x612a, 0x612b, 0x6130, 0x6131,
  0x6135, 0x6136, 0x6137, 0x6139, 0x6141, 0x6145, 0x6146, 0x6149,
  0x615e, 0x6160, 0x616c, 0x6172, 0x6178, 0x617b, 0x617c, 0x617f,
  0x6180, 0x6181, 0x6183, 0x6184, 0x618b, 0x618d, 0x6192, 0x6193,
  0x6197, 0x6198, 0x619c, 0x619d, 0x619f, 0x61a0, 0x61a5, 0x61a8,
  0x61aa, 0x61ad, 0x61b8, 0x61b9, 0x61bc, 0x61c0, 0x61c1, 0x61c2,
  0x61ce, 0x61cf, 0x61d5, 0x61dc, 0x61dd, 0x61de, 0x61df, 0x61e1,
  0x61e2, 0x61e7, 0x61e9, 0x61e5, 0x61ec, 0x61ed, 0x61ef, 0x6201,
  0x6203, 0x6204, 0x6207, 0x6213, 0x6215, 0x621c, 0x6220, 0x6222,
  0x6223, 0x6227, 0x6229, 0x622b, 0x6239, 0x623d, 0x6242, 0x6243,
  0x6244, 0x6246, 0x624c, 0x6250, 0x6251, 0x6252, 0x6254, 0x6256,
  0x625a, 0x625c, 0x6264, 0x626d, 0x626f, 0x6273, 0x627a, 0x627d,
  0x628d, 0x628e, 0x628f, 0x6290, 0x62a6, 0x62a8, 0x62b3, 0x62b6,
  0x62b7, 0x62ba, 0x62be, 0x62bf, 0x62c4, 0x62ce, 0x62d5, 0x62d6,
  0x62da, 0x62ea, 0x62f2, 0x62f4, 0x62fc, 0x62fd, 0x6303, 0x6304,
  0x630a, 0x630b, 0x630d, 0x6310, 0x6313, 0x6316, 0x6318, 0x6329,
  0x632a, 0x632d, 0x6335, 0x6336, 0x6339, 0x633c, 0x6341, 0x6342,
  0x6343, 0x6344, 0x6346, 0x634a, 0x634b, 0x634e, 0x6352, 0x6353,
  0x6354, 0x6358, 0x635b, 0x6365, 0x6366, 0x636c, 0x636d, 0x6371,
  0x6374, 0x6375, 0x6378, 0x637c, 0x637d, 0x637f, 0x6382, 0x6384,
  0x6387, 0x638a, 0x6390, 0x6394, 0x6395, 0x6399, 0x639a, 0x639e,
  0x63a4, 0x63a6, 0x63ad, 0x63ae, 0x63af, 0x63bd, 0x63c1, 0x63c5,
  0x63c8, 0x63ce, 0x63d1, 0x63d3, 0x63d4, 0x63d5, 0x63dc, 0x63e0,
  0x63e5, 0x63ea, 0x63ec, 0x63f2, 0x63f3, 0x63f5, 0x63f8, 0x63f9,
  0x6409, 0x640a, 0x6410, 0x6412, 0x6414, 0x6418, 0x641e, 0x6420,
  0x6422, 0x6424, 0x6425, 0x6429, 0x642a, 0x642f, 0x6430, 0x6435,
  0x643d, 0x643f, 0x644b, 0x644f, 0x6451, 0x6452, 0x6453, 0x6454,
  0x645a, 0x645b, 0x645c, 0x645d, 0x645f, 0x6460, 0x6461, 0x6463,
  0x646d, 0x6473, 0x6474, 0x647b, 0x647d, 0x6485, 0x6487, 0x648f,
  0x6490, 0x6491, 0x6498, 0x6499, 0x649b, 0x649d, 0x649f, 0x64a1,
  0x64a3, 0x64a6, 0x64a8, 0x64ac, 0x64b3, 0x64bd, 0x64be, 0x64bf,
  0x64c4, 0x64c9, 0x64ca, 0x64cb, 0x64cc, 0x64ce, 0x64d0, 0x64d1,
  0x64d5, 0x64d7, 0x64e4, 0x64e5, 0x64e9, 0x64ea, 0x64ed, 0x64f0,
  0x64f5, 0x64f7, 0x64fb, 0x64ff, 0x6501, 0x6504, 0x6508, 0x6509,
  0x650a, 0x650f, 0x6513, 0x6514, 0x6516, 0x6519, 0x651b, 0x651e,
  0x651f, 0x6522, 0x6526, 0x6529, 0x652e, 0x6531, 0x653a, 0x653c,
  0x653d, 0x6543, 0x6547, 0x6549, 0x6550, 0x6552, 0x6554, 0x655f,
  0x6560, 0x6567, 0x656b, 0x657a, 0x657d, 0x6581, 0x6585, 0x658a,
  0x6592, 0x6595, 0x6598, 0x659d, 0x65a0, 0x65a3, 0x65a6, 0x65ae,
  0x65b2, 0x65b3, 0x65b4, 0x65bf, 0x65c2, 0x65c8, 0x65c9, 0x65ce,
  0x65d0, 0x65d4, 0x65d6, 0x65d8, 0x65df, 0x65f0, 0x65f2, 0x65f4,
  0x65f5, 0x65f9, 0x65fe, 0x65ff, 0x6600, 0x6604, 0x6608, 0x6609,
  0x660d, 0x6611, 0x6612, 0x6615, 0x6616, 0x661d, 0x661e, 0x6621,
  0x6622, 0x6623, 0x6624, 0x6626, 0x6629, 0x662a, 0x662b, 0x662c,
  0x662e, 0x6630, 0x6631, 0x6633, 0x6639, 0x6637, 0x6640, 0x6645,
  0x6646, 0x664a, 0x664c, 0x6651, 0x664e, 0x6657, 0x6658, 0x6659,
  0x665b, 0x665c, 0x6660, 0x6661, 0x66fb, 0x666a, 0x666b, 0x666c,
  0x667e, 0x6673, 0x6675, 0x667f, 0x6677, 0x6678, 0x6679, 0x667b,
  0x6680, 0x667c, 0x668b, 0x668c, 0x668d, 0x6690, 0x6692, 0x6699,
  0x669a, 0x669b, 0x669c, 0x669f, 0x66a0, 0x66a4, 0x66ad, 0x66b1,
  0x66b2, 0x66b5, 0x66bb, 0x66bf, 0x66c0, 0x66c2, 0x66c3, 0x66c8,
  0x66cc, 0x66ce, 0x66cf, 0x66d4, 0x66db, 0x66df, 0x66e8, 0x66eb,
  0x66ec, 0x66ee, 0x66fa, 0x6705, 0x6707, 0x670e, 0x6713, 0x6719,
  0x671c, 0x6720, 0x6722, 0x6733, 0x673e, 0x6745, 0x6747, 0x6748,
  0x674c, 0x6754, 0x6755, 0x675d, 0x6766, 0x676c, 0x676e, 0x6774,
  0x6776, 0x677b, 0x6781, 0x6784, 0x678e, 0x678f, 0x6791, 0x6793,
  0x6796, 0x6798, 0x6799, 0x679b, 0x67b0, 0x67b1, 0x67b2, 0x67b5,
  0x67bb, 0x67bc, 0x67bd, 0x67f9, 0x67c0, 0x67c2, 0x67c3, 0x67c5,
  0x67c8, 0x67c9, 0x67d2, 0x67d7, 0x67d9, 0x67dc, 0x67e1, 0x67e6,
  0x67f0, 0x67f2, 0x67f6, 0x67f7, 0x6852, 0x6814, 0x6819, 0x681d,
  0x681f, 0x6828, 0x6827, 0x682c, 0x682d, 0x682f, 0x6830, 0x6831,
  0x6833, 0x683b, 0x683f, 0x6844, 0x6845, 0x684a, 0x684c, 0x6855,
  0x6857, 0x6858, 0x685b, 0x686b, 0x686e, 0x686f, 0x6870, 0x6871,
  0x6872, 0x6875, 0x6879, 0x687a, 0x687b, 0x687c, 0x6882, 0x6884,
  0x6886, 0x6888, 0x6896, 0x6898, 0x689a, 0x689c, 0x68a1, 0x68a3,
  0x68a5, 0x68a9, 0x68aa, 0x68ae, 0x68b2, 0x68bb, 0x68c5, 0x68c8,
  0x68cc, 0x68cf, 0x68d0, 0x68d1, 0x68d3, 0x68d6, 0x68d9, 0x68dc,
  0x68dd, 0x68e5, 0x68e8, 0x68ea, 0x68eb, 0x68ec, 0x68ed, 0x68f0,
  0x68f1, 0x68f5, 0x68f6, 0x68fb, 0x68fc, 0x68fd, 0x6906, 0x6909,
  0x690a, 0x6910, 0x6911, 0x6913, 0x6916, 0x6917, 0x6931, 0x6933,
  0x6935, 0x6938, 0x693b, 0x6942, 0x6945, 0x6949, 0x694e, 0x6957,
  0x695b, 0x6963, 0x6964, 0x6965, 0x6966, 0x6968, 0x6969, 0x696c,
  0x6970, 0x6971, 0x6972, 0x697a, 0x697b, 0x697f, 0x6980, 0x698d,
  0x6992, 0x6996, 0x6998, 0x69a1, 0x69a5, 0x69a6, 0x69a8, 0x69ab,
  0x69ad, 0x69af, 0x69b7, 0x69b8, 0x69ba, 0x69bc, 0x69c5, 0x69c8,
  0x69d1, 0x69d6, 0x69d7, 0x69e2, 0x69e5, 0x69ee, 0x69ef, 0x69f1,
  0x69f3, 0x69f5, 0x69fe, 0x6a00, 0x6a01, 0x6a03, 0x6a0f, 0x6a11,
  0x6a15, 0x6a1a, 0x6a1d, 0x6a20, 0x6a24, 0x6a28, 0x6a30, 0x6a32,
  0x6a34, 0x6a37, 0x6a3b, 0x6a3e, 0x6a3f, 0x6a45, 0x6a46, 0x6a49,
  0x6a4a, 0x6a4e, 0x6a50, 0x6a51, 0x6a52, 0x6a55, 0x6a56, 0x6a5b,
  0x6a64, 0x6a67, 0x6a6a, 0x6a71, 0x6a73, 0x6a7e, 0x6a81, 0x6a83,
  0x6a86, 0x6a87, 0x6a89, 0x6a8b, 0x6a91, 0x6a9b, 0x6a9d, 0x6a9e,
  0x6a9f, 0x6aa5, 0x6aab, 0x6aaf, 0x6ab0, 0x6ab1, 0x6ab4, 0x6abd,
  0x6abe, 0x6abf, 0x6ac6, 0x6ac9, 0x6ac8, 0x6acc, 0x6ad0, 0x6ad4,
  0x6ad5, 0x6ad6, 0x6adc, 0x6add, 0x6ae4, 0x6ae7, 0x6aec, 0x6af0,
  0x6af1, 0x6af2, 0x6afc, 0x6afd, 0x6b02, 0x6b03, 0x6b06, 0x6b07,
  0x6b09, 0x6b0f, 0x6b10, 0x6b11, 0x6b17, 0x6b1b, 0x6b1e, 0x6b24,
  0x6b28, 0x6b2b, 0x6b2c, 0x6b2f, 0x6b35, 0x6b36, 0x6b3b, 0x6b3f,
  0x6b46, 0x6b4a, 0x6b4d, 0x6b52, 0x6b56, 0x6b58, 0x6b5d, 0x6b60,
  0x6b67, 0x6b6b, 0x6b6e, 0x6b70, 0x6b75, 0x6b7d, 0x6b7e, 0x6b82,
  0x6b85, 0x6b97, 0x6b9b, 0x6b9f, 0x6ba0, 0x6ba2, 0x6ba3, 0x6ba8,
  0x6ba9, 0x6bac, 0x6bad, 0x6bae, 0x6bb0, 0x6bb8, 0x6bb9, 0x6bbd,
  0x6bbe, 0x6bc3, 0x6bc4, 0x6bc9, 0x6bcc, 0x6bd6, 0x6bda, 0x6be1,
  0x6be3, 0x6be6, 0x6be7, 0x6bee, 0x6bf1, 0x6bf7, 0x6bf9, 0x6bff,
  0x6c02, 0x6c04, 0x6c05, 0x6c09, 0x6c0d, 0x6c0e, 0x6c10, 0x6c12,
  0x6c19, 0x6c1f, 0x6c26, 0x6c27, 0x6c28, 0x6c2c, 0x6c2e, 0x6c33,
  0x6c35, 0x6c36, 0x6c3a, 0x6c3b, 0x6c3f, 0x6c4a, 0x6c4b, 0x6c4d,
  0x6c4f, 0x6c52, 0x6c54, 0x6c59, 0x6c5b, 0x6c5c, 0x6c6b, 0x6c6d,
  0x6c6f, 0x6c74, 0x6c76, 0x6c78, 0x6c79, 0x6c7b, 0x6c85, 0x6c86,
  0x6c87, 0x6c89, 0x6c94, 0x6c95, 0x6c97, 0x6c98, 0x6c9c, 0x6c9f,
  0x6cb0, 0x6cb2, 0x6cb4, 0x6cc2, 0x6cc6, 0x6ccd, 0x6ccf, 0x6cd0,
  0x6cd1, 0x6cd2, 0x6cd4, 0x6cd6, 0x6cda, 0x6cdc, 0x6ce0, 0x6ce7,
  0x6ce9, 0x6ceb, 0x6cec, 0x6cee, 0x6cf2, 0x6cf4, 0x6d04, 0x6d07,
  0x6d0a, 0x6d0e, 0x6d0f, 0x6d11, 0x6d13, 0x6d1a, 0x6d26, 0x6d27,
  0x6d28, 0x6c67, 0x6d2e, 0x6d2f, 0x6d31, 0x6d39, 0x6d3c, 0x6d3f,
  0x6d57, 0x6d5e, 0x6d5f, 0x6d61, 0x6d65, 0x6d67, 0x6d6f, 0x6d70,
  0x6d7c, 0x6d82, 0x6d87, 0x6d91, 0x6d92, 0x6d94, 0x6d96, 0x6d97,
  0x6d98, 0x6daa, 0x6dac, 0x6db4, 0x6db7, 0x6db9, 0x6dbd, 0x6dbf,
  0x6dc4, 0x6dc8, 0x6dca, 0x6dce, 0x6dcf, 0x6dd6, 0x6ddb, 0x6ddd,
  0x6ddf, 0x6de0, 0x6de2, 0x6de5, 0x6de9, 0x6def, 0x6df0, 0x6df4,
  0x6df6, 0x6dfc, 0x6e00, 0x6e04, 0x6e1e, 0x6e22, 0x6e27, 0x6e32,
  0x6e36, 0x6e39, 0x6e3b, 0x6e3c, 0x6e44, 0x6e45, 0x6e48, 0x6e49,
  0x6e4b, 0x6e4f, 0x6e51, 0x6e52, 0x6e53, 0x6e54, 0x6e57, 0x6e5c,
  0x6e5d, 0x6e5e, 0x6e62, 0x6e63, 0x6e68, 0x6e73, 0x6e7b, 0x6e7d,
  0x6e8d, 0x6e93, 0x6e99, 0x6ea0, 0x6ea7, 0x6ead, 0x6eae, 0x6eb1,
  0x6eb3, 0x6ebb, 0x6ebf, 0x6ec0, 0x6ec1, 0x6ec3, 0x6ec7, 0x6ec8,
  0x6eca, 0x6ecd, 0x6ece, 0x6ecf, 0x6eeb, 0x6eed, 0x6eee, 0x6ef9,
  0x6efb, 0x6efd, 0x6f04, 0x6f08, 0x6f0a, 0x6f0c, 0x6f0d, 0x6f16,
  0x6f18, 0x6f1a, 0x6f1b, 0x6f26, 0x6f29, 0x6f2a, 0x6f2f, 0x6f30,
  0x6f33, 0x6f36, 0x6f3b, 0x6f3c, 0x6f2d, 0x6f4f, 0x6f51, 0x6f52,
  0x6f53, 0x6f57, 0x6f59, 0x6f5a, 0x6f5d, 0x6f5e, 0x6f61, 0x6f62,
  0x6f68, 0x6f6c, 0x6f7d, 0x6f7e, 0x6f83, 0x6f87, 0x6f88, 0x6f8b,
  0x6f8c, 0x6f8d, 0x6f90, 0x6f92, 0x6f93, 0x6f94, 0x6f96, 0x6f9a,
  0x6f9f, 0x6fa0, 0x6fa5, 0x6fa6, 0x6fa7, 0x6fa8, 0x6fae, 0x6faf,
  0x6fb0, 0x6fb5, 0x6fb6, 0x6fbc, 0x6fc5, 0x6fc7, 0x6fc8, 0x6fca,
  0x6fda, 0x6fde, 0x6fe8, 0x6fe9, 0x6ff0, 0x6ff5, 0x6ff9, 0x6ffc,
  0x6ffd, 0x7000, 0x7005, 0x7006, 0x7007, 0x700d, 0x7017, 0x7020,
  0x7023, 0x702f, 0x7034, 0x7037, 0x7039, 0x703c, 0x7043, 0x7044,
  0x7048, 0x7049, 0x704a, 0x704b, 0x7054, 0x7055, 0x705d, 0x705e,
  0x704e, 0x7064, 0x7065, 0x706c, 0x706e, 0x7075, 0x7076, 0x707e,
  0x7081, 0x7085, 0x7086, 0x7094, 0x7095, 0x7096, 0x7097, 0x7098,
  0x709b, 0x70a4, 0x70ab, 0x70b0, 0x70b1, 0x70b4, 0x70b7, 0x70ca,
  0x70d1, 0x70d3, 0x70d4, 0x70d5, 0x70d6, 0x70d8, 0x70dc, 0x70e4,
  0x70fa, 0x7103, 0x7104, 0x7105, 0x7106, 0x7107, 0x710b, 0x710c,
  0x710f, 0x711e, 0x7120, 0x712b, 0x712d, 0x712f, 0x7130, 0x7131,
  0x7138, 0x7141, 0x7145, 0x7146, 0x7147, 0x714a, 0x714b, 0x7150,
  0x7152, 0x7157, 0x715a, 0x715c, 0x715e, 0x7160, 0x7168, 0x7179,
  0x7180, 0x7185, 0x7187, 0x718c, 0x7192, 0x719a, 0x719b, 0x71a0,
  0x71a2, 0x71af, 0x71b0, 0x71b2, 0x71b3, 0x71ba, 0x71bf, 0x71c0,
  0x71c1, 0x71c4, 0x71cb, 0x71cc, 0x71d3, 0x71d6, 0x71d9, 0x71da,
  0x71dc, 0x71f8, 0x71fe, 0x7200, 0x7207, 0x7208, 0x7209, 0x7213,
  0x7217, 0x721a, 0x721d, 0x721f, 0x7224, 0x722b, 0x722f, 0x7234,
  0x7238, 0x7239, 0x7241, 0x7242, 0x7243, 0x7245, 0x724e, 0x724f,
  0x7250, 0x7253, 0x7255, 0x7256, 0x725a, 0x725c, 0x725e, 0x7260,
  0x7263, 0x7268, 0x726b, 0x726e, 0x726f, 0x7271, 0x7277, 0x7278,
  0x727b, 0x727c, 0x727f, 0x7284, 0x7289, 0x728d, 0x728e, 0x7293,
  0x729b, 0x72a8, 0x72ad, 0x72ae, 0x72b1, 0x72b4, 0x72be, 0x72c1,
  0x72c7, 0x72c9, 0x72cc, 0x72d5, 0x72d6, 0x72d8, 0x72df, 0x72e5,
  0x72f3, 0x72f4, 0x72fa, 0x72fb, 0x72fe, 0x7302, 0x7304, 0x7305,
  0x7307, 0x730b, 0x730d, 0x7312, 0x7313, 0x7318, 0x7319, 0x731e,
  0x7322, 0x7324, 0x7327, 0x7328, 0x732c, 0x7331, 0x7332, 0x7335,
  0x733a, 0x733b, 0x733d, 0x7343, 0x734d, 0x7350, 0x7352, 0x7356,
  0x7358, 0x735d, 0x735e, 0x735f, 0x7360, 0x7366, 0x7367, 0x7369,
  0x736b, 0x736c, 0x736e, 0x736f, 0x7371, 0x7377, 0x7379, 0x737c,
  0x7380, 0x7381, 0x7383, 0x7385, 0x7386, 0x738e, 0x7390, 0x7393,
  0x7395, 0x7397, 0x7398, 0x739c, 0x739e, 0x739f, 0x73a0, 0x73a2,
  0x73a5, 0x73a6, 0x73aa, 0x73ab, 0x73ad, 0x73b5, 0x73b7, 0x73b9,
  0x73bc, 0x73bd, 0x73bf, 0x73c5, 0x73c6, 0x73c9, 0x73cb, 0x73cc,
  0x73cf, 0x73d2, 0x73d3, 0x73d6, 0x73d9, 0x73dd, 0x73e1, 0x73e3,
  0x73e6, 0x73e7, 0x73e9, 0x73f4, 0x73f5, 0x73f7, 0x73f9, 0x73fa,
  0x73fb, 0x73fd, 0x73ff, 0x7400, 0x7401, 0x7404, 0x7407, 0x740a,
  0x7411, 0x741a, 0x741b, 0x7424, 0x7426, 0x7428, 0x7429, 0x742a,
  0x742b, 0x742c, 0x742d, 0x742e, 0x742f, 0x7430, 0x7431, 0x7439,
  0x7440, 0x7443, 0x7444, 0x7446, 0x7447, 0x744b, 0x744d, 0x7451,
  0x7452, 0x7457, 0x745d, 0x7462, 0x7466, 0x7467, 0x7468, 0x746b,
  0x746d, 0x746e, 0x7471, 0x7472, 0x7480, 0x7481, 0x7485, 0x7486,
  0x7487, 0x7489, 0x748f, 0x7490, 0x7491, 0x7492, 0x7498, 0x7499,
  0x749a, 0x749c, 0x749f, 0x74a0, 0x74a1, 0x74a3, 0x74a6, 0x74a8,
  0x74a9, 0x74aa, 0x74ab, 0x74ae, 0x74af, 0x74b1, 0x74b2, 0x74b5,
  0x74b9, 0x74bb, 0x74bf, 0x74c8, 0x74c9, 0x74cc, 0x74d0, 0x74d3,
  0x74d8, 0x74da, 0x74db, 0x74de, 0x74df, 0x74e4, 0x74e8, 0x74ea,
  0x74eb, 0x74ef, 0x74f4, 0x74fa, 0x74fb, 0x74fc, 0x74ff, 0x7506,
  0x7512, 0x7516, 0x7517, 0x7520, 0x7521, 0x7524, 0x7527, 0x7529,
  0x752a, 0x752f, 0x7536, 0x7539, 0x753d, 0x753e, 0x753f, 0x7540,
  0x7543, 0x7547, 0x7548, 0x754e, 0x7550, 0x7552, 0x7557, 0x755e,
  0x755f, 0x7561, 0x756f, 0x7571, 0x7579, 0x757a, 0x757b, 0x757c,
  0x757d, 0x757e, 0x7581, 0x7585, 0x7590, 0x7592, 0x7593, 0x7595,
  0x7599, 0x759c, 0x75a2, 0x75a4, 0x75b4, 0x75ba, 0x75bf, 0x75c0,
  0x75c1, 0x75c4, 0x75c6, 0x75cc, 0x75ce, 0x75cf, 0x75d7, 0x75dc,
  0x75df, 0x75e0, 0x75e1, 0x75e4, 0x75e7, 0x75ec, 0x75ee, 0x75ef,
  0x75f1, 0x75f9, 0x7600, 0x7602, 0x7603, 0x7604, 0x7607, 0x7608,
  0x760a, 0x760c, 0x760f, 0x7612, 0x7613, 0x7615, 0x7616, 0x7619,
  0x761b, 0x761c, 0x761d, 0x761e, 0x7623, 0x7625, 0x7626, 0x7629,
  0x762d, 0x7632, 0x7633, 0x7635, 0x7638, 0x7639, 0x763a, 0x763c,
  0x764a, 0x7640, 0x7641, 0x7643, 0x7644, 0x7645, 0x7649, 0x764b,
  0x7655, 0x7659, 0x765f, 0x7664, 0x7665, 0x766d, 0x766e, 0x766f,
  0x7671, 0x7674, 0x7681, 0x7685, 0x768c, 0x768d, 0x7695, 0x769b,
  0x769c, 0x769d, 0x769f, 0x76a0, 0x76a2, 0x76a3, 0x76a4, 0x76a5,
  0x76a6, 0x76a7, 0x76a8, 0x76aa, 0x76ad, 0x76bd, 0x76c1, 0x76c5,
  0x76c9, 0x76cb, 0x76cc, 0x76ce, 0x76d4, 0x76d9, 0x76e0, 0x76e6,
  0x76e8, 0x76ec, 0x76f0, 0x76f1, 0x76f6, 0x76f9, 0x76fc, 0x7700,
  0x7706, 0x770a, 0x770e, 0x7712, 0x7714, 0x7715, 0x7717, 0x7719,
  0x771a, 0x771c, 0x7722, 0x7728, 0x772d, 0x772e, 0x772f, 0x7734,
  0x7735, 0x7736, 0x7739, 0x773d, 0x773e, 0x7742, 0x7745, 0x7746,
  0x774a, 0x774d, 0x774e, 0x774f, 0x7752, 0x7756, 0x7757, 0x775c,
  0x775e, 0x775f, 0x7760, 0x7762, 0x7764, 0x7767, 0x776a, 0x776c,
  0x7770, 0x7772, 0x7773, 0x7774, 0x777a, 0x777d, 0x7780, 0x7784,
  0x778c, 0x778d, 0x7794, 0x7795, 0x7796, 0x779a, 0x779f, 0x77a2,
  0x77a7, 0x77aa, 0x77ae, 0x77af, 0x77b1, 0x77b5, 0x77be, 0x77c3,
  0x77c9, 0x77d1, 0x77d2, 0x77d5, 0x77d9, 0x77de, 0x77df, 0x77e0,
  0x77e4, 0x77e6, 0x77ea, 0x77ec, 0x77f0, 0x77f1, 0x77f4, 0x77f8,
  0x77fb, 0x7805, 0x7806, 0x7809, 0x780d, 0x780e, 0x7811, 0x781d,
  0x7821, 0x7822, 0x7823, 0x782d, 0x782e, 0x7830, 0x7835, 0x7837,
  0x7843, 0x7844, 0x7847, 0x7848, 0x784c, 0x784e, 0x7852, 0x785c,
  0x785e, 0x7860, 0x7861, 0x7863, 0x7864, 0x7868, 0x786a, 0x786e,
  0x787a, 0x787e, 0x788a, 0x788f, 0x7894, 0x7898, 0x78a1, 0x789d,
  0x789e, 0x789f, 0x78a4, 0x78a8, 0x78ac, 0x78ad, 0x78b0, 0x78b1,
  0x78b2, 0x78b3, 0x78bb, 0x78bd, 0x78bf, 0x78c7, 0x78c8, 0x78c9,
  0x78cc, 0x78ce, 0x78d2, 0x78d3, 0x78d5, 0x78d6, 0x78e4, 0x78db,
  0x78df, 0x78e0, 0x78e1, 0x78e6, 0x78ea, 0x78f2, 0x78f3, 0x7900,
  0x78f6, 0x78f7, 0x78fa, 0x78fb, 0x78ff, 0x7906, 0x790c, 0x7910,
  0x791a, 0x791c, 0x791e, 0x791f, 0x7920, 0x7925, 0x7927, 0x7929,
  0x792d, 0x7931, 0x7934, 0x7935, 0x793b, 0x793d, 0x793f, 0x7944,
  0x7945, 0x7946, 0x794a, 0x794b, 0x794f, 0x7951, 0x7954, 0x7958,
  0x795b, 0x795c, 0x7967, 0x7969, 0x796b, 0x7972, 0x7979, 0x797b,
  0x797c, 0x797e, 0x798b, 0x798c, 0x7991, 0x7993, 0x7994, 0x7995,
  0x7996, 0x7998, 0x799b, 0x799c, 0x79a1, 0x79a8, 0x79a9, 0x79ab,
  0x79af, 0x79b1, 0x79b4, 0x79b8, 0x79bb, 0x79c2, 0x79c4, 0x79c7,
  0x79c8, 0x79ca, 0x79cf, 0x79d4, 0x79d6, 0x79da, 0x79dd, 0x79de,
  0x79e0, 0x79e2, 0x79e5, 0x79ea, 0x79eb, 0x79ed, 0x79f1, 0x79f8,
  0x79fc, 0x7a02, 0x7a03, 0x7a07, 0x7a09, 0x7a0a, 0x7a0c, 0x7a11,
  0x7a15, 0x7a1b, 0x7a1e, 0x7a21, 0x7a27, 0x7a2b, 0x7a2d, 0x7a2f,
  0x7a30, 0x7a34, 0x7a35, 0x7a38, 0x7a39, 0x7a3a, 0x7a44, 0x7a45,
  0x7a47, 0x7a48, 0x7a4c, 0x7a55, 0x7a56, 0x7a59, 0x7a5c, 0x7a5d,
  0x7a5f, 0x7a60, 0x7a65, 0x7a67, 0x7a6a, 0x7a6d, 0x7a75, 0x7a78,
  0x7a7e, 0x7a80, 0x7a82, 0x7a85, 0x7a86, 0x7a8a, 0x7a8b, 0x7a90,
  0x7a91, 0x7a94, 0x7a9e, 0x7aa0, 0x7aa3, 0x7aac, 0x7ab3, 0x7ab5,
  0x7ab9, 0x7abb, 0x7abc, 0x7ac6, 0x7ac9, 0x7acc, 0x7ace, 0x7ad1,
  0x7adb, 0x7ae8, 0x7ae9, 0x7aeb, 0x7aec, 0x7af1, 0x7af4, 0x7afb,
  0x7afd, 0x7afe, 0x7b07, 0x7b14, 0x7b1f, 0x7b23, 0x7b27, 0x7b29,
  0x7b2a, 0x7b2b, 0x7b2d, 0x7b2e, 0x7b2f, 0x7b30, 0x7b31, 0x7b34,
  0x7b3d, 0x7b3f, 0x7b40, 0x7b41, 0x7b47, 0x7b4e, 0x7b55, 0x7b60,
  0x7b64, 0x7b66, 0x7b69, 0x7b6a, 0x7b6d, 0x7b6f, 0x7b72, 0x7b73,
  0x7b77, 0x7b84, 0x7b89, 0x7b8e, 0x7b90, 0x7b91, 0x7b96, 0x7b9b,
  0x7b9e, 0x7ba0, 0x7ba5, 0x7bac, 0x7baf, 0x7bb0, 0x7bb2, 0x7bb5,
  0x7bb6, 0x7bba, 0x7bbb, 0x7bbc, 0x7bbd, 0x7bc2, 0x7bc5, 0x7bc8,
  0x7bca, 0x7bd4, 0x7bd6, 0x7bd7, 0x7bd9, 0x7bda, 0x7bdb, 0x7be8,
  0x7bea, 0x7bf2, 0x7bf4, 0x7bf5, 0x7bf8, 0x7bf9, 0x7bfa, 0x7bfc,
  0x7bfe, 0x7c01, 0x7c02, 0x7c03, 0x7c04, 0x7c06, 0x7c09, 0x7c0b,
  0x7c0c, 0x7c0e, 0x7c0f, 0x7c19, 0x7c1b, 0x7c20, 0x7c25, 0x7c26,
  0x7c28, 0x7c2c, 0x7c31, 0x7c33, 0x7c34, 0x7c36, 0x7c39, 0x7c3a,
  0x7c46, 0x7c4a, 0x7c55, 0x7c51, 0x7c52, 0x7c53, 0x7c59, 0x7c5a,
  0x7c5b, 0x7c5c, 0x7c5d, 0x7c5e, 0x7c61, 0x7c63, 0x7c67, 0x7c69,
  0x7c6d, 0x7c6e, 0x7c70, 0x7c72, 0x7c79, 0x7c7c, 0x7c7d, 0x7c86,
  0x7c87, 0x7c8f, 0x7c94, 0x7c9e, 0x7ca0, 0x7ca6, 0x7cb0, 0x7cb6,
  0x7cb7, 0x7cba, 0x7cbb, 0x7cbc, 0x7cbf, 0x7cc4, 0x7cc7, 0x7cc8,
  0x7cc9, 0x7ccd, 0x7ccf, 0x7cd3, 0x7cd4, 0x7cd5, 0x7cd7, 0x7cd9,
  0x7cda, 0x7cdd, 0x7ce6, 0x7ce9, 0x7ceb, 0x7cf5, 0x7d03, 0x7d07,
  0x7d08, 0x7d09, 0x7d0f, 0x7d11, 0x7d12, 0x7d13, 0x7d16, 0x7d1d,
  0x7d1e, 0x7d23, 0x7d26, 0x7d2a, 0x7d2d, 0x7d31, 0x7d3c, 0x7d3d,
  0x7d3e, 0x7d40, 0x7d41, 0x7d47, 0x7d48, 0x7d4d, 0x7d51, 0x7d53,
  0x7d57, 0x7d59, 0x7d5a, 0x7d5c, 0x7d5d, 0x7d65, 0x7d67, 0x7d6a,
  0x7d70, 0x7d78, 0x7d7a, 0x7d7b, 0x7d7f, 0x7d81, 0x7d82, 0x7d83,
  0x7d85, 0x7d86, 0x7d88, 0x7d8b, 0x7d8c, 0x7d8d, 0x7d91, 0x7d96,
  0x7d97, 0x7d9d, 0x7d9e, 0x7da6, 0x7da7, 0x7daa, 0x7db3, 0x7db6,
  0x7db7, 0x7db9, 0x7dc2, 0x7dc3, 0x7dc4, 0x7dc5, 0x7dc6, 0x7dcc,
  0x7dcd, 0x7dce, 0x7dd7, 0x7dd9, 0x7e00, 0x7de2, 0x7de5, 0x7de6,
  0x7dea, 0x7deb, 0x7ded, 0x7df1, 0x7df5, 0x7df6, 0x7df9, 0x7dfa,
  0x7e08, 0x7e10, 0x7e11, 0x7e15, 0x7e17, 0x7e1c, 0x7e1d, 0x7e20,
  0x7e27, 0x7e28, 0x7e2c, 0x7e2d, 0x7e2f, 0x7e33, 0x7e36, 0x7e3f,
  0x7e44, 0x7e45, 0x7e47, 0x7e4e, 0x7e50, 0x7e52, 0x7e58, 0x7e5f,
  0x7e61, 0x7e62, 0x7e65, 0x7e6b, 0x7e6e, 0x7e6f, 0x7e73, 0x7e78,
  0x7e7e, 0x7e81, 0x7e86, 0x7e87, 0x7e8a, 0x7e8d, 0x7e91, 0x7e95,
  0x7e98, 0x7e9a, 0x7e9d, 0x7e9e, 0x7f3c, 0x7f3b, 0x7f3d, 0x7f3e,
  0x7f3f, 0x7f43, 0x7f44, 0x7f47, 0x7f4f, 0x7f52, 0x7f53, 0x7f5b,
  0x7f5c, 0x7f5d, 0x7f61, 0x7f63, 0x7f64, 0x7f65, 0x7f66, 0x7f6d,
  0x7f71, 0x7f7d, 0x7f7e, 0x7f7f, 0x7f80, 0x7f8b, 0x7f8d, 0x7f8f,
  0x7f90, 0x7f91, 0x7f96, 0x7f97, 0x7f9c, 0x7fa1, 0x7fa2, 0x7fa6,
  0x7faa, 0x7fad, 0x7fb4, 0x7fbc, 0x7fbf, 0x7fc0, 0x7fc3, 0x7fc8,
  0x7fce, 0x7fcf, 0x7fdb, 0x7fdf, 0x7fe3, 0x7fe5, 0x7fe8, 0x7fec,
  0x7fee, 0x7fef, 0x7ff2, 0x7ffa, 0x7ffd, 0x7ffe, 0x7fff, 0x8007,
  0x8008, 0x800a, 0x800d, 0x800e, 0x800f, 0x8011, 0x8013, 0x8014,
  0x8016, 0x801d, 0x801e, 0x801f, 0x8020, 0x8024, 0x8026, 0x802c,
  0x802e, 0x8030, 0x8034, 0x8035, 0x8037, 0x8039, 0x803a, 0x803c,
  0x803e, 0x8040, 0x8044, 0x8060, 0x8064, 0x8066, 0x806d, 0x8071,
  0x8075, 0x8081, 0x8088, 0x808e, 0x809c, 0x809e, 0x80a6, 0x80a7,
  0x80ab, 0x80b8, 0x80b9, 0x80c8, 0x80cd, 0x80cf, 0x80d2, 0x80d4,
  0x80d5, 0x80d7, 0x80d8, 0x80e0, 0x80ed, 0x80ee, 0x80f0, 0x80f2,
  0x80f3, 0x80f6, 0x80f9, 0x80fa, 0x80fe, 0x8103, 0x810b, 0x8116,
  0x8117, 0x8118, 0x811c, 0x811e, 0x8120, 0x8124, 0x8127, 0x812c,
  0x8130, 0x8135, 0x813a, 0x813c, 0x8145, 0x8147, 0x814a, 0x814c,
  0x8152, 0x8157, 0x8160, 0x8161, 0x8167, 0x8168, 0x8169, 0x816d,
  0x816f, 0x8177, 0x8181, 0x8190, 0x8184, 0x8185, 0x8186, 0x818b,
  0x818e, 0x8196, 0x8198, 0x819b, 0x819e, 0x81a2, 0x81ae, 0x81b2,
  0x81b4, 0x81bb, 0x81cb, 0x81c3, 0x81c5, 0x81ca, 0x81ce, 0x81cf,
  0x81d5, 0x81d7, 0x81db, 0x81dd, 0x81de, 0x81e1, 0x81e4, 0x81eb,
  0x81ec, 0x81f0, 0x81f1, 0x81f2, 0x81f5, 0x81f6, 0x81f8, 0x81f9,
  0x81fd, 0x81ff, 0x8200, 0x8203, 0x820f, 0x8213, 0x8214, 0x8219,
  0x821a, 0x821d, 0x8221, 0x8222, 0x8228, 0x8232, 0x8234, 0x823a,
  0x8243, 0x8244, 0x8245, 0x8246, 0x824b, 0x824e, 0x824f, 0x8251,
  0x8256, 0x825c, 0x8260, 0x8263, 0x8267, 0x826d, 0x8274, 0x827b,
  0x827d, 0x827f, 0x8280, 0x8281, 0x8283, 0x8284, 0x8287, 0x8289,
  0x828a, 0x828e, 0x8291, 0x8294, 0x8296, 0x8298, 0x829a, 0x829b,
  0x82a0, 0x82a1, 0x82a3, 0x82a4, 0x82a7, 0x82a8, 0x82a9, 0x82aa,
  0x82ae, 0x82b0, 0x82b2, 0x82b4, 0x82b7, 0x82ba, 0x82bc, 0x82be,
  0x82bf, 0x82c6, 0x82d0, 0x82d5, 0x82da, 0x82e0, 0x82e2, 0x82e4,
  0x82e8, 0x82ea, 0x82ed, 0x82ef, 0x82f6, 0x82f7, 0x82fd, 0x82fe,
  0x8300, 0x8301, 0x8307, 0x8308, 0x830a, 0x830b, 0x8354, 0x831b,
  0x831d, 0x831e, 0x831f, 0x8321, 0x8322, 0x832c, 0x832d, 0x832e,
  0x8330, 0x8333, 0x8337, 0x833a, 0x833c, 0x833d, 0x8342, 0x8343,
  0x8344, 0x8347, 0x834d, 0x834e, 0x8351, 0x8355, 0x8356, 0x8357,
  0x8370, 0x8378, 0x837d, 0x837f, 0x8380, 0x8382, 0x8384, 0x8386,
  0x838d, 0x8392, 0x8394, 0x8395, 0x8398, 0x8399, 0x839b, 0x839c,
  0x839d, 0x83a6, 0x83a7, 0x83a9, 0x83ac, 0x83be, 0x83bf, 0x83c0,
  0x83c7, 0x83c9, 0x83cf, 0x83d0, 0x83d1, 0x83d4, 0x83dd, 0x8353,
  0x83e8, 0x83ea, 0x83f6, 0x83f8, 0x83f9, 0x83fc, 0x8401, 0x8406,
  0x840a, 0x840f, 0x8411, 0x8415, 0x8419, 0x83ad, 0x842f, 0x8439,
  0x8445, 0x8447, 0x8448, 0x844a, 0x844d, 0x844f, 0x8451, 0x8452,
  0x8456, 0x8458, 0x8459, 0x845a, 0x845c, 0x8460, 0x8464, 0x8465,
  0x8467, 0x846a, 0x8470, 0x8473, 0x8474, 0x8476, 0x8478, 0x847c,
  0x847d, 0x8481, 0x8485, 0x8492, 0x8493, 0x8495, 0x849e, 0x84a6,
  0x84a8, 0x84a9, 0x84aa, 0x84af, 0x84b1, 0x84b4, 0x84ba, 0x84bd,
  0x84be, 0x84c0, 0x84c2, 0x84c7, 0x84c8, 0x84cc, 0x84cf, 0x84d3,
  0x84dc, 0x84e7, 0x84ea, 0x84ef, 0x84f0, 0x84f1, 0x84f2, 0x84f7,
  0x8532, 0x84fa, 0x84fb, 0x84fd, 0x8502, 0x8503, 0x8507, 0x850c,
  0x850e, 0x8510, 0x851c, 0x851e, 0x8522, 0x8523, 0x8524, 0x8525,
  0x8527, 0x852a, 0x852b, 0x852f, 0x8533, 0x8534, 0x8536, 0x853f,
  0x8546, 0x854f, 0x8550, 0x8551, 0x8552, 0x8553, 0x8556, 0x8559,
  0x855c, 0x855d, 0x855e, 0x855f, 0x8560, 0x8561, 0x8562, 0x8564,
  0x856b, 0x856f, 0x8579, 0x857a, 0x857b, 0x857d, 0x857f, 0x8581,
  0x8585, 0x8586, 0x8589, 0x858b, 0x858c, 0x858f, 0x8593, 0x8598,
  0x859d, 0x859f, 0x85a0, 0x85a2, 0x85a5, 0x85a7, 0x85b4, 0x85b6,
  0x85b7, 0x85b8, 0x85bc, 0x85bd, 0x85be, 0x85bf, 0x85c2, 0x85c7,
  0x85ca, 0x85cb, 0x85ce, 0x85ad, 0x85d8, 0x85da, 0x85df, 0x85e0,
  0x85e6, 0x85e8, 0x85ed, 0x85f3, 0x85f6, 0x85fc, 0x85ff, 0x8600,
  0x8604, 0x8605, 0x860d, 0x860e, 0x8610, 0x8611, 0x8612, 0x8618,
  0x8619, 0x861b, 0x861e, 0x8621, 0x8627, 0x8629, 0x8636, 0x8638,
  0x863a, 0x863c, 0x863d, 0x8640, 0x8642, 0x8646, 0x8652, 0x8653,
  0x8656, 0x8657, 0x8658, 0x8659, 0x865d, 0x8660, 0x8661, 0x8662,
  0x8663, 0x8664, 0x8669, 0x866c, 0x866f, 0x8675, 0x8676, 0x8677,
  0x867a, 0x868d, 0x8691, 0x8696, 0x8698, 0x869a, 0x869c, 0x86a1,
  0x86a6, 0x86a7, 0x86a8, 0x86ad, 0x86b1, 0x86b3, 0x86b4, 0x86b5,
  0x86b7, 0x86b8, 0x86b9, 0x86bf, 0x86c0, 0x86c1, 0x86c3, 0x86c5,
  0x86d1, 0x86d2, 0x86d5, 0x86d7, 0x86da, 0x86dc, 0x86e0, 0x86e3,
  0x86e5, 0x86e7, 0x8688, 0x86fa, 0x86fc, 0x86fd, 0x8704, 0x8705,
  0x8707, 0x870b, 0x870e, 0x870f, 0x8710, 0x8713, 0x8714, 0x8719,
  0x871e, 0x871f, 0x8721, 0x8723, 0x8728, 0x872e, 0x872f, 0x8731,
  0x8732, 0x8739, 0x873a, 0x873c, 0x873d, 0x873e, 0x8740, 0x8743,
  0x8745, 0x874d, 0x8758, 0x875d, 0x8761, 0x8764, 0x8765, 0x876f,
  0x8771, 0x8772, 0x877b, 0x8783, 0x8784, 0x8785, 0x8786, 0x8787,
  0x8788, 0x8789, 0x878b, 0x878c, 0x8790, 0x8793, 0x8795, 0x8797,
  0x8798, 0x8799, 0x879e, 0x87a0, 0x87a3, 0x87a7, 0x87ac, 0x87ad,
  0x87ae, 0x87b1, 0x87b5, 0x87be, 0x87bf, 0x87c1, 0x87c8, 0x87c9,
  0x87ca, 0x87ce, 0x87d5, 0x87d6, 0x87d9, 0x87da, 0x87dc, 0x87df,
  0x87e2, 0x87e3, 0x87e4, 0x87ea, 0x87eb, 0x87ed, 0x87f1, 0x87f3,
  0x87f8, 0x87fa, 0x87ff, 0x8801, 0x8803, 0x8806, 0x8809, 0x880a,
  0x880b, 0x8810, 0x8819, 0x8812, 0x8813, 0x8814, 0x8818, 0x881a,
  0x881b, 0x881c, 0x881e, 0x881f, 0x8828, 0x882d, 0x882e, 0x8830,
  0x8832, 0x8835, 0x883a, 0x883c, 0x8841, 0x8843, 0x8845, 0x8848,
  0x8849, 0x884a, 0x884b, 0x884e, 0x8851, 0x8855, 0x8856, 0x8858,
  0x885a, 0x885c, 0x885f, 0x8860, 0x8864, 0x8869, 0x8871, 0x8879,
  0x887b, 0x8880, 0x8898, 0x889a, 0x889b, 0x889c, 0x889f, 0x88a0,
  0x88a8, 0x88aa, 0x88ba, 0x88bd, 0x88be, 0x88c0, 0x88ca, 0x88cb,
  0x88cc, 0x88cd, 0x88ce, 0x88d1, 0x88d2, 0x88d3, 0x88db, 0x88de,
  0x88e7, 0x88ef, 0x88f0, 0x88f1, 0x88f5, 0x88f7, 0x8901, 0x8906,
  0x890d, 0x890e, 0x890f, 0x8915, 0x8916, 0x8918, 0x8919, 0x891a,
  0x891c, 0x8920, 0x8926, 0x8927, 0x8928, 0x8930, 0x8931, 0x8932,
  0x8935, 0x8939, 0x893a, 0x893e, 0x8940, 0x8942, 0x8945, 0x8946,
  0x8949, 0x894f, 0x8952, 0x8957, 0x895a, 0x895b, 0x895c, 0x8961,
  0x8962, 0x8963, 0x896b, 0x896e, 0x8970, 0x8973, 0x8975, 0x897a,
  0x897b, 0x897c, 0x897d, 0x8989, 0x898d, 0x8990, 0x8994, 0x8995,
  0x899b, 0x899c, 0x899f, 0x89a0, 0x89a5, 0x89b0, 0x89b4, 0x89b5,
  0x89b6, 0x89b7, 0x89bc, 0x89d4, 0x89d5, 0x89d6, 0x89d7, 0x89d8,
  0x89e5, 0x89e9, 0x89eb, 0x89ed, 0x89f1, 0x89f3, 0x89f6, 0x89f9,
  0x89fd, 0x89ff, 0x8a04, 0x8a05, 0x8a07, 0x8a0f, 0x8a11, 0x8a12,
  0x8a14, 0x8a15, 0x8a1e, 0x8a20, 0x8a22, 0x8a24, 0x8a26, 0x8a2b,
  0x8a2c, 0x8a2f, 0x8a35, 0x8a37, 0x8a3d, 0x8a3e, 0x8a40, 0x8a43,
  0x8a45, 0x8a47, 0x8a49, 0x8a4d, 0x8a4e, 0x8a53, 0x8a56, 0x8a57,
  0x8a58, 0x8a5c, 0x8a5d, 0x8a61, 0x8a65, 0x8a67, 0x8a75, 0x8a76,
  0x8a77, 0x8a79, 0x8a7a, 0x8a7b, 0x8a7e, 0x8a7f, 0x8a80, 0x8a83,
  0x8a86, 0x8a8b, 0x8a8f, 0x8a90, 0x8a92, 0x8a96, 0x8a97, 0x8a99,
  0x8a9f, 0x8aa7, 0x8aa9, 0x8aae, 0x8aaf, 0x8ab3, 0x8ab6, 0x8ab7,
  0x8abb, 0x8abe, 0x8ac3, 0x8ac6, 0x8ac8, 0x8ac9, 0x8aca, 0x8ad1,
  0x8ad3, 0x8ad4, 0x8ad5, 0x8ad7, 0x8add, 0x8adf, 0x8aec, 0x8af0,
  0x8af4, 0x8af5, 0x8af6, 0x8afc, 0x8aff, 0x8b05, 0x8b06, 0x8b0b,
  0x8b11, 0x8b1c, 0x8b1e, 0x8b1f, 0x8b0a, 0x8b2d, 0x8b30, 0x8b37,
  0x8b3c, 0x8b42, 0x8b43, 0x8b44, 0x8b45, 0x8b46, 0x8b48, 0x8b52,
  0x8b53, 0x8b54, 0x8b59, 0x8b4d, 0x8b5e, 0x8b63, 0x8b6d, 0x8b76,
  0x8b78, 0x8b79, 0x8b7c, 0x8b7e, 0x8b81, 0x8b84, 0x8b85, 0x8b8b,
  0x8b8d, 0x8b8f, 0x8b94, 0x8b95, 0x8b9c, 0x8b9e, 0x8b9f, 0x8c38,
  0x8c39, 0x8c3d, 0x8c3e, 0x8c45, 0x8c47, 0x8c49, 0x8c4b, 0x8c4f,
  0x8c51, 0x8c53, 0x8c54, 0x8c57, 0x8c58, 0x8c5b, 0x8c5d, 0x8c59,
  0x8c63, 0x8c64, 0x8c66, 0x8c68, 0x8c69, 0x8c6d, 0x8c73, 0x8c75,
  0x8c76, 0x8c7b, 0x8c7e, 0x8c86, 0x8c87, 0x8c8b, 0x8c90, 0x8c92,
  0x8c93, 0x8c99, 0x8c9b, 0x8c9c, 0x8ca4, 0x8cb9, 0x8cba, 0x8cc5,
  0x8cc6, 0x8cc9, 0x8ccb, 0x8ccf, 0x8cd6, 0x8cd5, 0x8cd9, 0x8cdd,
  0x8ce1, 0x8ce8, 0x8cec, 0x8cef, 0x8cf0, 0x8cf2, 0x8cf5, 0x8cf7,
  0x8cf8, 0x8cfe, 0x8cff, 0x8d01, 0x8d03, 0x8d09, 0x8d12, 0x8d17,
  0x8d1b, 0x8d65, 0x8d69, 0x8d6c, 0x8d6e, 0x8d7f, 0x8d82, 0x8d84,
  0x8d88, 0x8d8d, 0x8d90, 0x8d91, 0x8d95, 0x8d9e, 0x8d9f, 0x8da0,
  0x8da6, 0x8dab, 0x8dac, 0x8daf, 0x8db2, 0x8db5, 0x8db7, 0x8db9,
  0x8dbb, 0x8dc0, 0x8dc5, 0x8dc6, 0x8dc7, 0x8dc8, 0x8dca, 0x8dce,
  0x8dd1, 0x8dd4, 0x8dd5, 0x8dd7, 0x8dd9, 0x8de4, 0x8de5, 0x8de7,
  0x8dec, 0x8df0, 0x8dbc, 0x8df1, 0x8df2, 0x8df4, 0x8dfd, 0x8e01,
  0x8e04, 0x8e05, 0x8e06, 0x8e0b, 0x8e11, 0x8e14, 0x8e16, 0x8e20,
  0x8e21, 0x8e22, 0x8e23, 0x8e26, 0x8e27, 0x8e31, 0x8e33, 0x8e36,
  0x8e37, 0x8e38, 0x8e39, 0x8e3d, 0x8e40, 0x8e41, 0x8e4b, 0x8e4d,
  0x8e4e, 0x8e4f, 0x8e54, 0x8e5b, 0x8e5c, 0x8e5d, 0x8e5e, 0x8e61,
  0x8e62, 0x8e69, 0x8e6c, 0x8e6d, 0x8e6f, 0x8e70, 0x8e71, 0x8e79,
  0x8e7a, 0x8e7b, 0x8e82, 0x8e83, 0x8e89, 0x8e90, 0x8e92, 0x8e95,
  0x8e9a, 0x8e9b, 0x8e9d, 0x8e9e, 0x8ea2, 0x8ea7, 0x8ea9, 0x8ead,
  0x8eae, 0x8eb3, 0x8eb5, 0x8eba, 0x8ebb, 0x8ec0, 0x8ec1, 0x8ec3,
  0x8ec4, 0x8ec7, 0x8ecf, 0x8ed1, 0x8ed4, 0x8edc, 0x8ee8, 0x8eee,
  0x8ef0, 0x8ef1, 0x8ef7, 0x8ef9, 0x8efa, 0x8eed, 0x8f00, 0x8f02,
  0x8f07, 0x8f08, 0x8f0f, 0x8f10, 0x8f16, 0x8f17, 0x8f18, 0x8f1e,
  0x8f20, 0x8f21, 0x8f23, 0x8f25, 0x8f27, 0x8f28, 0x8f2c, 0x8f2d,
  0x8f2e, 0x8f34, 0x8f35, 0x8f36, 0x8f37, 0x8f3a, 0x8f40, 0x8f41,
  0x8f43, 0x8f47, 0x8f4f, 0x8f51, 0x8f52, 0x8f53, 0x8f54, 0x8f55,
  0x8f58, 0x8f5d, 0x8f5e, 0x8f65, 0x8f9d, 0x8fa0, 0x8fa1, 0x8fa4,
  0x8fa5, 0x8fa6, 0x8fb5, 0x8fb6, 0x8fb8, 0x8fbe, 0x8fc0, 0x8fc1,
  0x8fc6, 0x8fca, 0x8fcb, 0x8fcd, 0x8fd0, 0x8fd2, 0x8fd3, 0x8fd5,
  0x8fe0, 0x8fe3, 0x8fe4, 0x8fe8, 0x8fee, 0x8ff1, 0x8ff5, 0x8ff6,
  0x8ffb, 0x8ffe, 0x9002, 0x9004, 0x9008, 0x900c, 0x9018, 0x901b,
  0x9028, 0x9029, 0x902f, 0x902a, 0x902c, 0x902d, 0x9033, 0x9034,
  0x9037, 0x903f, 0x9043, 0x9044, 0x904c, 0x905b, 0x905d, 0x9062,
  0x9066, 0x9067, 0x906c, 0x9070, 0x9074, 0x9079, 0x9085, 0x9088,
  0x908b, 0x908c, 0x908e, 0x9090, 0x9095, 0x9097, 0x9098, 0x9099,
  0x909b, 0x90a0, 0x90a1, 0x90a2, 0x90a5, 0x90b0, 0x90b2, 0x90b3,
  0x90b4, 0x90b6, 0x90bd, 0x90cc, 0x90be, 0x90c3, 0x90c4, 0x90c5,
  0x90c7, 0x90c8, 0x90d5, 0x90d7, 0x90d8, 0x90d9, 0x90dc, 0x90dd,
  0x90df, 0x90e5, 0x90d2, 0x90f6, 0x90eb, 0x90ef, 0x90f0, 0x90f4,
  0x90fe, 0x90ff, 0x9100, 0x9104, 0x9105, 0x9106, 0x9108, 0x910d,
  0x9110, 0x9114, 0x9116, 0x9117, 0x9118, 0x911a, 0x911c, 0x911e,
  0x9120, 0x9125, 0x9122, 0x9123, 0x9127, 0x9129, 0x912e, 0x912f,
  0x9131, 0x9134, 0x9136, 0x9137, 0x9139, 0x913a, 0x913c, 0x913d,
  0x9143, 0x9147, 0x9148, 0x914f, 0x9153, 0x9157, 0x9159, 0x915a,
  0x915b, 0x9161, 0x9164, 0x9167, 0x916d, 0x9174, 0x9179, 0x917a,
  0x917b, 0x9181, 0x9183, 0x9185, 0x9186, 0x918a, 0x918e, 0x9191,
  0x9193, 0x9194, 0x9195, 0x9198, 0x919e, 0x91a1, 0x91a6, 0x91a8,
  0x91ac, 0x91ad, 0x91ae, 0x91b0, 0x91b1, 0x91b2, 0x91b3, 0x91b6,
  0x91bb, 0x91bc, 0x91bd, 0x91bf, 0x91c2, 0x91c3, 0x91c5, 0x91d3,
  0x91d4, 0x91d7, 0x91d9, 0x91da, 0x91de, 0x91e4, 0x91e5, 0x91e9,
  0x91ea, 0x91ec, 0x91ed, 0x91ee, 0x91ef, 0x91f0, 0x91f1, 0x91f7,
  0x91f9, 0x91fb, 0x91fd, 0x9200, 0x9201, 0x9204, 0x9205, 0x9206,
  0x9207, 0x9209, 0x920a, 0x920c, 0x9210, 0x9212, 0x9213, 0x9216,
  0x9218, 0x921c, 0x921d, 0x9223, 0x9224, 0x9225, 0x9226, 0x9228,
  0x922e, 0x922f, 0x9230, 0x9233, 0x9235, 0x9236, 0x9238, 0x9239,
  0x923a, 0x923c, 0x923e, 0x9240, 0x9242, 0x9243, 0x9246, 0x9247,
  0x924a, 0x924d, 0x924e, 0x924f, 0x9251, 0x9258, 0x9259, 0x925c,
  0x925d, 0x9260, 0x9261, 0x9265, 0x9267, 0x9268, 0x9269, 0x926e,
  0x926f, 0x9270, 0x9275, 0x9276, 0x9277, 0x9278, 0x9279, 0x927b,
  0x927c, 0x927d, 0x927f, 0x9288, 0x9289, 0x928a, 0x928d, 0x928e,
  0x9292, 0x9297, 0x9299, 0x929f, 0x92a0, 0x92a4, 0x92a5, 0x92a7,
  0x92a8, 0x92ab, 0x92af, 0x92b2, 0x92b6, 0x92b8, 0x92ba, 0x92bb,
  0x92bc, 0x92bd, 0x92bf, 0x92c0, 0x92c1, 0x92c2, 0x92c3, 0x92c5,
  0x92c6, 0x92c7, 0x92c8, 0x92cb, 0x92cc, 0x92cd, 0x92ce, 0x92d0,
  0x92d3, 0x92d5, 0x92d7, 0x92d8, 0x92d9, 0x92dc, 0x92dd, 0x92df,
  0x92e0, 0x92e1, 0x92e3, 0x92e5, 0x92e7, 0x92e8, 0x92ec, 0x92ee,
  0x92f0, 0x92f9, 0x92fb, 0x92ff, 0x9300, 0x9302, 0x9308, 0x930d,
  0x9311, 0x9314, 0x9315, 0x931c, 0x931d, 0x931e, 0x931f, 0x9321,
  0x9324, 0x9325, 0x9327, 0x9329, 0x932a, 0x9333, 0x9334, 0x9336,
  0x9337, 0x9347, 0x9348, 0x9349, 0x9350, 0x9351, 0x9352, 0x9355,
  0x9357, 0x9358, 0x935a, 0x935e, 0x9364, 0x9365, 0x9367, 0x9369,
  0x936a, 0x936d, 0x936f, 0x9370, 0x9371, 0x9373, 0x9374, 0x9376,
  0x937a, 0x937d, 0x937f, 0x9380, 0x9381, 0x9382, 0x9388, 0x938a,
  0x938b, 0x938d, 0x938f, 0x9392, 0x9395, 0x9398, 0x939b, 0x939e,
  0x93a1, 0x93a3, 0x93a4, 0x93a6, 0x93a8, 0x93ab, 0x93b4, 0x93b5,
  0x93b6, 0x93ba, 0x93a9, 0x93c1, 0x93c4, 0x93c5, 0x93c6, 0x93c7,
  0x93c9, 0x93ca, 0x93cb, 0x93cc, 0x93cd, 0x93d3, 0x93d9, 0x93dc,
  0x93de, 0x93df, 0x93e2, 0x93e6, 0x93e7, 0x93f9, 0x93f7, 0x93f8,
  0x93fa, 0x93fb, 0x93fd, 0x9401, 0x9402, 0x9404, 0x9408, 0x9409,
  0x940d, 0x940e, 0x940f, 0x9415, 0x9416, 0x9417, 0x941f, 0x942e,
  0x942f, 0x9431, 0x9432, 0x9433, 0x9434, 0x943b, 0x943f, 0x943d,
  0x9443, 0x9445, 0x9448, 0x944a, 0x944c, 0x9455, 0x9459, 0x945c,
  0x945f, 0x9461, 0x9463, 0x9468, 0x946b, 0x946d, 0x946e, 0x946f,
  0x9471, 0x9472, 0x9484, 0x9483, 0x9578, 0x9579, 0x957e, 0x9584,
  0x9588, 0x958c, 0x958d, 0x958e, 0x959d, 0x959e, 0x959f, 0x95a1,
  0x95a6, 0x95a9, 0x95ab, 0x95ac, 0x95b4, 0x95b6, 0x95ba, 0x95bd,
  0x95bf, 0x95c6, 0x95c8, 0x95c9, 0x95cb, 0x95d0, 0x95d1, 0x95d2,
  0x95d3, 0x95d9, 0x95da, 0x95dd, 0x95de, 0x95df, 0x95e0, 0x95e4,
  0x95e6, 0x961d, 0x961e, 0x9622, 0x9624, 0x9625, 0x9626, 0x962c,
  0x9631, 0x9633, 0x9637, 0x9638, 0x9639, 0x963a, 0x963c, 0x963d,
  0x9641, 0x9652, 0x9654, 0x9656, 0x9657, 0x9658, 0x9661, 0x966e,
  0x9674, 0x967b, 0x967c, 0x967e, 0x967f, 0x9681, 0x9682, 0x9683,
  0x9684, 0x9689, 0x9691, 0x9696, 0x969a, 0x969d, 0x969f, 0x96a4,
  0x96a5, 0x96a6, 0x96a9, 0x96ae, 0x96af, 0x96b3, 0x96ba, 0x96ca,
  0x96d2, 0x5db2, 0x96d8, 0x96da, 0x96dd, 0x96de, 0x96df, 0x96e9,
  0x96ef, 0x96f1, 0x96fa, 0x9702, 0x9703, 0x9705, 0x9709, 0x971a,
  0x971b, 0x971d, 0x9721, 0x9722, 0x9723, 0x9728, 0x9731, 0x9733,
  0x9741, 0x9743, 0x974a, 0x974e, 0x974f, 0x9755, 0x9757, 0x9758,
  0x975a, 0x975b, 0x9763, 0x9767, 0x976a, 0x976e, 0x9773, 0x9776,
  0x9777, 0x9778, 0x977b, 0x977d, 0x977f, 0x9780, 0x9789, 0x9795,
  0x9796, 0x9797, 0x9799, 0x979a, 0x979e, 0x979f, 0x97a2, 0x97ac,
  0x97ae, 0x97b1, 0x97b2, 0x97b5, 0x97b6, 0x97b8, 0x97b9, 0x97ba,
  0x97bc, 0x97be, 0x97bf, 0x97c1, 0x97c4, 0x97c5, 0x97c7, 0x97c9,
  0x97ca, 0x97cc, 0x97cd, 0x97ce, 0x97d0, 0x97d1, 0x97d4, 0x97d7,
  0x97d8, 0x97d9, 0x97dd, 0x97de, 0x97e0, 0x97db, 0x97e1, 0x97e4,
  0x97ef, 0x97f1, 0x97f4, 0x97f7, 0x97f8, 0x97fa, 0x9807, 0x980a,
  0x9819, 0x980d, 0x980e, 0x9814, 0x9816, 0x981c, 0x981e, 0x9820,
  0x9823, 0x9826, 0x982b, 0x982e, 0x982f, 0x9830, 0x9832, 0x9833,
  0x9835, 0x9825, 0x983e, 0x9844, 0x9847, 0x984a, 0x9851, 0x9852,
  0x9853, 0x9856, 0x9857, 0x9859, 0x985a, 0x9862, 0x9863, 0x9865,
  0x9866, 0x986a, 0x986c, 0x98ab, 0x98ad, 0x98ae, 0x98b0, 0x98b4,
  0x98b7, 0x98b8, 0x98ba, 0x98bb, 0x98bf, 0x98c2, 0x98c5, 0x98c8,
  0x98cc, 0x98e1, 0x98e3, 0x98e5, 0x98e6, 0x98e7, 0x98ea, 0x98f3,
  0x98f6, 0x9902, 0x9907, 0x9908, 0x9911, 0x9915, 0x9916, 0x9917,
  0x991a, 0x991b, 0x991c, 0x991f, 0x9922, 0x9926, 0x9927, 0x992b,
  0x9931, 0x9932, 0x9933, 0x9934, 0x9935, 0x9939, 0x993a, 0x993b,
  0x993c, 0x9940, 0x9941, 0x9946, 0x9947, 0x9948, 0x994d, 0x994e,
  0x9954, 0x9958, 0x9959, 0x995b, 0x995c, 0x995e, 0x995f, 0x9960,
  0x999b, 0x999d, 0x999f, 0x99a6, 0x99b0, 0x99b1, 0x99b2, 0x99b5,
  0x99b9, 0x99ba, 0x99bd, 0x99bf, 0x99c3, 0x99c9, 0x99d3, 0x99d4,
  0x99d9, 0x99da, 0x99dc, 0x99de, 0x99e7, 0x99ea, 0x99eb, 0x99ec,
  0x99f0, 0x99f4, 0x99f5, 0x99f9, 0x99fd, 0x99fe, 0x9a02, 0x9a03,
  0x9a04, 0x9a0b, 0x9a0c, 0x9a10, 0x9a11, 0x9a16, 0x9a1e, 0x9a20,
  0x9a22, 0x9a23, 0x9a24, 0x9a27, 0x9a2d, 0x9a2e, 0x9a33, 0x9a35,
  0x9a36, 0x9a38, 0x9a47, 0x9a41, 0x9a44, 0x9a4a, 0x9a4b, 0x9a4c,
  0x9a4e, 0x9a51, 0x9a54, 0x9a56, 0x9a5d, 0x9aaa, 0x9aac, 0x9aae,
  0x9aaf, 0x9ab2, 0x9ab4, 0x9ab5, 0x9ab6, 0x9ab9, 0x9abb, 0x9abe,
  0x9abf, 0x9ac1, 0x9ac3, 0x9ac6, 0x9ac8, 0x9ace, 0x9ad0, 0x9ad2,
  0x9ad5, 0x9ad6, 0x9ad7, 0x9adb, 0x9adc, 0x9ae0, 0x9ae4, 0x9ae5,
  0x9ae7, 0x9ae9, 0x9aec, 0x9af2, 0x9af3, 0x9af5, 0x9af9, 0x9afa,
  0x9afd, 0x9aff, 0x9b00, 0x9b01, 0x9b02, 0x9b03, 0x9b04, 0x9b05,
  0x9b08, 0x9b09, 0x9b0b, 0x9b0c, 0x9b0d, 0x9b0e, 0x9b10, 0x9b12,
  0x9b16, 0x9b19, 0x9b1b, 0x9b1c, 0x9b20, 0x9b26, 0x9b2b, 0x9b2d,
  0x9b33, 0x9b34, 0x9b35, 0x9b37, 0x9b39, 0x9b3a, 0x9b3d, 0x9b48,
  0x9b4b, 0x9b4c, 0x9b55, 0x9b56, 0x9b57, 0x9b5b, 0x9b5e, 0x9b61,
  0x9b63, 0x9b65, 0x9b66, 0x9b68, 0x9b6a, 0x9b6b, 0x9b6c, 0x9b6d,
  0x9b6e, 0x9b73, 0x9b75, 0x9b77, 0x9b78, 0x9b79, 0x9b7f, 0x9b80,
  0x9b84, 0x9b85, 0x9b86, 0x9b87, 0x9b89, 0x9b8a, 0x9b8b, 0x9b8d,
  0x9b8f, 0x9b90, 0x9b94, 0x9b9a, 0x9b9d, 0x9b9e, 0x9ba6, 0x9ba7,
  0x9ba9, 0x9bac, 0x9bb0, 0x9bb1, 0x9bb2, 0x9bb7, 0x9bb8, 0x9bbb,
  0x9bbc, 0x9bbe, 0x9bbf, 0x9bc1, 0x9bc7, 0x9bc8, 0x9bce, 0x9bd0,
  0x9bd7, 0x9bd8, 0x9bdd, 0x9bdf, 0x9be5, 0x9be7, 0x9bea, 0x9beb,
  0x9bef, 0x9bf3, 0x9bf7, 0x9bf8, 0x9bf9, 0x9bfa, 0x9bfd, 0x9bff,
  0x9c00, 0x9c02, 0x9c0b, 0x9c0f, 0x9c11, 0x9c16, 0x9c18, 0x9c19,
  0x9c1a, 0x9c1c, 0x9c1e, 0x9c22, 0x9c23, 0x9c26, 0x9c27, 0x9c28,
  0x9c29, 0x9c2a, 0x9c31, 0x9c35, 0x9c36, 0x9c37, 0x9c3d, 0x9c41,
  0x9c43, 0x9c44, 0x9c45, 0x9c49, 0x9c4a, 0x9c4e, 0x9c4f, 0x9c50,
  0x9c53, 0x9c54, 0x9c56, 0x9c58, 0x9c5b, 0x9c5d, 0x9c5e, 0x9c5f,
  0x9c63, 0x9c69, 0x9c6a, 0x9c5c, 0x9c6b, 0x9c68, 0x9c6e, 0x9c70,
  0x9c72, 0x9c75, 0x9c77, 0x9c7b, 0x9ce6, 0x9cf2, 0x9cf7, 0x9cf9,
  0x9d0b, 0x9d02, 0x9d11, 0x9d17, 0x9d18, 0x9d1c, 0x9d1d, 0x9d1e,
  0x9d2f, 0x9d30, 0x9d32, 0x9d33, 0x9d34, 0x9d3a, 0x9d3c, 0x9d45,
  0x9d3d, 0x9d42, 0x9d43, 0x9d47, 0x9d4a, 0x9d53, 0x9d54, 0x9d5f,
  0x9d63, 0x9d62, 0x9d65, 0x9d69, 0x9d6a, 0x9d6b, 0x9d70, 0x9d76,
  0x9d77, 0x9d7b, 0x9d7c, 0x9d7e, 0x9d83, 0x9d84, 0x9d86, 0x9d8a,
  0x9d8d, 0x9d8e, 0x9d92, 0x9d93, 0x9d95, 0x9d96, 0x9d97, 0x9d98,
  0x9da1, 0x9daa, 0x9dac, 0x9dae, 0x9db1, 0x9db5, 0x9db9, 0x9dbc,
  0x9dbf, 0x9dc3, 0x9dc7, 0x9dc9, 0x9dca, 0x9dd4, 0x9dd5, 0x9dd6,
  0x9dd7, 0x9dda, 0x9dde, 0x9ddf, 0x9de0, 0x9de5, 0x9de7, 0x9de9,
  0x9deb, 0x9dee, 0x9df0, 0x9df3, 0x9df4, 0x9dfe, 0x9e0a, 0x9e02,
  0x9e07, 0x9e0e, 0x9e10, 0x9e11, 0x9e12, 0x9e15, 0x9e16, 0x9e19,
  0x9e1c, 0x9e1d, 0x9e7a, 0x9e7b, 0x9e7c, 0x9e80, 0x9e82, 0x9e83,
  0x9e84, 0x9e85, 0x9e87, 0x9e8e, 0x9e8f, 0x9e96, 0x9e98, 0x9e9b,
  0x9e9e, 0x9ea4, 0x9ea8, 0x9eac, 0x9eae, 0x9eaf, 0x9eb0, 0x9eb3,
  0x9eb4, 0x9eb5, 0x9ec6, 0x9ec8, 0x9ecb, 0x9ed5, 0x9edf, 0x9ee4,
  0x9ee7, 0x9eec, 0x9eed, 0x9eee, 0x9ef0, 0x9ef1, 0x9ef2, 0x9ef5,
  0x9ef8, 0x9eff, 0x9f02, 0x9f03, 0x9f09, 0x9f0f, 0x9f10, 0x9f11,
  0x9f12, 0x9f14, 0x9f16, 0x9f17, 0x9f19, 0x9f1a, 0x9f1b, 0x9f1f,
  0x9f22, 0x9f26, 0x9f2a, 0x9f2b, 0x9f2f, 0x9f31, 0x9f32, 0x9f34,
  0x9f37, 0x9f39, 0x9f3a, 0x9f3c, 0x9f3d, 0x9f3f, 0x9f41, 0x9f43,
  0x9f44, 0x9f45, 0x9f46, 0x9f47, 0x9f53, 0x9f55, 0x9f56, 0x9f57,
  0x9f58, 0x9f5a, 0x9f5d, 0x9f5e, 0x9f68, 0x9f69, 0x9f6d, 0x9f6e,
  0x9f6f, 0x9f70, 0x9f71, 0x9f73, 0x9f75, 0x9f7a, 0x9f7d, 0x9f8f,
  0x9f90, 0x9f91, 0x9f92, 0x9f94, 0x9f96, 0x9f97, 0x9f9e, 0x9fa1,
  0x9fa2, 0x9fa3, 0x9fa5, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, };
UNICHAR *iso2022_94[] = {
  map_ISO_646_irv_1983, map_BS_4730, map_ANSI_X3_4_1968, map_NATS_SEFI, 
  map_NATS_SEFI_ADD, map_NATS_DANO, map_NATS_DANO_ADD, map_SEN_850200_B, 
  map_SEN_850200_C, map_JIS_C6220_1969_jp, map_JIS_C6220_1969_ro, map_DIN_66003, 
  map_PT, NULL, map_ISO_5427, NULL, 
  NULL, map_ISO_5427_1981, map_NF_Z_62_010_1973, map_ISO_5428_1980, 
  map_GB_1988_80, map_Latin_greek_1, map_BS_viewdata, map_INIS, 
  NULL, map_IT, map_ES, map_greek7_old, 
  map_latin_greek, map_INIS_8, map_INIS_cyrillic, NULL, 
  map_NS_4551_1, map_NS_4551_2, map_videotex_suppl, NULL, 
  NULL, NULL, map_NF_Z_62_010, map_PT2, 
  map_ES2, map_MSZ_7795_3, map_greek7, map_ASMO_449, 
  map_iso_ir_90, map_JIS_C6229_1984_a, map_JIS_C6229_1984_b, map_JIS_C6229_1984_b_add, 
  map_JIS_C6229_1984_hand, map_JIS_C6229_1984_hand_add, map_JIS_C6229_1984_kana, map_ISO_2033_1983, 
  map_ANSI_X3_110_1983, map_T_61_7bit, map_T_61_8bit, map_CSA_Z243_4_1985_1, 
  map_CSA_Z243_4_1985_2, NULL, map_JUS_I_B1_002, map_JUS_I_B1_003_serb, 
  map_T_101_G2, map_JUS_I_B1_003_mac, NULL };
UNICHAR *iso2022_96[] = {
  map_ECMA_cyrillic, map_ISO_8859_1_1987, map_ISO_8859_2_1987, map_ISO_8859_3_1988, 
  map_ISO_8859_4_1988, map_CSA_Z243_4_1985_gr, map_ISO_8859_7_1987, map_ISO_8859_6_1987, 
  map_ISO_8859_8_1988, map_CSN_369103, map_ISO_6937_2_add, map_IEC_P27_1, 
  map_ISO_8859_5_1988, map_ISO_8859_9_1989, map_ISO_6937_2_25, map_GOST_19768_74, 
  map_ISO_8859_supp, map_ISO_10367_box, NULL, NULL, 
  NULL, NULL, NULL, NULL, 
  NULL, NULL, NULL, NULL, 
  NULL, NULL, NULL, NULL, 
  NULL, NULL, NULL, NULL, 
  NULL, NULL, NULL, NULL, 
  NULL, NULL, NULL, NULL, 
  NULL, NULL, NULL, NULL, 
  NULL, NULL, NULL, NULL, 
  NULL, NULL, NULL, NULL, 
  NULL, NULL, NULL, NULL, 
  NULL, NULL, NULL };
UNICHAR *iso2022_9494[] = {
  map_JIS_C6226_1978, map_GB_2312_80, map_JIS_C6226_1983, map_KS_C_5601_1987, 
  map_JIS_X0212_1990, NULL, NULL, NULL, 
  NULL, NULL, NULL, NULL, 
  NULL, NULL, NULL, NULL, 
  NULL, NULL, NULL, NULL, 
  NULL, NULL, NULL, NULL, 
  NULL, NULL, NULL, NULL, 
  NULL, NULL, NULL, NULL };
UNICHAR *iso2022_9696[] = {
  NULL, NULL, NULL, NULL, 
  NULL, NULL, NULL, NULL, 
  NULL, NULL, NULL, NULL, 
  NULL, NULL, NULL, NULL, 
  NULL, NULL, NULL, NULL, 
  NULL, NULL, NULL, NULL, 
  NULL, NULL, NULL, NULL, 
  NULL, NULL, NULL, NULL };
struct charset_def charset_map[] = {
  { "ansi_x3.4-1968", map_ANSI_X3_4_1968, MODE_94 },
  { "ansi_x3.4-1986", map_ANSI_X3_4_1968, MODE_94 },
  { "arabic", map_ISO_8859_6_1987, MODE_96 },
  { "arabic7", map_ASMO_449, MODE_94 },
  { "ascii", map_ANSI_X3_4_1968, MODE_94 },
  { "asmo-708", map_ISO_8859_6_1987, MODE_96 },
  { "asmo_449", map_ASMO_449, MODE_94 },
  { "bs_4730", map_BS_4730, MODE_94 },
  { "bs_viewdata", map_BS_viewdata, MODE_94 },
  { "ca", map_CSA_Z243_4_1985_1, MODE_94 },
  { "chinese", map_GB_2312_80, MODE_9494 },
  { "cn", map_GB_1988_80, MODE_94 },
  { "cp367", map_ANSI_X3_4_1968, MODE_94 },
  { "cp819", map_ISO_8859_1_1987, MODE_96 },
  { "csa7-1", map_CSA_Z243_4_1985_1, MODE_94 },
  { "csa7-2", map_CSA_Z243_4_1985_2, MODE_94 },
  { "csa_z243.4-1985-1", map_CSA_Z243_4_1985_1, MODE_94 },
  { "csa_z243.4-1985-2", map_CSA_Z243_4_1985_2, MODE_94 },
  { "csa_z243.4-1985-gr", map_CSA_Z243_4_1985_gr, MODE_96 },
  { "csn_369103", map_CSN_369103, MODE_96 },
  { "cyrillic", map_ISO_8859_5_1988, MODE_96 },
  { "de", map_DIN_66003, MODE_94 },
  { "din_66003", map_DIN_66003, MODE_94 },
  { "e13b", map_ISO_2033_1983, MODE_94 },
  { "ecma-114", map_ISO_8859_6_1987, MODE_96 },
  { "ecma-118", map_ISO_8859_7_1987, MODE_96 },
  { "ecma-cyrillic", map_ECMA_cyrillic, MODE_96 },
  { "elot_928", map_ISO_8859_7_1987, MODE_96 },
  { "es", map_ES, MODE_94 },
  { "es2", map_ES2, MODE_94 },
  { "fi", map_SEN_850200_B, MODE_94 },
  { "fr", map_NF_Z_62_010, MODE_94 },
  { "gb", map_BS_4730, MODE_94 },
  { "gb_1988-80", map_GB_1988_80, MODE_94 },
  { "gb_2312-80", map_GB_2312_80, MODE_9494 },
  { "gost_19768-74", map_GOST_19768_74, MODE_96 },
  { "greek", map_ISO_8859_7_1987, MODE_96 },
  { "greek7", map_greek7, MODE_94 },
  { "greek7-old", map_greek7_old, MODE_94 },
  { "greek8", map_ISO_8859_7_1987, MODE_96 },
  { "hebrew", map_ISO_8859_8_1988, MODE_96 },
  { "hu", map_MSZ_7795_3, MODE_94 },
  { "ibm367", map_ANSI_X3_4_1968, MODE_94 },
  { "ibm819", map_ISO_8859_1_1987, MODE_96 },
  { "iec_p27-1", map_IEC_P27_1, MODE_96 },
  { "inis", map_INIS, MODE_94 },
  { "inis-8", map_INIS_8, MODE_94 },
  { "inis-cyrillic", map_INIS_cyrillic, MODE_94 },
  { "irv", map_ISO_646_irv_1983, MODE_94 },
  { "iso-8859-1", map_ISO_8859_1_1987, MODE_96 },
  { "iso-8859-2", map_ISO_8859_2_1987, MODE_96 },
  { "iso-8859-3", map_ISO_8859_3_1988, MODE_96 },
  { "iso-8859-4", map_ISO_8859_4_1988, MODE_96 },
  { "iso-8859-5", map_ISO_8859_5_1988, MODE_96 },
  { "iso-8859-6", map_ISO_8859_6_1987, MODE_96 },
  { "iso-8859-7", map_ISO_8859_7_1987, MODE_96 },
  { "iso-8859-8", map_ISO_8859_8_1988, MODE_96 },
  { "iso-8859-9", map_ISO_8859_9_1989, MODE_96 },
  { "iso-ir-10", map_SEN_850200_B, MODE_94 },
  { "iso-ir-100", map_ISO_8859_1_1987, MODE_96 },
  { "iso-ir-101", map_ISO_8859_2_1987, MODE_96 },
  { "iso-ir-102", map_T_61_7bit, MODE_94 },
  { "iso-ir-109", map_ISO_8859_3_1988, MODE_96 },
  { "iso-ir-11", map_SEN_850200_C, MODE_94 },
  { "iso-ir-110", map_ISO_8859_4_1988, MODE_96 },
  { "iso-ir-111", map_ECMA_cyrillic, MODE_96 },
  { "iso-ir-121", map_CSA_Z243_4_1985_1, MODE_94 },
  { "iso-ir-122", map_CSA_Z243_4_1985_2, MODE_94 },
  { "iso-ir-123", map_CSA_Z243_4_1985_gr, MODE_96 },
  { "iso-ir-126", map_ISO_8859_7_1987, MODE_96 },
  { "iso-ir-127", map_ISO_8859_6_1987, MODE_96 },
  { "iso-ir-13", map_JIS_C6220_1969_jp, MODE_94 },
  { "iso-ir-138", map_ISO_8859_8_1988, MODE_96 },
  { "iso-ir-139", map_CSN_369103, MODE_96 },
  { "iso-ir-14", map_JIS_C6220_1969_ro, MODE_94 },
  { "iso-ir-141", map_JUS_I_B1_002, MODE_94 },
  { "iso-ir-142", map_ISO_6937_2_add, MODE_96 },
  { "iso-ir-143", map_IEC_P27_1, MODE_96 },
  { "iso-ir-144", map_ISO_8859_5_1988, MODE_96 },
  { "iso-ir-146", map_JUS_I_B1_003_serb, MODE_94 },
  { "iso-ir-147", map_JUS_I_B1_003_mac, MODE_94 },
  { "iso-ir-148", map_ISO_8859_9_1989, MODE_96 },
  { "iso-ir-149", map_KS_C_5601_1987, MODE_9494 },
  { "iso-ir-15", map_IT, MODE_94 },
  { "iso-ir-152", map_ISO_6937_2_25, MODE_96 },
  { "iso-ir-153", map_GOST_19768_74, MODE_96 },
  { "iso-ir-154", map_ISO_8859_supp, MODE_96 },
  { "iso-ir-155", map_ISO_10367_box, MODE_96 },
  { "iso-ir-159", map_JIS_X0212_1990, MODE_9494 },
  { "iso-ir-16", map_PT, MODE_94 },
  { "iso-ir-17", map_ES, MODE_94 },
  { "iso-ir-18", map_greek7_old, MODE_94 },
  { "iso-ir-19", map_latin_greek, MODE_94 },
  { "iso-ir-2", map_ISO_646_irv_1983, MODE_94 },
  { "iso-ir-21", map_DIN_66003, MODE_94 },
  { "iso-ir-25", map_NF_Z_62_010_1973, MODE_94 },
  { "iso-ir-27", map_Latin_greek_1, MODE_94 },
  { "iso-ir-37", map_ISO_5427, MODE_94 },
  { "iso-ir-4", map_BS_4730, MODE_94 },
  { "iso-ir-42", map_JIS_C6226_1978, MODE_9494 },
  { "iso-ir-47", map_BS_viewdata, MODE_94 },
  { "iso-ir-49", map_INIS, MODE_94 },
  { "iso-ir-50", map_INIS_8, MODE_94 },
  { "iso-ir-51", map_INIS_cyrillic, MODE_94 },
  { "iso-ir-54", map_ISO_5427_1981, MODE_94 },
  { "iso-ir-55", map_ISO_5428_1980, MODE_94 },
  { "iso-ir-57", map_GB_1988_80, MODE_94 },
  { "iso-ir-58", map_GB_2312_80, MODE_9494 },
  { "iso-ir-6", map_ANSI_X3_4_1968, MODE_94 },
  { "iso-ir-60", map_NS_4551_1, MODE_94 },
  { "iso-ir-61", map_NS_4551_2, MODE_94 },
  { "iso-ir-69", map_NF_Z_62_010, MODE_94 },
  { "iso-ir-8-1", map_NATS_SEFI, MODE_94 },
  { "iso-ir-8-2", map_NATS_SEFI_ADD, MODE_94 },
  { "iso-ir-84", map_PT2, MODE_94 },
  { "iso-ir-85", map_ES2, MODE_94 },
  { "iso-ir-86", map_MSZ_7795_3, MODE_94 },
  { "iso-ir-87", map_JIS_C6226_1983, MODE_9494 },
  { "iso-ir-88", map_greek7, MODE_94 },
  { "iso-ir-89", map_ASMO_449, MODE_94 },
  { "iso-ir-9-1", map_NATS_DANO, MODE_94 },
  { "iso-ir-9-2", map_NATS_DANO_ADD, MODE_94 },
  { "iso-ir-91", map_JIS_C6229_1984_a, MODE_94 },
  { "iso-ir-92", map_JIS_C6229_1984_b, MODE_94 },
  { "iso-ir-93", map_JIS_C6229_1984_b_add, MODE_94 },
  { "iso-ir-94", map_JIS_C6229_1984_hand, MODE_94 },
  { "iso-ir-95", map_JIS_C6229_1984_hand_add, MODE_94 },
  { "iso-ir-96", map_JIS_C6229_1984_kana, MODE_94 },
  { "iso-ir-98", map_ISO_2033_1983, MODE_94 },
  { "iso646-ca", map_CSA_Z243_4_1985_1, MODE_94 },
  { "iso646-ca2", map_CSA_Z243_4_1985_2, MODE_94 },
  { "iso646-cn", map_GB_1988_80, MODE_94 },
  { "iso646-de", map_DIN_66003, MODE_94 },
  { "iso646-es", map_ES, MODE_94 },
  { "iso646-es2", map_ES2, MODE_94 },
  { "iso646-fi", map_SEN_850200_B, MODE_94 },
  { "iso646-fr", map_NF_Z_62_010, MODE_94 },
  { "iso646-fr1", map_NF_Z_62_010_1973, MODE_94 },
  { "iso646-gb", map_BS_4730, MODE_94 },
  { "iso646-hu", map_MSZ_7795_3, MODE_94 },
  { "iso646-it", map_IT, MODE_94 },
  { "iso646-jp", map_JIS_C6220_1969_ro, MODE_94 },
  { "iso646-jp-ocr-b", map_JIS_C6229_1984_b, MODE_94 },
  { "iso646-no", map_NS_4551_1, MODE_94 },
  { "iso646-no2", map_NS_4551_2, MODE_94 },
  { "iso646-pt", map_PT, MODE_94 },
  { "iso646-pt2", map_PT2, MODE_94 },
  { "iso646-se", map_SEN_850200_B, MODE_94 },
  { "iso646-se2", map_SEN_850200_C, MODE_94 },
  { "iso646-us", map_ANSI_X3_4_1968, MODE_94 },
  { "iso646-yu", map_JUS_I_B1_002, MODE_94 },
  { "iso_10367-box", map_ISO_10367_box, MODE_96 },
  { "iso_2033-1983", map_ISO_2033_1983, MODE_94 },
  { "iso_5427", map_ISO_5427, MODE_94 },
  { "iso_5427:1981", map_ISO_5427_1981, MODE_94 },
  { "iso_5428:1980", map_ISO_5428_1980, MODE_94 },
  { "iso_646.irv:1983", map_ISO_646_irv_1983, MODE_94 },
  { "iso_646.irv:1991", map_ANSI_X3_4_1968, MODE_94 },
  { "iso_6937-2-25", map_ISO_6937_2_25, MODE_96 },
  { "iso_6937-2-add", map_ISO_6937_2_add, MODE_96 },
  { "iso_8859-1", map_ISO_8859_1_1987, MODE_96 },
  { "iso_8859-1:1987", map_ISO_8859_1_1987, MODE_96 },
  { "iso_8859-2", map_ISO_8859_2_1987, MODE_96 },
  { "iso_8859-2:1987", map_ISO_8859_2_1987, MODE_96 },
  { "iso_8859-3", map_ISO_8859_3_1988, MODE_96 },
  { "iso_8859-3:1988", map_ISO_8859_3_1988, MODE_96 },
  { "iso_8859-4", map_ISO_8859_4_1988, MODE_96 },
  { "iso_8859-4:1988", map_ISO_8859_4_1988, MODE_96 },
  { "iso_8859-5", map_ISO_8859_5_1988, MODE_96 },
  { "iso_8859-5:1988", map_ISO_8859_5_1988, MODE_96 },
  { "iso_8859-6", map_ISO_8859_6_1987, MODE_96 },
  { "iso_8859-6:1987", map_ISO_8859_6_1987, MODE_96 },
  { "iso_8859-7", map_ISO_8859_7_1987, MODE_96 },
  { "iso_8859-7:1987", map_ISO_8859_7_1987, MODE_96 },
  { "iso_8859-8", map_ISO_8859_8_1988, MODE_96 },
  { "iso_8859-8:1988", map_ISO_8859_8_1988, MODE_96 },
  { "iso_8859-9", map_ISO_8859_9_1989, MODE_96 },
  { "iso_8859-9:1989", map_ISO_8859_9_1989, MODE_96 },
  { "iso_8859-supp", map_ISO_8859_supp, MODE_96 },
  { "iso_9036", map_ASMO_449, MODE_94 },
  { "it", map_IT, MODE_94 },
  { "jis_c6220-1969", map_JIS_C6220_1969_jp, MODE_94 },
  { "jis_c6220-1969-jp", map_JIS_C6220_1969_jp, MODE_94 },
  { "jis_c6220-1969-ro", map_JIS_C6220_1969_ro, MODE_94 },
  { "jis_c6226-1978", map_JIS_C6226_1978, MODE_9494 },
  { "jis_c6226-1983", map_JIS_C6226_1983, MODE_9494 },
  { "jis_c6229-1984-a", map_JIS_C6229_1984_a, MODE_94 },
  { "jis_c6229-1984-b", map_JIS_C6229_1984_b, MODE_94 },
  { "jis_c6229-1984-b-add", map_JIS_C6229_1984_b_add, MODE_94 },
  { "jis_c6229-1984-hand", map_JIS_C6229_1984_hand, MODE_94 },
  { "jis_c6229-1984-hand-add", map_JIS_C6229_1984_hand_add, MODE_94 },
  { "jis_c6229-1984-kana", map_JIS_C6229_1984_kana, MODE_94 },
  { "jis_x0208-1983", map_JIS_C6226_1983, MODE_9494 },
  { "jis_x0212-1990", map_JIS_X0212_1990, MODE_9494 },
  { "jp", map_JIS_C6220_1969_ro, MODE_94 },
  { "jp-ocr-a", map_JIS_C6229_1984_a, MODE_94 },
  { "jp-ocr-b", map_JIS_C6229_1984_b, MODE_94 },
  { "jp-ocr-b-add", map_JIS_C6229_1984_b_add, MODE_94 },
  { "jp-ocr-hand", map_JIS_C6229_1984_hand, MODE_94 },
  { "jp-ocr-hand-add", map_JIS_C6229_1984_hand_add, MODE_94 },
  { "js", map_JUS_I_B1_002, MODE_94 },
  { "jus_i.b1.002", map_JUS_I_B1_002, MODE_94 },
  { "jus_i.b1.003-mac", map_JUS_I_B1_003_mac, MODE_94 },
  { "jus_i.b1.003-serb", map_JUS_I_B1_003_serb, MODE_94 },
  { "katakana", map_JIS_C6220_1969_jp, MODE_94 },
  { "korean", map_KS_C_5601_1987, MODE_9494 },
  { "ks_c_5601-1987", map_KS_C_5601_1987, MODE_9494 },
  { "ks_c_5601-1989", map_KS_C_5601_1987, MODE_9494 },
  { "ksc_5601", map_KS_C_5601_1987, MODE_9494 },
  { "l1", map_ISO_8859_1_1987, MODE_96 },
  { "l2", map_ISO_8859_2_1987, MODE_96 },
  { "l3", map_ISO_8859_3_1988, MODE_96 },
  { "l4", map_ISO_8859_4_1988, MODE_96 },
  { "l5", map_ISO_8859_9_1989, MODE_96 },
  { "latin-greek", map_latin_greek, MODE_94 },
  { "latin-greek-1", map_Latin_greek_1, MODE_94 },
  { "latin1", map_ISO_8859_1_1987, MODE_96 },
  { "latin1-2-5", map_ISO_8859_supp, MODE_96 },
  { "latin2", map_ISO_8859_2_1987, MODE_96 },
  { "latin3", map_ISO_8859_3_1988, MODE_96 },
  { "latin4", map_ISO_8859_4_1988, MODE_96 },
  { "latin5", map_ISO_8859_9_1989, MODE_96 },
  { "macedonian", map_JUS_I_B1_003_mac, MODE_94 },
  { "msz_7795.3", map_MSZ_7795_3, MODE_94 },
  { "nats-dano", map_NATS_DANO, MODE_94 },
  { "nats-dano-add", map_NATS_DANO_ADD, MODE_94 },
  { "nats-sefi", map_NATS_SEFI, MODE_94 },
  { "nats-sefi-add", map_NATS_SEFI_ADD, MODE_94 },
  { "nf_z_62-010", map_NF_Z_62_010, MODE_94 },
  { "nf_z_62-010_(1973)", map_NF_Z_62_010_1973, MODE_94 },
  { "no", map_NS_4551_1, MODE_94 },
  { "no2", map_NS_4551_2, MODE_94 },
  { "ns_4551-1", map_NS_4551_1, MODE_94 },
  { "ns_4551-2", map_NS_4551_2, MODE_94 },
  { "pt", map_PT, MODE_94 },
  { "pt2", map_PT2, MODE_94 },
  { "se", map_SEN_850200_B, MODE_94 },
  { "se2", map_SEN_850200_C, MODE_94 },
  { "sen_850200_b", map_SEN_850200_B, MODE_94 },
  { "sen_850200_c", map_SEN_850200_C, MODE_94 },
  { "serbian", map_JUS_I_B1_003_serb, MODE_94 },
  { "st_sev_358-88", map_GOST_19768_74, MODE_96 },
  { "t.61-7bit", map_T_61_7bit, MODE_94 },
  { "uk", map_BS_4730, MODE_94 },
  { "us", map_ANSI_X3_4_1968, MODE_94 },
  { "us-ascii", map_ANSI_X3_4_1968, MODE_94 },
  { "x0201-7", map_JIS_C6220_1969_jp, MODE_94 },
  { "x0208", map_JIS_C6226_1983, MODE_9494 },
  { "x0212", map_JIS_X0212_1990, MODE_9494 },
  { "yu", map_JUS_I_B1_002, MODE_94 },
};
int num_charset_def = sizeof(charset_map)/sizeof(charset_map[0]);

