# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python binding unit tests
#
# Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

from pgm_test_case import PgmTestCase
import pgm

class TestViewport(PgmTestCase):

    def setUp(self):
        #self.v = pgm.viewport_factory_make('boilerplate')
        factory = pgm.ViewportFactory("boilerplate")
        self.v = factory.create()
        PgmTestCase.setUp(self)

    def tearDown(self):
        del self.v
        PgmTestCase.tearDown(self)

    def test_title(self):
        # title set
        new_title = ("foo quoi")
        self.failUnless(self.v.set_title(new_title))

    def test_cursor(self):
        # cursor get
        cursor = self.v.get_cursor()
        self.failUnless(isinstance(cursor, pgm.ViewportCursor))
        self.assertEqual(cursor, pgm.VIEWPORT_LEFT_ARROW)

        # cursor set
        new_cursor = pgm.ViewportCursor(pgm.VIEWPORT_INHERIT)
        self.v.set_cursor(new_cursor)
        self.assertEqual(self.v.get_cursor(), new_cursor)

    def test_size(self):
        # size get
        size = self.v.get_size()
        self.failUnless(isinstance(size, tuple))
        self.assertEqual(len(size), 2)
        self.assertEqual(size, (800, 600))

        # size set
        s = (1024, 768)
        self.v.set_size(*s)
        new_size = self.v.get_size()
        self.assertEqual(new_size, s)

    def test_fullscreen(self):
        # fullscreen get
        fs = self.v.get_fullscreen()
        self.failUnless(isinstance(fs, bool))
        self.assertEqual(fs, False)

        # fullscreen set
        self.v.set_fullscreen(True)
        self.assertEqual(self.v.get_fullscreen(), True)

    def test_screen_resolution(self):
        # screen resolution get
        res = self.v.get_screen_resolution()
        self.failUnless(isinstance(res, tuple))
        self.assertEqual(len(res), 2)

        for r in res:
            self.failUnless(isinstance(r, int))

        # screen resolution set
        # FIXME: we do not want to play with developers' resolution
        #new_res = (1, 2)
        #self.v.set_screen_resolution(*new_res)
        #self.assertEqual(self.v.get_screen_resolution(), new_res)

    def test_screen_size_mm(self):
        # screen size mm get
        size = self.v.get_screen_size_mm()
        self.failUnless(isinstance(size, tuple))
        self.assertEqual(len(size), 2)

        for r in size:
            self.failUnless(isinstance(r, int))

        # screen size mm set
        new_size = (1, 2)
        self.v.set_screen_size_mm(*new_size)
        self.assertEqual(self.v.get_screen_size_mm(), new_size)

    def test_events(self):
        # TODO: connect to signals
        # TODO: manually push events and test?
        pass

    def test_canvas(self):
        # canvas get
        canvas = self.v.get_canvas()
        self.assertEqual(canvas, None)

        # canvas set
        c = pgm.Canvas()
        self.v.set_canvas(c)
        self.assertEqual(c, self.v.get_canvas())
        self.v.set_canvas(None)

    def test_pixel_formats(self):
        # pixel formats get
        pixel_formats = self.v.get_pixel_formats()

        # TODO: finish me

    def test_caps_mask(self):
        # get
        mask = self.v.get_caps_mask()
##         print '>>', mask
##         self.failUnless(isinstance(mask, long))

        # no set ??
