# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python binding mapping matrix example
#
# Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
#
# Author: Loïc Molinari <loic@fluendo.com>

import sys, math, pgm, gobject

# Transform the mapping matrix of the image
def update_pass_cb(viewport, image, transformation):
    image.mapping_matrix *= transformation
    return True

# Start animating the mapping matrix when the pixbuf is loaded
def on_pixbuf_loaded(image, viewport, transformation):
    viewport.connect('update-pass', update_pass_cb, image, transformation)

# Terminate the mainloop on a delete event
def on_delete(viewport, event):
    pgm.main_quit()

# Entry point
def main(args):
    # OpenGL viewport creation
    gl = pgm.viewport_factory_make('opengl')
    gl.connect('delete-event', on_delete)
    gl.size = (600, 600)
    gl.title = 'Mapping matrix'

    # Canvas creation
    cvs = pgm.Canvas()
    cvs.size = (600, 600)
    gl.set_canvas(cvs)

    # Transformation matrix creation
    t = pgm.mat4x4_new_identity()
    t.translate(0.5, 0.5, 0.0)
    t.rotate_z(math.pi / 120.0)
    t.translate(-0.5, -0.5, 0.0)

    # Image creation
    img = pgm.Image()
    img.set_from_file('examples/pictures/meiko.jpg')
    img.connect('pixbuf-loaded', on_pixbuf_loaded, gl, t)
    img.size = (400, 400)
    img.position = (100, 100, 0)
    img.bg_color = (255, 255, 255, 0)
    cvs.add(pgm.DRAWABLE_MIDDLE, img)

    # Show the objects and start the main loop
    img.show()
    gl.show()
    pgm.main()

if __name__ == '__main__':
    sys.exit(main(sys.argv[1:]))
