/*
   +----------------------------------------------------------------------+
   | PHP version 4.0                                                      |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997, 1998, 1999, 2000 The PHP Group                   |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.02 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available at through the world-wide-web at                           |
   | http://www.php.net/license/2_02.txt.                                 |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Matt McClanahan <cardinal@dodds.net>                        |
   +----------------------------------------------------------------------+
 */

#ifndef _PHP_IMLIB_H
#define _PHP_IMLIB_H

#include <X11/Xlib.h>
#include <Imlib2.h>

#if HAVE_IMLIB

extern zend_module_entry imlib_module_entry;
#define phpext_imlib_ptr &imlib_module_entry

#ifdef PHP_WIN32
#define PHP_IMLIB_API __declspec(dllexport)
#else
#define PHP_IMLIB_API
#endif

PHP_MINIT_FUNCTION(imlib);
PHP_RINIT_FUNCTION(imlib);
PHP_RSHUTDOWN_FUNCTION(imlib);
PHP_MINFO_FUNCTION(imlib);

PHP_FUNCTION(imlib_add_color_to_color_range);
PHP_FUNCTION(imlib_blend_image_onto_image);
PHP_FUNCTION(imlib_clone_image);
PHP_FUNCTION(imlib_create_color_range);
PHP_FUNCTION(imlib_create_cropped_image);
PHP_FUNCTION(imlib_create_cropped_scaled_image);
PHP_FUNCTION(imlib_create_image);
PHP_FUNCTION(imlib_create_rotated_image);
PHP_FUNCTION(imlib_create_scaled_image);
PHP_FUNCTION(imlib_free_color_range);
PHP_FUNCTION(imlib_free_font);
PHP_FUNCTION(imlib_free_image);
PHP_FUNCTION(imlib_get_text_size);
PHP_FUNCTION(imlib_image_blur);
PHP_FUNCTION(imlib_image_draw_ellipse);
PHP_FUNCTION(imlib_image_draw_line);
PHP_FUNCTION(imlib_image_draw_polygon);
PHP_FUNCTION(imlib_image_draw_rectangle);
PHP_FUNCTION(imlib_image_fill_color_range_rectangle);
PHP_FUNCTION(imlib_image_fill_ellipse);
PHP_FUNCTION(imlib_image_fill_polygon);
PHP_FUNCTION(imlib_image_fill_rectangle);
PHP_FUNCTION(imlib_image_flip_horizontal);
PHP_FUNCTION(imlib_image_flip_vertical);
PHP_FUNCTION(imlib_image_flip_diagonal);
PHP_FUNCTION(imlib_image_format);
PHP_FUNCTION(imlib_image_get_filename);
PHP_FUNCTION(imlib_image_get_height);
PHP_FUNCTION(imlib_image_get_width);
PHP_FUNCTION(imlib_image_has_alpha);
PHP_FUNCTION(imlib_image_modify_alpha);
PHP_FUNCTION(imlib_image_set_format);
PHP_FUNCTION(imlib_image_sharpen);
PHP_FUNCTION(imlib_image_tile_horizontal);
PHP_FUNCTION(imlib_image_tile_vertical);
PHP_FUNCTION(imlib_image_tile);
PHP_FUNCTION(imlib_list_fonts);
PHP_FUNCTION(imlib_load_font);
PHP_FUNCTION(imlib_load_image);
PHP_FUNCTION(imlib_load_image_with_error_return);
PHP_FUNCTION(imlib_polygon_add_point);
PHP_FUNCTION(imlib_polygon_contains_point);
PHP_FUNCTION(imlib_polygon_free);
PHP_FUNCTION(imlib_polygon_get_bounds);
PHP_FUNCTION(imlib_polygon_new);
PHP_FUNCTION(imlib_save_image);
PHP_FUNCTION(imlib_dump_image);
PHP_FUNCTION(imlib_text_draw);

typedef struct {
	char *font_path;
	char **saved_path;
} php_imlib_globals;

#ifdef ZTS
#define IMLIBG(v) (imlib_globals->v)
#define IMLIBLS_FETCH() php_imlib_globals *imlib_globals = ts_resource(gd_imlib_id)
#else
#define IMLIBG(v) (imlib_globals.v)
#define IMLIBLS_FETCH()
#endif

#else

#define phpext_imlib_ptr NULL

#endif

#endif	/* _PHP_IMLIB_H */


/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 */
