#!/usr/bin/python

# $Progeny: reducemodules.py,v 1.4 2002/02/04 23:36:25 jlicquia Exp $

# reducemodules.py - reduce a module list to fit in a given amount of
# space
#
# Copyright (c) 2002 Progeny Linux Systems, Inc.
#
# License: GPL
# 
# Usage: reducemodules.py <kernel-version> <size>
#
# This script takes a priority-sorted list of modules on stdin.  It
# calculates the dependencies on each module, adds their sizes to a
# running size total, and outputs the module's path (and its
# dependencies) on stdout.  Once the running size exceeds the size
# passed on the command line, stop.

import sys
import os
import string

tooldir = os.environ["TOOLS"]
kernel = sys.argv[1]
max_size = int(sys.argv[2])
total_size = 0
mod_list_read = []

input = sys.stdin
output = sys.stdout

def get_module_paths(module):
    global tooldir
    global kernel
    global mod_list_read
    global input

    mod_list = []
    modpaths = os.popen("sh %s/modtofile.sh %s %s" % (tooldir, kernel, module))
    modules_size = 0
    for line in modpaths.readlines():
        module_path = string.strip(line)
        if module_path in mod_list_read:
            continue
        if not os.path.exists(module_path):
            continue

        mod_size = (os.stat(module_path))[6]
        modules_size = modules_size + mod_size
        mod_list.append(module_path)

    return (modules_size, mod_list)

for module in input.readlines():
    (mod_size, mod_list) = get_module_paths(string.strip(module))
    if total_size + mod_size > max_size:
        continue

    total_size = total_size + mod_size
    mod_list_read.extend(mod_list)
    for mod_path in mod_list:
        output.write(mod_path + "\n")
