#! /usr/bin/python

# $Progeny: list-devices.py,v 1.6 2002/02/01 17:28:32 epg Exp $

import parted
import sys

from getopt import getopt, GetoptError

# fucking python...
TRUE = 1
FALSE = 0

# Has Guido heard of sysexits.h?
EX_OK = 0
EX_USAGE = 64

# Fake gettext; might be interested in i18n one day.
def _(s):
    return s

def warn(s):
    if not quiet:
        sys.stderr.write("%s: WARNING: %s" % (sys.argv[0], s))

def print_partitions(device):
    disk = device.disk_open()
    if not disk:
        warn(_("Could not read partition table from %s\n") % (path,))
        return FALSE

    for part in disk.get_part_list():
        minor = part.get_num()
        if minor != -1 and part.get_type() != parted.PARTITION_EXTENDED:
            sys.stdout.write("%s%d\n" % (path, minor))

    return TRUE

###############################################################################
# Main

try:
    (opts, args) = getopt(sys.argv[1:], "d:q",
                      ['disk-device=', 'disks', 'quiet'])
except GetoptError:
    #usage()
    sys.exit(EX_USAGE)

disk_device=None
disks_only = FALSE
quiet = FALSE

for (o, a) in opts:
    if o == "--disk-device" or o == "-d":
        disk_device = a
    elif o == "--disks":
        disks_only = TRUE
    elif o == "-q" or o == "--quiet":
        quiet = TRUE

parted.init()

parted.device_probe_all()

for device in parted.get_devices():
    path = device.get_path()

    if disks_only:
        sys.stdout.write("%s\n" % (path,))
        continue

    if disk_device:
        if path == disk_device:
            print_partitions(device)
            sys.exit(EX_OK)
        else:
            continue

    print_partitions(device)
