function pfs_write_luminance( fileName, img )
% Write an hdr image file (formats accepted by pfsout). You can
% specify additional options in fileName, such as
% '--compression=PXR24' for OpenEXR files. Check manual pages of
% pfsout* commands for the list of available options. 
% Note that writing luminance alone does not work with some HDR file formats, such
% as RGBE (.hdr). 
% 
% pfs_write_luminance( fileName, img )
%
% img - 2D matrix representing luminance values

if( nargin ~= 2 )
    error( 'pfs_write_luminance: improper usage' );
end

%cmd = sprintf( '%spfsout %s%s', pfs_shell(), fileName, pfs_shell(1) )
fid = pfspopen( sprintf( '%spfsout ''%s''%s', pfs_shell(), fileName, pfs_shell(1) ), 'w' );    
pfs = pfsopen( fid, size( img ) );

pfs.channels.Y = img;

pfsput( pfs );
pfsclose( pfs );
pfspclose( fid );

end
