#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: rcm.c,v 1.4 2000/01/10 03:54:21 knepley Exp $";
#endif

#include "src/mesh/impls/triangular/triimpl.h"
#include "src/mat/order/order.h"

EXTERN_C_BEGIN
/*
    MeshOrdering_Triangular_2D_RCM - Find the Reverse Cuthill-McKee ordering for the nodes of a given mesh.
*/    
#undef __FUNCT__  
#define __FUNCT__ "MeshOrdering_RCM"
int MeshOrdering_Triangular_2D_RCM(Mesh mesh, MatOrderingType type, AO *ordering)
{
  int        numNodes  = mesh->numNodes;
  PetscTruth constrain = PETSC_FALSE;
  int       *AppOrdering;   /* The initial ordering (0, 1, ...) */
  int       *PetscOrdering; /* The RCM ordering */
  int       *offsets, *adj; /* The graph in CSR format */
  int       *mask;          /* Nodes with >0 are ignored, and once a node is seen it gets its number */
  int       *levels;        /* The level structure of the mesh */
  int        numVertices, numEdges;
  int        i;
  PetscTruth opt;
  int        ierr;

  ierr = PetscMalloc(numNodes   * sizeof(int), &AppOrdering);                                             CHKERRQ(ierr);
  ierr = PetscMalloc(numNodes   * sizeof(int), &PetscOrdering);                                           CHKERRQ(ierr);
  ierr = PetscMalloc(numNodes   * sizeof(int), &mask);                                                    CHKERRQ(ierr);
  ierr = PetscMalloc(numNodes*2 * sizeof(int), &levels);                                                  CHKERRQ(ierr);

  ierr = PetscOptionsHasName(mesh->prefix, "-mesh_reorder_constrain", &opt);                              CHKERRQ(ierr);
  if (opt == PETSC_TRUE)
    constrain = PETSC_TRUE;
  ierr = MeshCreateFullCSR(mesh, constrain, &numVertices, &numEdges, &offsets, &adj);                     CHKERRQ(ierr);
  if (numVertices != numNodes) SETERRQ(PETSC_ERR_PLIB, "Invalid full graph of the mesh");
  /* Identity ordering originally */
  for(i = 0; i < numNodes; i++) {
    PetscOrdering[i] = i;
  }
  /* Must shift numbering for SPARSEPAK */
  for(i = 0; i < offsets[numNodes]; i++) {
    adj[i]++;
  }
  for(i = 0; i <= numNodes; i++) {
    offsets[i]++;
  }
  ierr = SPARSEPACKgenrcm(&numNodes, offsets, adj, AppOrdering, mask, levels);                            CHKERRQ(ierr);
  for(i = 0; i < numNodes; i++) {
    AppOrdering[i]--;
  }
  ierr = MeshDestroyFullCSR(mesh, offsets, adj);                                                          CHKERRQ(ierr);
  /* Create the ordering object */
  ierr = AOCreateBasic(mesh->comm, numNodes, AppOrdering, PetscOrdering, ordering);                       CHKERRQ(ierr);

  ierr = PetscFree(AppOrdering);                                                                          CHKERRQ(ierr);
  ierr = PetscFree(PetscOrdering);                                                                        CHKERRQ(ierr);
  ierr = PetscFree(mask);                                                                                 CHKERRQ(ierr);
  ierr = PetscFree(levels);                                                                               CHKERRQ(ierr);
  PetscFunctionReturn(0);
}
EXTERN_C_END
