/* $Id: gridDB.h,v 1.4 2000/07/16 23:23:55 knepley Exp $ */

/*
    Routines for working with the grid database
*/
#define GridValidField(grid, field)                                                                         \
  {                                                                                                         \
    if ((field < 0) || (field >= grid->numFields)) {                                                        \
      SETERRQ2(PETSC_ERR_ARG_WRONG, "Invalid field number %d should be in [0,%d)", field, grid->numFields); \
    }                                                                                                       \
  }

extern int GridGetNumFields(Grid, int *);
extern int GridAddField(Grid, const char [], DiscretizationType, int, int *);
extern int GridGetFieldName(Grid, int, char **);
extern int GridSetFieldName(Grid, int, char *);
extern int GridGetFieldComponents(Grid, int, int *);
extern int GridGetFieldDisc(Grid, int, Discretization *);
extern int GridGetNumActiveFields(Grid, int *);
extern int GridGetActiveField(Grid, int, int *);
extern int GridSetActiveField(Grid, int);
extern int GridAddActiveField(Grid, int);

extern int GridGetNumVars(Grid, int *, int *, int *, int *);

extern int GridIsMatrixFree(Grid, PetscTruth *);
extern int GridSetMatrixFree(Grid, PetscTruth);

extern int GridGetNumRhsOperators(Grid, int *);
extern int GridGetNumNonlinearOperators(Grid, int *);
extern int GridGetNonlinearOperatorStart(Grid, NonlinearOperator *, int *, PetscScalar *, PetscTruth *);
extern int GridGetNonlinearOperatorNext(Grid, NonlinearOperator *, int *, PetscScalar *, PetscTruth *);
extern int GridAddRhsFunction(Grid, int, PointFunction, PetscScalar);
extern int GridAddRhsNonlinearOperator(Grid, int, NonlinearOperator, PetscScalar, PetscTruth);
extern int GridSetRhsOperator(Grid, int, int, int, PetscScalar, PetscTruth, int *);
extern int GridAddRhsOperator(Grid, int, int, int, PetscScalar, PetscTruth, int *);
extern int GridScaleRhs(Grid, PetscScalar);
extern int GridScaleRhsOperator(Grid, PetscScalar, int);

extern int GridGetNumMatOperators(Grid, int *);
extern int GridGetMatOperatorStart(Grid, int *, int *, int *, PetscScalar *, PetscTruth *);
extern int GridGetMatOperatorNext(Grid, int *, int *, int *, PetscScalar *, PetscTruth *);
extern int GridSetMatOperator(Grid, int, int, int, PetscScalar, PetscTruth, int *);
extern int GridAddMatOperator(Grid, int, int, int, PetscScalar, PetscTruth, int *);
extern int GridRegisterOperator(Grid, int, OperatorFunction, int *);
extern int GridRegisterALEOperator(Grid, int, ALEOperatorFunction, int *);
extern int GridScaleSystemMatrix(Grid, PetscScalar);
extern int GridScaleMatOperator(Grid, PetscScalar, int);
