#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

#include <gtk/gtk.h>

#include "npthreads.h"

class NP_Summary
{
   NP_Threads threads;

   np_thread_node_t *tree, *current_node, *spool_beginning;

   GtkStyle *header_style, *unread_request_style,
      *request_style, *unread_header_style,
      *unread_style, *read_style, *unread_dummy_style, *dummy_style;

   GtkWidget *window, *list_window, *message_window, *message_label, 
      *root_node, *list, *old_list_button, *compose_button, **items,
      *message_button, *table, *scroll, *tree_widget, *search_window,
      *search_clist, *transfer_window, *quantity_frame, *search_label,
      *next_article_wid, *prev_article_wid, *next_unread_wid, 
      *prev_full_wid, *next_full_wid, *left_grey_button, *right_grey_button,
      *prev_header_wid, *next_header_wid, *prev_request_wid,
      *next_request_wid, *right_green_button,
      *right_red_button, *left_red_button, *left_green_button,
      *prev_unread_wid, *remove_button, *undelete_button, *request_button,
      *mark_button, *folders_window, *folders_clist, *hide_button,
      *headers_label, *seen_label, *left_button, *right_button, *up_button,
      *down_button, *group_label, *font_button, *font_menu, *item,
      *first_item, *second_item, *third_item, *request_menu, *mark_menu;
      
   GtkAdjustment *adjustment;

   gpointer selected_item;

   char *home, *server, *group, search_text[ 128 ];

   NP_Stringarray children, search_results;

   int *positions;

   int total, unseen, headers, requested, transfer_type, transfer_quantity,
      transfer_what, SIGPIPE_received, stop, reading, text_pipe[ 2 ],
      is_stdout_a_tty, text_line, folder_selection, hide_headers, hide_seen,
      ordinal, button, list_onscreen;

   pid_t text_pid, compose_pid;
   FILE *input, *output;
   
   update_tree();
   void create_subtree( GtkWidget *, np_thread_node_t * );
   char *create_tree_entry( np_thread_node_t * );

   void set_size();
   void save_size();

   void write_read_file();
   void write_requests_file();
   
   np_thread_node_t *recursively_ascend_forward( np_thread_node_t * );
   void kill_my_children();
   void show_message( char * );

   int convert_month( char * );
   void convert_localtime( int *, int *, int *, int *, int *, int * );
   void convert_zone( char * );
   void adjust_time( int *, int *, int *, int *, int *, int * );
   void convert_back_month( int, char * );
   int convert_back_date( char ** );

 public:

   NP_Summary( int, char ** );
   ~NP_Summary();
   
   friend void SIGUSR1_handler( int );
   friend void SIGPIPE_handler( int );
   
   friend void help_button_callback( GtkWidget *, gpointer );
   friend void exit_button_callback( GtkWidget *, gpointer );
   friend void close_button_callback( GtkWidget *, gpointer );
   friend int fonts_button_callback( GtkWidget *, GdkEvent * );
   friend void font_menu_callback( GtkWidget *, gpointer );

   friend void compose_button_callback( GtkWidget *, gpointer );
   friend void text_button_callback( GtkWidget *, gpointer );
   friend void list_button_callback( GtkWidget *, gpointer );
   friend void list_callback( GtkWidget *, gint, gint, GdkEvent *, gpointer );
   friend void sort_list_callback( GtkWidget *, gpointer );
   friend void close_list_callback( GtkWidget *, gpointer );

   friend void up_button_callback( GtkWidget *, gpointer );
   friend void down_button_callback( GtkWidget *, gpointer );
   friend void left_grey_button_callback( GtkWidget *, gpointer);
   friend void right_grey_button_callback( GtkWidget *, gpointer );
   friend void left_red_button_callback( GtkWidget *, gpointer );
   friend void right_red_button_callback( GtkWidget *, gpointer );
   friend void left_green_button_callback( GtkWidget *, gpointer );
   friend void right_green_button_callback( GtkWidget *, gpointer );
   friend np_thread_node_t *left_button_callback( GtkWidget *, gpointer );
   friend np_thread_node_t *right_button_callback( GtkWidget *, gpointer );

   friend void tree_item_callback( GtkWidget *, gpointer );
   friend void tree_widget_callback( GtkWidget *, gpointer );

   friend void SIGCHLD_handler( int );
   friend void message_callback( GtkWidget *, gpointer );
   friend void SIGTERM_handler( int );   
   friend void SIGUSR2_handler( int );

   friend void input_callback( gpointer, gint, GdkInputCondition );

   friend void mark_current_callback( GtkWidget *, gpointer );
   friend void mark_thread_callback( GtkWidget *, gpointer );
   friend void recursively_mark( np_thread_node_t *, int,
                                 NP_Summary *, int * );
   friend void recursively_label( np_thread_node_t *, NP_Summary * );
   friend void mark_all_callback( GtkWidget *, gpointer );
   
   friend void request_current_callback( GtkWidget *, gpointer );
   friend void request_thread_callback( GtkWidget *, gpointer );
   friend void recursively_request( np_thread_node_t *, int,
                                    NP_Summary *, int * );
   friend void request_all_callback( GtkWidget *, gpointer );

   friend void remove_all_callback( GtkWidget *, gpointer );
   friend void remove_current_callback( GtkWidget *, gpointer );
   
   friend void file_button_callback( GtkWidget *, gpointer );
   friend void folders_clist_callback( GtkWidget *, gint, gint, GdkEvent *,
                                       gpointer );
   friend void folders_callback( GtkWidget *, gpointer );

   friend void hide_headers_callback( GtkWidget *, gpointer );
   friend void hide_seen_callback( GtkWidget *, gpointer );

   friend gint mark_button_callback( GtkWidget *, GdkEvent * );
   friend gint request_button_callback( GtkWidget *, GdkEvent * );
   friend gint request_current_wrapper( GtkWidget *, GdkEvent * );
   friend gint mark_shortcut_callback( GtkWidget *, GdkEvent * );
   friend gint request_shortcut_callback( GtkWidget *, GdkEvent * );
   friend void set_expanded_callback( GtkWidget *, gpointer );
   friend void expand_subtree_callback( GtkWidget *, gpointer );

   void convert_date( char *, char ** );
   void run();
};

gint remove_button_callback( GtkWidget *, GdkEvent * );
gint hide_button_callback( GtkWidget *, GdkEvent * );
gint button_press_event( GtkWidget *, GdkEvent * );
