#include <signal.h>
#include "nplauncher.h"

NP_Launcher *launcher;

void escape_hatch( int signo )
{
   delete launcher;
   exit( signo );
}

int main( int argc, char **argv )
{
   signal( SIGTERM, escape_hatch );
   signal( SIGQUIT, escape_hatch );
   signal( SIGSEGV, escape_hatch );
   signal( SIGHUP, escape_hatch );

   launcher = new NP_Launcher( &argc, &argv );
   launcher->run();
   delete launcher;

   return 0;
}
