#include <stdio.h>
#include <unistd.h>
#include <signal.h>

#include <gdk/gdkx.h>
#include <gtk/gtk.h>

#include "npstringarray.h"
#include "npfile.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"
#include "npcollections.h"

void tree_callback( GtkWidget *widget, gpointer data )
{
   NP_Collections *collections = ( NP_Collections *)data;

   collections->selected_item = GTK_TREE( widget )->selection;

   if ( collections->selected_item == NULL )
      return;
   
   if (( collections->selected_item = GTK_TREE_SELECTION( widget )->data )
       == NULL )
      return;

   if ( collections->button )
   {
      GtkAdjustment *adjustment = collections->adjustment;

      float pos = GTK_WIDGET( collections->selected_item )->allocation.y;
      int height = 
         GTK_WIDGET( collections->selected_item )->requisition.height;
      float par_pos = 
         GTK_WIDGET( collections->selected_item )->parent->allocation.y;

      static int old_chunk = 0;
      int chunk = int(( pos + par_pos + height ) / adjustment->page_size );

      if ( chunk != old_chunk )
      {
         float value = chunk * adjustment->page_size;
         if ( value >= adjustment->upper - adjustment->page_size )
            value = adjustment->upper - adjustment->page_size;

         gtk_adjustment_set_value( adjustment, value - height );
      }

      old_chunk = chunk;
   }

   char *server, *group;
   server =
      ( char *)gtk_object_get_data( GTK_OBJECT( collections->selected_item ),
                                    "server" );
   group =
      ( char *)gtk_object_get_data( GTK_OBJECT( collections->selected_item ),
                                    "group" );

   if ( group == NULL )
      return;

   if ( !collections->summary_pid )
   {
      if ( pipe( collections->summary_pipe_fds ))
      {
         perror( "pipe" );
         return;
      }

      if ( pipe( collections->feedback_pipe_fds ))
      {
         perror( "pipe" );
         return;
      }
      
      switch( collections->summary_pid = fork() )
      {
      case -1:
         perror( "fork" );
         break;

      case 0:
         close( ConnectionNumber( gdk_display ));
         close( collections->summary_pipe_fds[ 1 ] );
         close( collections->feedback_pipe_fds[ 0 ] );

         if ( dup2( collections->summary_pipe_fds[ 0 ], STDIN_FILENO ) < 0 )
         {
            perror( "dup2" );
            _exit( 1 );
         }

         if ( dup2 ( collections->feedback_pipe_fds[ 1 ], STDOUT_FILENO ) < 0 )
         {
            perror( "dup2" );
            _exit( 1 );
         }

         char article[ 16 ], line[ 16 ];
         snprintf( article, sizeof article, "%d",
                   collections->search_position );
         snprintf( line, sizeof line, "%d",
                   collections->search_line );

         execlp( "npsummary", "npsummary",
                 server, group, article, line, NULL );
         perror( "execlp" );
         _exit( 1 );
         break;

      default:
         close( collections->summary_pipe_fds[ 0 ] );
         close( collections->feedback_pipe_fds[ 1 ] );

         char buffer[ 128 ];
         snprintf( buffer, sizeof buffer, "%d", collections->summary_pid );
         if ( collections->children.add_item( buffer ))
            collections->children.print_error();
         break;
      }

      if (( collections->summary_file
            = fdopen( collections->summary_pipe_fds[ 1 ], "w" )) == NULL )
      {
         perror( "fdopen" );
         return;
      }

      if (( collections->feedback_file
            = fdopen( collections->feedback_pipe_fds[ 0 ], "r" )) == NULL )
      {
         perror( "fdopen" );
         return;
      }

      if ( collections->feedback_id >= 0 )
      {
         gtk_input_remove( collections->feedback_id );
         collections->feedback_id = -1;
      }
      
      collections->feedback_id =
         gdk_input_add( collections->feedback_pipe_fds[ 0 ],
                        GDK_INPUT_READ,
                        feedback_callback, collections );
   }
   else
   {
      fprintf( collections->summary_file, "%s\n%s\n%d\n%d\n",
               server, group,
               collections->search_position,
               collections->search_line );
      fflush( collections->summary_file );

      collections->search_line = 0;
   }

   return;
}
