#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"

int NP_Tree::update()
{
   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.peruser4-newsrc", home );
   if ( file.openr( buffer ))
   {
      snprintf( error_message, sizeof error_message, "NP_Tree: update(): "
                "%s", file.get_error() );

      if ( errno == ENOENT )
         return errno;
      else
         return 1;
   }

   if ( clear() )
      return 1;

   NP_Node **pointer = NULL;
   char *line;
   while(( line = file.get_string() ) != NULL )
   {
      if ( *line == '\n' )
         continue;

      if ( isspace( *line ))
      {
         if ( array.add_item( strtok( line + strspn( line, "\t " ), ":" )))
         {
            snprintf( error_message, sizeof error_message,
                      "NP_Tree: update(): %s", array.get_error() );
            file.close();
            return 1;
         }
         
         continue;
      }
      
      if (( nodes =
            ( NP_Node **)realloc( nodes, ++total_nodes * sizeof *nodes ))
          == NULL )
      {
         perror( "realloc" );
         exit( 1 );
      }

      pointer = nodes;
      if (( pointer[ total_nodes - 1 ] = new NP_Node( strtok( line, "\n" )))
          == NULL )
      {
         perror( "new" );
         exit( 1 );
      }

      if ( total_nodes > 1 )
      {
         if ( array.add_item( "FOLLOW-UPS" ) || array.add_item( "POSTED" ))
         {
            snprintf( error_message, sizeof error_message, "NP_Tree: "
                      "update(): %s", array.get_error());
            return 1;
         }

         if ( array.add_item( "OUTBOX" ) || array.add_item( "SENT-MAIL" ))
         {
            snprintf( error_message, sizeof error_message, "NP_Tree: "
                      "update(): %s", array.get_error());
            return 1;
         }
            
         if (( pointer[ total_nodes - 2 ]->update_groups( array )))
         {
            snprintf( error_message, sizeof error_message,
                      "NP_Tree: update(): "
                      " %s", pointer[ total_nodes - 2 ]->get_error() );
            file.close();
            return 1;
         }

         int groups, messages, unseen, headers, requested;
         if ( pointer[ total_nodes - 2 ]->get_stats( &groups, &messages,
                                                     &unseen, &requested,
                                                     &headers ))
         {
            snprintf( error_message, sizeof error_message, "NP_Tree: "
                      "update(): %s",
                      pointer[ total_nodes - 2 ]->get_error() );
            return 1;
         }

         total_groups += groups;
         total_messages += messages;
         total_unseen += unseen;
         total_requested += requested;
         total_headers += headers;
         
         if ( array.clear() )
         {
            file.close();

            snprintf( error_message, sizeof error_message, "NP_Tree: "
                      "update(): %s", array.get_error() );
            return 1;
         }
      }
   }

   if ( total_nodes )
   {
      if ( array.add_item( "FOLLOW-UPS" ) || array.add_item( "POSTED" ))
      {
         snprintf( error_message, sizeof error_message, "NP_Tree: "
                   "update(): %s", array.get_error());
         return 1;
      }

      if ( array.add_item( "OUTBOX" ) || array.add_item( "SENT-MAIL" ))
      {
         snprintf( error_message, sizeof error_message, "NP_Tree: "
                   "update(): %s", array.get_error());
         return 1;
      }
            
      if (( pointer[ total_nodes - 1 ]->update_groups( array )))
      {
         snprintf( buffer, sizeof buffer, "NP_Tree: update(): "
                   " %s", pointer[ total_nodes - 1 ]->get_error() );
         file.close();
         return 1;
      }

      int groups, messages, unseen, headers, requested;
      if ( pointer[ total_nodes - 1 ]->get_stats( &groups, &messages,
                                                  &unseen, &requested,
                                                  &headers ))
      {
         snprintf( error_message, sizeof error_message, "NP_Tree: "
                   "update(): %s",
                   pointer[ total_nodes - 1 ]->get_error() );
         return 1;
      }

      total_groups += groups;
      total_messages += messages;
      total_unseen += unseen;
      total_requested += requested;
      total_headers += headers;
         
      if ( array.clear() )
      {
         file.close();

         snprintf( error_message, sizeof error_message, "NP_Tree: "
                   "update(): %s", array.get_error() );
         return 1;
      }
   }
   
   file.close();

   update_folders();
   
   return 0;
}

