#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include <X11/Xlib.h>
#include <gdk/gdkx.h>
#include <gtk/gtk.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"
#include "npcollections.h"

void author_email_website_callback( GtkWidget *widget, gpointer data )
{
   NP_Collections *collections =
      ( NP_Collections *)gtk_object_get_data( GTK_OBJECT( widget ),
                                              "collections" );

   if ( ( int )data )
      collections->fork_browser();
   else
   {
      message_callback( NULL, collections );

      if ( collections->compose_pid )
      {
         collections->show_message( "Another message is being composed.\n"
                                    "Finish it first.", 0 );
         return;
      }

      if ( !collections->total_nodes || collections->tree_nodes == NULL )
      {
         collections->show_message( "You must create at least one server\n"
                                    "tree before you can use this feature.",
                                    0 );
         return;
      }

      char *server =
         ( char *)gtk_object_get_data(
            GTK_OBJECT( collections->tree_nodes->node ),
            "server" );

      if ( server == NULL )
         return;

      switch( collections->compose_pid = fork() )
      {
      case -1:
         perror( "fork" );
         return;
         break;

      case 0:
         close( ConnectionNumber( gdk_display ));

         execlp( "npcompose", "npcompose", server, "OUTBOX",
                 "jimmy", "-1", NULL );
         perror( "execlp" );
         _exit( 1 );
         break;

      default:

         char buffer[ 128 ];
         snprintf( buffer, sizeof buffer, "%d", collections->compose_pid );
         if ( collections->children.add_item( buffer ))
            collections->children.print_error();

         break;
      }
      
   }

   return;
}
