#!/bin/sh
#
# ctrlmod.sh    
#
# description: install/uninstal modules 
#
# $1 : command
# $2 : tool module's name
# $3 : driver module's name


current_kernel_ver=`uname -r`

# See how we were called.
case "$1" in
	add)
		if [ "$(expr substr "$(sed -n '/'$2'/p' /proc/modules)" 1 7 )" = $2 ]; then
			echo 	
			echo "A module named $2 already exists"
			echo 
			exit 1
		else
			if [ ! -f ./tools/$2.o ]; then
				echo 
				echo "Please re-compile driver's source again"
				echo 
				exit 2
			fi

			echo 	
			echo "->Installing module $2"
			echo 

			echo "pre-install $3 insmod $2" >> /etc/modules.conf
			cp ./tools/$2.o /lib/modules/$current_kernel_ver/kernel/drivers/net
			/sbin/insmod $2
		fi

		if [ "$(expr substr "$(sed -n '/'$3'/p' /proc/modules)" 1 8 )" = $3 ]; then
			echo
			echo "A module named $3 already exists"
			echo 
			exit 3
		else
			if [ ! -f ./driver/$3.o ]; then
				echo 
				echo "please re-compile driver's source again"
				echo 
				exit 4
			fi

			echo 	
			echo "->Installing module $3"
			echo 

			cp ./driver/$3.o /lib/modules/$current_kernel_ver/kernel/drivers/net
			/sbin/insmod $3
		fi
        ;;

	delete)
		if [ "$(expr substr "$(sed -n '/'$2'/p' /proc/modules)" 1 7 )" = $2 ]; then
			echo 	
			echo "->Removing module $2"
			echo 

			sed -e '/pre-install '$3' insmod '$2'/d' /etc/modules.conf > tmp
			rm -f /etc/modules.conf
			mv tmp /etc/modules.conf
			rm -f /lib/modules/$current_kernel_ver/kernel/drivers/net/$2.o
			/sbin/rmmod $2
		else
			echo 	
			echo "A module named $2 not exist"
			echo 
			exit 5
		fi

		if [ "$(expr substr "$(sed -n '/'$3'/p' /proc/modules)" 1 8 )" = $3 ]; then
			echo 	
			echo "->Removing module $3"
			echo 
			rm -f  /lib/modules/$current_kernel_ver/kernel/drivers/net/$3.o
			/sbin/rmmod $3
		else
			echo 	
			echo "A module named $3 not exist"
			echo 
			exit 6
		fi
        ;;

	*)
        echo $"Usage: $0 {add|delete} {tool module's name} {driver module's name}" 
        exit 5
esac

exit 0
