/* ----------------------------------------------- */
/* company : pentamedia
 * author  : elcomski 
 * file    : pentapi.h
 * date    : 2001-06-17
 * modify  : 2001-12-23 by elcomski
 */
/* ----------------------------------------------- */
#ifndef _PENTAPI_H_
#define _PENTAPI_H_

#ifdef __cplusplus
extern "C" {
#endif
    

/*--------------------------------*/
/* Constant definitions */
/*--------------------------------*/
#define P18v 1
#define P13v 0
    
#define ERR_OPEN_SOCKET -1
#define ERR_NOT_DEVICE -2
#define ERR_NOT_DEVICE_OPEN -3



/*--------------------------------*/
/* External function definition */
/*--------------------------------*/
extern aint sm_init_device(achar *dev_name);
extern aint sm_exit_device(achar *dev_name);

// - : error
// 0 : driver is
// + : driver initialize
extern aint sm_get_device_status(achar *dev_name);
extern aulong sm_get_device_version(achar *dev_name);
extern aint sm_get_mac_address(achar *dev_name, achar *addr);
// - : not tunning
// 0 : lock fail
// + : lock ok
extern aint sm_tuner_get_status(achar *dev_name);
extern aint sm_get_received_packets(achar *dev_name);
extern aint sm_get_down_speed(achar *dev_name);
extern aint sm_get_bit_error_rate(achar *dev_name);
extern double sm_get_signal_quality(achar *dev_name);
extern aint sm_get_uncorrected_rs_error(achar *dev_name);
extern aint sm_get_corrected_rs_error( achar *dev_name );
 

/*---------------------------------*/
// 
//  PID queue control
//
/*---------------------------------*/
// x = 0 -> ok
// x < 0 -> fail
extern aint sm_queue_pid_clear(achar *dev_name);
extern aint sm_queue_pid_delete(achar *dev_name, auint pid);
extern aint sm_queue_pid_add(achar *dev_name, auint pid);
/* Begin for add Fixed Key */
extern auint sm_queue_pid_add_with_cw(achar *dev_name, auint pid, auchar *evencw, auchar *oddcw );
extern auint sm_queue_pid_set_cw(achar *dev_name, auint pid, auchar *evencw, auchar *oddcw );
/* End for add Fixed Key */
    

/*---------------------------------*/
// 
// LNB control
//
/*---------------------------------*/
// sw : ON , OFF
extern aint sm_lnb_set_power(achar *dev_name, auint sw);
// voltage :  P18v,P13v
extern aint sm_lnb_set_voltage(achar *dev_name, auint voltage);
// sw : ON , OFF
extern aint sm_lnb_set_22khz(achar *dev_name, auint sw);



/*---------------------------------*/
// 
//  IP-filter control
//
/*---------------------------------*/
extern aint sm_filter_ip_clear(achar *dev_name);
extern aint sm_filter_ip_add(achar *dev_name, aulong fip);
extern aint sm_filter_ip_active(achar *dev_name);


/*---------------------------------*/
// 
//  Tuner control
//
/*---------------------------------*/
extern aint sm_tuner_start_tunning(achar *dev_name, str_trans_data trans);
extern aint sm_tuner_stop_tunning(achar *dev_name);


/*---------------------------------*/
// 
//  Multicast-route control
//
/*---------------------------------*/
// - : error
// 0 : can not find the device 
// 1 : ok
extern aint sm_multi_route_device(achar *dev_name, achar *gate_dev_name);
// - : error
// 0 : ok
extern aint sm_multi_ip_add(achar *dev_name, aulong mip);
extern aint sm_multi_ip_del(achar *dev_name, aulong mip);
extern aint sm_multi_ip_clear(achar *dev_name);
extern aint sm_multi_ip_all(achar *dev_name, abool flag);
extern aint sm_multi_get_mac_info( achar *dev_name, str_mac_data *mmac_data );


/*---------------------------------*/
// 
//  I2C(qpsk/tuner) control
//
/*---------------------------------*/
extern aint sm_send_without_offset(achar *dev_name, aint chip_addr, abyte *ba_data, auint usize);
extern aint sm_read_without_offset(achar *dev_name, aint chip_addr, abyte *ba_data, auint usize);
extern aint sm_send_with_offset(achar *dev_name, aint chip_addr, abyte offset, abyte *ba_data, auint usize);
extern aint sm_read_with_offset(achar *dev_name, aint chip_addr, abyte offset, abyte *ba_data, auint usize);


#ifdef __cplusplus
}
#endif

#endif /* _PENTAPI_H_ */
