/*
 * dialog.cc
 * Copyright (C) Martin Singer 2009-2011 <m_power3@users.sourceforge.net>
 * 
 * pdfchain is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * pdfchain is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "dialog.h"


/*** About Dialog *************************************************************/

// Constructor
cDialog_About::cDialog_About()
{
	std::vector<Glib::ustring>	vect_authors;
	Glib::RefPtr<Gio::File>	ref_icon_path_A = Gio::File::create_for_path( Pdfchain::APPICON_PATH_A );
	Glib::RefPtr<Gio::File>	ref_icon_path_B = Gio::File::create_for_path( Pdfchain::APPICON_PATH_B );

	if		( ref_icon_path_A->query_exists() )	set_logo( Gdk::Pixbuf::create_from_file( Pdfchain::APPICON_PATH_A ) );
	else if	( ref_icon_path_B->query_exists() )	set_logo( Gdk::Pixbuf::create_from_file( Pdfchain::APPICON_PATH_B ) );
	else										std::cerr << std::endl << "Icon file doesn't exist! " << Pdfchain::APPICON_PATH_A << " , " << Pdfchain::APPICON_PATH_B;
		
	vect_authors.push_back( "Martin Singer <m_power3@users.sourceforge.net>" );
	
	set_default_response( Gtk::RESPONSE_CLOSE );
	set_program_name( Pdfchain::About::PROGRAM_NAME );
	set_version( Pdfchain::About::PROGRAM_VERSION );
	set_comments( _("a GUI for the PDFTK") );
	set_authors( vect_authors );
	//set_documenters( vet_documenters );
	//set_artists( vet_artists );
	//set_translator_credits( str_translators );
	set_copyright( "Copyright " + Pdfchain::String::COPYRIGHT + " 2009-2011 Martin Singer" );
	set_license_type( Gtk::LICENSE_GPL_3_0 );
	set_website( Pdfchain::About::PROJECT_URL );
	set_website_label( Pdfchain::About::PROJECT_URL );
	//set_website_label( _("Visit the PDF Chain Projekt") );
}


// Destructor
cDialog_About::~cDialog_About()
{
#ifdef PDFCHAIN_TEST
	std::cout << std::endl << "cDialog_About::~cDialog_About()";	//TEST
#endif
}



/*** Message Dialog : PDFTK Error *********************************************/

// Constructor
cMDialog_PdftkError::cMDialog_PdftkError( Gtk::Window& ref_window )
:
	Gtk::MessageDialog( ref_window , _("PDFTK returned error!") , false ,  Gtk::MESSAGE_ERROR , Gtk::BUTTONS_CLOSE , false )
{
}


// Destructor
cMDialog_PdftkError::~cMDialog_PdftkError()
{
#ifdef PDFCHAIN_TEST
	std::cout << std::endl << "cMDialog_PdftkError::~cMDialog_PdftkError()";	//TEST
#endif
}


// Methode (public) : popup message
void
cMDialog_PdftkError::popupMessage( const Glib::ustring& str_error_text , int error_code )
{
	std::cerr << std::endl << str_error_text << " - PDFTK returned: " << error_code << std::endl;

	Glib::ustring str_secondary_text = str_error_text + + "\n" + _("Error code:") + " "
		+ static_cast<Glib::ustring>( Pdfchain::convert_guint_to_string( static_cast<guint>( error_code ) ) );
	
	set_secondary_text( str_secondary_text , false );

	run();
	hide();
	return;
}



/*** Message Dialog : Password ************************************************/

// Constructor
cMDialog_Password::cMDialog_Password( Gtk::Window& ref_window )
:
	Gtk::MessageDialog( ref_window , _("For a file has already been assigned a password!") , false , Gtk::MESSAGE_QUESTION , Gtk::BUTTONS_OK , false ),
	mTable( 5 , 2 , false ),	// y_rows , x_columns , homogenous
	mRButton_PasswordNone(	_("No Password")			, false ),	// label , mnemonic
	mRButton_PasswordNew(	_("New Password:")			, false ),
	mRButton_PasswordOrg(	_("Original Password:")		, false ),
	mRButton_PasswordAlt(	_("Alternative Password:")	, false ),
	mLabel_FileName(	""	, Gtk::ALIGN_CENTER	, Gtk::ALIGN_CENTER	, false	),	// label , xalign , yalign , mnemonic
	mLabel_PasswordNew(	""	, Gtk::ALIGN_START	, Gtk::ALIGN_CENTER	, false	),
	mLabel_PasswordOrg(	""	, Gtk::ALIGN_START	, Gtk::ALIGN_CENTER	, false	),
	bChecked( false ),
	sPassword( "" )
{
	set_secondary_text( _("Which password should be used?") );
	
	mRBGroup_Password = mRButton_PasswordNone.get_group();
	mRButton_PasswordNew.set_group( mRBGroup_Password );
	mRButton_PasswordOrg.set_group( mRBGroup_Password );
	mRButton_PasswordAlt.set_group( mRBGroup_Password );
	mRButton_PasswordOrg.set_active();

	mLabel_FileName.set_single_line_mode( true );
	mLabel_PasswordNew.set_single_line_mode( true );
	mLabel_PasswordOrg.set_single_line_mode( true );

	mEntry_PasswordAlt.set_icon_from_stock(	Gtk::Stock::CLEAR , Gtk::ENTRY_ICON_SECONDARY );

	mTable.attach( mLabel_FileName			, 0 , 2 , 0 , 1 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::EXPAND , Pdfchain::PADDING , Pdfchain::PADDING );
	mTable.attach( mRButton_PasswordNone	, 0 , 1 , 1 , 2 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::EXPAND , Pdfchain::PADDING , Pdfchain::PADDING );
	mTable.attach( mRButton_PasswordNew		, 0 , 1 , 2 , 3 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::EXPAND , Pdfchain::PADDING , Pdfchain::PADDING );
	mTable.attach( mRButton_PasswordOrg		, 0 , 1 , 3 , 4 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::EXPAND , Pdfchain::PADDING , Pdfchain::PADDING );
	mTable.attach( mRButton_PasswordAlt		, 0 , 1 , 4 , 5 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::EXPAND , Pdfchain::PADDING , Pdfchain::PADDING );
	mTable.attach( mLabel_PasswordNew		, 1 , 2 , 2 , 3 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::EXPAND , Pdfchain::PADDING , Pdfchain::PADDING );
	mTable.attach( mLabel_PasswordOrg		, 1 , 2 , 3 , 4 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::EXPAND , Pdfchain::PADDING , Pdfchain::PADDING );
	mTable.attach( mEntry_PasswordAlt		, 1 , 2 , 4 , 5 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::EXPAND , Pdfchain::PADDING , Pdfchain::PADDING );

	get_vbox()->pack_start( mTable	, false	, false	, Pdfchain::PADDING );	// widget , expand , fill , padding
	show_all_children();

	mEntry_PasswordAlt.signal_icon_press().connect( sigc::mem_fun( *this , &cMDialog_Password::onEntryIcon_PasswordAlt_pressed ) );
}


// Destructor
cMDialog_Password::~cMDialog_Password()
{
#ifdef PDFCHAIN_TEST
	std::cout << std::endl << "cMDialog_Password::~cDialog_Password()";	//TEST
#endif
}


// Methode (public) : init (used at cLStore_Cat::addRows())
void
cMDialog_Password::init( const std::string& str_sourcepath , const Glib::ustring& str_password_new )
{
	bChecked	= false;
	sPassword	= "";

	mRButton_PasswordOrg.set_active();
	mLabel_FileName.set_text( Pdfchain::String::QUOTE_BEGIN + Glib::filename_to_utf8( Pdfchain::extract_filename_from_path( str_sourcepath ) ) + Pdfchain::String::QUOTE_END );
	mLabel_PasswordNew.set_text( str_password_new );
	mLabel_PasswordOrg.set_text( "" );
	return;
}


// Methode (public) : get correct password
Glib::ustring
cMDialog_Password::getCorrectPassword( const Glib::ustring& str_password_org )
{
	switch ( bChecked ) {
		case false:
			mLabel_PasswordOrg.set_text( str_password_org );
			run();
			hide();

			if (		mRButton_PasswordNone.get_active()	)	sPassword = "";
			else if (	mRButton_PasswordNew.get_active()	)	sPassword = mLabel_PasswordNew.get_text();
			else if (	mRButton_PasswordOrg.get_active()	)	sPassword = mLabel_PasswordOrg.get_text();
			else if (	mRButton_PasswordAlt.get_active()	)	sPassword = mEntry_PasswordAlt.get_text();

			bChecked = true;
			break;
	}

	return sPassword;
}