#ifndef INCLUDE_MODULE_PMAC_H
#define INCLUDE_MODULE_PMAC_H
/* ----------------------------------------------------------------------------
 * module_PMAC.h
 * prototypes and definitions for the laptop module pmac.
 *
 * Copyright 2002 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#include <pbbtaglist.h>

#define ADB_BUFSIZE		32      /* Size of the ADB buffer, constant,
                                            must not be changed !! */

#define OHARE_PMU		9

#define BACKLIGHTMAX		15      /* from asm/backlight.h */
#define KEYBLIGHTMAX		15
#define AMBIENTMAX		1600
#define MAX_BATTERIES		2

#define DEFAULT_PMU		"/dev/pmu"
#define DEFAULT_ADB		"/dev/adb"
#define DEFAULT_BATLOG		"/var/lib/pbbuttons/%03d_battery.log"
#define DEFAULT_BATCYCLE	"/var/lib/pbbuttons/battery.cycle"

/* definitions for input device config */
#define TRACKPAD_NOTAP_NAME	"notap"
#define TRACKPAD_TAP_NAME	"tap"
#define TRACKPAD_DRAG_NAME	"drag"
#define TRACKPAD_LOCK_NAME	"lock"
#define TRACKPAD_MASK		3
enum {TRACKPAD_NOTAP, TRACKPAD_TAP, TRACKPAD_DRAG, TRACKPAD_LOCK, TRACKPAD_LAST=TRACKPAD_LOCK};

#define KEYBOARD_FNBACK_NAME	"fkeyslast"
#define KEYBOARD_FNTOP_NAME	"fkeysfirst"
#define KEYBOARD_MASK		1
enum {KEYBOARD_FNBACK, KEYBOARD_FNTOP, KEYBOARD_LAST=KEYBOARD_FNTOP};

#define BATLOG_NONE_NAME	"none"
#define BATLOG_CYCLE_NAME	"cycle"
#define BATLOG_LOG_NAME		"log"
enum {BATLOG_NONE, BATLOG_CYCLE, BATLOG_LOG, BATLOG_LAST=BATLOG_LOG};

#ifndef PMU_IOC_GRAB_BACKLIGHT
#define PMU_IOC_GRAB_BACKLIGHT	_IOR('B', 6, 0)
#endif

#ifndef PMU_ENV_AC_POWER
#define PMU_ENV_AC_POWER	0x04
#endif
#ifndef PMU_ENV_BATTERY_PRESENT
#define PMU_ENV_BATTERY_PRESENT	0x10
#endif

#define LMU_ADDR	0x42

struct modflags_pmac {
	unsigned int coveropen :1;
	unsigned int ac_power:1;
	unsigned int batpresent:1;      /* set by pmu hardware */
	unsigned int sleepsupported :1;
	unsigned int set_tpmode:1;        /* delayed function triggered */
	unsigned int set_kbdmode:1;          /* delayed function triggered */
	unsigned int goto_sleep:1;             /* delayed function triggered */
	unsigned int bat_present:MAX_BATTERIES; /* set by /proc/pmu/battery_% */
	unsigned int bat_charging:MAX_BATTERIES;
	unsigned int :0;
};

/* public prototypes */
int pmac_init (struct tagitem *taglist);
int pmac_exit ();

/* private prototypes */
void pmac_keyboard (struct tagitem *taglist);
void pmac_secure (struct tagitem *taglist);
void pmac_query (struct tagitem *taglist);
void pmac_configure (struct tagitem *taglist);
int pmac_handle_tags (int cfgure, struct tagitem *taglist);
void pmac_pmu_handler (int fd);
void pmac_timer (struct tagitem *taglist);

void pmac_update_batteryinfo ();
int pmac_get_procac ();
int pmac_update_flags ();
void activate_sleepmode ();
int pmac_get_lcdbacklight();
void pmac_set_lcdbacklight(int val);
void pmac_identify (char* buffer, int pmu);

int keyboard_get_config(int fd);
void keyboard_set_config(int fd, int config);
int keyboard_get_dev(int fd);
int trackpad_get_config(int fd);
void trackpad_set_config(int fd, int config);
int trackpad_get_dev(int fd);
void trackpad_set_prgmode(int fd, int dev, int mode);
int send_pmu_request(int fd, unsigned char *buffer, int params, ...);
int adb_read_reg(int fd, unsigned char *ADBBuffer, int dev, int reg);
int adb_write_reg(int fd, unsigned char *ADBBuffer, int len, int dev, int reg);
int get_pmu_version(int fd);
int get_button(int fd, int button);
int get_int_environment(int fd);
#ifndef WITH_PMUD
int get_cover_position(int fd);
#endif
int batlog_setup();
void batlog_save();
void batlog_write(long timerem);

/* functions for new alluminum PowerBook features */
int lmu_get_ambient ();
int lmu_find_bus ();
void lmu_set_illumination (int dev, unsigned short level);
int lmu_get_raw_ambient (int dev);

#endif    /* INCLUDE_MODULE_PMAC_H */
