/*****************************************************************************
 *                                                                           *
 * Program:   paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Modul:     negativ.c                                                      *
 *            Negative of images                                             *
 * Author:    Andreas Tille                                                  *
 * Date:      25.05.1998                                                     *
 * Copyright: Andreas Tille, 1999; GNU Public License                        *
 *                                                                           *
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "paul.h" 

void NegativBuffer(unsigned char *buf, int size, int step)
/* negate each byte:  b_new = 255 - b_old
 * --- Parameter: ---
 * unsigned char *buf : byte to negate
 * int           size : number of bytes
 * int           step : distance of the bytes to negate
 * --- Return: ---
 * unsigned char *buf : negated bytes
 */
{
  register unsigned char *ap, *fip;
  register int           s = step;
   
  for ( fip = (ap = buf) + size; ap < fip; ap += s )
    *ap = 255 - *ap;
}


int MakeNegative(GList *piclist)
/* negativ of a set of images, that is
 *    b_new = 255 - b_old for each color value
 * --- Parameter: ---
 * GList *piclist        : list of images
 * --- Return: ---
 * int    MakeNegative() : RET_ERR or RET_OK
 */
{
  PICTURE *bild;
  GList   *pl;
  char    *desc;

  if ( !NBILDER(piclist) ) return RET_OK;

  for ( bild = BILD(pl = piclist); pl; bild = BILD(pl = pl->next) ) {
    if ( IsMonochrom(bild) && bild->storepix == 3 ) 
      NegativBuffer(bild->DATA + 1, 3*bild->size, 3);
    else 
      NegativBuffer(bild->DATA, bild->storepix*bild->size, 1);

    desc = g_strdup_printf("%s of %s", TypNegativ, ImgFileName(bild));
    ImgChunksUpdate(bild, TypNegativ, desc, APPNEGATIV, NEGATIV);
    FREE(desc);
  }
  return RET_OK;
}

