/*
**  Charset.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#import <Pantomime/Charset.h>

#import <Pantomime/Constants.h>

@implementation Charset

- (void) dealloc
{
  RELEASE(dict);

  [super dealloc];
}

- (id) init
{
  self = [super init];

  dict = [[NSMutableDictionary alloc] init];

  return self;
}

- (NSString *) characterForCode: (NSString *) theCode
{
  NSString *aString;

  // We verify if we have a horizontal tab character
  if ( [theCode isEqualToString: @"=09"] )
    {
      return @"\t";
    }

  // We verify if we have a \n (line feed) character
  if ( [theCode isEqualToString: @"=0A"] ||
       [theCode isEqualToString: @"=0a"] )
    {
      return @"\n";
    }

  // We verify if we have a \r (carriage return) character
  if ( [theCode isEqualToString: @"=0D"] ||
       [theCode isEqualToString: @"=0d"] )
    {
      return @"\r";
    }
  
  aString = [dict objectForKey: [theCode uppercaseString]];
  
  return (aString ? aString: @"");
}

- (NSString *) codeForCharacter: (NSString *) theCharacter
{
  NSEnumerator *anEnumerator;
  NSString *aKey;

  anEnumerator = [dict keyEnumerator];
  
  while ( (aKey = [anEnumerator nextObject]) )
    {
      if ( [[dict objectForKey: aKey] isEqualToString: theCharacter] )
	{
	  return aKey;
	}
    }
  
  return @"";
}

- (BOOL) characterIsInCharset: (NSString *) theCharacter
{
  NSEnumerator *anEnumerator;
  NSString *anObject;
  NSRange aRange;

  aRange = [theCharacter rangeOfCharacterFromSet: [NSCharacterSet controlCharacterSet]];
  
  if (aRange.length)
    {
      return YES;
    }

  anEnumerator = [dict objectEnumerator];
  
  while ( (anObject = [anEnumerator nextObject]) )
    {
      if ( [anObject isEqualToString: theCharacter] )
	{
	  return YES;
	}
    }
  
  return NO;
}


//
// Returns the name of the Charset. Like:
// "iso-8859-1"
// 
- (NSString *) name
{
  [self subclassResponsibility: _cmd];
  return nil;
}

@end
