/*
**  SMTP.h
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**          Jonathan B. Leffert <jonathan@leffert.net>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#import <Foundation/Foundation.h>

#import <Pantomime/Service.h>
#import <Pantomime/Transport.h>

@class Message;
@class TCPConnection;

@interface SMTP : NSObject <Service, Transport>
{
  TCPConnection *tcpConnection;
  
  NSMutableArray *supportedAuthenticationMechanisms;

  NSString *name;
  int port;
}

- (BOOL) authenticateWithUsername: (NSString *) username
                         password: (NSString *) password
                        mechanism: (NSString *) mechanism;

- (void) close;

- (NSArray *) supportedAuthenticationMechanisms;

@end


//
// Private methods
//
@interface SMTP (Private)

- (void) _decodeSupportedAuthenticationMechanismFromString: (NSString *) theString;

- (BOOL) _responseFromServerIsEqualToCode: (NSString *) theCode
            verifyAuthenticationMechanism: (BOOL) aBOOL;

- (BOOL) sendMessage: (Message *) theMessage
       withRawSource: (NSData *) theRawSource;

- (BOOL) writeRecipients: (NSArray *) recipients
       usingBouncingMode: (BOOL) aBOOL;

- (BOOL) writeMessageFromRawSource: (NSData *) theRawSource;

- (BOOL) _plainAuthenticationUsingUsername: (NSString *) username
                                  password: (NSString *) password;

- (BOOL) _loginAuthenticationUsingUsername: (NSString *) username
                                  password: (NSString *) password;

- (BOOL) _cramMD5AuthenticationUsingUsername: (NSString *) username
                                    password: (NSString *) password;

@end
