/*
**  Constants.h
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef GNUSTEP_BASE_VERSION
#define RETAIN(object)          [object retain]
#define RELEASE(object)         [object release]
#define AUTORELEASE(object)     [object autorelease]
#define TEST_RELEASE(object)    ({ if (object) [object release]; })
#define ASSIGN(object,value)    ({\
id __value = (id)(value); \
id __object = (id)(object); \
if (__value != __object) \
  { \
    if (__value != nil) \
      { \
        [__value retain]; \
      } \
    object = __value; \
    if (__object != nil) \
      { \
        [__object release]; \
      } \
  } \
})
#define DESTROY(object) ({ \
  if (object) \
    { \
      id __o = object; \
      object = nil; \
      [__o release]; \
    } \
})
#define CREATE_AUTORELEASE_POOL(X)      \
  NSAutoreleasePool *(X) = [NSAutoreleasePool new]
#endif

#define PANTOMIME_VERSION @"1.0.2"

#ifdef MACOSX
#import <Pantomime/MacOSXGlue.h>
#endif

#define CRLF "\r\n"
#define LF "\n"

#define NONE 0
#define QUOTEDPRINTABLE 1
#define BASE64 2
#define EIGHTBIT 3
#define BINARY 4

#define SEND_USING_SMTP 1
#define SEND_USING_SENDMAIL 2
#define SEND_TO_FOLDER 3

#define FORMAT_UNKNOWN 0
#define FORMAT_FLOWED 1
