'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\" $Id$
'\"
.TH DS1991 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.TP
.B DS1991
1152bit MultiKey iButton
.SH SYNOPSIS
Non-volatile memory with password protection.
.PP
.B 02
[.]XXXXXXXXXXXX[XX][/[
.B memory
|
.B pages/ident.[0-2|ALL]
|
.B pages/page.[0-2|ALL]
|
.B pages/password.[0-2|ALL]
|
.B settings/ident.[0-2|ALL]
|
.B settings/page.[0-2|ALL]
|
.B settings/password.[0-2|ALL]
|
.B settings/change_password.[0-2|ALL]
|
.B settings/reset_password.[0-2|ALL]
|
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.PP
.I 02
.SH SPECIAL PROPERTIES
.SS memory
.I read-write, binary
.br
144 bytes of non-volatile memory. Reading and writing (with offset) to the files will only work if currently used password is correct for all 3 pages.
.SS pages/page.0 pages/page.1 pages/page.2 pages/page.ALL
.I read-write, binary
.br
Memory is split into 3 pages of 48 bytes each.
.I ALL
is an aggregate of the pages. Each page is accessed sequentially. If currently used password is incorrect, random data will be returned when reading a page.
.SS pages/password.0 pages/password.1 pages/password.2 pages/password.ALL
.I write, binary
.br
Memory is split into 3 pages and each page has a unique password (8 bytes).
.I ALL
is an aggregate of the password. Each page is accessed sequentially. Writing to this file will set the currently used password when accessing memory in corresponding page. If the password is wrong, random data will be returned when reading memory.
.SS pages/ident.0 pages/ident.1 pages/ident.2 pages/ident.ALL
.I read-write, binary
.br
Memory is split into 3 pages and each page has a unique identification (8 bytes).
.I ALL
is an aggregate of the ident. Each page is accessed sequentially. Identification will return correct result even if currently used password is incorrect.
.SS settings/page.0 settings/page.1 settings/page.2 settings/page.ALL
.I read-write, binary
.br
Memory is split into 3 pages of 48 bytes each.
.I ALL
is an aggregate of the pages. Each page is accessed sequentially. If currently used password is incorrect, random data will be returned when reading a page. (same as pages/page.*)
.SS settings/ident.0 settings/ident.1 settings/ident.2 settings/ident.ALL
.I read-write, binary
.br
Memory is split into 3 pages and each page has a unique identification (8 bytes).
.I ALL
is an aggregate of the ident. Each page is accessed sequentially. Identification will return correct result even if currently used password is incorrect. (same as pages/ident.*)
.SS settings/password.0 settings/password.1 settings/password.2 settings/password.ALL
.I write, binary
.br
Memory is split into 3 pages and each page has a unique password (8 bytes).
.I ALL
is an aggregate of the password. Each page is accessed sequentially. Writing to this file will set the currently used password when accessing memory in corresponding page. If the password is wrong, random data will be returned when reading memory. (same as pages/password.*)
.SS settings/reset_password.0 settings/reset_password.1 settings/reset_password.2 settings/reset_password.ALL
.I write, binary
.br
Memory is split into 3 pages and each page has a unique password (8 bytes).
.I ALL
is an aggregate of the ident. Each page is accessed sequentially. Writing to this file will reset the password on the page. NOTE: All data in corresponding page will be deleted!
.SS settings/change_password.0 settings/change_password.1 settings/change_password.2 settings/change_password.ALL
.I write, binary
.br
Memory is split into 3 pages and each page has a unique password (8 bytes).
.I ALL
is an aggregate of the ident. Each page is accessed sequentially. Writing to this file will change the password on the page. NOTE: Currently used password have to be set to correct password before changing password. Data in the corresponding page is NOT effected.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
None.
.SH DESCRIPTION
.so man3/description.3so
.SS DS1991
The
.B DS1991 (3)
is an iButton with password protected non-volatile memory. Data is read/written with error checking (transparent to the user). The memory is divided into 3 different pages with 3 separate passwords.
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://pdfserv.maxim-ic.com/en/ds/DS1991.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Christian Magnusson (mag@mag.cx)
