'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\" $Id$
'\"
.TH DS1822 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B DS1822
Econo 1-Wire Digital Thermometer
.SH SYNOPSIS
Thermometer.
.PP
.B 22
[.]XXXXXXXXXXXX[XX][/[
.so man3/temperatures_mini.3so
|
.B die
|
.B power
|
.B temphigh
|
.B templow
|
.B trim
|
.B trimblanket
|
.B trimvalid
|
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.PP
.I 22
.SH SPECIAL PROPERTIES
.SS power
.I read-only,yes-no
.br
Is the chip powered externally (=1) or from the parasitically from the data bus (=0)?
.SS temperature
.I read-only, floating point
.br
Measured temperature with 12 bit resolution. 
.SS temperature9 temperature10 temperature11 temperature12
.I read-only, floating point
Measured temperature at 9 to 12 bit resolution. There is a tradeoff of time versus accuracy in the temperature measurement.
.SS fasttemp
.I read-only, floating point
.br
Equivalent to
.I temperature9
.so man3/temperature_threshold.3so
.so man3/temperature_errata.3so
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH DESCRIPTION
.so man3/description.3so
.SS DS1822
The
.B DS1822 (3)
is one of several available 1-wire temperature sensors. Alternatives are the
.B DS18S20 (3),
.B DS18B20 (3)
as well as temperature/voltage measurements in the
.B DS2436 (3)
and
.B DS2438 (3).
For truly versatile temperature measurements, see the protean
.B DS1921 (3) Thermachron (3).
.PP
Although the
.B DS1822 (3)
can select between 4 resolutions, this program simplifies the interface by only implementing the fastest/roughest and slowest/best.
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://pdfserv.maxim-ic.com/en/ds/DS1822.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
