###############################################################################
# 
#  Copyright (2008) Alexander Stukowski
#
#  This file is part of OVITO (Open Visualization Tool).
#
#  OVITO is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  OVITO is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
###############################################################################

# Find the QScintilla2 includes and library

# This module defines
#  QSCINTILLA2_INCLUDE_DIR, where to find qsciscintilla.h, etc.
#  QSCINTILLA2_LIBRARIES, libraries to link against to use QScintilla.
#  QSCINTILLA2_FOUND, If false, do not try to use QScintilla.
#
#  Also defined, but not for general use are
#  QSCINTILLA2_LIBRARY, where to find the QScintilla library.

FIND_PATH(QSCINTILLA2_INCLUDE_DIR Qsci/qsciscintilla.h
  ${QT_INCLUDE_DIR}
  /usr/local/include
  /usr/include
)

SET(QSCINTILLA2_NAMES ${QSCINTILLA2_NAMES} qscintilla2)
FIND_LIBRARY(QSCINTILLA2_LIBRARY
  NAMES ${QSCINTILLA2_NAMES}
  PATHS ${QT_LIBRARY_DIR} /usr/lib /usr/local/lib
)

IF(QSCINTILLA2_INCLUDE_DIR)
  IF(QSCINTILLA2_LIBRARY)
    SET(QSCINTILLA2_FOUND "YES")
    SET(QSCINTILLA2_LIBRARIES ${QSCINTILLA2_LIBRARY})
  ENDIF(QSCINTILLA2_LIBRARY)
ENDIF(QSCINTILLA2_INCLUDE_DIR)
