/*
 * Copyright (c) 1999, 2000 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

#include <oskit/version.h>
#include <stdio.h>
#include <stdarg.h>

/*
 * Overrides kern/version.c and kern/version_print.c
 */

unsigned long	oskit_version        = _OSKIT_VERSION;
char *		oskit_version_string = _OSKIT_VERSION_STRING;

/*
 * So we can tell people to print the version.
 */
void
oskit_print_version(void)
{
	printf("OSKit/UNIX Version %s (compiled %s)\n",
	       _OSKIT_VERSION_STRING, __DATE__);
}
