/* 
   ORSA - Orbit Reconstruction, Simulation and Analysis
   Copyright (C) 2002-2004 Pasquale Tricarico
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.
   
   As a special exception, Pasquale Tricarico gives permission to
   link this program with Qt commercial edition, and distribute the
   resulting executable, without including the source code for the Qt
   commercial edition in the source distribution.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef _XORSA_OBJECTS_GENERATOR_CARTESIAN_H_
#define _XORSA_OBJECTS_GENERATOR_CARTESIAN_H_

#include <qdialog.h>

class QLineEdit;
class QLabel;
class QSpinBox;

#include "xorsa_units_combo.h"
#include "xorsa_date.h"

#include <orsa_body.h>

class XOrsaObjectsGeneratorCartesian : public QDialog {
  
  Q_OBJECT
    
 public:
  XOrsaObjectsGeneratorCartesian(std::vector<orsa::BodyWithEpoch>&, QWidget *parent=0);
  
 private slots:
  void init_draw();
  void ok_pressed();
  void cancel_pressed();
  
 private:
  std::vector<orsa::BodyWithEpoch> &bodies;
  
 private:
  QLineEdit *le_name, *le_mass_m, *le_mass_M, *le_px_m, *le_px_M, *le_py_m, *le_py_M, *le_pz_m, *le_pz_M, *le_vx_m, *le_vx_M, *le_vy_m, *le_vy_M, *le_vz_m, *le_vz_M;
  QSpinBox  *sb_num;
  
  QPushButton *okpb;
  QPushButton *cancpb;
  
  XOrsaDatePushButton *odpb;
  orsa::UniverseTypeAwareTime epoch;  
  
 private:
  LengthCombo *pos_spacecb;
  LengthCombo *vel_spacecb;
  TimeCombo   *vel_timecb;
  MassCombo   *masscb;
};

#endif // _XORSA_OBJECTS_GENERATOR_CARTESIAN_H_
