#ifndef INC_CircularQueue_hpp__
#define INC_CircularQueue_hpp__

/**
 * <b>SOFTWARE RIGHTS</b>
 * <p>
 * ANTLR 2.6.0 MageLang Insitute, 1999
 * <p>
 * We reserve no legal rights to the ANTLR--it is fully in the
 * public domain. An individual or company may do whatever
 * they wish with source code distributed with ANTLR or the
 * code generated by ANTLR, including the incorporation of
 * ANTLR, or its output, into commerical software.
 * <p>
 * We encourage users to develop software with ANTLR. However,
 * we do ask that credit is given to us for developing
 * ANTLR. By "credit", we mean that if you use ANTLR or
 * incorporate any source code into one of your programs
 * (commercial product, research project, or otherwise) that
 * you acknowledge this fact somewhere in the documentation,
 * research report, etc... If you like ANTLR and have
 * developed a nice tool with the output, please mention that
 * you developed it using ANTLR. In addition, we ask that the
 * headers remain intact in our source code. As long as these
 * guidelines are kept, we expect to continue enhancing this
 * system and expect to make other tools available as they are
 * completed.
 * <p>
 * The ANTLR gang:
 * @version ANTLR 2.6.0 MageLang Insitute, 1999
 * @author Terence Parr, <a href=http://www.MageLang.com>MageLang Institute</a>
 * @author <br>John Lilley, <a href=http://www.Empathy.com>Empathy Software</a>
 * @author <br><a href="mailto:pete@yamuna.demon.co.uk">Pete Wells</a>
 */

#include "config.hpp"
#include <vector>

ANTLR_BEGIN_NAMESPACE(antlr)

// Resize every 5000 items
#define OFFSET_MAX_RESIZE 5000

template <class T>
class CircularQueue {
private:
	ANTLR_USE_NAMESPACE(std)vector<T> storage;

public:
	CircularQueue()
		: storage(), m_offset(0) {}
	~CircularQueue()
		{}

	T elementAt(int idx) const
		{ return storage[idx+m_offset]; } //Is this safe?
	void removeFirst()
		{
			if (m_offset >= OFFSET_MAX_RESIZE) {
				storage.erase( storage.begin(), storage.begin() + m_offset + 1 );
				m_offset = 0;
			} else {
				++m_offset;
			}
		}
	inline void removeItems( int nb )
		{
			if (m_offset >= OFFSET_MAX_RESIZE) {
				storage.erase( storage.begin(), storage.begin() + m_offset + nb );
				m_offset = 0;
			} else {
				m_offset+=nb;
			}
		}
	void append(const T& t)
		{ storage.push_back(t); }
	int entries() const
		{ return storage.size()-m_offset; }

private:
	int m_offset;
	CircularQueue(const CircularQueue&);
	const CircularQueue& operator=(const CircularQueue&);
};

ANTLR_END_NAMESPACE

#endif //INC_CircularQueue_hpp__
