###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_invision_power_board_mult_sql_inj_vuln.nasl 5817 2009-11-20 15:10:56Z apr $
#
# Invision Power Board Multiple SQL Injection Vulnerabilities
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900981);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-3974");
  script_name("Invision Power Board Multiple SQL Injection Vulnerabilities");
  desc = "
  Overview: The host is running Invision Power Board and is prone to multiple
  SQL Injection vulnerabilities.

  Vulnerability Insight:
  Tha input passed into 'search_term' parameter in search.php and in 'aid'
  parameter in lostpass.php is not porpperly sanitisied before being used
  to construct SQL queries.

  Impact:
  Succesful exploitation will allow attackers to access and modify the backend
  database by injecting arbitrary SQL queries.

  Impact Level: Application

  Affected Software/OS:
  Invision Power Board version 3.0.0, 3.0.1, and 3.0.2.

  Fix: Apply the following patch,
  http://community.invisionpower.com/topic/291103-invision-power-board-3-0-2-security-update/

  *****
  NOTE: Please ignore this warning if the above mentioned patch is already applied.
  *****

  References:
  http://en.securitylab.ru/nvd/387879.php
  http://www.vupen.com/english/advisories/2009/2413

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.5
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of Invision Power Board");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Secpod");
  script_family("Web application abuses");
  script_dependencies("invision_power_board_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

ipbPort = get_http_port(default:80);
if(!ipbPort){
  exit(0);
}

ipbVer = get_kb_item("www/" + ipbPort + "/invision_power_board");
if(!ipbVer){
  exit(0);
}

ipbVer = eregmatch(pattern:"^(.+) under (/.*)$", string:ipbVer);
if(ipbVer[1] =~ "3.0.(0|1|2)"){
  security_hole(ipbPort);
}
