###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_quixplorer_detect.nasl 2690 2009-06-09 15:15:24Z jun $
#
# QuiXplorer Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800630);
  script_version("Revision: 1.0");
  script_tag(name:"risk_factor", value:"None");
  script_name("QuiXplorer Version Detection");
  desc = "

  Overview : This script finds the installed QuiXplorer Version and saves the
  version in KB.

  Risk factor : None";

  script_description(desc);
  script_family("Service detection");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_summary("Set Version of QuiXplorer in KB");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

quixplorerPort = get_http_port(default:80);

if(!get_port_state(quixplorerPort)){
  exit(0);
}

foreach dir (make_list("/quixplorer", "/quixplore", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/index.php"), port:quixplorerPort);
  rcvRes = http_send_recv(port:quixplorerPort, data:sndReq);
  if(rcvRes == NULL){
    exit(0);
  }

  if(egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes) &&
     egrep(pattern:"QuiXplorer", string:rcvRes))
  {
    quixplorerVer = eregmatch(pattern:"QuiXplorer (([0-9.]+)(BETA)?)", string:rcvRes);

    if(quixplorerVer[1] != NULL)
    {
      set_kb_item(name:"www/"+ quixplorerPort + "/QuiXplorer", value:quixplorerVer[1] +
                           " under " + dir);
      security_note(data:"QuiXplorer version " + quixplorerVer[1] + 
                    " running at location " + dir + " was detected on the host");
    }
  }
}

