###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Java Plug-In (JPI) HPSBUX01100
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835085);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "HPSBUX", value: "01100");
  script_cve_id("CAN-2004-1029");
  script_name( "HP-UX Update for Java Plug-In (JPI) HPSBUX01100");
  desc = "

  Vulnerability Insight:
  Potential security vulnerabilities have been identified with HP-UX running 
  Java Plug-In (JPI). These vulnerabilities could be exploited remotely to 
  allow elevation of privilege, Denial of Service (DoS), or unauthorized 
  access to files and web pages. 

  Impact:
  Remote elevation of privilege
  Denial of Service (DoS)
  unauthorized access to files and web pages.

  Affected Software/OS:
  Java Plug-In (JPI) on
  HP-UX B.11.00, B.11.11, B.11.22, B.11.23 running Java Plug-In (JPI) revision 
  1.3.1 prior to revision 1.3.1.14.00 HP-UX B.11.00, B.11.11, B.11.22, B.11.23 
  running Java Plug-In (JPI) revision 1.4.2 prior to revision 1.4.2.06.00. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00899041-2

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Java Plug-In (JPI)");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"Jdk.JDK-COM", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk.JDK-DEMO", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk.JDK-IPF32", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre.JRE-COM", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre.JRE-COM-DOC", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre.JRE-IPF32", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre.JRE-IPF32-CL", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre.JRE-IPF32-HS", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk13.JDK13-COM", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk13.JDK13-DEMO", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk13.JDK13-IPF32", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk13.JDK13-PA11", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk13.JDK13-PA20", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-COM", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-COM-DOC", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-IPF32", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-IPF32-CL", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-IPF32-HS", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-PA11", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-PA11-CL", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-PA11-HS", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-PA20", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-PA20-CL", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-PA20-HS", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-JDK13_base.JAVA2-DEMO", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-JDK13_base.JAVA2-JDK-BASE", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-JDK13_perf.JAVA2-JDK", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-PlugIn13.JAVA2-PLUGIN", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-RTE13_base.JAVA2-JRE-BASE", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-RTE13_doc.JAVA2-JRE-DOC", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-RTE13_perf.JAVA2-JRE", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi13.JPI13-COM", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi13.JPI13-COM-DOC", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi13.JPI13-IPF32", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi13.JPI13-PA11", revision:"1.3.1.14.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi14.JPI14-COM", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi14.JPI14-COM-DOC", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi14.JPI14-IPF32", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi14.JPI14-PA11", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-COM", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-DEMO", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-IPF32", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-IPF64", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA11", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA20", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA20W", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PNV2", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PWV2", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-COM", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-COM-DOC", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF32", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF32-HS", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF64", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF64-HS", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA11-HS", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20-HS", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20W", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20W-HS", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PNV2", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PNV2-H", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PWV2", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PWV2-H", revision:"1.4.2.06.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.22")
{

  if(ishpuxpkgvuln(pkg:"Jdk.JDK-COM", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk.JDK-DEMO", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk.JDK-IPF32", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre.JRE-COM", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre.JRE-COM-DOC", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre.JRE-IPF32", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre.JRE-IPF32-CL", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre.JRE-IPF32-HS", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk13.JDK13-COM", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk13.JDK13-DEMO", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk13.JDK13-IPF32", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk13.JDK13-PA11", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk13.JDK13-PA20", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-COM", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-COM-DOC", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-IPF32", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-IPF32-CL", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-IPF32-HS", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-PA11", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-PA11-CL", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-PA11-HS", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-PA20", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-PA20-CL", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-PA20-HS", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-JDK13_base.JAVA2-DEMO", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-JDK13_base.JAVA2-JDK-BASE", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-JDK13_perf.JAVA2-JDK", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-PlugIn13.JAVA2-PLUGIN", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-RTE13_base.JAVA2-JRE-BASE", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-RTE13_doc.JAVA2-JRE-DOC", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-RTE13_perf.JAVA2-JRE", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi13.JPI13-COM", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi13.JPI13-COM-DOC", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi13.JPI13-IPF32", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi13.JPI13-PA11", revision:"1.3.1.14.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi14.JPI14-COM", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi14.JPI14-COM-DOC", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi14.JPI14-IPF32", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi14.JPI14-PA11", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-COM", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-DEMO", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-IPF32", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-IPF64", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA11", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA20", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA20W", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PNV2", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PWV2", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-COM", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-COM-DOC", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF32", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF32-HS", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF64", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF64-HS", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA11-HS", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20-HS", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20W", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20W-HS", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PNV2", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PNV2-H", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PWV2", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PWV2-H", revision:"1.4.2.06.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"Jdk.JDK-COM", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk.JDK-DEMO", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk.JDK-IPF32", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre.JRE-COM", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre.JRE-COM-DOC", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre.JRE-IPF32", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre.JRE-IPF32-CL", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre.JRE-IPF32-HS", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk13.JDK13-COM", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk13.JDK13-DEMO", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk13.JDK13-IPF32", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk13.JDK13-PA11", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk13.JDK13-PA20", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-COM", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-COM-DOC", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-IPF32", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-IPF32-CL", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-IPF32-HS", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-PA11", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-PA11-CL", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-PA11-HS", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-PA20", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-PA20-CL", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-PA20-HS", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-JDK13_base.JAVA2-DEMO", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-JDK13_base.JAVA2-JDK-BASE", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-JDK13_perf.JAVA2-JDK", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-PlugIn13.JAVA2-PLUGIN", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-RTE13_base.JAVA2-JRE-BASE", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-RTE13_doc.JAVA2-JRE-DOC", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-RTE13_perf.JAVA2-JRE", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi13.JPI13-COM", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi13.JPI13-COM-DOC", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi13.JPI13-IPF32", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi13.JPI13-PA11", revision:"1.3.1.14.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi14.JPI14-COM", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi14.JPI14-COM-DOC", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi14.JPI14-IPF32", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi14.JPI14-PA11", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-COM", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-DEMO", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-IPF32", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-IPF64", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA11", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA20", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA20W", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PNV2", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PWV2", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-COM", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-COM-DOC", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF32", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF32-HS", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF64", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF64-HS", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA11-HS", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20-HS", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20W", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20W-HS", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PNV2", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PNV2-H", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PWV2", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PWV2-H", revision:"1.4.2.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"Jdk.JDK-COM", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk.JDK-DEMO", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk.JDK-IPF32", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre.JRE-COM", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre.JRE-COM-DOC", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre.JRE-IPF32", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre.JRE-IPF32-CL", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre.JRE-IPF32-HS", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk13.JDK13-COM", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk13.JDK13-DEMO", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk13.JDK13-IPF32", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk13.JDK13-PA11", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk13.JDK13-PA20", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-COM", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-COM-DOC", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-IPF32", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-IPF32-CL", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-IPF32-HS", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-PA11", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-PA11-CL", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-PA11-HS", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-PA20", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-PA20-CL", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre13.JRE13-PA20-HS", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-JDK13_base.JAVA2-DEMO", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-JDK13_base.JAVA2-JDK-BASE", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-JDK13_perf.JAVA2-JDK", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-PlugIn13.JAVA2-PLUGIN", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-RTE13_base.JAVA2-JRE-BASE", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-RTE13_doc.JAVA2-JRE-DOC", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Java2-RTE13_perf.JAVA2-JRE", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi13.JPI13-COM", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi13.JPI13-COM-DOC", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi13.JPI13-IPF32", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi13.JPI13-PA11", revision:"1.3.1.14.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi14.JPI14-COM", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi14.JPI14-COM-DOC", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi14.JPI14-IPF32", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi14.JPI14-PA11", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-COM", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-DEMO", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-IPF32", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-IPF64", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA11", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA20", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA20W", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PNV2", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PWV2", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-COM", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-COM-DOC", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF32", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF32-HS", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF64", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF64-HS", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA11-HS", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20-HS", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20W", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20W-HS", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PNV2", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PNV2-H", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PWV2", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PWV2-H", revision:"1.4.2.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
