###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for file FEDORA-2007-0836
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861048);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.1");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2007-0836");
  script_cve_id("CVE-2007-2799");
  script_name( "Fedora Update for file FEDORA-2007-0836");
  desc = "

  Vulnerability Insight:
  The file command is used to identify a particular file according to the
  type of data contained by the file.  File can identify many different
  file types, including ELF binaries, system libraries, RPM packages, and
  different graphics formats.
  
  You should install the file package, since the file command is such a
  useful utility.


  Affected Software/OS:
  file on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-July/msg00058.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of file");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"file", rpm:"file~4.21~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"file-libs", rpm:"file-libs~4.21~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"file", rpm:"file~4.21~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"file-debuginfo", rpm:"file-debuginfo~4.21~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"file-devel", rpm:"file-devel~4.21~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"file-debuginfo", rpm:"file-debuginfo~4.21~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"file-libs", rpm:"file-libs~4.21~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"file-devel", rpm:"file-devel~4.21~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"file", rpm:"file~4.21~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}