###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_claroline_detect.nasl 2693 2009-06-08 15:15:24Z jun $
#
# Claroline Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800627);
  script_version("Revision: 1.0");
  script_tag(name:"risk_factor", value:"None");
  script_name("Claroline Version Detection");
  desc = "

  Overview : This script finds the installed Claroline Version and saves the
  version in KB.

  Risk factor : None";

  script_description(desc);
  script_family("Service detection");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_summary("Set Version of Claroline in KB");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

clarolinPort = get_http_port(default:80);


if(!get_port_state(clarolinPort)){
  exit(0);
}

foreach dir (make_list("/claroline/claroline/install", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/index.php"), port:clarolinPort);
  rcvRes = http_send_recv(port:clarolinPort, data:sndReq);
  if(rcvRes == NULL){
    exit(0);
  }
  if(egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes) &&
     egrep(pattern:"Claroline", string:rcvRes))
  {
    clarolineVer = eregmatch(pattern:"Claroline ([0-9.]+)(rc[0-9])?",
                            string:rcvRes);
    if(clarolineVer[1] != NULL)
    {
      if(clarolineVer[2] != NULL){
        clarolineVer = clarolineVer[1] + "." + clarolineVer[2];
      }
      else
        clarolineVer = clarolineVer[1];
      set_kb_item(name:"www/"+ clarolinPort + "/Claroline", value:clarolineVer +
                       " under " + dir);
      security_note(data:"Claroline version " + clarolineVer + " running at" + 
                         " location " + dir +  " was detected on the host"); 
    }
  }
}
