# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1963-1 (unbound)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66597);
 script_cve_id("CVE-2009-3602");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 script_name("Debian Security Advisory DSA 1963-1 (unbound)");

 desc = "The remote host is missing an update to unbound
announced via advisory DSA 1963-1.

It was discovered that Unbound, a DNS resolver, does not properly
check cryptographic signatures on NSEC3 records.  As a result, zones
signed with the NSEC3 variant of DNSSEC lose their cryptographic
protection.  (An attacker would still have to carry out an ordinary
cache poisoning attack to add bad data to the cache.)

The old stable distribution (etch) does not contain an unbound
package.

For the stable distribution (lenny), this problem has been fixed in
version 1.0.2-1+lenny1.

For the unstable distribution (sid) and the testing distribution
(squeeze), this problem has been fixed in version 1.3.4-1.

We recommend that you upgrade your unbound package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201963-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1963-1 (unbound)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libunbound-dev", ver:"1.0.2-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"unbound-host", ver:"1.0.2-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libunbound0", ver:"1.0.2-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"unbound", ver:"1.0.2-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
