/*
 * PERMISSIONS module
 *
 * Copyright (C) 2003 Miklós Tirpák (mtirpak@sztaki.hu)
 * Copyright (C) 2006 Juha Heinanen
 *
 * This file is part of opensips, a free SIP server.
 *
 * opensips is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * opensips is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * History:
 * --------
 *  2003-09-03  replaced /usr/local/et/ser/ with CFG_DIR (andrei)
 */

#ifndef PERMISSIONS_H
#define PERMISSIONS_H 1

#include "../../sr_module.h"
#include "../../db/db.h"
#include "../../pvar.h"
#include "rule.h"

#define DEFAULT_ALLOW_FILE "permissions.allow"
#define DEFAULT_DENY_FILE  "permissions.deny"

typedef struct rule_file {
	rule* rules;    /* Parsed rule set */
	char* filename; /* The name of the file */
} rule_file_t;

/*
 * Maximum number if allow/deny file pairs that can be opened
 * at any time
 */
#define MAX_RULE_FILES 64

extern str db_url;        /* Database URL */
extern str address_table; /* Name of address table */
extern str ip_col;    	  /* Name of IP address column */
extern str proto_col;     /* Name of protocol column */
extern str pattern_col;   /* Name of pattern column */
extern str info_col;      /* Name of context_info column */
extern str grp_col;       /* Name of address group column */
extern str mask_col;      /* Name of mask column */
extern str port_col;      /* Name of port column */
extern str id_col;        /* Name of id column */

typedef struct int_or_pvar {
    unsigned int i;
    pv_spec_t *pvar;  /* zero if int */
} int_or_pvar_t;

#define DISABLE_CACHE 0
#define ENABLE_CACHE 1

char *allow_suffix;
int allow_test(char *file, char *uri, char *contact);

#endif
