// $Id: FileBase.cc 6786 2007-08-04 10:29:59Z m9710797 $

#include "FileBase.hh"
#include <algorithm>
#include <cstring>

using std::string;

namespace openmsx {

FileBase::FileBase()
	: mmem(NULL)
{
}

FileBase::~FileBase()
{
	munmap();
}

byte* FileBase::mmap(bool writeBack)
{
	if (!mmem) {
		mmapWrite = writeBack;
		mmapSize = getSize();
		mmem = malloc(mmapSize);
		read(mmem, mmapSize);
	}
	return static_cast<byte*>(mmem);
}

void FileBase::munmap()
{
	if (mmem) {
		if (mmapWrite) {
			seek(0);
			write(mmem, mmapSize);
		}
		free(mmem);
		mmem = NULL;
	}
}

void FileBase::truncate(unsigned newSize)
{
	unsigned oldSize = getSize();
	if (newSize < oldSize) {
		PRT_DEBUG("Default truncate() can't shrink file!");
		return;
	}
	unsigned remaining = newSize - oldSize;
	seek(oldSize);

	const unsigned BUF_SIZE = 4096;
	byte buf[BUF_SIZE];
	memset(buf, 0, BUF_SIZE);
	while (remaining) {
		unsigned chunkSize = std::min(BUF_SIZE, remaining);
		write(buf, chunkSize);
		remaining -= chunkSize;
	}
}

const string FileBase::getOriginalName()
{
	// default implementation just returns filename portion of URL
	string url = getURL();
	string::size_type pos = url.find_last_of('/');
	return (pos == string::npos) ? url : url.substr(pos + 1);
}

} // namespace openmsx
