// $Id: HDImageCLI.cc,v 1.2 2006/05/28 10:35:28 manuelbi Exp $

#include "HDImageCLI.hh"
#include "Reactor.hh"
#include "CommandController.hh"
#include "TclObject.hh"
#include "MSXException.hh"

using std::list;
using std::string;

namespace openmsx {

HDImageCLI::HDImageCLI(CommandLineParser& commandLineParser)
	: commandController(commandLineParser.getReactor().getCommandController())
{
	commandLineParser.registerOption("-hda", this);
	// TODO: offer more options in case you want to specify 2 hard disk images?
}

bool HDImageCLI::parseOption(const string& option, list<string>& cmdLine)
{
	string hd = option.substr(1); // hda
	string filename = getArgument(option, cmdLine);
	if (!commandController.hasCommand(hd)) {
		throw MSXException("No hard disk named '" + hd + "'.");
	}
	TclObject command(commandController.getInterpreter());
	command.addListElement(hd);
	command.addListElement(filename);
	command.executeCommand();
	return true;
}
const string& HDImageCLI::optionHelp() const
{
	static const string text("Use hard disk image in argument for the IDE extension");
	return text;
}

} // namespace openmsx
