#! /bin/sh

#
# Copyright (c) 2004-2006 The Trustees of Indiana University and Indiana
#                         University Research and Technology
#                         Corporation.  All rights reserved.
# Copyright (c) 2004-2005 The Regents of the University of California.
#                         All rights reserved.
# Copyright (c) 2006      Cisco Systems, Inc.  All rights reserved.
# $COPYRIGHT$
# 
# Additional copyrights may follow
# 
# $HEADER$
#

# This flie was not generated by XML scripts; it was written by hand.
# It may be generated someday, but at this point, it was simpler to
# just write it by hand.

. "$1/fortran_kinds.sh"

# This entire file is only generated in small or larger modules.  So
# if we're not at least small, bail now.

check_size small
if test "$output" = "0"; then
    exit 0
fi

# Ok, we should continue.

cat <<EOF

subroutine MPI_Testall_normal(count, array_of_requests, flag, array_of_statuses, ierr)
  include 'mpif-config.h'
  integer, intent(in) :: count
  integer, dimension(count), intent(inout) :: array_of_requests
  logical, intent(out) :: flag
  integer, dimension(count, MPI_STATUS_SIZE), intent(inout) :: array_of_statuses
  integer, intent(out) :: ierr
  call MPI_TESTALL(count, array_of_requests, flag, array_of_statuses, ierr)
end subroutine MPI_Testall_normal

subroutine MPI_Testall_ignore(count, array_of_requests, flag, array_of_statuses, ierr)
! Note that we need mpif-common.h (not mpif-config.h) because we need
! the global common variable MPI_STATUSES_IGNORE
  include 'mpif-common.h'
  integer, intent(in) :: count
  integer, dimension(count), intent(inout) :: array_of_requests
  logical, intent(out) :: flag
  double complex, intent(in) :: array_of_statuses
  integer, intent(out) :: ierr
  call MPI_TESTALL(count, array_of_requests, flag, MPI_STATUSES_IGNORE, ierr)
end subroutine MPI_Testall_ignore

EOF
