/*
 * Copyright (c) 2004-2005 The Trustees of Indiana University and Indiana
 *                         University Research and Technology
 *                         Corporation.  All rights reserved.
 * Copyright (c) 2004-2005 The University of Tennessee and The University
 *                         of Tennessee Research Foundation.  All rights
 *                         reserved.
 * Copyright (c) 2004-2005 High Performance Computing Center Stuttgart, 
 *                         University of Stuttgart.  All rights reserved.
 * Copyright (c) 2004-2006 The Regents of the University of California.
 *                         All rights reserved.
 * $COPYRIGHT$
 * 
 * Additional copyrights may follow
 * 
 * $HEADER$
 */

#ifndef MCA_BML_BASE_H
#define MCA_BML_BASE_H

#include "ompi_config.h"

#include "opal/mca/mca.h"
#include "ompi/mca/bml/bml.h"


/*
 * Global functions for the BML
 */

#if defined(c_plusplus) || defined(__cplusplus)
extern "C" {
#endif


struct mca_bml_base_selected_module_t {
    opal_list_item_t super;
    mca_bml_base_component_t *bml_component;
    mca_bml_base_module_t *bml_module;
};
    typedef struct mca_bml_base_selected_module_t mca_bml_base_selected_module_t;
OBJ_CLASS_DECLARATION(mca_bml_base_selected_module_t); 



/*
 * Global functions for MCA: overall BTL open and close
 */

OMPI_DECLSPEC  int mca_bml_base_open(void);
OMPI_DECLSPEC  int mca_bml_base_init(bool enable_progress_threads, 
                                     bool enable_mpi_threads, 
                                     opal_class_t* endpoint_class);
OMPI_DECLSPEC  int mca_bml_base_close(void);


/*
 * Globals
 */
OMPI_DECLSPEC extern int mca_bml_base_output;
OMPI_DECLSPEC extern mca_bml_base_component_t mca_bml_component;
OMPI_DECLSPEC extern opal_list_t mca_bml_base_components_available; 
OMPI_DECLSPEC extern mca_bml_base_module_t mca_bml; 

#if defined(c_plusplus) || defined(__cplusplus)
}
#endif
#endif /* MCA_BML_BASE_H */
