/*
 * Copyright (c) 2000, Amnon BARAK (amnon@cs.huji.ac.il). All rights reserved.
 *
 *       MOSIX $Id: mos.h,v 1.7 2001/04/12 16:53:00 amnons Exp $
 *
 * Permission to use, copy and distribute this software is hereby granted 
 * under the terms of version 2 or any later version of the GNU General Public
 * License, as published by the Free Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED IN ITS "AS IS" CONDITION, WITH NO WARRANTY
 * WHATSOEVER. NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING
 * FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED.
 */
/*
 * Author(s): Ariel Rosenblatt, Amnon Shiloh
 * Code derived from previous work by Amnon Shiloh and Oren Laadan.
 */
#ifndef __mos__
#define __mos__

#include <libmosix.h>

int dadvise(int advice, int interval, int keep);

int msx_is_mosix(void);
int msx_is_configured(void);

int msx_where_is(pid_t pid);
int msx_is_lock(pid_t pid);
int msx_send(pid_t pid, int node);
int msx_get_nmigs(pid_t pid);
int msx_where_am_i(void);
int msx_self_is_lock(void);
int msx_lock(void);
int msx_unlock(void);
int msx_self_get_cantmove(char *buff, int len);
int msx_migrate(int node);
int msx_self_get_nmigs(void);
int msx_send_back_home(pid_t pid);
int msx_go_back_home(void);
int msx_get_cpujob(void);
int msx_set_cpujob(void);
int msx_get_iojob(void);
int msx_set_iojob(void);
int msx_get_slow(void);
int msx_set_slow(void);
int msx_get_fast(void);
int msx_set_fast(void);
int msx_get_own(int *decay, int *period);
int msx_set_own(int decay, int period);
int msx_get_slowdecay(void);
int msx_get_fastdecay(void);
int msx_get_decayinterval(void);
#endif 
