/*
 * crypt-dull.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1995-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

static const char rcsid[] =
    "@(#) $Header: /usr/mash/src/repository/srmv2/net/crypt-dull.cc,v 1.4 2002/02/03 03:03:19 lim Exp $ (LBL)";

#include "crypt.h"
#include "inet.h"
/*
 * Largest (user-level) packet size generated by our rtp applications.
 * Individual video formats may use smaller mtu's.
 */
#define RTP_MTU 1024

/*
 * A simple XOR data scrambler.  This is module is provided for test
 * purposes and to illustrate the extensibility of the encryption interface.
 *
 * This algorithm is trivial to crack using an obvious plaintext
 * attack.  It will only protect against accidental eavesdropping.
 */
class SRMv2_CryptDull : public SRMv2_Crypt {
    public:
	SRMv2_CryptDull();
	~SRMv2_CryptDull();
	virtual int install_key(const u_int8_t* key);
	virtual u_char* Encrypt(const u_char* in, int& len);
	virtual int Decrypt(const u_char* in, int len, u_char* out);
    protected:
	void crypt(const u_int32_t* in, u_int32_t* out, int nw);
	u_int32_t key_;
	u_char* wrkbuf_;
};

SRMv2_CryptDull::SRMv2_CryptDull()
{

	/* enough extra space for padding and RTCP 4-byte random header */
	wrkbuf_ = new u_char[RTP_MTU + 8 + 4];
}

SRMv2_CryptDull::~SRMv2_CryptDull()
{
	delete wrkbuf_;
}

int SRMv2_CryptDull::install_key(const u_int8_t* key)
{
	/* net order */
	key_ = *(u_int32_t*)key;
	return (0);
}

void SRMv2_CryptDull::crypt(const u_int32_t* in, u_int32_t* out, int nw)
{
	u_int32_t k = key_;
	for (int i = 0; i < nw; ++i)
		out[i] = in[i] ^ k;
}

u_char* SRMv2_CryptDull::Encrypt(const u_char* in, int& len)
{
	/*
	 * assume input is word-aligned and we can read
	 * past end to next longword boundary
	 */
	crypt((const u_int32_t*)in, (u_int32_t*)wrkbuf_, (len + 3) >> 2);
	return (wrkbuf_);
}

int SRMv2_CryptDull::Decrypt(const u_char* in, int len, u_char* out)
{
	/*
	 * assume input/output is word-aligned and we can read/write
	 * past end to next longword boundary
	 */
	crypt((const u_int32_t*)in, (u_int32_t*)out, (len + 3) >> 2);
	return (len);
}
