/*
 * callback.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __CALLBACK_H__
#define __CALLBACK_H__

/* This is a workaround for a bug in the current version of gcc:

   gcc assumes that no one will touch %a4 after it is set up in crt0.o.
   This isn't true if a function is called as a callback by something
   that wasn't compiled by gcc (like FrmCloseAllForms()).  It may also
   not be true if it is used as a callback by something in a different
   shared library.

   We really want a function attribute "callback" which will insert this
   progloue and epilogoue automatically.

      - Ian */

register void *reg_a4 asm("%a4");

#define CALLBACK_PROLOGUE \
    void *save_a4 = reg_a4; asm("move.l %%a5,%%a4; sub.l #edata,%%a4" : :);

#define CALLBACK_EPILOGUE reg_a4 = save_a4;

/* These versions are for routines (like systrap patches) that might be
    called _directly_ from OTHER apps.  We can't necessarily calculate our
    %a4 from %a5, because %a5 isn't ours.  Ugh.  We also want to avoid
    doing a SysTrap in the common case that we are called from our own
    app (and so we can calculate %a4 from %a5). */

#define CALLBACK_INTERAPP_PROLOGUE(apptype,ftrnum,magic,magicval) \
    void *ftr_a4, *save_a4 = reg_a4; \
    asm("move.l %%a5,%%d0; bclr.l #31,%%d0; move.l %%d0,%%a4; \
         sub.l #edata,%%a4" : : : "d0"); \
    if ((magic) != (magicval)) { \
	if (!FtrGet((apptype),(ftrnum),(DWord *)&ftr_a4)) { \
	    reg_a4 = ftr_a4; \
	} \
    }

#define CALLBACK_INTERAPP_EPILOGUE reg_a4 = save_a4;

#define REGISTER_INTERAPP_CALLBACK(apptype,ftrnum) \
    FtrSet((apptype),(ftrnum),(DWord)reg_a4);

#define DEREGISTER_INTERAPP_CALLBACK(apptype,ftrnum) \
    FtrUnregister((apptype),(ftrnum));

#endif
