/*
 * log_b2a.c --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 2000-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include "../../../../vd/audio/qm-files.h"

int main(int argc, char** argv)
{
  int x;
  FILE* infile;
  struct MicInputHeader hdr;
  struct MicInputInfo info;

  if(argc != 2)
  {
    fprintf(stderr, "Usage: log_b2a <filename>\n");
    exit(1);
  }

  infile = fopen(argv[1], "r");
  if(infile == NULL)
  {
    fprintf(stderr, "Error: unable to open %s for reading.\n", argv[1]);
    exit(1);
  }

  fread(&hdr, sizeof(struct MicInputHeader), 1, infile);
  //printf("numSamples = %d\n", hdr.numSamples);

  for(x = 0; x < hdr.numSamples; ++x)
  {
    fread(&info, sizeof(struct MicInputInfo), 1, infile);
    printf("%d %d\n", info.index, info.val);
    //printf("\t%u %u\n", info.sysTime.tv_sec, info.sysTime.tv_usec);
  }
  fclose(infile);

  return(0);
}

